import * as $protobuf from "protobufjs";
import Long = require("long");
/** Namespace proto. */
export namespace proto {

    /** Properties of a ADVDeviceIdentity. */
    interface IADVDeviceIdentity {

        /** ADVDeviceIdentity rawId */
        rawId?: (number|null);

        /** ADVDeviceIdentity timestamp */
        timestamp?: (number|Long|null);

        /** ADVDeviceIdentity keyIndex */
        keyIndex?: (number|null);

        /** ADVDeviceIdentity accountType */
        accountType?: (proto.ADVEncryptionType|null);

        /** ADVDeviceIdentity deviceType */
        deviceType?: (proto.ADVEncryptionType|null);
    }

    /** Represents a ADVDeviceIdentity. */
    class ADVDeviceIdentity implements IADVDeviceIdentity {

        /**
         * Constructs a new ADVDeviceIdentity.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVDeviceIdentity);

        /** ADVDeviceIdentity rawId. */
        public rawId?: (number|null);

        /** ADVDeviceIdentity timestamp. */
        public timestamp?: (number|Long|null);

        /** ADVDeviceIdentity keyIndex. */
        public keyIndex?: (number|null);

        /** ADVDeviceIdentity accountType. */
        public accountType?: (proto.ADVEncryptionType|null);

        /** ADVDeviceIdentity deviceType. */
        public deviceType?: (proto.ADVEncryptionType|null);

        /**
         * Creates a new ADVDeviceIdentity instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVDeviceIdentity instance
         */
        public static create(properties?: proto.IADVDeviceIdentity): proto.ADVDeviceIdentity;

        /**
         * Encodes the specified ADVDeviceIdentity message. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @param message ADVDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @param message ADVDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVDeviceIdentity;

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVDeviceIdentity;

        /**
         * Verifies a ADVDeviceIdentity message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVDeviceIdentity
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVDeviceIdentity;

        /**
         * Creates a plain object from a ADVDeviceIdentity message. Also converts values to other types if specified.
         * @param message ADVDeviceIdentity
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVDeviceIdentity, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVDeviceIdentity to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ADVDeviceIdentity
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** ADVEncryptionType enum. */
    enum ADVEncryptionType {
        E2EE = 0,
        HOSTED = 1
    }

    /** Properties of a ADVKeyIndexList. */
    interface IADVKeyIndexList {

        /** ADVKeyIndexList rawId */
        rawId?: (number|null);

        /** ADVKeyIndexList timestamp */
        timestamp?: (number|Long|null);

        /** ADVKeyIndexList currentIndex */
        currentIndex?: (number|null);

        /** ADVKeyIndexList validIndexes */
        validIndexes?: (number[]|null);

        /** ADVKeyIndexList accountType */
        accountType?: (proto.ADVEncryptionType|null);
    }

    /** Represents a ADVKeyIndexList. */
    class ADVKeyIndexList implements IADVKeyIndexList {

        /**
         * Constructs a new ADVKeyIndexList.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVKeyIndexList);

        /** ADVKeyIndexList rawId. */
        public rawId?: (number|null);

        /** ADVKeyIndexList timestamp. */
        public timestamp?: (number|Long|null);

        /** ADVKeyIndexList currentIndex. */
        public currentIndex?: (number|null);

        /** ADVKeyIndexList validIndexes. */
        public validIndexes: number[];

        /** ADVKeyIndexList accountType. */
        public accountType?: (proto.ADVEncryptionType|null);

        /**
         * Creates a new ADVKeyIndexList instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVKeyIndexList instance
         */
        public static create(properties?: proto.IADVKeyIndexList): proto.ADVKeyIndexList;

        /**
         * Encodes the specified ADVKeyIndexList message. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @param message ADVKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @param message ADVKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVKeyIndexList;

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVKeyIndexList;

        /**
         * Verifies a ADVKeyIndexList message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVKeyIndexList
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVKeyIndexList;

        /**
         * Creates a plain object from a ADVKeyIndexList message. Also converts values to other types if specified.
         * @param message ADVKeyIndexList
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVKeyIndexList, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVKeyIndexList to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ADVKeyIndexList
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a ADVSignedDeviceIdentity. */
    interface IADVSignedDeviceIdentity {

        /** ADVSignedDeviceIdentity details */
        details?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity accountSignatureKey */
        accountSignatureKey?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity accountSignature */
        accountSignature?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity deviceSignature */
        deviceSignature?: (Uint8Array|null);
    }

    /** Represents a ADVSignedDeviceIdentity. */
    class ADVSignedDeviceIdentity implements IADVSignedDeviceIdentity {

        /**
         * Constructs a new ADVSignedDeviceIdentity.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVSignedDeviceIdentity);

        /** ADVSignedDeviceIdentity details. */
        public details?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity accountSignatureKey. */
        public accountSignatureKey?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity accountSignature. */
        public accountSignature?: (Uint8Array|null);

        /** ADVSignedDeviceIdentity deviceSignature. */
        public deviceSignature?: (Uint8Array|null);

        /**
         * Creates a new ADVSignedDeviceIdentity instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVSignedDeviceIdentity instance
         */
        public static create(properties?: proto.IADVSignedDeviceIdentity): proto.ADVSignedDeviceIdentity;

        /**
         * Encodes the specified ADVSignedDeviceIdentity message. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @param message ADVSignedDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVSignedDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVSignedDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @param message ADVSignedDeviceIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVSignedDeviceIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVSignedDeviceIdentity;

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVSignedDeviceIdentity;

        /**
         * Verifies a ADVSignedDeviceIdentity message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVSignedDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVSignedDeviceIdentity
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVSignedDeviceIdentity;

        /**
         * Creates a plain object from a ADVSignedDeviceIdentity message. Also converts values to other types if specified.
         * @param message ADVSignedDeviceIdentity
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVSignedDeviceIdentity, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVSignedDeviceIdentity to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ADVSignedDeviceIdentity
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a ADVSignedDeviceIdentityHMAC. */
    interface IADVSignedDeviceIdentityHMAC {

        /** ADVSignedDeviceIdentityHMAC details */
        details?: (Uint8Array|null);

        /** ADVSignedDeviceIdentityHMAC hmac */
        hmac?: (Uint8Array|null);

        /** ADVSignedDeviceIdentityHMAC accountType */
        accountType?: (proto.ADVEncryptionType|null);
    }

    /** Represents a ADVSignedDeviceIdentityHMAC. */
    class ADVSignedDeviceIdentityHMAC implements IADVSignedDeviceIdentityHMAC {

        /**
         * Constructs a new ADVSignedDeviceIdentityHMAC.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVSignedDeviceIdentityHMAC);

        /** ADVSignedDeviceIdentityHMAC details. */
        public details?: (Uint8Array|null);

        /** ADVSignedDeviceIdentityHMAC hmac. */
        public hmac?: (Uint8Array|null);

        /** ADVSignedDeviceIdentityHMAC accountType. */
        public accountType?: (proto.ADVEncryptionType|null);

        /**
         * Creates a new ADVSignedDeviceIdentityHMAC instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVSignedDeviceIdentityHMAC instance
         */
        public static create(properties?: proto.IADVSignedDeviceIdentityHMAC): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @param message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVSignedDeviceIdentityHMAC, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @param message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVSignedDeviceIdentityHMAC, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Verifies a ADVSignedDeviceIdentityHMAC message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVSignedDeviceIdentityHMAC message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVSignedDeviceIdentityHMAC
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVSignedDeviceIdentityHMAC;

        /**
         * Creates a plain object from a ADVSignedDeviceIdentityHMAC message. Also converts values to other types if specified.
         * @param message ADVSignedDeviceIdentityHMAC
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVSignedDeviceIdentityHMAC, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVSignedDeviceIdentityHMAC to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ADVSignedDeviceIdentityHMAC
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a ADVSignedKeyIndexList. */
    interface IADVSignedKeyIndexList {

        /** ADVSignedKeyIndexList details */
        details?: (Uint8Array|null);

        /** ADVSignedKeyIndexList accountSignature */
        accountSignature?: (Uint8Array|null);

        /** ADVSignedKeyIndexList accountSignatureKey */
        accountSignatureKey?: (Uint8Array|null);
    }

    /** Represents a ADVSignedKeyIndexList. */
    class ADVSignedKeyIndexList implements IADVSignedKeyIndexList {

        /**
         * Constructs a new ADVSignedKeyIndexList.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IADVSignedKeyIndexList);

        /** ADVSignedKeyIndexList details. */
        public details?: (Uint8Array|null);

        /** ADVSignedKeyIndexList accountSignature. */
        public accountSignature?: (Uint8Array|null);

        /** ADVSignedKeyIndexList accountSignatureKey. */
        public accountSignatureKey?: (Uint8Array|null);

        /**
         * Creates a new ADVSignedKeyIndexList instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ADVSignedKeyIndexList instance
         */
        public static create(properties?: proto.IADVSignedKeyIndexList): proto.ADVSignedKeyIndexList;

        /**
         * Encodes the specified ADVSignedKeyIndexList message. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @param message ADVSignedKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IADVSignedKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ADVSignedKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @param message ADVSignedKeyIndexList message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IADVSignedKeyIndexList, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ADVSignedKeyIndexList;

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ADVSignedKeyIndexList;

        /**
         * Verifies a ADVSignedKeyIndexList message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ADVSignedKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ADVSignedKeyIndexList
         */
        public static fromObject(object: { [k: string]: any }): proto.ADVSignedKeyIndexList;

        /**
         * Creates a plain object from a ADVSignedKeyIndexList message. Also converts values to other types if specified.
         * @param message ADVSignedKeyIndexList
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ADVSignedKeyIndexList, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ADVSignedKeyIndexList to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ADVSignedKeyIndexList
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a AIQueryFanout. */
    interface IAIQueryFanout {

        /** AIQueryFanout messageKey */
        messageKey?: (proto.IMessageKey|null);

        /** AIQueryFanout message */
        message?: (proto.IMessage|null);

        /** AIQueryFanout timestamp */
        timestamp?: (number|Long|null);
    }

    /** Represents a AIQueryFanout. */
    class AIQueryFanout implements IAIQueryFanout {

        /**
         * Constructs a new AIQueryFanout.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IAIQueryFanout);

        /** AIQueryFanout messageKey. */
        public messageKey?: (proto.IMessageKey|null);

        /** AIQueryFanout message. */
        public message?: (proto.IMessage|null);

        /** AIQueryFanout timestamp. */
        public timestamp?: (number|Long|null);

        /**
         * Creates a new AIQueryFanout instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AIQueryFanout instance
         */
        public static create(properties?: proto.IAIQueryFanout): proto.AIQueryFanout;

        /**
         * Encodes the specified AIQueryFanout message. Does not implicitly {@link proto.AIQueryFanout.verify|verify} messages.
         * @param message AIQueryFanout message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IAIQueryFanout, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AIQueryFanout message, length delimited. Does not implicitly {@link proto.AIQueryFanout.verify|verify} messages.
         * @param message AIQueryFanout message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IAIQueryFanout, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a AIQueryFanout message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AIQueryFanout
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIQueryFanout;

        /**
         * Decodes a AIQueryFanout message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AIQueryFanout
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIQueryFanout;

        /**
         * Verifies a AIQueryFanout message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a AIQueryFanout message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AIQueryFanout
         */
        public static fromObject(object: { [k: string]: any }): proto.AIQueryFanout;

        /**
         * Creates a plain object from a AIQueryFanout message. Also converts values to other types if specified.
         * @param message AIQueryFanout
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.AIQueryFanout, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AIQueryFanout to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for AIQueryFanout
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a AIRichResponseMessage. */
    interface IAIRichResponseMessage {

        /** AIRichResponseMessage messageType */
        messageType?: (proto.AIRichResponseMessage.AIRichResponseMessageType|null);

        /** AIRichResponseMessage submessages */
        submessages?: (proto.AIRichResponseMessage.IAIRichResponseSubMessage[]|null);

        /** AIRichResponseMessage unifiedResponse */
        unifiedResponse?: (proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse|null);
    }

    /** Represents a AIRichResponseMessage. */
    class AIRichResponseMessage implements IAIRichResponseMessage {

        /**
         * Constructs a new AIRichResponseMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IAIRichResponseMessage);

        /** AIRichResponseMessage messageType. */
        public messageType?: (proto.AIRichResponseMessage.AIRichResponseMessageType|null);

        /** AIRichResponseMessage submessages. */
        public submessages: proto.AIRichResponseMessage.IAIRichResponseSubMessage[];

        /** AIRichResponseMessage unifiedResponse. */
        public unifiedResponse?: (proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse|null);

        /**
         * Creates a new AIRichResponseMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AIRichResponseMessage instance
         */
        public static create(properties?: proto.IAIRichResponseMessage): proto.AIRichResponseMessage;

        /**
         * Encodes the specified AIRichResponseMessage message. Does not implicitly {@link proto.AIRichResponseMessage.verify|verify} messages.
         * @param message AIRichResponseMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IAIRichResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AIRichResponseMessage message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.verify|verify} messages.
         * @param message AIRichResponseMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IAIRichResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a AIRichResponseMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AIRichResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage;

        /**
         * Decodes a AIRichResponseMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AIRichResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage;

        /**
         * Verifies a AIRichResponseMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a AIRichResponseMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AIRichResponseMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage;

        /**
         * Creates a plain object from a AIRichResponseMessage message. Also converts values to other types if specified.
         * @param message AIRichResponseMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.AIRichResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AIRichResponseMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for AIRichResponseMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace AIRichResponseMessage {

        /** Properties of a AIRichResponseCodeMetadata. */
        interface IAIRichResponseCodeMetadata {

            /** AIRichResponseCodeMetadata codeLanguage */
            codeLanguage?: (string|null);

            /** AIRichResponseCodeMetadata codeBlocks */
            codeBlocks?: (proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock[]|null);
        }

        /** Represents a AIRichResponseCodeMetadata. */
        class AIRichResponseCodeMetadata implements IAIRichResponseCodeMetadata {

            /**
             * Constructs a new AIRichResponseCodeMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseCodeMetadata);

            /** AIRichResponseCodeMetadata codeLanguage. */
            public codeLanguage?: (string|null);

            /** AIRichResponseCodeMetadata codeBlocks. */
            public codeBlocks: proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock[];

            /**
             * Creates a new AIRichResponseCodeMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseCodeMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseCodeMetadata): proto.AIRichResponseMessage.AIRichResponseCodeMetadata;

            /**
             * Encodes the specified AIRichResponseCodeMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.verify|verify} messages.
             * @param message AIRichResponseCodeMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseCodeMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseCodeMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.verify|verify} messages.
             * @param message AIRichResponseCodeMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseCodeMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseCodeMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseCodeMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseCodeMetadata;

            /**
             * Decodes a AIRichResponseCodeMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseCodeMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseCodeMetadata;

            /**
             * Verifies a AIRichResponseCodeMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseCodeMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseCodeMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseCodeMetadata;

            /**
             * Creates a plain object from a AIRichResponseCodeMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseCodeMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseCodeMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseCodeMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseCodeMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AIRichResponseCodeMetadata {

            /** Properties of a AIRichResponseCodeBlock. */
            interface IAIRichResponseCodeBlock {

                /** AIRichResponseCodeBlock highlightType */
                highlightType?: (proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType|null);

                /** AIRichResponseCodeBlock codeContent */
                codeContent?: (string|null);
            }

            /** Represents a AIRichResponseCodeBlock. */
            class AIRichResponseCodeBlock implements IAIRichResponseCodeBlock {

                /**
                 * Constructs a new AIRichResponseCodeBlock.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock);

                /** AIRichResponseCodeBlock highlightType. */
                public highlightType?: (proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeHighlightType|null);

                /** AIRichResponseCodeBlock codeContent. */
                public codeContent?: (string|null);

                /**
                 * Creates a new AIRichResponseCodeBlock instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AIRichResponseCodeBlock instance
                 */
                public static create(properties?: proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock): proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock;

                /**
                 * Encodes the specified AIRichResponseCodeBlock message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.verify|verify} messages.
                 * @param message AIRichResponseCodeBlock message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AIRichResponseCodeBlock message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock.verify|verify} messages.
                 * @param message AIRichResponseCodeBlock message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.AIRichResponseMessage.AIRichResponseCodeMetadata.IAIRichResponseCodeBlock, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a AIRichResponseCodeBlock message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AIRichResponseCodeBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock;

                /**
                 * Decodes a AIRichResponseCodeBlock message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AIRichResponseCodeBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock;

                /**
                 * Verifies a AIRichResponseCodeBlock message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a AIRichResponseCodeBlock message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AIRichResponseCodeBlock
                 */
                public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock;

                /**
                 * Creates a plain object from a AIRichResponseCodeBlock message. Also converts values to other types if specified.
                 * @param message AIRichResponseCodeBlock
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.AIRichResponseMessage.AIRichResponseCodeMetadata.AIRichResponseCodeBlock, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AIRichResponseCodeBlock to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for AIRichResponseCodeBlock
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            /** AIRichResponseCodeHighlightType enum. */
            enum AIRichResponseCodeHighlightType {
                AI_RICH_RESPONSE_CODE_HIGHLIGHT_DEFAULT = 0,
                AI_RICH_RESPONSE_CODE_HIGHLIGHT_KEYWORD = 1,
                AI_RICH_RESPONSE_CODE_HIGHLIGHT_METHOD = 2,
                AI_RICH_RESPONSE_CODE_HIGHLIGHT_STRING = 3,
                AI_RICH_RESPONSE_CODE_HIGHLIGHT_NUMBER = 4,
                AI_RICH_RESPONSE_CODE_HIGHLIGHT_COMMENT = 5
            }
        }

        /** Properties of a AIRichResponseContentItemsMetadata. */
        interface IAIRichResponseContentItemsMetadata {

            /** AIRichResponseContentItemsMetadata itemsMetadata */
            itemsMetadata?: (proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata[]|null);

            /** AIRichResponseContentItemsMetadata contentType */
            contentType?: (proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType|null);
        }

        /** Represents a AIRichResponseContentItemsMetadata. */
        class AIRichResponseContentItemsMetadata implements IAIRichResponseContentItemsMetadata {

            /**
             * Constructs a new AIRichResponseContentItemsMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata);

            /** AIRichResponseContentItemsMetadata itemsMetadata. */
            public itemsMetadata: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata[];

            /** AIRichResponseContentItemsMetadata contentType. */
            public contentType?: (proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.ContentType|null);

            /**
             * Creates a new AIRichResponseContentItemsMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseContentItemsMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata;

            /**
             * Encodes the specified AIRichResponseContentItemsMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.verify|verify} messages.
             * @param message AIRichResponseContentItemsMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseContentItemsMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.verify|verify} messages.
             * @param message AIRichResponseContentItemsMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseContentItemsMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseContentItemsMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata;

            /**
             * Decodes a AIRichResponseContentItemsMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseContentItemsMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata;

            /**
             * Verifies a AIRichResponseContentItemsMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseContentItemsMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseContentItemsMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata;

            /**
             * Creates a plain object from a AIRichResponseContentItemsMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseContentItemsMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseContentItemsMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseContentItemsMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AIRichResponseContentItemsMetadata {

            /** Properties of a AIRichResponseContentItemMetadata. */
            interface IAIRichResponseContentItemMetadata {

                /** AIRichResponseContentItemMetadata reelItem */
                reelItem?: (proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem|null);
            }

            /** Represents a AIRichResponseContentItemMetadata. */
            class AIRichResponseContentItemMetadata implements IAIRichResponseContentItemMetadata {

                /**
                 * Constructs a new AIRichResponseContentItemMetadata.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata);

                /** AIRichResponseContentItemMetadata reelItem. */
                public reelItem?: (proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem|null);

                /** AIRichResponseContentItemMetadata aIRichResponseContentItem. */
                public aIRichResponseContentItem?: "reelItem";

                /**
                 * Creates a new AIRichResponseContentItemMetadata instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AIRichResponseContentItemMetadata instance
                 */
                public static create(properties?: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata;

                /**
                 * Encodes the specified AIRichResponseContentItemMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.verify|verify} messages.
                 * @param message AIRichResponseContentItemMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AIRichResponseContentItemMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata.verify|verify} messages.
                 * @param message AIRichResponseContentItemMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseContentItemMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a AIRichResponseContentItemMetadata message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AIRichResponseContentItemMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata;

                /**
                 * Decodes a AIRichResponseContentItemMetadata message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AIRichResponseContentItemMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata;

                /**
                 * Verifies a AIRichResponseContentItemMetadata message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a AIRichResponseContentItemMetadata message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AIRichResponseContentItemMetadata
                 */
                public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata;

                /**
                 * Creates a plain object from a AIRichResponseContentItemMetadata message. Also converts values to other types if specified.
                 * @param message AIRichResponseContentItemMetadata
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseContentItemMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AIRichResponseContentItemMetadata to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for AIRichResponseContentItemMetadata
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            /** Properties of a AIRichResponseReelItem. */
            interface IAIRichResponseReelItem {

                /** AIRichResponseReelItem title */
                title?: (string|null);

                /** AIRichResponseReelItem profileIconUrl */
                profileIconUrl?: (string|null);

                /** AIRichResponseReelItem thumbnailUrl */
                thumbnailUrl?: (string|null);

                /** AIRichResponseReelItem videoUrl */
                videoUrl?: (string|null);
            }

            /** Represents a AIRichResponseReelItem. */
            class AIRichResponseReelItem implements IAIRichResponseReelItem {

                /**
                 * Constructs a new AIRichResponseReelItem.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem);

                /** AIRichResponseReelItem title. */
                public title?: (string|null);

                /** AIRichResponseReelItem profileIconUrl. */
                public profileIconUrl?: (string|null);

                /** AIRichResponseReelItem thumbnailUrl. */
                public thumbnailUrl?: (string|null);

                /** AIRichResponseReelItem videoUrl. */
                public videoUrl?: (string|null);

                /**
                 * Creates a new AIRichResponseReelItem instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AIRichResponseReelItem instance
                 */
                public static create(properties?: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem;

                /**
                 * Encodes the specified AIRichResponseReelItem message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.verify|verify} messages.
                 * @param message AIRichResponseReelItem message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AIRichResponseReelItem message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem.verify|verify} messages.
                 * @param message AIRichResponseReelItem message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.IAIRichResponseReelItem, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a AIRichResponseReelItem message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AIRichResponseReelItem
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem;

                /**
                 * Decodes a AIRichResponseReelItem message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AIRichResponseReelItem
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem;

                /**
                 * Verifies a AIRichResponseReelItem message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a AIRichResponseReelItem message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AIRichResponseReelItem
                 */
                public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem;

                /**
                 * Creates a plain object from a AIRichResponseReelItem message. Also converts values to other types if specified.
                 * @param message AIRichResponseReelItem
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.AIRichResponseMessage.AIRichResponseContentItemsMetadata.AIRichResponseReelItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AIRichResponseReelItem to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for AIRichResponseReelItem
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            /** ContentType enum. */
            enum ContentType {
                DEFAULT = 0,
                CAROUSEL = 1
            }
        }

        /** Properties of a AIRichResponseDynamicMetadata. */
        interface IAIRichResponseDynamicMetadata {

            /** AIRichResponseDynamicMetadata type */
            type?: (proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType|null);

            /** AIRichResponseDynamicMetadata version */
            version?: (number|Long|null);

            /** AIRichResponseDynamicMetadata url */
            url?: (string|null);

            /** AIRichResponseDynamicMetadata loopCount */
            loopCount?: (number|null);
        }

        /** Represents a AIRichResponseDynamicMetadata. */
        class AIRichResponseDynamicMetadata implements IAIRichResponseDynamicMetadata {

            /**
             * Constructs a new AIRichResponseDynamicMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata);

            /** AIRichResponseDynamicMetadata type. */
            public type?: (proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.AIRichResponseDynamicMetadataType|null);

            /** AIRichResponseDynamicMetadata version. */
            public version?: (number|Long|null);

            /** AIRichResponseDynamicMetadata url. */
            public url?: (string|null);

            /** AIRichResponseDynamicMetadata loopCount. */
            public loopCount?: (number|null);

            /**
             * Creates a new AIRichResponseDynamicMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseDynamicMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata): proto.AIRichResponseMessage.AIRichResponseDynamicMetadata;

            /**
             * Encodes the specified AIRichResponseDynamicMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.verify|verify} messages.
             * @param message AIRichResponseDynamicMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseDynamicMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseDynamicMetadata.verify|verify} messages.
             * @param message AIRichResponseDynamicMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseDynamicMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseDynamicMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseDynamicMetadata;

            /**
             * Decodes a AIRichResponseDynamicMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseDynamicMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseDynamicMetadata;

            /**
             * Verifies a AIRichResponseDynamicMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseDynamicMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseDynamicMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseDynamicMetadata;

            /**
             * Creates a plain object from a AIRichResponseDynamicMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseDynamicMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseDynamicMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseDynamicMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseDynamicMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AIRichResponseDynamicMetadata {

            /** AIRichResponseDynamicMetadataType enum. */
            enum AIRichResponseDynamicMetadataType {
                AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_UNKNOWN = 0,
                AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_IMAGE = 1,
                AI_RICH_RESPONSE_DYNAMIC_METADATA_TYPE_GIF = 2
            }
        }

        /** Properties of a AIRichResponseGridImageMetadata. */
        interface IAIRichResponseGridImageMetadata {

            /** AIRichResponseGridImageMetadata gridImageUrl */
            gridImageUrl?: (proto.AIRichResponseMessage.IAIRichResponseImageURL|null);

            /** AIRichResponseGridImageMetadata imageUrls */
            imageUrls?: (proto.AIRichResponseMessage.IAIRichResponseImageURL[]|null);
        }

        /** Represents a AIRichResponseGridImageMetadata. */
        class AIRichResponseGridImageMetadata implements IAIRichResponseGridImageMetadata {

            /**
             * Constructs a new AIRichResponseGridImageMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata);

            /** AIRichResponseGridImageMetadata gridImageUrl. */
            public gridImageUrl?: (proto.AIRichResponseMessage.IAIRichResponseImageURL|null);

            /** AIRichResponseGridImageMetadata imageUrls. */
            public imageUrls: proto.AIRichResponseMessage.IAIRichResponseImageURL[];

            /**
             * Creates a new AIRichResponseGridImageMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseGridImageMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata): proto.AIRichResponseMessage.AIRichResponseGridImageMetadata;

            /**
             * Encodes the specified AIRichResponseGridImageMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.verify|verify} messages.
             * @param message AIRichResponseGridImageMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseGridImageMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseGridImageMetadata.verify|verify} messages.
             * @param message AIRichResponseGridImageMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseGridImageMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseGridImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseGridImageMetadata;

            /**
             * Decodes a AIRichResponseGridImageMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseGridImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseGridImageMetadata;

            /**
             * Verifies a AIRichResponseGridImageMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseGridImageMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseGridImageMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseGridImageMetadata;

            /**
             * Creates a plain object from a AIRichResponseGridImageMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseGridImageMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseGridImageMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseGridImageMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseGridImageMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a AIRichResponseImageURL. */
        interface IAIRichResponseImageURL {

            /** AIRichResponseImageURL imagePreviewUrl */
            imagePreviewUrl?: (string|null);

            /** AIRichResponseImageURL imageHighResUrl */
            imageHighResUrl?: (string|null);

            /** AIRichResponseImageURL sourceUrl */
            sourceUrl?: (string|null);
        }

        /** Represents a AIRichResponseImageURL. */
        class AIRichResponseImageURL implements IAIRichResponseImageURL {

            /**
             * Constructs a new AIRichResponseImageURL.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseImageURL);

            /** AIRichResponseImageURL imagePreviewUrl. */
            public imagePreviewUrl?: (string|null);

            /** AIRichResponseImageURL imageHighResUrl. */
            public imageHighResUrl?: (string|null);

            /** AIRichResponseImageURL sourceUrl. */
            public sourceUrl?: (string|null);

            /**
             * Creates a new AIRichResponseImageURL instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseImageURL instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseImageURL): proto.AIRichResponseMessage.AIRichResponseImageURL;

            /**
             * Encodes the specified AIRichResponseImageURL message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseImageURL.verify|verify} messages.
             * @param message AIRichResponseImageURL message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseImageURL, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseImageURL message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseImageURL.verify|verify} messages.
             * @param message AIRichResponseImageURL message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseImageURL, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseImageURL message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseImageURL
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseImageURL;

            /**
             * Decodes a AIRichResponseImageURL message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseImageURL
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseImageURL;

            /**
             * Verifies a AIRichResponseImageURL message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseImageURL message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseImageURL
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseImageURL;

            /**
             * Creates a plain object from a AIRichResponseImageURL message. Also converts values to other types if specified.
             * @param message AIRichResponseImageURL
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseImageURL, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseImageURL to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseImageURL
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a AIRichResponseInlineImageMetadata. */
        interface IAIRichResponseInlineImageMetadata {

            /** AIRichResponseInlineImageMetadata imageUrl */
            imageUrl?: (proto.AIRichResponseMessage.IAIRichResponseImageURL|null);

            /** AIRichResponseInlineImageMetadata imageText */
            imageText?: (string|null);

            /** AIRichResponseInlineImageMetadata alignment */
            alignment?: (proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment|null);

            /** AIRichResponseInlineImageMetadata tapLinkUrl */
            tapLinkUrl?: (string|null);
        }

        /** Represents a AIRichResponseInlineImageMetadata. */
        class AIRichResponseInlineImageMetadata implements IAIRichResponseInlineImageMetadata {

            /**
             * Constructs a new AIRichResponseInlineImageMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata);

            /** AIRichResponseInlineImageMetadata imageUrl. */
            public imageUrl?: (proto.AIRichResponseMessage.IAIRichResponseImageURL|null);

            /** AIRichResponseInlineImageMetadata imageText. */
            public imageText?: (string|null);

            /** AIRichResponseInlineImageMetadata alignment. */
            public alignment?: (proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.AIRichResponseImageAlignment|null);

            /** AIRichResponseInlineImageMetadata tapLinkUrl. */
            public tapLinkUrl?: (string|null);

            /**
             * Creates a new AIRichResponseInlineImageMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseInlineImageMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata): proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata;

            /**
             * Encodes the specified AIRichResponseInlineImageMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.verify|verify} messages.
             * @param message AIRichResponseInlineImageMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseInlineImageMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata.verify|verify} messages.
             * @param message AIRichResponseInlineImageMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseInlineImageMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseInlineImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata;

            /**
             * Decodes a AIRichResponseInlineImageMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseInlineImageMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata;

            /**
             * Verifies a AIRichResponseInlineImageMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseInlineImageMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseInlineImageMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata;

            /**
             * Creates a plain object from a AIRichResponseInlineImageMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseInlineImageMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseInlineImageMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseInlineImageMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseInlineImageMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AIRichResponseInlineImageMetadata {

            /** AIRichResponseImageAlignment enum. */
            enum AIRichResponseImageAlignment {
                AI_RICH_RESPONSE_IMAGE_LAYOUT_LEADING_ALIGNED = 0,
                AI_RICH_RESPONSE_IMAGE_LAYOUT_TRAILING_ALIGNED = 1,
                AI_RICH_RESPONSE_IMAGE_LAYOUT_CENTER_ALIGNED = 2
            }
        }

        /** Properties of a AIRichResponseLatexMetadata. */
        interface IAIRichResponseLatexMetadata {

            /** AIRichResponseLatexMetadata text */
            text?: (string|null);

            /** AIRichResponseLatexMetadata expressions */
            expressions?: (proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression[]|null);
        }

        /** Represents a AIRichResponseLatexMetadata. */
        class AIRichResponseLatexMetadata implements IAIRichResponseLatexMetadata {

            /**
             * Constructs a new AIRichResponseLatexMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseLatexMetadata);

            /** AIRichResponseLatexMetadata text. */
            public text?: (string|null);

            /** AIRichResponseLatexMetadata expressions. */
            public expressions: proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression[];

            /**
             * Creates a new AIRichResponseLatexMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseLatexMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseLatexMetadata): proto.AIRichResponseMessage.AIRichResponseLatexMetadata;

            /**
             * Encodes the specified AIRichResponseLatexMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.verify|verify} messages.
             * @param message AIRichResponseLatexMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseLatexMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseLatexMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.verify|verify} messages.
             * @param message AIRichResponseLatexMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseLatexMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseLatexMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseLatexMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseLatexMetadata;

            /**
             * Decodes a AIRichResponseLatexMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseLatexMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseLatexMetadata;

            /**
             * Verifies a AIRichResponseLatexMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseLatexMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseLatexMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseLatexMetadata;

            /**
             * Creates a plain object from a AIRichResponseLatexMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseLatexMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseLatexMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseLatexMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseLatexMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AIRichResponseLatexMetadata {

            /** Properties of a AIRichResponseLatexExpression. */
            interface IAIRichResponseLatexExpression {

                /** AIRichResponseLatexExpression latexExpression */
                latexExpression?: (string|null);

                /** AIRichResponseLatexExpression url */
                url?: (string|null);

                /** AIRichResponseLatexExpression width */
                width?: (number|null);

                /** AIRichResponseLatexExpression height */
                height?: (number|null);

                /** AIRichResponseLatexExpression fontHeight */
                fontHeight?: (number|null);

                /** AIRichResponseLatexExpression imageTopPadding */
                imageTopPadding?: (number|null);

                /** AIRichResponseLatexExpression imageLeadingPadding */
                imageLeadingPadding?: (number|null);

                /** AIRichResponseLatexExpression imageBottomPadding */
                imageBottomPadding?: (number|null);

                /** AIRichResponseLatexExpression imageTrailingPadding */
                imageTrailingPadding?: (number|null);
            }

            /** Represents a AIRichResponseLatexExpression. */
            class AIRichResponseLatexExpression implements IAIRichResponseLatexExpression {

                /**
                 * Constructs a new AIRichResponseLatexExpression.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression);

                /** AIRichResponseLatexExpression latexExpression. */
                public latexExpression?: (string|null);

                /** AIRichResponseLatexExpression url. */
                public url?: (string|null);

                /** AIRichResponseLatexExpression width. */
                public width?: (number|null);

                /** AIRichResponseLatexExpression height. */
                public height?: (number|null);

                /** AIRichResponseLatexExpression fontHeight. */
                public fontHeight?: (number|null);

                /** AIRichResponseLatexExpression imageTopPadding. */
                public imageTopPadding?: (number|null);

                /** AIRichResponseLatexExpression imageLeadingPadding. */
                public imageLeadingPadding?: (number|null);

                /** AIRichResponseLatexExpression imageBottomPadding. */
                public imageBottomPadding?: (number|null);

                /** AIRichResponseLatexExpression imageTrailingPadding. */
                public imageTrailingPadding?: (number|null);

                /**
                 * Creates a new AIRichResponseLatexExpression instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AIRichResponseLatexExpression instance
                 */
                public static create(properties?: proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression): proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression;

                /**
                 * Encodes the specified AIRichResponseLatexExpression message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.verify|verify} messages.
                 * @param message AIRichResponseLatexExpression message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AIRichResponseLatexExpression message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression.verify|verify} messages.
                 * @param message AIRichResponseLatexExpression message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.AIRichResponseMessage.AIRichResponseLatexMetadata.IAIRichResponseLatexExpression, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a AIRichResponseLatexExpression message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AIRichResponseLatexExpression
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression;

                /**
                 * Decodes a AIRichResponseLatexExpression message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AIRichResponseLatexExpression
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression;

                /**
                 * Verifies a AIRichResponseLatexExpression message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a AIRichResponseLatexExpression message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AIRichResponseLatexExpression
                 */
                public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression;

                /**
                 * Creates a plain object from a AIRichResponseLatexExpression message. Also converts values to other types if specified.
                 * @param message AIRichResponseLatexExpression
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.AIRichResponseMessage.AIRichResponseLatexMetadata.AIRichResponseLatexExpression, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AIRichResponseLatexExpression to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for AIRichResponseLatexExpression
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }

        /** Properties of a AIRichResponseMapMetadata. */
        interface IAIRichResponseMapMetadata {

            /** AIRichResponseMapMetadata centerLatitude */
            centerLatitude?: (number|null);

            /** AIRichResponseMapMetadata centerLongitude */
            centerLongitude?: (number|null);

            /** AIRichResponseMapMetadata latitudeDelta */
            latitudeDelta?: (number|null);

            /** AIRichResponseMapMetadata longitudeDelta */
            longitudeDelta?: (number|null);

            /** AIRichResponseMapMetadata annotations */
            annotations?: (proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation[]|null);

            /** AIRichResponseMapMetadata showInfoList */
            showInfoList?: (boolean|null);
        }

        /** Represents a AIRichResponseMapMetadata. */
        class AIRichResponseMapMetadata implements IAIRichResponseMapMetadata {

            /**
             * Constructs a new AIRichResponseMapMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseMapMetadata);

            /** AIRichResponseMapMetadata centerLatitude. */
            public centerLatitude?: (number|null);

            /** AIRichResponseMapMetadata centerLongitude. */
            public centerLongitude?: (number|null);

            /** AIRichResponseMapMetadata latitudeDelta. */
            public latitudeDelta?: (number|null);

            /** AIRichResponseMapMetadata longitudeDelta. */
            public longitudeDelta?: (number|null);

            /** AIRichResponseMapMetadata annotations. */
            public annotations: proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation[];

            /** AIRichResponseMapMetadata showInfoList. */
            public showInfoList?: (boolean|null);

            /**
             * Creates a new AIRichResponseMapMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseMapMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseMapMetadata): proto.AIRichResponseMessage.AIRichResponseMapMetadata;

            /**
             * Encodes the specified AIRichResponseMapMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.verify|verify} messages.
             * @param message AIRichResponseMapMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseMapMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseMapMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.verify|verify} messages.
             * @param message AIRichResponseMapMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseMapMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseMapMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseMapMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseMapMetadata;

            /**
             * Decodes a AIRichResponseMapMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseMapMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseMapMetadata;

            /**
             * Verifies a AIRichResponseMapMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseMapMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseMapMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseMapMetadata;

            /**
             * Creates a plain object from a AIRichResponseMapMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseMapMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseMapMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseMapMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseMapMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AIRichResponseMapMetadata {

            /** Properties of a AIRichResponseMapAnnotation. */
            interface IAIRichResponseMapAnnotation {

                /** AIRichResponseMapAnnotation annotationNumber */
                annotationNumber?: (number|null);

                /** AIRichResponseMapAnnotation latitude */
                latitude?: (number|null);

                /** AIRichResponseMapAnnotation longitude */
                longitude?: (number|null);

                /** AIRichResponseMapAnnotation title */
                title?: (string|null);

                /** AIRichResponseMapAnnotation body */
                body?: (string|null);
            }

            /** Represents a AIRichResponseMapAnnotation. */
            class AIRichResponseMapAnnotation implements IAIRichResponseMapAnnotation {

                /**
                 * Constructs a new AIRichResponseMapAnnotation.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation);

                /** AIRichResponseMapAnnotation annotationNumber. */
                public annotationNumber?: (number|null);

                /** AIRichResponseMapAnnotation latitude. */
                public latitude?: (number|null);

                /** AIRichResponseMapAnnotation longitude. */
                public longitude?: (number|null);

                /** AIRichResponseMapAnnotation title. */
                public title?: (string|null);

                /** AIRichResponseMapAnnotation body. */
                public body?: (string|null);

                /**
                 * Creates a new AIRichResponseMapAnnotation instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AIRichResponseMapAnnotation instance
                 */
                public static create(properties?: proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation): proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation;

                /**
                 * Encodes the specified AIRichResponseMapAnnotation message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.verify|verify} messages.
                 * @param message AIRichResponseMapAnnotation message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AIRichResponseMapAnnotation message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation.verify|verify} messages.
                 * @param message AIRichResponseMapAnnotation message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.AIRichResponseMessage.AIRichResponseMapMetadata.IAIRichResponseMapAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a AIRichResponseMapAnnotation message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AIRichResponseMapAnnotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation;

                /**
                 * Decodes a AIRichResponseMapAnnotation message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AIRichResponseMapAnnotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation;

                /**
                 * Verifies a AIRichResponseMapAnnotation message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a AIRichResponseMapAnnotation message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AIRichResponseMapAnnotation
                 */
                public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation;

                /**
                 * Creates a plain object from a AIRichResponseMapAnnotation message. Also converts values to other types if specified.
                 * @param message AIRichResponseMapAnnotation
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.AIRichResponseMessage.AIRichResponseMapMetadata.AIRichResponseMapAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AIRichResponseMapAnnotation to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for AIRichResponseMapAnnotation
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }

        /** AIRichResponseMessageType enum. */
        enum AIRichResponseMessageType {
            AI_RICH_RESPONSE_TYPE_UNKNOWN = 0,
            AI_RICH_RESPONSE_TYPE_STANDARD = 1
        }

        /** Properties of a AIRichResponseSubMessage. */
        interface IAIRichResponseSubMessage {

            /** AIRichResponseSubMessage messageType */
            messageType?: (proto.AIRichResponseMessage.AIRichResponseSubMessageType|null);

            /** AIRichResponseSubMessage gridImageMetadata */
            gridImageMetadata?: (proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata|null);

            /** AIRichResponseSubMessage messageText */
            messageText?: (string|null);

            /** AIRichResponseSubMessage imageMetadata */
            imageMetadata?: (proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata|null);

            /** AIRichResponseSubMessage codeMetadata */
            codeMetadata?: (proto.AIRichResponseMessage.IAIRichResponseCodeMetadata|null);

            /** AIRichResponseSubMessage tableMetadata */
            tableMetadata?: (proto.AIRichResponseMessage.IAIRichResponseTableMetadata|null);

            /** AIRichResponseSubMessage dynamicMetadata */
            dynamicMetadata?: (proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata|null);

            /** AIRichResponseSubMessage latexMetadata */
            latexMetadata?: (proto.AIRichResponseMessage.IAIRichResponseLatexMetadata|null);

            /** AIRichResponseSubMessage mapMetadata */
            mapMetadata?: (proto.AIRichResponseMessage.IAIRichResponseMapMetadata|null);

            /** AIRichResponseSubMessage contentItemsMetadata */
            contentItemsMetadata?: (proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata|null);
        }

        /** Represents a AIRichResponseSubMessage. */
        class AIRichResponseSubMessage implements IAIRichResponseSubMessage {

            /**
             * Constructs a new AIRichResponseSubMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseSubMessage);

            /** AIRichResponseSubMessage messageType. */
            public messageType?: (proto.AIRichResponseMessage.AIRichResponseSubMessageType|null);

            /** AIRichResponseSubMessage gridImageMetadata. */
            public gridImageMetadata?: (proto.AIRichResponseMessage.IAIRichResponseGridImageMetadata|null);

            /** AIRichResponseSubMessage messageText. */
            public messageText?: (string|null);

            /** AIRichResponseSubMessage imageMetadata. */
            public imageMetadata?: (proto.AIRichResponseMessage.IAIRichResponseInlineImageMetadata|null);

            /** AIRichResponseSubMessage codeMetadata. */
            public codeMetadata?: (proto.AIRichResponseMessage.IAIRichResponseCodeMetadata|null);

            /** AIRichResponseSubMessage tableMetadata. */
            public tableMetadata?: (proto.AIRichResponseMessage.IAIRichResponseTableMetadata|null);

            /** AIRichResponseSubMessage dynamicMetadata. */
            public dynamicMetadata?: (proto.AIRichResponseMessage.IAIRichResponseDynamicMetadata|null);

            /** AIRichResponseSubMessage latexMetadata. */
            public latexMetadata?: (proto.AIRichResponseMessage.IAIRichResponseLatexMetadata|null);

            /** AIRichResponseSubMessage mapMetadata. */
            public mapMetadata?: (proto.AIRichResponseMessage.IAIRichResponseMapMetadata|null);

            /** AIRichResponseSubMessage contentItemsMetadata. */
            public contentItemsMetadata?: (proto.AIRichResponseMessage.IAIRichResponseContentItemsMetadata|null);

            /**
             * Creates a new AIRichResponseSubMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseSubMessage instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseSubMessage): proto.AIRichResponseMessage.AIRichResponseSubMessage;

            /**
             * Encodes the specified AIRichResponseSubMessage message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseSubMessage.verify|verify} messages.
             * @param message AIRichResponseSubMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseSubMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseSubMessage message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseSubMessage.verify|verify} messages.
             * @param message AIRichResponseSubMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseSubMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseSubMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseSubMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseSubMessage;

            /**
             * Decodes a AIRichResponseSubMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseSubMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseSubMessage;

            /**
             * Verifies a AIRichResponseSubMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseSubMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseSubMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseSubMessage;

            /**
             * Creates a plain object from a AIRichResponseSubMessage message. Also converts values to other types if specified.
             * @param message AIRichResponseSubMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseSubMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseSubMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseSubMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** AIRichResponseSubMessageType enum. */
        enum AIRichResponseSubMessageType {
            AI_RICH_RESPONSE_UNKNOWN = 0,
            AI_RICH_RESPONSE_GRID_IMAGE = 1,
            AI_RICH_RESPONSE_TEXT = 2,
            AI_RICH_RESPONSE_INLINE_IMAGE = 3,
            AI_RICH_RESPONSE_TABLE = 4,
            AI_RICH_RESPONSE_CODE = 5,
            AI_RICH_RESPONSE_DYNAMIC = 6,
            AI_RICH_RESPONSE_MAP = 7,
            AI_RICH_RESPONSE_LATEX = 8,
            AI_RICH_RESPONSE_CONTENT_ITEMS = 9
        }

        /** Properties of a AIRichResponseTableMetadata. */
        interface IAIRichResponseTableMetadata {

            /** AIRichResponseTableMetadata rows */
            rows?: (proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow[]|null);
        }

        /** Represents a AIRichResponseTableMetadata. */
        class AIRichResponseTableMetadata implements IAIRichResponseTableMetadata {

            /**
             * Constructs a new AIRichResponseTableMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseTableMetadata);

            /** AIRichResponseTableMetadata rows. */
            public rows: proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow[];

            /**
             * Creates a new AIRichResponseTableMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseTableMetadata instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseTableMetadata): proto.AIRichResponseMessage.AIRichResponseTableMetadata;

            /**
             * Encodes the specified AIRichResponseTableMetadata message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.verify|verify} messages.
             * @param message AIRichResponseTableMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseTableMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseTableMetadata message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.verify|verify} messages.
             * @param message AIRichResponseTableMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseTableMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseTableMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseTableMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseTableMetadata;

            /**
             * Decodes a AIRichResponseTableMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseTableMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseTableMetadata;

            /**
             * Verifies a AIRichResponseTableMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseTableMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseTableMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseTableMetadata;

            /**
             * Creates a plain object from a AIRichResponseTableMetadata message. Also converts values to other types if specified.
             * @param message AIRichResponseTableMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseTableMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseTableMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseTableMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AIRichResponseTableMetadata {

            /** Properties of a AIRichResponseTableRow. */
            interface IAIRichResponseTableRow {

                /** AIRichResponseTableRow items */
                items?: (string[]|null);

                /** AIRichResponseTableRow isHeading */
                isHeading?: (boolean|null);
            }

            /** Represents a AIRichResponseTableRow. */
            class AIRichResponseTableRow implements IAIRichResponseTableRow {

                /**
                 * Constructs a new AIRichResponseTableRow.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow);

                /** AIRichResponseTableRow items. */
                public items: string[];

                /** AIRichResponseTableRow isHeading. */
                public isHeading?: (boolean|null);

                /**
                 * Creates a new AIRichResponseTableRow instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AIRichResponseTableRow instance
                 */
                public static create(properties?: proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow): proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow;

                /**
                 * Encodes the specified AIRichResponseTableRow message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.verify|verify} messages.
                 * @param message AIRichResponseTableRow message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AIRichResponseTableRow message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow.verify|verify} messages.
                 * @param message AIRichResponseTableRow message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.AIRichResponseMessage.AIRichResponseTableMetadata.IAIRichResponseTableRow, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a AIRichResponseTableRow message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AIRichResponseTableRow
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow;

                /**
                 * Decodes a AIRichResponseTableRow message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AIRichResponseTableRow
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow;

                /**
                 * Verifies a AIRichResponseTableRow message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a AIRichResponseTableRow message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AIRichResponseTableRow
                 */
                public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow;

                /**
                 * Creates a plain object from a AIRichResponseTableRow message. Also converts values to other types if specified.
                 * @param message AIRichResponseTableRow
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.AIRichResponseMessage.AIRichResponseTableMetadata.AIRichResponseTableRow, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AIRichResponseTableRow to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for AIRichResponseTableRow
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }

        /** Properties of a AIRichResponseUnifiedResponse. */
        interface IAIRichResponseUnifiedResponse {

            /** AIRichResponseUnifiedResponse data */
            data?: (Uint8Array|null);
        }

        /** Represents a AIRichResponseUnifiedResponse. */
        class AIRichResponseUnifiedResponse implements IAIRichResponseUnifiedResponse {

            /**
             * Constructs a new AIRichResponseUnifiedResponse.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse);

            /** AIRichResponseUnifiedResponse data. */
            public data?: (Uint8Array|null);

            /**
             * Creates a new AIRichResponseUnifiedResponse instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AIRichResponseUnifiedResponse instance
             */
            public static create(properties?: proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse): proto.AIRichResponseMessage.AIRichResponseUnifiedResponse;

            /**
             * Encodes the specified AIRichResponseUnifiedResponse message. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.verify|verify} messages.
             * @param message AIRichResponseUnifiedResponse message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AIRichResponseUnifiedResponse message, length delimited. Does not implicitly {@link proto.AIRichResponseMessage.AIRichResponseUnifiedResponse.verify|verify} messages.
             * @param message AIRichResponseUnifiedResponse message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.AIRichResponseMessage.IAIRichResponseUnifiedResponse, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a AIRichResponseUnifiedResponse message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AIRichResponseUnifiedResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AIRichResponseMessage.AIRichResponseUnifiedResponse;

            /**
             * Decodes a AIRichResponseUnifiedResponse message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AIRichResponseUnifiedResponse
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AIRichResponseMessage.AIRichResponseUnifiedResponse;

            /**
             * Verifies a AIRichResponseUnifiedResponse message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a AIRichResponseUnifiedResponse message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AIRichResponseUnifiedResponse
             */
            public static fromObject(object: { [k: string]: any }): proto.AIRichResponseMessage.AIRichResponseUnifiedResponse;

            /**
             * Creates a plain object from a AIRichResponseUnifiedResponse message. Also converts values to other types if specified.
             * @param message AIRichResponseUnifiedResponse
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.AIRichResponseMessage.AIRichResponseUnifiedResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AIRichResponseUnifiedResponse to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AIRichResponseUnifiedResponse
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }
    }

    /** Properties of an Account. */
    interface IAccount {

        /** Account lid */
        lid?: (string|null);

        /** Account username */
        username?: (string|null);

        /** Account countryCode */
        countryCode?: (string|null);

        /** Account isUsernameDeleted */
        isUsernameDeleted?: (boolean|null);
    }

    /** Represents an Account. */
    class Account implements IAccount {

        /**
         * Constructs a new Account.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IAccount);

        /** Account lid. */
        public lid?: (string|null);

        /** Account username. */
        public username?: (string|null);

        /** Account countryCode. */
        public countryCode?: (string|null);

        /** Account isUsernameDeleted. */
        public isUsernameDeleted?: (boolean|null);

        /**
         * Creates a new Account instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Account instance
         */
        public static create(properties?: proto.IAccount): proto.Account;

        /**
         * Encodes the specified Account message. Does not implicitly {@link proto.Account.verify|verify} messages.
         * @param message Account message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IAccount, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Account message, length delimited. Does not implicitly {@link proto.Account.verify|verify} messages.
         * @param message Account message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IAccount, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an Account message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Account
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Account;

        /**
         * Decodes an Account message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Account
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Account;

        /**
         * Verifies an Account message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an Account message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Account
         */
        public static fromObject(object: { [k: string]: any }): proto.Account;

        /**
         * Creates a plain object from an Account message. Also converts values to other types if specified.
         * @param message Account
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Account, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Account to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for Account
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an ActionLink. */
    interface IActionLink {

        /** ActionLink url */
        url?: (string|null);

        /** ActionLink buttonTitle */
        buttonTitle?: (string|null);
    }

    /** Represents an ActionLink. */
    class ActionLink implements IActionLink {

        /**
         * Constructs a new ActionLink.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IActionLink);

        /** ActionLink url. */
        public url?: (string|null);

        /** ActionLink buttonTitle. */
        public buttonTitle?: (string|null);

        /**
         * Creates a new ActionLink instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ActionLink instance
         */
        public static create(properties?: proto.IActionLink): proto.ActionLink;

        /**
         * Encodes the specified ActionLink message. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @param message ActionLink message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IActionLink, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ActionLink message, length delimited. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @param message ActionLink message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IActionLink, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an ActionLink message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ActionLink;

        /**
         * Decodes an ActionLink message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ActionLink;

        /**
         * Verifies an ActionLink message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an ActionLink message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ActionLink
         */
        public static fromObject(object: { [k: string]: any }): proto.ActionLink;

        /**
         * Creates a plain object from an ActionLink message. Also converts values to other types if specified.
         * @param message ActionLink
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ActionLink, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ActionLink to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ActionLink
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an AutoDownloadSettings. */
    interface IAutoDownloadSettings {

        /** AutoDownloadSettings downloadImages */
        downloadImages?: (boolean|null);

        /** AutoDownloadSettings downloadAudio */
        downloadAudio?: (boolean|null);

        /** AutoDownloadSettings downloadVideo */
        downloadVideo?: (boolean|null);

        /** AutoDownloadSettings downloadDocuments */
        downloadDocuments?: (boolean|null);
    }

    /** Represents an AutoDownloadSettings. */
    class AutoDownloadSettings implements IAutoDownloadSettings {

        /**
         * Constructs a new AutoDownloadSettings.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IAutoDownloadSettings);

        /** AutoDownloadSettings downloadImages. */
        public downloadImages?: (boolean|null);

        /** AutoDownloadSettings downloadAudio. */
        public downloadAudio?: (boolean|null);

        /** AutoDownloadSettings downloadVideo. */
        public downloadVideo?: (boolean|null);

        /** AutoDownloadSettings downloadDocuments. */
        public downloadDocuments?: (boolean|null);

        /**
         * Creates a new AutoDownloadSettings instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AutoDownloadSettings instance
         */
        public static create(properties?: proto.IAutoDownloadSettings): proto.AutoDownloadSettings;

        /**
         * Encodes the specified AutoDownloadSettings message. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @param message AutoDownloadSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IAutoDownloadSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AutoDownloadSettings message, length delimited. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @param message AutoDownloadSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IAutoDownloadSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AutoDownloadSettings;

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AutoDownloadSettings;

        /**
         * Verifies an AutoDownloadSettings message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AutoDownloadSettings message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AutoDownloadSettings
         */
        public static fromObject(object: { [k: string]: any }): proto.AutoDownloadSettings;

        /**
         * Creates a plain object from an AutoDownloadSettings message. Also converts values to other types if specified.
         * @param message AutoDownloadSettings
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.AutoDownloadSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AutoDownloadSettings to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for AutoDownloadSettings
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an AvatarUserSettings. */
    interface IAvatarUserSettings {

        /** AvatarUserSettings fbid */
        fbid?: (string|null);

        /** AvatarUserSettings password */
        password?: (string|null);
    }

    /** Represents an AvatarUserSettings. */
    class AvatarUserSettings implements IAvatarUserSettings {

        /**
         * Constructs a new AvatarUserSettings.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IAvatarUserSettings);

        /** AvatarUserSettings fbid. */
        public fbid?: (string|null);

        /** AvatarUserSettings password. */
        public password?: (string|null);

        /**
         * Creates a new AvatarUserSettings instance using the specified properties.
         * @param [properties] Properties to set
         * @returns AvatarUserSettings instance
         */
        public static create(properties?: proto.IAvatarUserSettings): proto.AvatarUserSettings;

        /**
         * Encodes the specified AvatarUserSettings message. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @param message AvatarUserSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IAvatarUserSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified AvatarUserSettings message, length delimited. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @param message AvatarUserSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IAvatarUserSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.AvatarUserSettings;

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.AvatarUserSettings;

        /**
         * Verifies an AvatarUserSettings message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an AvatarUserSettings message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns AvatarUserSettings
         */
        public static fromObject(object: { [k: string]: any }): proto.AvatarUserSettings;

        /**
         * Creates a plain object from an AvatarUserSettings message. Also converts values to other types if specified.
         * @param message AvatarUserSettings
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.AvatarUserSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this AvatarUserSettings to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for AvatarUserSettings
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BizAccountLinkInfo. */
    interface IBizAccountLinkInfo {

        /** BizAccountLinkInfo whatsappBizAcctFbid */
        whatsappBizAcctFbid?: (number|Long|null);

        /** BizAccountLinkInfo whatsappAcctNumber */
        whatsappAcctNumber?: (string|null);

        /** BizAccountLinkInfo issueTime */
        issueTime?: (number|Long|null);

        /** BizAccountLinkInfo hostStorage */
        hostStorage?: (proto.BizAccountLinkInfo.HostStorageType|null);

        /** BizAccountLinkInfo accountType */
        accountType?: (proto.BizAccountLinkInfo.AccountType|null);
    }

    /** Represents a BizAccountLinkInfo. */
    class BizAccountLinkInfo implements IBizAccountLinkInfo {

        /**
         * Constructs a new BizAccountLinkInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBizAccountLinkInfo);

        /** BizAccountLinkInfo whatsappBizAcctFbid. */
        public whatsappBizAcctFbid?: (number|Long|null);

        /** BizAccountLinkInfo whatsappAcctNumber. */
        public whatsappAcctNumber?: (string|null);

        /** BizAccountLinkInfo issueTime. */
        public issueTime?: (number|Long|null);

        /** BizAccountLinkInfo hostStorage. */
        public hostStorage?: (proto.BizAccountLinkInfo.HostStorageType|null);

        /** BizAccountLinkInfo accountType. */
        public accountType?: (proto.BizAccountLinkInfo.AccountType|null);

        /**
         * Creates a new BizAccountLinkInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BizAccountLinkInfo instance
         */
        public static create(properties?: proto.IBizAccountLinkInfo): proto.BizAccountLinkInfo;

        /**
         * Encodes the specified BizAccountLinkInfo message. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @param message BizAccountLinkInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBizAccountLinkInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BizAccountLinkInfo message, length delimited. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @param message BizAccountLinkInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBizAccountLinkInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BizAccountLinkInfo;

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BizAccountLinkInfo;

        /**
         * Verifies a BizAccountLinkInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BizAccountLinkInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BizAccountLinkInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.BizAccountLinkInfo;

        /**
         * Creates a plain object from a BizAccountLinkInfo message. Also converts values to other types if specified.
         * @param message BizAccountLinkInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BizAccountLinkInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BizAccountLinkInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BizAccountLinkInfo
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BizAccountLinkInfo {

        /** AccountType enum. */
        enum AccountType {
            ENTERPRISE = 0
        }

        /** HostStorageType enum. */
        enum HostStorageType {
            ON_PREMISE = 0,
            FACEBOOK = 1
        }
    }

    /** Properties of a BizAccountPayload. */
    interface IBizAccountPayload {

        /** BizAccountPayload vnameCert */
        vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizAccountPayload bizAcctLinkInfo */
        bizAcctLinkInfo?: (Uint8Array|null);
    }

    /** Represents a BizAccountPayload. */
    class BizAccountPayload implements IBizAccountPayload {

        /**
         * Constructs a new BizAccountPayload.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBizAccountPayload);

        /** BizAccountPayload vnameCert. */
        public vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizAccountPayload bizAcctLinkInfo. */
        public bizAcctLinkInfo?: (Uint8Array|null);

        /**
         * Creates a new BizAccountPayload instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BizAccountPayload instance
         */
        public static create(properties?: proto.IBizAccountPayload): proto.BizAccountPayload;

        /**
         * Encodes the specified BizAccountPayload message. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @param message BizAccountPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBizAccountPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BizAccountPayload message, length delimited. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @param message BizAccountPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBizAccountPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BizAccountPayload;

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BizAccountPayload;

        /**
         * Verifies a BizAccountPayload message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BizAccountPayload message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BizAccountPayload
         */
        public static fromObject(object: { [k: string]: any }): proto.BizAccountPayload;

        /**
         * Creates a plain object from a BizAccountPayload message. Also converts values to other types if specified.
         * @param message BizAccountPayload
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BizAccountPayload, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BizAccountPayload to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BizAccountPayload
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BizIdentityInfo. */
    interface IBizIdentityInfo {

        /** BizIdentityInfo vlevel */
        vlevel?: (proto.BizIdentityInfo.VerifiedLevelValue|null);

        /** BizIdentityInfo vnameCert */
        vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizIdentityInfo signed */
        signed?: (boolean|null);

        /** BizIdentityInfo revoked */
        revoked?: (boolean|null);

        /** BizIdentityInfo hostStorage */
        hostStorage?: (proto.BizIdentityInfo.HostStorageType|null);

        /** BizIdentityInfo actualActors */
        actualActors?: (proto.BizIdentityInfo.ActualActorsType|null);

        /** BizIdentityInfo privacyModeTs */
        privacyModeTs?: (number|Long|null);

        /** BizIdentityInfo featureControls */
        featureControls?: (number|Long|null);
    }

    /** Represents a BizIdentityInfo. */
    class BizIdentityInfo implements IBizIdentityInfo {

        /**
         * Constructs a new BizIdentityInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBizIdentityInfo);

        /** BizIdentityInfo vlevel. */
        public vlevel?: (proto.BizIdentityInfo.VerifiedLevelValue|null);

        /** BizIdentityInfo vnameCert. */
        public vnameCert?: (proto.IVerifiedNameCertificate|null);

        /** BizIdentityInfo signed. */
        public signed?: (boolean|null);

        /** BizIdentityInfo revoked. */
        public revoked?: (boolean|null);

        /** BizIdentityInfo hostStorage. */
        public hostStorage?: (proto.BizIdentityInfo.HostStorageType|null);

        /** BizIdentityInfo actualActors. */
        public actualActors?: (proto.BizIdentityInfo.ActualActorsType|null);

        /** BizIdentityInfo privacyModeTs. */
        public privacyModeTs?: (number|Long|null);

        /** BizIdentityInfo featureControls. */
        public featureControls?: (number|Long|null);

        /**
         * Creates a new BizIdentityInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BizIdentityInfo instance
         */
        public static create(properties?: proto.IBizIdentityInfo): proto.BizIdentityInfo;

        /**
         * Encodes the specified BizIdentityInfo message. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @param message BizIdentityInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBizIdentityInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BizIdentityInfo message, length delimited. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @param message BizIdentityInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBizIdentityInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BizIdentityInfo;

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BizIdentityInfo;

        /**
         * Verifies a BizIdentityInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BizIdentityInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BizIdentityInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.BizIdentityInfo;

        /**
         * Creates a plain object from a BizIdentityInfo message. Also converts values to other types if specified.
         * @param message BizIdentityInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BizIdentityInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BizIdentityInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BizIdentityInfo
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BizIdentityInfo {

        /** ActualActorsType enum. */
        enum ActualActorsType {
            SELF = 0,
            BSP = 1
        }

        /** HostStorageType enum. */
        enum HostStorageType {
            ON_PREMISE = 0,
            FACEBOOK = 1
        }

        /** VerifiedLevelValue enum. */
        enum VerifiedLevelValue {
            UNKNOWN = 0,
            LOW = 1,
            HIGH = 2
        }
    }

    /** Properties of a BotAgeCollectionMetadata. */
    interface IBotAgeCollectionMetadata {

        /** BotAgeCollectionMetadata ageCollectionEligible */
        ageCollectionEligible?: (boolean|null);

        /** BotAgeCollectionMetadata shouldTriggerAgeCollectionOnClient */
        shouldTriggerAgeCollectionOnClient?: (boolean|null);
    }

    /** Represents a BotAgeCollectionMetadata. */
    class BotAgeCollectionMetadata implements IBotAgeCollectionMetadata {

        /**
         * Constructs a new BotAgeCollectionMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotAgeCollectionMetadata);

        /** BotAgeCollectionMetadata ageCollectionEligible. */
        public ageCollectionEligible?: (boolean|null);

        /** BotAgeCollectionMetadata shouldTriggerAgeCollectionOnClient. */
        public shouldTriggerAgeCollectionOnClient?: (boolean|null);

        /**
         * Creates a new BotAgeCollectionMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotAgeCollectionMetadata instance
         */
        public static create(properties?: proto.IBotAgeCollectionMetadata): proto.BotAgeCollectionMetadata;

        /**
         * Encodes the specified BotAgeCollectionMetadata message. Does not implicitly {@link proto.BotAgeCollectionMetadata.verify|verify} messages.
         * @param message BotAgeCollectionMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotAgeCollectionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotAgeCollectionMetadata message, length delimited. Does not implicitly {@link proto.BotAgeCollectionMetadata.verify|verify} messages.
         * @param message BotAgeCollectionMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotAgeCollectionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotAgeCollectionMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotAgeCollectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotAgeCollectionMetadata;

        /**
         * Decodes a BotAgeCollectionMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotAgeCollectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotAgeCollectionMetadata;

        /**
         * Verifies a BotAgeCollectionMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotAgeCollectionMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotAgeCollectionMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotAgeCollectionMetadata;

        /**
         * Creates a plain object from a BotAgeCollectionMetadata message. Also converts values to other types if specified.
         * @param message BotAgeCollectionMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotAgeCollectionMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotAgeCollectionMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotAgeCollectionMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotAvatarMetadata. */
    interface IBotAvatarMetadata {

        /** BotAvatarMetadata sentiment */
        sentiment?: (number|null);

        /** BotAvatarMetadata behaviorGraph */
        behaviorGraph?: (string|null);

        /** BotAvatarMetadata action */
        action?: (number|null);

        /** BotAvatarMetadata intensity */
        intensity?: (number|null);

        /** BotAvatarMetadata wordCount */
        wordCount?: (number|null);
    }

    /** Represents a BotAvatarMetadata. */
    class BotAvatarMetadata implements IBotAvatarMetadata {

        /**
         * Constructs a new BotAvatarMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotAvatarMetadata);

        /** BotAvatarMetadata sentiment. */
        public sentiment?: (number|null);

        /** BotAvatarMetadata behaviorGraph. */
        public behaviorGraph?: (string|null);

        /** BotAvatarMetadata action. */
        public action?: (number|null);

        /** BotAvatarMetadata intensity. */
        public intensity?: (number|null);

        /** BotAvatarMetadata wordCount. */
        public wordCount?: (number|null);

        /**
         * Creates a new BotAvatarMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotAvatarMetadata instance
         */
        public static create(properties?: proto.IBotAvatarMetadata): proto.BotAvatarMetadata;

        /**
         * Encodes the specified BotAvatarMetadata message. Does not implicitly {@link proto.BotAvatarMetadata.verify|verify} messages.
         * @param message BotAvatarMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotAvatarMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotAvatarMetadata message, length delimited. Does not implicitly {@link proto.BotAvatarMetadata.verify|verify} messages.
         * @param message BotAvatarMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotAvatarMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotAvatarMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotAvatarMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotAvatarMetadata;

        /**
         * Decodes a BotAvatarMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotAvatarMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotAvatarMetadata;

        /**
         * Verifies a BotAvatarMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotAvatarMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotAvatarMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotAvatarMetadata;

        /**
         * Creates a plain object from a BotAvatarMetadata message. Also converts values to other types if specified.
         * @param message BotAvatarMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotAvatarMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotAvatarMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotAvatarMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotCapabilityMetadata. */
    interface IBotCapabilityMetadata {

        /** BotCapabilityMetadata capabilities */
        capabilities?: (proto.BotCapabilityMetadata.BotCapabilityType[]|null);
    }

    /** Represents a BotCapabilityMetadata. */
    class BotCapabilityMetadata implements IBotCapabilityMetadata {

        /**
         * Constructs a new BotCapabilityMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotCapabilityMetadata);

        /** BotCapabilityMetadata capabilities. */
        public capabilities: proto.BotCapabilityMetadata.BotCapabilityType[];

        /**
         * Creates a new BotCapabilityMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotCapabilityMetadata instance
         */
        public static create(properties?: proto.IBotCapabilityMetadata): proto.BotCapabilityMetadata;

        /**
         * Encodes the specified BotCapabilityMetadata message. Does not implicitly {@link proto.BotCapabilityMetadata.verify|verify} messages.
         * @param message BotCapabilityMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotCapabilityMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotCapabilityMetadata message, length delimited. Does not implicitly {@link proto.BotCapabilityMetadata.verify|verify} messages.
         * @param message BotCapabilityMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotCapabilityMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotCapabilityMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotCapabilityMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotCapabilityMetadata;

        /**
         * Decodes a BotCapabilityMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotCapabilityMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotCapabilityMetadata;

        /**
         * Verifies a BotCapabilityMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotCapabilityMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotCapabilityMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotCapabilityMetadata;

        /**
         * Creates a plain object from a BotCapabilityMetadata message. Also converts values to other types if specified.
         * @param message BotCapabilityMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotCapabilityMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotCapabilityMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotCapabilityMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotCapabilityMetadata {

        /** BotCapabilityType enum. */
        enum BotCapabilityType {
            UNKNOWN = 0,
            PROGRESS_INDICATOR = 1,
            RICH_RESPONSE_HEADING = 2,
            RICH_RESPONSE_NESTED_LIST = 3,
            AI_MEMORY = 4,
            RICH_RESPONSE_THREAD_SURFING = 5,
            RICH_RESPONSE_TABLE = 6,
            RICH_RESPONSE_CODE = 7,
            RICH_RESPONSE_STRUCTURED_RESPONSE = 8,
            RICH_RESPONSE_INLINE_IMAGE = 9,
            WA_IG_1P_PLUGIN_RANKING_CONTROL = 10,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_1 = 11,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_2 = 12,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_3 = 13,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_4 = 14,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_5 = 15,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_6 = 16,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_7 = 17,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_8 = 18,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_9 = 19,
            WA_IG_1P_PLUGIN_RANKING_UPDATE_10 = 20,
            RICH_RESPONSE_SUB_HEADING = 21,
            RICH_RESPONSE_GRID_IMAGE = 22,
            AI_STUDIO_UGC_MEMORY = 23,
            RICH_RESPONSE_LATEX = 24,
            RICH_RESPONSE_MAPS = 25,
            RICH_RESPONSE_INLINE_REELS = 26,
            AGENTIC_PLANNING = 27,
            ACCOUNT_LINKING = 28,
            STREAMING_DISAGGREGATION = 29,
            RICH_RESPONSE_GRID_IMAGE_3P = 30,
            RICH_RESPONSE_LATEX_INLINE = 31,
            QUERY_PLAN = 32,
            PROACTIVE_MESSAGE = 33,
            RICH_RESPONSE_UNIFIED_RESPONSE = 34,
            PROMOTION_MESSAGE = 35
        }
    }

    /** Properties of a BotImagineMetadata. */
    interface IBotImagineMetadata {

        /** BotImagineMetadata imagineType */
        imagineType?: (proto.BotImagineMetadata.ImagineType|null);
    }

    /** Represents a BotImagineMetadata. */
    class BotImagineMetadata implements IBotImagineMetadata {

        /**
         * Constructs a new BotImagineMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotImagineMetadata);

        /** BotImagineMetadata imagineType. */
        public imagineType?: (proto.BotImagineMetadata.ImagineType|null);

        /**
         * Creates a new BotImagineMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotImagineMetadata instance
         */
        public static create(properties?: proto.IBotImagineMetadata): proto.BotImagineMetadata;

        /**
         * Encodes the specified BotImagineMetadata message. Does not implicitly {@link proto.BotImagineMetadata.verify|verify} messages.
         * @param message BotImagineMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotImagineMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotImagineMetadata message, length delimited. Does not implicitly {@link proto.BotImagineMetadata.verify|verify} messages.
         * @param message BotImagineMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotImagineMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotImagineMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotImagineMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotImagineMetadata;

        /**
         * Decodes a BotImagineMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotImagineMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotImagineMetadata;

        /**
         * Verifies a BotImagineMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotImagineMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotImagineMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotImagineMetadata;

        /**
         * Creates a plain object from a BotImagineMetadata message. Also converts values to other types if specified.
         * @param message BotImagineMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotImagineMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotImagineMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotImagineMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotImagineMetadata {

        /** ImagineType enum. */
        enum ImagineType {
            UNKNOWN = 0,
            IMAGINE = 1,
            MEMU = 2,
            FLASH = 3,
            EDIT = 4
        }
    }

    /** Properties of a BotLinkedAccount. */
    interface IBotLinkedAccount {

        /** BotLinkedAccount type */
        type?: (proto.BotLinkedAccount.BotLinkedAccountType|null);
    }

    /** Represents a BotLinkedAccount. */
    class BotLinkedAccount implements IBotLinkedAccount {

        /**
         * Constructs a new BotLinkedAccount.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotLinkedAccount);

        /** BotLinkedAccount type. */
        public type?: (proto.BotLinkedAccount.BotLinkedAccountType|null);

        /**
         * Creates a new BotLinkedAccount instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotLinkedAccount instance
         */
        public static create(properties?: proto.IBotLinkedAccount): proto.BotLinkedAccount;

        /**
         * Encodes the specified BotLinkedAccount message. Does not implicitly {@link proto.BotLinkedAccount.verify|verify} messages.
         * @param message BotLinkedAccount message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotLinkedAccount, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotLinkedAccount message, length delimited. Does not implicitly {@link proto.BotLinkedAccount.verify|verify} messages.
         * @param message BotLinkedAccount message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotLinkedAccount, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotLinkedAccount message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotLinkedAccount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotLinkedAccount;

        /**
         * Decodes a BotLinkedAccount message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotLinkedAccount
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotLinkedAccount;

        /**
         * Verifies a BotLinkedAccount message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotLinkedAccount message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotLinkedAccount
         */
        public static fromObject(object: { [k: string]: any }): proto.BotLinkedAccount;

        /**
         * Creates a plain object from a BotLinkedAccount message. Also converts values to other types if specified.
         * @param message BotLinkedAccount
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotLinkedAccount, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotLinkedAccount to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotLinkedAccount
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotLinkedAccount {

        /** BotLinkedAccountType enum. */
        enum BotLinkedAccountType {
            BOT_LINKED_ACCOUNT_TYPE_1P = 0
        }
    }

    /** Properties of a BotLinkedAccountsMetadata. */
    interface IBotLinkedAccountsMetadata {

        /** BotLinkedAccountsMetadata accounts */
        accounts?: (proto.IBotLinkedAccount[]|null);

        /** BotLinkedAccountsMetadata acAuthTokens */
        acAuthTokens?: (Uint8Array|null);

        /** BotLinkedAccountsMetadata acErrorCode */
        acErrorCode?: (number|null);
    }

    /** Represents a BotLinkedAccountsMetadata. */
    class BotLinkedAccountsMetadata implements IBotLinkedAccountsMetadata {

        /**
         * Constructs a new BotLinkedAccountsMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotLinkedAccountsMetadata);

        /** BotLinkedAccountsMetadata accounts. */
        public accounts: proto.IBotLinkedAccount[];

        /** BotLinkedAccountsMetadata acAuthTokens. */
        public acAuthTokens?: (Uint8Array|null);

        /** BotLinkedAccountsMetadata acErrorCode. */
        public acErrorCode?: (number|null);

        /**
         * Creates a new BotLinkedAccountsMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotLinkedAccountsMetadata instance
         */
        public static create(properties?: proto.IBotLinkedAccountsMetadata): proto.BotLinkedAccountsMetadata;

        /**
         * Encodes the specified BotLinkedAccountsMetadata message. Does not implicitly {@link proto.BotLinkedAccountsMetadata.verify|verify} messages.
         * @param message BotLinkedAccountsMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotLinkedAccountsMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotLinkedAccountsMetadata message, length delimited. Does not implicitly {@link proto.BotLinkedAccountsMetadata.verify|verify} messages.
         * @param message BotLinkedAccountsMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotLinkedAccountsMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotLinkedAccountsMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotLinkedAccountsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotLinkedAccountsMetadata;

        /**
         * Decodes a BotLinkedAccountsMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotLinkedAccountsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotLinkedAccountsMetadata;

        /**
         * Verifies a BotLinkedAccountsMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotLinkedAccountsMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotLinkedAccountsMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotLinkedAccountsMetadata;

        /**
         * Creates a plain object from a BotLinkedAccountsMetadata message. Also converts values to other types if specified.
         * @param message BotLinkedAccountsMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotLinkedAccountsMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotLinkedAccountsMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotLinkedAccountsMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotMediaMetadata. */
    interface IBotMediaMetadata {

        /** BotMediaMetadata fileSha256 */
        fileSha256?: (string|null);

        /** BotMediaMetadata mediaKey */
        mediaKey?: (string|null);

        /** BotMediaMetadata fileEncSha256 */
        fileEncSha256?: (string|null);

        /** BotMediaMetadata directPath */
        directPath?: (string|null);

        /** BotMediaMetadata mediaKeyTimestamp */
        mediaKeyTimestamp?: (number|Long|null);

        /** BotMediaMetadata mimetype */
        mimetype?: (string|null);

        /** BotMediaMetadata orientationType */
        orientationType?: (proto.BotMediaMetadata.OrientationType|null);
    }

    /** Represents a BotMediaMetadata. */
    class BotMediaMetadata implements IBotMediaMetadata {

        /**
         * Constructs a new BotMediaMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotMediaMetadata);

        /** BotMediaMetadata fileSha256. */
        public fileSha256?: (string|null);

        /** BotMediaMetadata mediaKey. */
        public mediaKey?: (string|null);

        /** BotMediaMetadata fileEncSha256. */
        public fileEncSha256?: (string|null);

        /** BotMediaMetadata directPath. */
        public directPath?: (string|null);

        /** BotMediaMetadata mediaKeyTimestamp. */
        public mediaKeyTimestamp?: (number|Long|null);

        /** BotMediaMetadata mimetype. */
        public mimetype?: (string|null);

        /** BotMediaMetadata orientationType. */
        public orientationType?: (proto.BotMediaMetadata.OrientationType|null);

        /**
         * Creates a new BotMediaMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotMediaMetadata instance
         */
        public static create(properties?: proto.IBotMediaMetadata): proto.BotMediaMetadata;

        /**
         * Encodes the specified BotMediaMetadata message. Does not implicitly {@link proto.BotMediaMetadata.verify|verify} messages.
         * @param message BotMediaMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotMediaMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotMediaMetadata message, length delimited. Does not implicitly {@link proto.BotMediaMetadata.verify|verify} messages.
         * @param message BotMediaMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotMediaMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotMediaMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotMediaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotMediaMetadata;

        /**
         * Decodes a BotMediaMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotMediaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotMediaMetadata;

        /**
         * Verifies a BotMediaMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotMediaMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotMediaMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotMediaMetadata;

        /**
         * Creates a plain object from a BotMediaMetadata message. Also converts values to other types if specified.
         * @param message BotMediaMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotMediaMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotMediaMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotMediaMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotMediaMetadata {

        /** OrientationType enum. */
        enum OrientationType {
            CENTER = 1,
            LEFT = 2,
            RIGHT = 3
        }
    }

    /** Properties of a BotMemoryFact. */
    interface IBotMemoryFact {

        /** BotMemoryFact fact */
        fact?: (string|null);

        /** BotMemoryFact factId */
        factId?: (string|null);
    }

    /** Represents a BotMemoryFact. */
    class BotMemoryFact implements IBotMemoryFact {

        /**
         * Constructs a new BotMemoryFact.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotMemoryFact);

        /** BotMemoryFact fact. */
        public fact?: (string|null);

        /** BotMemoryFact factId. */
        public factId?: (string|null);

        /**
         * Creates a new BotMemoryFact instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotMemoryFact instance
         */
        public static create(properties?: proto.IBotMemoryFact): proto.BotMemoryFact;

        /**
         * Encodes the specified BotMemoryFact message. Does not implicitly {@link proto.BotMemoryFact.verify|verify} messages.
         * @param message BotMemoryFact message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotMemoryFact, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotMemoryFact message, length delimited. Does not implicitly {@link proto.BotMemoryFact.verify|verify} messages.
         * @param message BotMemoryFact message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotMemoryFact, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotMemoryFact message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotMemoryFact
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotMemoryFact;

        /**
         * Decodes a BotMemoryFact message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotMemoryFact
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotMemoryFact;

        /**
         * Verifies a BotMemoryFact message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotMemoryFact message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotMemoryFact
         */
        public static fromObject(object: { [k: string]: any }): proto.BotMemoryFact;

        /**
         * Creates a plain object from a BotMemoryFact message. Also converts values to other types if specified.
         * @param message BotMemoryFact
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotMemoryFact, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotMemoryFact to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotMemoryFact
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotMemoryMetadata. */
    interface IBotMemoryMetadata {

        /** BotMemoryMetadata addedFacts */
        addedFacts?: (proto.IBotMemoryFact[]|null);

        /** BotMemoryMetadata removedFacts */
        removedFacts?: (proto.IBotMemoryFact[]|null);

        /** BotMemoryMetadata disclaimer */
        disclaimer?: (string|null);
    }

    /** Represents a BotMemoryMetadata. */
    class BotMemoryMetadata implements IBotMemoryMetadata {

        /**
         * Constructs a new BotMemoryMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotMemoryMetadata);

        /** BotMemoryMetadata addedFacts. */
        public addedFacts: proto.IBotMemoryFact[];

        /** BotMemoryMetadata removedFacts. */
        public removedFacts: proto.IBotMemoryFact[];

        /** BotMemoryMetadata disclaimer. */
        public disclaimer?: (string|null);

        /**
         * Creates a new BotMemoryMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotMemoryMetadata instance
         */
        public static create(properties?: proto.IBotMemoryMetadata): proto.BotMemoryMetadata;

        /**
         * Encodes the specified BotMemoryMetadata message. Does not implicitly {@link proto.BotMemoryMetadata.verify|verify} messages.
         * @param message BotMemoryMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotMemoryMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotMemoryMetadata message, length delimited. Does not implicitly {@link proto.BotMemoryMetadata.verify|verify} messages.
         * @param message BotMemoryMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotMemoryMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotMemoryMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotMemoryMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotMemoryMetadata;

        /**
         * Decodes a BotMemoryMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotMemoryMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotMemoryMetadata;

        /**
         * Verifies a BotMemoryMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotMemoryMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotMemoryMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotMemoryMetadata;

        /**
         * Creates a plain object from a BotMemoryMetadata message. Also converts values to other types if specified.
         * @param message BotMemoryMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotMemoryMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotMemoryMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotMemoryMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotMemuMetadata. */
    interface IBotMemuMetadata {

        /** BotMemuMetadata faceImages */
        faceImages?: (proto.IBotMediaMetadata[]|null);
    }

    /** Represents a BotMemuMetadata. */
    class BotMemuMetadata implements IBotMemuMetadata {

        /**
         * Constructs a new BotMemuMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotMemuMetadata);

        /** BotMemuMetadata faceImages. */
        public faceImages: proto.IBotMediaMetadata[];

        /**
         * Creates a new BotMemuMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotMemuMetadata instance
         */
        public static create(properties?: proto.IBotMemuMetadata): proto.BotMemuMetadata;

        /**
         * Encodes the specified BotMemuMetadata message. Does not implicitly {@link proto.BotMemuMetadata.verify|verify} messages.
         * @param message BotMemuMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotMemuMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotMemuMetadata message, length delimited. Does not implicitly {@link proto.BotMemuMetadata.verify|verify} messages.
         * @param message BotMemuMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotMemuMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotMemuMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotMemuMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotMemuMetadata;

        /**
         * Decodes a BotMemuMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotMemuMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotMemuMetadata;

        /**
         * Verifies a BotMemuMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotMemuMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotMemuMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotMemuMetadata;

        /**
         * Creates a plain object from a BotMemuMetadata message. Also converts values to other types if specified.
         * @param message BotMemuMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotMemuMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotMemuMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotMemuMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotMetadata. */
    interface IBotMetadata {

        /** BotMetadata avatarMetadata */
        avatarMetadata?: (proto.IBotAvatarMetadata|null);

        /** BotMetadata personaId */
        personaId?: (string|null);

        /** BotMetadata pluginMetadata */
        pluginMetadata?: (proto.IBotPluginMetadata|null);

        /** BotMetadata suggestedPromptMetadata */
        suggestedPromptMetadata?: (proto.IBotSuggestedPromptMetadata|null);

        /** BotMetadata invokerJid */
        invokerJid?: (string|null);

        /** BotMetadata sessionMetadata */
        sessionMetadata?: (proto.IBotSessionMetadata|null);

        /** BotMetadata memuMetadata */
        memuMetadata?: (proto.IBotMemuMetadata|null);

        /** BotMetadata timezone */
        timezone?: (string|null);

        /** BotMetadata reminderMetadata */
        reminderMetadata?: (proto.IBotReminderMetadata|null);

        /** BotMetadata modelMetadata */
        modelMetadata?: (proto.IBotModelMetadata|null);

        /** BotMetadata messageDisclaimerText */
        messageDisclaimerText?: (string|null);

        /** BotMetadata progressIndicatorMetadata */
        progressIndicatorMetadata?: (proto.IBotProgressIndicatorMetadata|null);

        /** BotMetadata capabilityMetadata */
        capabilityMetadata?: (proto.IBotCapabilityMetadata|null);

        /** BotMetadata imagineMetadata */
        imagineMetadata?: (proto.IBotImagineMetadata|null);

        /** BotMetadata memoryMetadata */
        memoryMetadata?: (proto.IBotMemoryMetadata|null);

        /** BotMetadata renderingMetadata */
        renderingMetadata?: (proto.IBotRenderingMetadata|null);

        /** BotMetadata botMetricsMetadata */
        botMetricsMetadata?: (proto.IBotMetricsMetadata|null);

        /** BotMetadata botLinkedAccountsMetadata */
        botLinkedAccountsMetadata?: (proto.IBotLinkedAccountsMetadata|null);

        /** BotMetadata richResponseSourcesMetadata */
        richResponseSourcesMetadata?: (proto.IBotSourcesMetadata|null);

        /** BotMetadata aiConversationContext */
        aiConversationContext?: (Uint8Array|null);

        /** BotMetadata botPromotionMessageMetadata */
        botPromotionMessageMetadata?: (proto.IBotPromotionMessageMetadata|null);

        /** BotMetadata botModeSelectionMetadata */
        botModeSelectionMetadata?: (proto.IBotModeSelectionMetadata|null);

        /** BotMetadata botQuotaMetadata */
        botQuotaMetadata?: (proto.IBotQuotaMetadata|null);

        /** BotMetadata botAgeCollectionMetadata */
        botAgeCollectionMetadata?: (proto.IBotAgeCollectionMetadata|null);
    }

    /** Represents a BotMetadata. */
    class BotMetadata implements IBotMetadata {

        /**
         * Constructs a new BotMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotMetadata);

        /** BotMetadata avatarMetadata. */
        public avatarMetadata?: (proto.IBotAvatarMetadata|null);

        /** BotMetadata personaId. */
        public personaId?: (string|null);

        /** BotMetadata pluginMetadata. */
        public pluginMetadata?: (proto.IBotPluginMetadata|null);

        /** BotMetadata suggestedPromptMetadata. */
        public suggestedPromptMetadata?: (proto.IBotSuggestedPromptMetadata|null);

        /** BotMetadata invokerJid. */
        public invokerJid?: (string|null);

        /** BotMetadata sessionMetadata. */
        public sessionMetadata?: (proto.IBotSessionMetadata|null);

        /** BotMetadata memuMetadata. */
        public memuMetadata?: (proto.IBotMemuMetadata|null);

        /** BotMetadata timezone. */
        public timezone?: (string|null);

        /** BotMetadata reminderMetadata. */
        public reminderMetadata?: (proto.IBotReminderMetadata|null);

        /** BotMetadata modelMetadata. */
        public modelMetadata?: (proto.IBotModelMetadata|null);

        /** BotMetadata messageDisclaimerText. */
        public messageDisclaimerText?: (string|null);

        /** BotMetadata progressIndicatorMetadata. */
        public progressIndicatorMetadata?: (proto.IBotProgressIndicatorMetadata|null);

        /** BotMetadata capabilityMetadata. */
        public capabilityMetadata?: (proto.IBotCapabilityMetadata|null);

        /** BotMetadata imagineMetadata. */
        public imagineMetadata?: (proto.IBotImagineMetadata|null);

        /** BotMetadata memoryMetadata. */
        public memoryMetadata?: (proto.IBotMemoryMetadata|null);

        /** BotMetadata renderingMetadata. */
        public renderingMetadata?: (proto.IBotRenderingMetadata|null);

        /** BotMetadata botMetricsMetadata. */
        public botMetricsMetadata?: (proto.IBotMetricsMetadata|null);

        /** BotMetadata botLinkedAccountsMetadata. */
        public botLinkedAccountsMetadata?: (proto.IBotLinkedAccountsMetadata|null);

        /** BotMetadata richResponseSourcesMetadata. */
        public richResponseSourcesMetadata?: (proto.IBotSourcesMetadata|null);

        /** BotMetadata aiConversationContext. */
        public aiConversationContext?: (Uint8Array|null);

        /** BotMetadata botPromotionMessageMetadata. */
        public botPromotionMessageMetadata?: (proto.IBotPromotionMessageMetadata|null);

        /** BotMetadata botModeSelectionMetadata. */
        public botModeSelectionMetadata?: (proto.IBotModeSelectionMetadata|null);

        /** BotMetadata botQuotaMetadata. */
        public botQuotaMetadata?: (proto.IBotQuotaMetadata|null);

        /** BotMetadata botAgeCollectionMetadata. */
        public botAgeCollectionMetadata?: (proto.IBotAgeCollectionMetadata|null);

        /**
         * Creates a new BotMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotMetadata instance
         */
        public static create(properties?: proto.IBotMetadata): proto.BotMetadata;

        /**
         * Encodes the specified BotMetadata message. Does not implicitly {@link proto.BotMetadata.verify|verify} messages.
         * @param message BotMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotMetadata message, length delimited. Does not implicitly {@link proto.BotMetadata.verify|verify} messages.
         * @param message BotMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotMetadata;

        /**
         * Decodes a BotMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotMetadata;

        /**
         * Verifies a BotMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotMetadata;

        /**
         * Creates a plain object from a BotMetadata message. Also converts values to other types if specified.
         * @param message BotMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** BotMetricsEntryPoint enum. */
    enum BotMetricsEntryPoint {
        FAVICON = 1,
        CHATLIST = 2,
        AISEARCH_NULL_STATE_PAPER_PLANE = 3,
        AISEARCH_NULL_STATE_SUGGESTION = 4,
        AISEARCH_TYPE_AHEAD_SUGGESTION = 5,
        AISEARCH_TYPE_AHEAD_PAPER_PLANE = 6,
        AISEARCH_TYPE_AHEAD_RESULT_CHATLIST = 7,
        AISEARCH_TYPE_AHEAD_RESULT_MESSAGES = 8,
        AIVOICE_SEARCH_BAR = 9,
        AIVOICE_FAVICON = 10,
        AISTUDIO = 11,
        DEEPLINK = 12,
        NOTIFICATION = 13,
        PROFILE_MESSAGE_BUTTON = 14,
        FORWARD = 15,
        APP_SHORTCUT = 16,
        FF_FAMILY = 17,
        AI_TAB = 18,
        AI_HOME = 19,
        AI_DEEPLINK_IMMERSIVE = 20,
        AI_DEEPLINK = 21,
        META_AI_CHAT_SHORTCUT_AI_STUDIO = 22,
        UGC_CHAT_SHORTCUT_AI_STUDIO = 23,
        NEW_CHAT_AI_STUDIO = 24
    }

    /** Properties of a BotMetricsMetadata. */
    interface IBotMetricsMetadata {

        /** BotMetricsMetadata destinationId */
        destinationId?: (string|null);

        /** BotMetricsMetadata destinationEntryPoint */
        destinationEntryPoint?: (proto.BotMetricsEntryPoint|null);

        /** BotMetricsMetadata threadOrigin */
        threadOrigin?: (proto.BotMetricsThreadEntryPoint|null);
    }

    /** Represents a BotMetricsMetadata. */
    class BotMetricsMetadata implements IBotMetricsMetadata {

        /**
         * Constructs a new BotMetricsMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotMetricsMetadata);

        /** BotMetricsMetadata destinationId. */
        public destinationId?: (string|null);

        /** BotMetricsMetadata destinationEntryPoint. */
        public destinationEntryPoint?: (proto.BotMetricsEntryPoint|null);

        /** BotMetricsMetadata threadOrigin. */
        public threadOrigin?: (proto.BotMetricsThreadEntryPoint|null);

        /**
         * Creates a new BotMetricsMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotMetricsMetadata instance
         */
        public static create(properties?: proto.IBotMetricsMetadata): proto.BotMetricsMetadata;

        /**
         * Encodes the specified BotMetricsMetadata message. Does not implicitly {@link proto.BotMetricsMetadata.verify|verify} messages.
         * @param message BotMetricsMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotMetricsMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotMetricsMetadata message, length delimited. Does not implicitly {@link proto.BotMetricsMetadata.verify|verify} messages.
         * @param message BotMetricsMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotMetricsMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotMetricsMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotMetricsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotMetricsMetadata;

        /**
         * Decodes a BotMetricsMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotMetricsMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotMetricsMetadata;

        /**
         * Verifies a BotMetricsMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotMetricsMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotMetricsMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotMetricsMetadata;

        /**
         * Creates a plain object from a BotMetricsMetadata message. Also converts values to other types if specified.
         * @param message BotMetricsMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotMetricsMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotMetricsMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotMetricsMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** BotMetricsThreadEntryPoint enum. */
    enum BotMetricsThreadEntryPoint {
        AI_TAB_THREAD = 1,
        AI_HOME_THREAD = 2,
        AI_DEEPLINK_IMMERSIVE_THREAD = 3,
        AI_DEEPLINK_THREAD = 4
    }

    /** Properties of a BotModeSelectionMetadata. */
    interface IBotModeSelectionMetadata {

        /** BotModeSelectionMetadata mode */
        mode?: (proto.BotModeSelectionMetadata.BotUserSelectionMode[]|null);
    }

    /** Represents a BotModeSelectionMetadata. */
    class BotModeSelectionMetadata implements IBotModeSelectionMetadata {

        /**
         * Constructs a new BotModeSelectionMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotModeSelectionMetadata);

        /** BotModeSelectionMetadata mode. */
        public mode: proto.BotModeSelectionMetadata.BotUserSelectionMode[];

        /**
         * Creates a new BotModeSelectionMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotModeSelectionMetadata instance
         */
        public static create(properties?: proto.IBotModeSelectionMetadata): proto.BotModeSelectionMetadata;

        /**
         * Encodes the specified BotModeSelectionMetadata message. Does not implicitly {@link proto.BotModeSelectionMetadata.verify|verify} messages.
         * @param message BotModeSelectionMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotModeSelectionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotModeSelectionMetadata message, length delimited. Does not implicitly {@link proto.BotModeSelectionMetadata.verify|verify} messages.
         * @param message BotModeSelectionMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotModeSelectionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotModeSelectionMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotModeSelectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotModeSelectionMetadata;

        /**
         * Decodes a BotModeSelectionMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotModeSelectionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotModeSelectionMetadata;

        /**
         * Verifies a BotModeSelectionMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotModeSelectionMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotModeSelectionMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotModeSelectionMetadata;

        /**
         * Creates a plain object from a BotModeSelectionMetadata message. Also converts values to other types if specified.
         * @param message BotModeSelectionMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotModeSelectionMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotModeSelectionMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotModeSelectionMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotModeSelectionMetadata {

        /** BotUserSelectionMode enum. */
        enum BotUserSelectionMode {
            UNKNOWN_MODE = 0,
            REASONING_MODE = 1
        }
    }

    /** Properties of a BotModelMetadata. */
    interface IBotModelMetadata {

        /** BotModelMetadata modelType */
        modelType?: (proto.BotModelMetadata.ModelType|null);

        /** BotModelMetadata premiumModelStatus */
        premiumModelStatus?: (proto.BotModelMetadata.PremiumModelStatus|null);
    }

    /** Represents a BotModelMetadata. */
    class BotModelMetadata implements IBotModelMetadata {

        /**
         * Constructs a new BotModelMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotModelMetadata);

        /** BotModelMetadata modelType. */
        public modelType?: (proto.BotModelMetadata.ModelType|null);

        /** BotModelMetadata premiumModelStatus. */
        public premiumModelStatus?: (proto.BotModelMetadata.PremiumModelStatus|null);

        /**
         * Creates a new BotModelMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotModelMetadata instance
         */
        public static create(properties?: proto.IBotModelMetadata): proto.BotModelMetadata;

        /**
         * Encodes the specified BotModelMetadata message. Does not implicitly {@link proto.BotModelMetadata.verify|verify} messages.
         * @param message BotModelMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotModelMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotModelMetadata message, length delimited. Does not implicitly {@link proto.BotModelMetadata.verify|verify} messages.
         * @param message BotModelMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotModelMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotModelMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotModelMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotModelMetadata;

        /**
         * Decodes a BotModelMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotModelMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotModelMetadata;

        /**
         * Verifies a BotModelMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotModelMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotModelMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotModelMetadata;

        /**
         * Creates a plain object from a BotModelMetadata message. Also converts values to other types if specified.
         * @param message BotModelMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotModelMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotModelMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotModelMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotModelMetadata {

        /** ModelType enum. */
        enum ModelType {
            UNKNOWN_TYPE = 0,
            LLAMA_PROD = 1,
            LLAMA_PROD_PREMIUM = 2
        }

        /** PremiumModelStatus enum. */
        enum PremiumModelStatus {
            UNKNOWN_STATUS = 0,
            AVAILABLE = 1,
            QUOTA_EXCEED_LIMIT = 2
        }
    }

    /** Properties of a BotPluginMetadata. */
    interface IBotPluginMetadata {

        /** BotPluginMetadata provider */
        provider?: (proto.BotPluginMetadata.SearchProvider|null);

        /** BotPluginMetadata pluginType */
        pluginType?: (proto.BotPluginMetadata.PluginType|null);

        /** BotPluginMetadata thumbnailCdnUrl */
        thumbnailCdnUrl?: (string|null);

        /** BotPluginMetadata profilePhotoCdnUrl */
        profilePhotoCdnUrl?: (string|null);

        /** BotPluginMetadata searchProviderUrl */
        searchProviderUrl?: (string|null);

        /** BotPluginMetadata referenceIndex */
        referenceIndex?: (number|null);

        /** BotPluginMetadata expectedLinksCount */
        expectedLinksCount?: (number|null);

        /** BotPluginMetadata searchQuery */
        searchQuery?: (string|null);

        /** BotPluginMetadata parentPluginMessageKey */
        parentPluginMessageKey?: (proto.IMessageKey|null);

        /** BotPluginMetadata deprecatedField */
        deprecatedField?: (proto.BotPluginMetadata.PluginType|null);

        /** BotPluginMetadata parentPluginType */
        parentPluginType?: (proto.BotPluginMetadata.PluginType|null);

        /** BotPluginMetadata faviconCdnUrl */
        faviconCdnUrl?: (string|null);
    }

    /** Represents a BotPluginMetadata. */
    class BotPluginMetadata implements IBotPluginMetadata {

        /**
         * Constructs a new BotPluginMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotPluginMetadata);

        /** BotPluginMetadata provider. */
        public provider?: (proto.BotPluginMetadata.SearchProvider|null);

        /** BotPluginMetadata pluginType. */
        public pluginType?: (proto.BotPluginMetadata.PluginType|null);

        /** BotPluginMetadata thumbnailCdnUrl. */
        public thumbnailCdnUrl?: (string|null);

        /** BotPluginMetadata profilePhotoCdnUrl. */
        public profilePhotoCdnUrl?: (string|null);

        /** BotPluginMetadata searchProviderUrl. */
        public searchProviderUrl?: (string|null);

        /** BotPluginMetadata referenceIndex. */
        public referenceIndex?: (number|null);

        /** BotPluginMetadata expectedLinksCount. */
        public expectedLinksCount?: (number|null);

        /** BotPluginMetadata searchQuery. */
        public searchQuery?: (string|null);

        /** BotPluginMetadata parentPluginMessageKey. */
        public parentPluginMessageKey?: (proto.IMessageKey|null);

        /** BotPluginMetadata deprecatedField. */
        public deprecatedField?: (proto.BotPluginMetadata.PluginType|null);

        /** BotPluginMetadata parentPluginType. */
        public parentPluginType?: (proto.BotPluginMetadata.PluginType|null);

        /** BotPluginMetadata faviconCdnUrl. */
        public faviconCdnUrl?: (string|null);

        /**
         * Creates a new BotPluginMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotPluginMetadata instance
         */
        public static create(properties?: proto.IBotPluginMetadata): proto.BotPluginMetadata;

        /**
         * Encodes the specified BotPluginMetadata message. Does not implicitly {@link proto.BotPluginMetadata.verify|verify} messages.
         * @param message BotPluginMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotPluginMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotPluginMetadata message, length delimited. Does not implicitly {@link proto.BotPluginMetadata.verify|verify} messages.
         * @param message BotPluginMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotPluginMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotPluginMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotPluginMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotPluginMetadata;

        /**
         * Decodes a BotPluginMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotPluginMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotPluginMetadata;

        /**
         * Verifies a BotPluginMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotPluginMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotPluginMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotPluginMetadata;

        /**
         * Creates a plain object from a BotPluginMetadata message. Also converts values to other types if specified.
         * @param message BotPluginMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotPluginMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotPluginMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotPluginMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotPluginMetadata {

        /** PluginType enum. */
        enum PluginType {
            UNKNOWN_PLUGIN = 0,
            REELS = 1,
            SEARCH = 2
        }

        /** SearchProvider enum. */
        enum SearchProvider {
            UNKNOWN = 0,
            BING = 1,
            GOOGLE = 2,
            SUPPORT = 3
        }
    }

    /** Properties of a BotProgressIndicatorMetadata. */
    interface IBotProgressIndicatorMetadata {

        /** BotProgressIndicatorMetadata progressDescription */
        progressDescription?: (string|null);

        /** BotProgressIndicatorMetadata stepsMetadata */
        stepsMetadata?: (proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata[]|null);
    }

    /** Represents a BotProgressIndicatorMetadata. */
    class BotProgressIndicatorMetadata implements IBotProgressIndicatorMetadata {

        /**
         * Constructs a new BotProgressIndicatorMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotProgressIndicatorMetadata);

        /** BotProgressIndicatorMetadata progressDescription. */
        public progressDescription?: (string|null);

        /** BotProgressIndicatorMetadata stepsMetadata. */
        public stepsMetadata: proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata[];

        /**
         * Creates a new BotProgressIndicatorMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotProgressIndicatorMetadata instance
         */
        public static create(properties?: proto.IBotProgressIndicatorMetadata): proto.BotProgressIndicatorMetadata;

        /**
         * Encodes the specified BotProgressIndicatorMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.verify|verify} messages.
         * @param message BotProgressIndicatorMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotProgressIndicatorMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotProgressIndicatorMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.verify|verify} messages.
         * @param message BotProgressIndicatorMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotProgressIndicatorMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotProgressIndicatorMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotProgressIndicatorMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotProgressIndicatorMetadata;

        /**
         * Decodes a BotProgressIndicatorMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotProgressIndicatorMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotProgressIndicatorMetadata;

        /**
         * Verifies a BotProgressIndicatorMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotProgressIndicatorMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotProgressIndicatorMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotProgressIndicatorMetadata;

        /**
         * Creates a plain object from a BotProgressIndicatorMetadata message. Also converts values to other types if specified.
         * @param message BotProgressIndicatorMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotProgressIndicatorMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotProgressIndicatorMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotProgressIndicatorMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotProgressIndicatorMetadata {

        /** Properties of a BotPlanningStepMetadata. */
        interface IBotPlanningStepMetadata {

            /** BotPlanningStepMetadata statusTitle */
            statusTitle?: (string|null);

            /** BotPlanningStepMetadata statusBody */
            statusBody?: (string|null);

            /** BotPlanningStepMetadata sourcesMetadata */
            sourcesMetadata?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata[]|null);

            /** BotPlanningStepMetadata status */
            status?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus|null);

            /** BotPlanningStepMetadata isReasoning */
            isReasoning?: (boolean|null);

            /** BotPlanningStepMetadata isEnhancedSearch */
            isEnhancedSearch?: (boolean|null);

            /** BotPlanningStepMetadata sections */
            sections?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata[]|null);
        }

        /** Represents a BotPlanningStepMetadata. */
        class BotPlanningStepMetadata implements IBotPlanningStepMetadata {

            /**
             * Constructs a new BotPlanningStepMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata);

            /** BotPlanningStepMetadata statusTitle. */
            public statusTitle?: (string|null);

            /** BotPlanningStepMetadata statusBody. */
            public statusBody?: (string|null);

            /** BotPlanningStepMetadata sourcesMetadata. */
            public sourcesMetadata: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata[];

            /** BotPlanningStepMetadata status. */
            public status?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.PlanningStepStatus|null);

            /** BotPlanningStepMetadata isReasoning. */
            public isReasoning?: (boolean|null);

            /** BotPlanningStepMetadata isEnhancedSearch. */
            public isEnhancedSearch?: (boolean|null);

            /** BotPlanningStepMetadata sections. */
            public sections: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata[];

            /**
             * Creates a new BotPlanningStepMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BotPlanningStepMetadata instance
             */
            public static create(properties?: proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata;

            /**
             * Encodes the specified BotPlanningStepMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.verify|verify} messages.
             * @param message BotPlanningStepMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BotPlanningStepMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.verify|verify} messages.
             * @param message BotPlanningStepMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.BotProgressIndicatorMetadata.IBotPlanningStepMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BotPlanningStepMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BotPlanningStepMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata;

            /**
             * Decodes a BotPlanningStepMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BotPlanningStepMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata;

            /**
             * Verifies a BotPlanningStepMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BotPlanningStepMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BotPlanningStepMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata;

            /**
             * Creates a plain object from a BotPlanningStepMetadata message. Also converts values to other types if specified.
             * @param message BotPlanningStepMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BotPlanningStepMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for BotPlanningStepMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace BotPlanningStepMetadata {

            /** Properties of a BotPlanningSearchSourceMetadata. */
            interface IBotPlanningSearchSourceMetadata {

                /** BotPlanningSearchSourceMetadata title */
                title?: (string|null);

                /** BotPlanningSearchSourceMetadata provider */
                provider?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider|null);

                /** BotPlanningSearchSourceMetadata sourceUrl */
                sourceUrl?: (string|null);

                /** BotPlanningSearchSourceMetadata favIconUrl */
                favIconUrl?: (string|null);
            }

            /** Represents a BotPlanningSearchSourceMetadata. */
            class BotPlanningSearchSourceMetadata implements IBotPlanningSearchSourceMetadata {

                /**
                 * Constructs a new BotPlanningSearchSourceMetadata.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata);

                /** BotPlanningSearchSourceMetadata title. */
                public title?: (string|null);

                /** BotPlanningSearchSourceMetadata provider. */
                public provider?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotSearchSourceProvider|null);

                /** BotPlanningSearchSourceMetadata sourceUrl. */
                public sourceUrl?: (string|null);

                /** BotPlanningSearchSourceMetadata favIconUrl. */
                public favIconUrl?: (string|null);

                /**
                 * Creates a new BotPlanningSearchSourceMetadata instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns BotPlanningSearchSourceMetadata instance
                 */
                public static create(properties?: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata;

                /**
                 * Encodes the specified BotPlanningSearchSourceMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.verify|verify} messages.
                 * @param message BotPlanningSearchSourceMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified BotPlanningSearchSourceMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata.verify|verify} messages.
                 * @param message BotPlanningSearchSourceMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a BotPlanningSearchSourceMetadata message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns BotPlanningSearchSourceMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata;

                /**
                 * Decodes a BotPlanningSearchSourceMetadata message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns BotPlanningSearchSourceMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata;

                /**
                 * Verifies a BotPlanningSearchSourceMetadata message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a BotPlanningSearchSourceMetadata message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns BotPlanningSearchSourceMetadata
                 */
                public static fromObject(object: { [k: string]: any }): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata;

                /**
                 * Creates a plain object from a BotPlanningSearchSourceMetadata message. Also converts values to other types if specified.
                 * @param message BotPlanningSearchSourceMetadata
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourceMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this BotPlanningSearchSourceMetadata to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for BotPlanningSearchSourceMetadata
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            /** Properties of a BotPlanningSearchSourcesMetadata. */
            interface IBotPlanningSearchSourcesMetadata {

                /** BotPlanningSearchSourcesMetadata sourceTitle */
                sourceTitle?: (string|null);

                /** BotPlanningSearchSourcesMetadata provider */
                provider?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider|null);

                /** BotPlanningSearchSourcesMetadata sourceUrl */
                sourceUrl?: (string|null);
            }

            /** Represents a BotPlanningSearchSourcesMetadata. */
            class BotPlanningSearchSourcesMetadata implements IBotPlanningSearchSourcesMetadata {

                /**
                 * Constructs a new BotPlanningSearchSourcesMetadata.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata);

                /** BotPlanningSearchSourcesMetadata sourceTitle. */
                public sourceTitle?: (string|null);

                /** BotPlanningSearchSourcesMetadata provider. */
                public provider?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.BotPlanningSearchSourceProvider|null);

                /** BotPlanningSearchSourcesMetadata sourceUrl. */
                public sourceUrl?: (string|null);

                /**
                 * Creates a new BotPlanningSearchSourcesMetadata instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns BotPlanningSearchSourcesMetadata instance
                 */
                public static create(properties?: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata;

                /**
                 * Encodes the specified BotPlanningSearchSourcesMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.verify|verify} messages.
                 * @param message BotPlanningSearchSourcesMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified BotPlanningSearchSourcesMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata.verify|verify} messages.
                 * @param message BotPlanningSearchSourcesMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourcesMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a BotPlanningSearchSourcesMetadata message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns BotPlanningSearchSourcesMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata;

                /**
                 * Decodes a BotPlanningSearchSourcesMetadata message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns BotPlanningSearchSourcesMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata;

                /**
                 * Verifies a BotPlanningSearchSourcesMetadata message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a BotPlanningSearchSourcesMetadata message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns BotPlanningSearchSourcesMetadata
                 */
                public static fromObject(object: { [k: string]: any }): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata;

                /**
                 * Creates a plain object from a BotPlanningSearchSourcesMetadata message. Also converts values to other types if specified.
                 * @param message BotPlanningSearchSourcesMetadata
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningSearchSourcesMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this BotPlanningSearchSourcesMetadata to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for BotPlanningSearchSourcesMetadata
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            namespace BotPlanningSearchSourcesMetadata {

                /** BotPlanningSearchSourceProvider enum. */
                enum BotPlanningSearchSourceProvider {
                    UNKNOWN = 0,
                    OTHER = 1,
                    GOOGLE = 2,
                    BING = 3
                }
            }

            /** Properties of a BotPlanningStepSectionMetadata. */
            interface IBotPlanningStepSectionMetadata {

                /** BotPlanningStepSectionMetadata sectionTitle */
                sectionTitle?: (string|null);

                /** BotPlanningStepSectionMetadata sectionBody */
                sectionBody?: (string|null);

                /** BotPlanningStepSectionMetadata sourcesMetadata */
                sourcesMetadata?: (proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata[]|null);
            }

            /** Represents a BotPlanningStepSectionMetadata. */
            class BotPlanningStepSectionMetadata implements IBotPlanningStepSectionMetadata {

                /**
                 * Constructs a new BotPlanningStepSectionMetadata.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata);

                /** BotPlanningStepSectionMetadata sectionTitle. */
                public sectionTitle?: (string|null);

                /** BotPlanningStepSectionMetadata sectionBody. */
                public sectionBody?: (string|null);

                /** BotPlanningStepSectionMetadata sourcesMetadata. */
                public sourcesMetadata: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningSearchSourceMetadata[];

                /**
                 * Creates a new BotPlanningStepSectionMetadata instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns BotPlanningStepSectionMetadata instance
                 */
                public static create(properties?: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata;

                /**
                 * Encodes the specified BotPlanningStepSectionMetadata message. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.verify|verify} messages.
                 * @param message BotPlanningStepSectionMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified BotPlanningStepSectionMetadata message, length delimited. Does not implicitly {@link proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata.verify|verify} messages.
                 * @param message BotPlanningStepSectionMetadata message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.IBotPlanningStepSectionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a BotPlanningStepSectionMetadata message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns BotPlanningStepSectionMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata;

                /**
                 * Decodes a BotPlanningStepSectionMetadata message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns BotPlanningStepSectionMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata;

                /**
                 * Verifies a BotPlanningStepSectionMetadata message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a BotPlanningStepSectionMetadata message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns BotPlanningStepSectionMetadata
                 */
                public static fromObject(object: { [k: string]: any }): proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata;

                /**
                 * Creates a plain object from a BotPlanningStepSectionMetadata message. Also converts values to other types if specified.
                 * @param message BotPlanningStepSectionMetadata
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.BotProgressIndicatorMetadata.BotPlanningStepMetadata.BotPlanningStepSectionMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this BotPlanningStepSectionMetadata to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for BotPlanningStepSectionMetadata
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            /** BotSearchSourceProvider enum. */
            enum BotSearchSourceProvider {
                UNKNOWN_PROVIDER = 0,
                OTHER = 1,
                GOOGLE = 2,
                BING = 3
            }

            /** PlanningStepStatus enum. */
            enum PlanningStepStatus {
                UNKNOWN = 0,
                PLANNED = 1,
                EXECUTING = 2,
                FINISHED = 3
            }
        }
    }

    /** Properties of a BotPromotionMessageMetadata. */
    interface IBotPromotionMessageMetadata {

        /** BotPromotionMessageMetadata promotionType */
        promotionType?: (proto.BotPromotionMessageMetadata.BotPromotionType|null);

        /** BotPromotionMessageMetadata buttonTitle */
        buttonTitle?: (string|null);
    }

    /** Represents a BotPromotionMessageMetadata. */
    class BotPromotionMessageMetadata implements IBotPromotionMessageMetadata {

        /**
         * Constructs a new BotPromotionMessageMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotPromotionMessageMetadata);

        /** BotPromotionMessageMetadata promotionType. */
        public promotionType?: (proto.BotPromotionMessageMetadata.BotPromotionType|null);

        /** BotPromotionMessageMetadata buttonTitle. */
        public buttonTitle?: (string|null);

        /**
         * Creates a new BotPromotionMessageMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotPromotionMessageMetadata instance
         */
        public static create(properties?: proto.IBotPromotionMessageMetadata): proto.BotPromotionMessageMetadata;

        /**
         * Encodes the specified BotPromotionMessageMetadata message. Does not implicitly {@link proto.BotPromotionMessageMetadata.verify|verify} messages.
         * @param message BotPromotionMessageMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotPromotionMessageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotPromotionMessageMetadata message, length delimited. Does not implicitly {@link proto.BotPromotionMessageMetadata.verify|verify} messages.
         * @param message BotPromotionMessageMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotPromotionMessageMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotPromotionMessageMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotPromotionMessageMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotPromotionMessageMetadata;

        /**
         * Decodes a BotPromotionMessageMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotPromotionMessageMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotPromotionMessageMetadata;

        /**
         * Verifies a BotPromotionMessageMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotPromotionMessageMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotPromotionMessageMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotPromotionMessageMetadata;

        /**
         * Creates a plain object from a BotPromotionMessageMetadata message. Also converts values to other types if specified.
         * @param message BotPromotionMessageMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotPromotionMessageMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotPromotionMessageMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotPromotionMessageMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotPromotionMessageMetadata {

        /** BotPromotionType enum. */
        enum BotPromotionType {
            UNKNOWN_TYPE = 0,
            C50 = 1
        }
    }

    /** Properties of a BotPromptSuggestion. */
    interface IBotPromptSuggestion {

        /** BotPromptSuggestion prompt */
        prompt?: (string|null);

        /** BotPromptSuggestion promptId */
        promptId?: (string|null);
    }

    /** Represents a BotPromptSuggestion. */
    class BotPromptSuggestion implements IBotPromptSuggestion {

        /**
         * Constructs a new BotPromptSuggestion.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotPromptSuggestion);

        /** BotPromptSuggestion prompt. */
        public prompt?: (string|null);

        /** BotPromptSuggestion promptId. */
        public promptId?: (string|null);

        /**
         * Creates a new BotPromptSuggestion instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotPromptSuggestion instance
         */
        public static create(properties?: proto.IBotPromptSuggestion): proto.BotPromptSuggestion;

        /**
         * Encodes the specified BotPromptSuggestion message. Does not implicitly {@link proto.BotPromptSuggestion.verify|verify} messages.
         * @param message BotPromptSuggestion message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotPromptSuggestion, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotPromptSuggestion message, length delimited. Does not implicitly {@link proto.BotPromptSuggestion.verify|verify} messages.
         * @param message BotPromptSuggestion message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotPromptSuggestion, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotPromptSuggestion message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotPromptSuggestion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotPromptSuggestion;

        /**
         * Decodes a BotPromptSuggestion message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotPromptSuggestion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotPromptSuggestion;

        /**
         * Verifies a BotPromptSuggestion message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotPromptSuggestion message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotPromptSuggestion
         */
        public static fromObject(object: { [k: string]: any }): proto.BotPromptSuggestion;

        /**
         * Creates a plain object from a BotPromptSuggestion message. Also converts values to other types if specified.
         * @param message BotPromptSuggestion
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotPromptSuggestion, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotPromptSuggestion to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotPromptSuggestion
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotPromptSuggestions. */
    interface IBotPromptSuggestions {

        /** BotPromptSuggestions suggestions */
        suggestions?: (proto.IBotPromptSuggestion[]|null);
    }

    /** Represents a BotPromptSuggestions. */
    class BotPromptSuggestions implements IBotPromptSuggestions {

        /**
         * Constructs a new BotPromptSuggestions.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotPromptSuggestions);

        /** BotPromptSuggestions suggestions. */
        public suggestions: proto.IBotPromptSuggestion[];

        /**
         * Creates a new BotPromptSuggestions instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotPromptSuggestions instance
         */
        public static create(properties?: proto.IBotPromptSuggestions): proto.BotPromptSuggestions;

        /**
         * Encodes the specified BotPromptSuggestions message. Does not implicitly {@link proto.BotPromptSuggestions.verify|verify} messages.
         * @param message BotPromptSuggestions message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotPromptSuggestions, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotPromptSuggestions message, length delimited. Does not implicitly {@link proto.BotPromptSuggestions.verify|verify} messages.
         * @param message BotPromptSuggestions message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotPromptSuggestions, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotPromptSuggestions message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotPromptSuggestions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotPromptSuggestions;

        /**
         * Decodes a BotPromptSuggestions message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotPromptSuggestions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotPromptSuggestions;

        /**
         * Verifies a BotPromptSuggestions message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotPromptSuggestions message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotPromptSuggestions
         */
        public static fromObject(object: { [k: string]: any }): proto.BotPromptSuggestions;

        /**
         * Creates a plain object from a BotPromptSuggestions message. Also converts values to other types if specified.
         * @param message BotPromptSuggestions
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotPromptSuggestions, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotPromptSuggestions to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotPromptSuggestions
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a BotQuotaMetadata. */
    interface IBotQuotaMetadata {

        /** BotQuotaMetadata botFeatureQuotaMetadata */
        botFeatureQuotaMetadata?: (proto.BotQuotaMetadata.IBotFeatureQuotaMetadata[]|null);
    }

    /** Represents a BotQuotaMetadata. */
    class BotQuotaMetadata implements IBotQuotaMetadata {

        /**
         * Constructs a new BotQuotaMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotQuotaMetadata);

        /** BotQuotaMetadata botFeatureQuotaMetadata. */
        public botFeatureQuotaMetadata: proto.BotQuotaMetadata.IBotFeatureQuotaMetadata[];

        /**
         * Creates a new BotQuotaMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotQuotaMetadata instance
         */
        public static create(properties?: proto.IBotQuotaMetadata): proto.BotQuotaMetadata;

        /**
         * Encodes the specified BotQuotaMetadata message. Does not implicitly {@link proto.BotQuotaMetadata.verify|verify} messages.
         * @param message BotQuotaMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotQuotaMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotQuotaMetadata message, length delimited. Does not implicitly {@link proto.BotQuotaMetadata.verify|verify} messages.
         * @param message BotQuotaMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotQuotaMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotQuotaMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotQuotaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotQuotaMetadata;

        /**
         * Decodes a BotQuotaMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotQuotaMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotQuotaMetadata;

        /**
         * Verifies a BotQuotaMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotQuotaMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotQuotaMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotQuotaMetadata;

        /**
         * Creates a plain object from a BotQuotaMetadata message. Also converts values to other types if specified.
         * @param message BotQuotaMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotQuotaMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotQuotaMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotQuotaMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotQuotaMetadata {

        /** Properties of a BotFeatureQuotaMetadata. */
        interface IBotFeatureQuotaMetadata {

            /** BotFeatureQuotaMetadata featureType */
            featureType?: (proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType|null);

            /** BotFeatureQuotaMetadata remainingQuota */
            remainingQuota?: (number|null);

            /** BotFeatureQuotaMetadata expirationTimestamp */
            expirationTimestamp?: (number|Long|null);
        }

        /** Represents a BotFeatureQuotaMetadata. */
        class BotFeatureQuotaMetadata implements IBotFeatureQuotaMetadata {

            /**
             * Constructs a new BotFeatureQuotaMetadata.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.BotQuotaMetadata.IBotFeatureQuotaMetadata);

            /** BotFeatureQuotaMetadata featureType. */
            public featureType?: (proto.BotQuotaMetadata.BotFeatureQuotaMetadata.BotFeatureType|null);

            /** BotFeatureQuotaMetadata remainingQuota. */
            public remainingQuota?: (number|null);

            /** BotFeatureQuotaMetadata expirationTimestamp. */
            public expirationTimestamp?: (number|Long|null);

            /**
             * Creates a new BotFeatureQuotaMetadata instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BotFeatureQuotaMetadata instance
             */
            public static create(properties?: proto.BotQuotaMetadata.IBotFeatureQuotaMetadata): proto.BotQuotaMetadata.BotFeatureQuotaMetadata;

            /**
             * Encodes the specified BotFeatureQuotaMetadata message. Does not implicitly {@link proto.BotQuotaMetadata.BotFeatureQuotaMetadata.verify|verify} messages.
             * @param message BotFeatureQuotaMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.BotQuotaMetadata.IBotFeatureQuotaMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BotFeatureQuotaMetadata message, length delimited. Does not implicitly {@link proto.BotQuotaMetadata.BotFeatureQuotaMetadata.verify|verify} messages.
             * @param message BotFeatureQuotaMetadata message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.BotQuotaMetadata.IBotFeatureQuotaMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BotFeatureQuotaMetadata message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BotFeatureQuotaMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotQuotaMetadata.BotFeatureQuotaMetadata;

            /**
             * Decodes a BotFeatureQuotaMetadata message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BotFeatureQuotaMetadata
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotQuotaMetadata.BotFeatureQuotaMetadata;

            /**
             * Verifies a BotFeatureQuotaMetadata message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BotFeatureQuotaMetadata message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BotFeatureQuotaMetadata
             */
            public static fromObject(object: { [k: string]: any }): proto.BotQuotaMetadata.BotFeatureQuotaMetadata;

            /**
             * Creates a plain object from a BotFeatureQuotaMetadata message. Also converts values to other types if specified.
             * @param message BotFeatureQuotaMetadata
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.BotQuotaMetadata.BotFeatureQuotaMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BotFeatureQuotaMetadata to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for BotFeatureQuotaMetadata
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace BotFeatureQuotaMetadata {

            /** BotFeatureType enum. */
            enum BotFeatureType {
                UNKNOWN_FEATURE = 0,
                REASONING_FEATURE = 1
            }
        }
    }

    /** Properties of a BotReminderMetadata. */
    interface IBotReminderMetadata {

        /** BotReminderMetadata requestMessageKey */
        requestMessageKey?: (proto.IMessageKey|null);

        /** BotReminderMetadata action */
        action?: (proto.BotReminderMetadata.ReminderAction|null);

        /** BotReminderMetadata name */
        name?: (string|null);

        /** BotReminderMetadata nextTriggerTimestamp */
        nextTriggerTimestamp?: (number|Long|null);

        /** BotReminderMetadata frequency */
        frequency?: (proto.BotReminderMetadata.ReminderFrequency|null);
    }

    /** Represents a BotReminderMetadata. */
    class BotReminderMetadata implements IBotReminderMetadata {

        /**
         * Constructs a new BotReminderMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotReminderMetadata);

        /** BotReminderMetadata requestMessageKey. */
        public requestMessageKey?: (proto.IMessageKey|null);

        /** BotReminderMetadata action. */
        public action?: (proto.BotReminderMetadata.ReminderAction|null);

        /** BotReminderMetadata name. */
        public name?: (string|null);

        /** BotReminderMetadata nextTriggerTimestamp. */
        public nextTriggerTimestamp?: (number|Long|null);

        /** BotReminderMetadata frequency. */
        public frequency?: (proto.BotReminderMetadata.ReminderFrequency|null);

        /**
         * Creates a new BotReminderMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotReminderMetadata instance
         */
        public static create(properties?: proto.IBotReminderMetadata): proto.BotReminderMetadata;

        /**
         * Encodes the specified BotReminderMetadata message. Does not implicitly {@link proto.BotReminderMetadata.verify|verify} messages.
         * @param message BotReminderMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotReminderMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotReminderMetadata message, length delimited. Does not implicitly {@link proto.BotReminderMetadata.verify|verify} messages.
         * @param message BotReminderMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotReminderMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotReminderMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotReminderMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotReminderMetadata;

        /**
         * Decodes a BotReminderMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotReminderMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotReminderMetadata;

        /**
         * Verifies a BotReminderMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotReminderMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotReminderMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotReminderMetadata;

        /**
         * Creates a plain object from a BotReminderMetadata message. Also converts values to other types if specified.
         * @param message BotReminderMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotReminderMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotReminderMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotReminderMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotReminderMetadata {

        /** ReminderAction enum. */
        enum ReminderAction {
            NOTIFY = 1,
            CREATE = 2,
            DELETE = 3,
            UPDATE = 4
        }

        /** ReminderFrequency enum. */
        enum ReminderFrequency {
            ONCE = 1,
            DAILY = 2,
            WEEKLY = 3,
            BIWEEKLY = 4,
            MONTHLY = 5
        }
    }

    /** Properties of a BotRenderingMetadata. */
    interface IBotRenderingMetadata {

        /** BotRenderingMetadata keywords */
        keywords?: (proto.BotRenderingMetadata.IKeyword[]|null);
    }

    /** Represents a BotRenderingMetadata. */
    class BotRenderingMetadata implements IBotRenderingMetadata {

        /**
         * Constructs a new BotRenderingMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotRenderingMetadata);

        /** BotRenderingMetadata keywords. */
        public keywords: proto.BotRenderingMetadata.IKeyword[];

        /**
         * Creates a new BotRenderingMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotRenderingMetadata instance
         */
        public static create(properties?: proto.IBotRenderingMetadata): proto.BotRenderingMetadata;

        /**
         * Encodes the specified BotRenderingMetadata message. Does not implicitly {@link proto.BotRenderingMetadata.verify|verify} messages.
         * @param message BotRenderingMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotRenderingMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotRenderingMetadata message, length delimited. Does not implicitly {@link proto.BotRenderingMetadata.verify|verify} messages.
         * @param message BotRenderingMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotRenderingMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotRenderingMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotRenderingMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotRenderingMetadata;

        /**
         * Decodes a BotRenderingMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotRenderingMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotRenderingMetadata;

        /**
         * Verifies a BotRenderingMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotRenderingMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotRenderingMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotRenderingMetadata;

        /**
         * Creates a plain object from a BotRenderingMetadata message. Also converts values to other types if specified.
         * @param message BotRenderingMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotRenderingMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotRenderingMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotRenderingMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotRenderingMetadata {

        /** Properties of a Keyword. */
        interface IKeyword {

            /** Keyword value */
            value?: (string|null);

            /** Keyword associatedPrompts */
            associatedPrompts?: (string[]|null);
        }

        /** Represents a Keyword. */
        class Keyword implements IKeyword {

            /**
             * Constructs a new Keyword.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.BotRenderingMetadata.IKeyword);

            /** Keyword value. */
            public value?: (string|null);

            /** Keyword associatedPrompts. */
            public associatedPrompts: string[];

            /**
             * Creates a new Keyword instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Keyword instance
             */
            public static create(properties?: proto.BotRenderingMetadata.IKeyword): proto.BotRenderingMetadata.Keyword;

            /**
             * Encodes the specified Keyword message. Does not implicitly {@link proto.BotRenderingMetadata.Keyword.verify|verify} messages.
             * @param message Keyword message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.BotRenderingMetadata.IKeyword, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Keyword message, length delimited. Does not implicitly {@link proto.BotRenderingMetadata.Keyword.verify|verify} messages.
             * @param message Keyword message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.BotRenderingMetadata.IKeyword, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a Keyword message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Keyword
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotRenderingMetadata.Keyword;

            /**
             * Decodes a Keyword message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Keyword
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotRenderingMetadata.Keyword;

            /**
             * Verifies a Keyword message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a Keyword message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Keyword
             */
            public static fromObject(object: { [k: string]: any }): proto.BotRenderingMetadata.Keyword;

            /**
             * Creates a plain object from a Keyword message. Also converts values to other types if specified.
             * @param message Keyword
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.BotRenderingMetadata.Keyword, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Keyword to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for Keyword
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }
    }

    /** Properties of a BotSessionMetadata. */
    interface IBotSessionMetadata {

        /** BotSessionMetadata sessionId */
        sessionId?: (string|null);

        /** BotSessionMetadata sessionSource */
        sessionSource?: (proto.BotSessionSource|null);
    }

    /** Represents a BotSessionMetadata. */
    class BotSessionMetadata implements IBotSessionMetadata {

        /**
         * Constructs a new BotSessionMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotSessionMetadata);

        /** BotSessionMetadata sessionId. */
        public sessionId?: (string|null);

        /** BotSessionMetadata sessionSource. */
        public sessionSource?: (proto.BotSessionSource|null);

        /**
         * Creates a new BotSessionMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotSessionMetadata instance
         */
        public static create(properties?: proto.IBotSessionMetadata): proto.BotSessionMetadata;

        /**
         * Encodes the specified BotSessionMetadata message. Does not implicitly {@link proto.BotSessionMetadata.verify|verify} messages.
         * @param message BotSessionMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotSessionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotSessionMetadata message, length delimited. Does not implicitly {@link proto.BotSessionMetadata.verify|verify} messages.
         * @param message BotSessionMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotSessionMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotSessionMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotSessionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotSessionMetadata;

        /**
         * Decodes a BotSessionMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotSessionMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotSessionMetadata;

        /**
         * Verifies a BotSessionMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotSessionMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotSessionMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotSessionMetadata;

        /**
         * Creates a plain object from a BotSessionMetadata message. Also converts values to other types if specified.
         * @param message BotSessionMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotSessionMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotSessionMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotSessionMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** BotSessionSource enum. */
    enum BotSessionSource {
        NONE = 0,
        NULL_STATE = 1,
        TYPEAHEAD = 2,
        USER_INPUT = 3,
        EMU_FLASH = 4,
        EMU_FLASH_FOLLOWUP = 5,
        VOICE = 6
    }

    /** Properties of a BotSourcesMetadata. */
    interface IBotSourcesMetadata {

        /** BotSourcesMetadata sources */
        sources?: (proto.BotSourcesMetadata.IBotSourceItem[]|null);
    }

    /** Represents a BotSourcesMetadata. */
    class BotSourcesMetadata implements IBotSourcesMetadata {

        /**
         * Constructs a new BotSourcesMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotSourcesMetadata);

        /** BotSourcesMetadata sources. */
        public sources: proto.BotSourcesMetadata.IBotSourceItem[];

        /**
         * Creates a new BotSourcesMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotSourcesMetadata instance
         */
        public static create(properties?: proto.IBotSourcesMetadata): proto.BotSourcesMetadata;

        /**
         * Encodes the specified BotSourcesMetadata message. Does not implicitly {@link proto.BotSourcesMetadata.verify|verify} messages.
         * @param message BotSourcesMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotSourcesMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotSourcesMetadata message, length delimited. Does not implicitly {@link proto.BotSourcesMetadata.verify|verify} messages.
         * @param message BotSourcesMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotSourcesMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotSourcesMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotSourcesMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotSourcesMetadata;

        /**
         * Decodes a BotSourcesMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotSourcesMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotSourcesMetadata;

        /**
         * Verifies a BotSourcesMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotSourcesMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotSourcesMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotSourcesMetadata;

        /**
         * Creates a plain object from a BotSourcesMetadata message. Also converts values to other types if specified.
         * @param message BotSourcesMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotSourcesMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotSourcesMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotSourcesMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace BotSourcesMetadata {

        /** Properties of a BotSourceItem. */
        interface IBotSourceItem {

            /** BotSourceItem provider */
            provider?: (proto.BotSourcesMetadata.BotSourceItem.SourceProvider|null);

            /** BotSourceItem thumbnailCdnUrl */
            thumbnailCdnUrl?: (string|null);

            /** BotSourceItem sourceProviderUrl */
            sourceProviderUrl?: (string|null);

            /** BotSourceItem sourceQuery */
            sourceQuery?: (string|null);

            /** BotSourceItem faviconCdnUrl */
            faviconCdnUrl?: (string|null);

            /** BotSourceItem citationNumber */
            citationNumber?: (number|null);
        }

        /** Represents a BotSourceItem. */
        class BotSourceItem implements IBotSourceItem {

            /**
             * Constructs a new BotSourceItem.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.BotSourcesMetadata.IBotSourceItem);

            /** BotSourceItem provider. */
            public provider?: (proto.BotSourcesMetadata.BotSourceItem.SourceProvider|null);

            /** BotSourceItem thumbnailCdnUrl. */
            public thumbnailCdnUrl?: (string|null);

            /** BotSourceItem sourceProviderUrl. */
            public sourceProviderUrl?: (string|null);

            /** BotSourceItem sourceQuery. */
            public sourceQuery?: (string|null);

            /** BotSourceItem faviconCdnUrl. */
            public faviconCdnUrl?: (string|null);

            /** BotSourceItem citationNumber. */
            public citationNumber?: (number|null);

            /**
             * Creates a new BotSourceItem instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BotSourceItem instance
             */
            public static create(properties?: proto.BotSourcesMetadata.IBotSourceItem): proto.BotSourcesMetadata.BotSourceItem;

            /**
             * Encodes the specified BotSourceItem message. Does not implicitly {@link proto.BotSourcesMetadata.BotSourceItem.verify|verify} messages.
             * @param message BotSourceItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.BotSourcesMetadata.IBotSourceItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BotSourceItem message, length delimited. Does not implicitly {@link proto.BotSourcesMetadata.BotSourceItem.verify|verify} messages.
             * @param message BotSourceItem message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.BotSourcesMetadata.IBotSourceItem, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BotSourceItem message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BotSourceItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotSourcesMetadata.BotSourceItem;

            /**
             * Decodes a BotSourceItem message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BotSourceItem
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotSourcesMetadata.BotSourceItem;

            /**
             * Verifies a BotSourceItem message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BotSourceItem message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BotSourceItem
             */
            public static fromObject(object: { [k: string]: any }): proto.BotSourcesMetadata.BotSourceItem;

            /**
             * Creates a plain object from a BotSourceItem message. Also converts values to other types if specified.
             * @param message BotSourceItem
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.BotSourcesMetadata.BotSourceItem, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BotSourceItem to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for BotSourceItem
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace BotSourceItem {

            /** SourceProvider enum. */
            enum SourceProvider {
                UNKNOWN = 0,
                BING = 1,
                GOOGLE = 2,
                SUPPORT = 3
            }
        }
    }

    /** Properties of a BotSuggestedPromptMetadata. */
    interface IBotSuggestedPromptMetadata {

        /** BotSuggestedPromptMetadata suggestedPrompts */
        suggestedPrompts?: (string[]|null);

        /** BotSuggestedPromptMetadata selectedPromptIndex */
        selectedPromptIndex?: (number|null);

        /** BotSuggestedPromptMetadata promptSuggestions */
        promptSuggestions?: (proto.IBotPromptSuggestions|null);

        /** BotSuggestedPromptMetadata selectedPromptId */
        selectedPromptId?: (string|null);
    }

    /** Represents a BotSuggestedPromptMetadata. */
    class BotSuggestedPromptMetadata implements IBotSuggestedPromptMetadata {

        /**
         * Constructs a new BotSuggestedPromptMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IBotSuggestedPromptMetadata);

        /** BotSuggestedPromptMetadata suggestedPrompts. */
        public suggestedPrompts: string[];

        /** BotSuggestedPromptMetadata selectedPromptIndex. */
        public selectedPromptIndex?: (number|null);

        /** BotSuggestedPromptMetadata promptSuggestions. */
        public promptSuggestions?: (proto.IBotPromptSuggestions|null);

        /** BotSuggestedPromptMetadata selectedPromptId. */
        public selectedPromptId?: (string|null);

        /**
         * Creates a new BotSuggestedPromptMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns BotSuggestedPromptMetadata instance
         */
        public static create(properties?: proto.IBotSuggestedPromptMetadata): proto.BotSuggestedPromptMetadata;

        /**
         * Encodes the specified BotSuggestedPromptMetadata message. Does not implicitly {@link proto.BotSuggestedPromptMetadata.verify|verify} messages.
         * @param message BotSuggestedPromptMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IBotSuggestedPromptMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified BotSuggestedPromptMetadata message, length delimited. Does not implicitly {@link proto.BotSuggestedPromptMetadata.verify|verify} messages.
         * @param message BotSuggestedPromptMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IBotSuggestedPromptMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a BotSuggestedPromptMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns BotSuggestedPromptMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.BotSuggestedPromptMetadata;

        /**
         * Decodes a BotSuggestedPromptMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns BotSuggestedPromptMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.BotSuggestedPromptMetadata;

        /**
         * Verifies a BotSuggestedPromptMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a BotSuggestedPromptMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns BotSuggestedPromptMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.BotSuggestedPromptMetadata;

        /**
         * Creates a plain object from a BotSuggestedPromptMetadata message. Also converts values to other types if specified.
         * @param message BotSuggestedPromptMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.BotSuggestedPromptMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this BotSuggestedPromptMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for BotSuggestedPromptMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a CallLogRecord. */
    interface ICallLogRecord {

        /** CallLogRecord callResult */
        callResult?: (proto.CallLogRecord.CallResult|null);

        /** CallLogRecord isDndMode */
        isDndMode?: (boolean|null);

        /** CallLogRecord silenceReason */
        silenceReason?: (proto.CallLogRecord.SilenceReason|null);

        /** CallLogRecord duration */
        duration?: (number|Long|null);

        /** CallLogRecord startTime */
        startTime?: (number|Long|null);

        /** CallLogRecord isIncoming */
        isIncoming?: (boolean|null);

        /** CallLogRecord isVideo */
        isVideo?: (boolean|null);

        /** CallLogRecord isCallLink */
        isCallLink?: (boolean|null);

        /** CallLogRecord callLinkToken */
        callLinkToken?: (string|null);

        /** CallLogRecord scheduledCallId */
        scheduledCallId?: (string|null);

        /** CallLogRecord callId */
        callId?: (string|null);

        /** CallLogRecord callCreatorJid */
        callCreatorJid?: (string|null);

        /** CallLogRecord groupJid */
        groupJid?: (string|null);

        /** CallLogRecord participants */
        participants?: (proto.CallLogRecord.IParticipantInfo[]|null);

        /** CallLogRecord callType */
        callType?: (proto.CallLogRecord.CallType|null);
    }

    /** Represents a CallLogRecord. */
    class CallLogRecord implements ICallLogRecord {

        /**
         * Constructs a new CallLogRecord.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ICallLogRecord);

        /** CallLogRecord callResult. */
        public callResult?: (proto.CallLogRecord.CallResult|null);

        /** CallLogRecord isDndMode. */
        public isDndMode?: (boolean|null);

        /** CallLogRecord silenceReason. */
        public silenceReason?: (proto.CallLogRecord.SilenceReason|null);

        /** CallLogRecord duration. */
        public duration?: (number|Long|null);

        /** CallLogRecord startTime. */
        public startTime?: (number|Long|null);

        /** CallLogRecord isIncoming. */
        public isIncoming?: (boolean|null);

        /** CallLogRecord isVideo. */
        public isVideo?: (boolean|null);

        /** CallLogRecord isCallLink. */
        public isCallLink?: (boolean|null);

        /** CallLogRecord callLinkToken. */
        public callLinkToken?: (string|null);

        /** CallLogRecord scheduledCallId. */
        public scheduledCallId?: (string|null);

        /** CallLogRecord callId. */
        public callId?: (string|null);

        /** CallLogRecord callCreatorJid. */
        public callCreatorJid?: (string|null);

        /** CallLogRecord groupJid. */
        public groupJid?: (string|null);

        /** CallLogRecord participants. */
        public participants: proto.CallLogRecord.IParticipantInfo[];

        /** CallLogRecord callType. */
        public callType?: (proto.CallLogRecord.CallType|null);

        /**
         * Creates a new CallLogRecord instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CallLogRecord instance
         */
        public static create(properties?: proto.ICallLogRecord): proto.CallLogRecord;

        /**
         * Encodes the specified CallLogRecord message. Does not implicitly {@link proto.CallLogRecord.verify|verify} messages.
         * @param message CallLogRecord message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ICallLogRecord, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CallLogRecord message, length delimited. Does not implicitly {@link proto.CallLogRecord.verify|verify} messages.
         * @param message CallLogRecord message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ICallLogRecord, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CallLogRecord message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CallLogRecord
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CallLogRecord;

        /**
         * Decodes a CallLogRecord message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CallLogRecord
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CallLogRecord;

        /**
         * Verifies a CallLogRecord message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CallLogRecord message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CallLogRecord
         */
        public static fromObject(object: { [k: string]: any }): proto.CallLogRecord;

        /**
         * Creates a plain object from a CallLogRecord message. Also converts values to other types if specified.
         * @param message CallLogRecord
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.CallLogRecord, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CallLogRecord to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for CallLogRecord
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace CallLogRecord {

        /** CallResult enum. */
        enum CallResult {
            CONNECTED = 0,
            REJECTED = 1,
            CANCELLED = 2,
            ACCEPTEDELSEWHERE = 3,
            MISSED = 4,
            INVALID = 5,
            UNAVAILABLE = 6,
            UPCOMING = 7,
            FAILED = 8,
            ABANDONED = 9,
            ONGOING = 10
        }

        /** CallType enum. */
        enum CallType {
            REGULAR = 0,
            SCHEDULED_CALL = 1,
            VOICE_CHAT = 2
        }

        /** Properties of a ParticipantInfo. */
        interface IParticipantInfo {

            /** ParticipantInfo userJid */
            userJid?: (string|null);

            /** ParticipantInfo callResult */
            callResult?: (proto.CallLogRecord.CallResult|null);
        }

        /** Represents a ParticipantInfo. */
        class ParticipantInfo implements IParticipantInfo {

            /**
             * Constructs a new ParticipantInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.CallLogRecord.IParticipantInfo);

            /** ParticipantInfo userJid. */
            public userJid?: (string|null);

            /** ParticipantInfo callResult. */
            public callResult?: (proto.CallLogRecord.CallResult|null);

            /**
             * Creates a new ParticipantInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ParticipantInfo instance
             */
            public static create(properties?: proto.CallLogRecord.IParticipantInfo): proto.CallLogRecord.ParticipantInfo;

            /**
             * Encodes the specified ParticipantInfo message. Does not implicitly {@link proto.CallLogRecord.ParticipantInfo.verify|verify} messages.
             * @param message ParticipantInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.CallLogRecord.IParticipantInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ParticipantInfo message, length delimited. Does not implicitly {@link proto.CallLogRecord.ParticipantInfo.verify|verify} messages.
             * @param message ParticipantInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.CallLogRecord.IParticipantInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ParticipantInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ParticipantInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CallLogRecord.ParticipantInfo;

            /**
             * Decodes a ParticipantInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ParticipantInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CallLogRecord.ParticipantInfo;

            /**
             * Verifies a ParticipantInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ParticipantInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ParticipantInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.CallLogRecord.ParticipantInfo;

            /**
             * Creates a plain object from a ParticipantInfo message. Also converts values to other types if specified.
             * @param message ParticipantInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.CallLogRecord.ParticipantInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ParticipantInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ParticipantInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** SilenceReason enum. */
        enum SilenceReason {
            NONE = 0,
            SCHEDULED = 1,
            PRIVACY = 2,
            LIGHTWEIGHT = 3
        }
    }

    /** Properties of a CertChain. */
    interface ICertChain {

        /** CertChain leaf */
        leaf?: (proto.CertChain.INoiseCertificate|null);

        /** CertChain intermediate */
        intermediate?: (proto.CertChain.INoiseCertificate|null);
    }

    /** Represents a CertChain. */
    class CertChain implements ICertChain {

        /**
         * Constructs a new CertChain.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ICertChain);

        /** CertChain leaf. */
        public leaf?: (proto.CertChain.INoiseCertificate|null);

        /** CertChain intermediate. */
        public intermediate?: (proto.CertChain.INoiseCertificate|null);

        /**
         * Creates a new CertChain instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CertChain instance
         */
        public static create(properties?: proto.ICertChain): proto.CertChain;

        /**
         * Encodes the specified CertChain message. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @param message CertChain message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ICertChain, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CertChain message, length delimited. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @param message CertChain message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ICertChain, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CertChain message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CertChain;

        /**
         * Decodes a CertChain message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CertChain;

        /**
         * Verifies a CertChain message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CertChain message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CertChain
         */
        public static fromObject(object: { [k: string]: any }): proto.CertChain;

        /**
         * Creates a plain object from a CertChain message. Also converts values to other types if specified.
         * @param message CertChain
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.CertChain, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CertChain to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for CertChain
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace CertChain {

        /** Properties of a NoiseCertificate. */
        interface INoiseCertificate {

            /** NoiseCertificate details */
            details?: (Uint8Array|null);

            /** NoiseCertificate signature */
            signature?: (Uint8Array|null);
        }

        /** Represents a NoiseCertificate. */
        class NoiseCertificate implements INoiseCertificate {

            /**
             * Constructs a new NoiseCertificate.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.CertChain.INoiseCertificate);

            /** NoiseCertificate details. */
            public details?: (Uint8Array|null);

            /** NoiseCertificate signature. */
            public signature?: (Uint8Array|null);

            /**
             * Creates a new NoiseCertificate instance using the specified properties.
             * @param [properties] Properties to set
             * @returns NoiseCertificate instance
             */
            public static create(properties?: proto.CertChain.INoiseCertificate): proto.CertChain.NoiseCertificate;

            /**
             * Encodes the specified NoiseCertificate message. Does not implicitly {@link proto.CertChain.NoiseCertificate.verify|verify} messages.
             * @param message NoiseCertificate message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.CertChain.INoiseCertificate, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified NoiseCertificate message, length delimited. Does not implicitly {@link proto.CertChain.NoiseCertificate.verify|verify} messages.
             * @param message NoiseCertificate message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.CertChain.INoiseCertificate, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a NoiseCertificate message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns NoiseCertificate
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CertChain.NoiseCertificate;

            /**
             * Decodes a NoiseCertificate message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns NoiseCertificate
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CertChain.NoiseCertificate;

            /**
             * Verifies a NoiseCertificate message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a NoiseCertificate message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns NoiseCertificate
             */
            public static fromObject(object: { [k: string]: any }): proto.CertChain.NoiseCertificate;

            /**
             * Creates a plain object from a NoiseCertificate message. Also converts values to other types if specified.
             * @param message NoiseCertificate
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.CertChain.NoiseCertificate, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this NoiseCertificate to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for NoiseCertificate
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace NoiseCertificate {

            /** Properties of a Details. */
            interface IDetails {

                /** Details serial */
                serial?: (number|null);

                /** Details issuerSerial */
                issuerSerial?: (number|null);

                /** Details key */
                key?: (Uint8Array|null);

                /** Details notBefore */
                notBefore?: (number|Long|null);

                /** Details notAfter */
                notAfter?: (number|Long|null);
            }

            /** Represents a Details. */
            class Details implements IDetails {

                /**
                 * Constructs a new Details.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.CertChain.NoiseCertificate.IDetails);

                /** Details serial. */
                public serial?: (number|null);

                /** Details issuerSerial. */
                public issuerSerial?: (number|null);

                /** Details key. */
                public key?: (Uint8Array|null);

                /** Details notBefore. */
                public notBefore?: (number|Long|null);

                /** Details notAfter. */
                public notAfter?: (number|Long|null);

                /**
                 * Creates a new Details instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Details instance
                 */
                public static create(properties?: proto.CertChain.NoiseCertificate.IDetails): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Encodes the specified Details message. Does not implicitly {@link proto.CertChain.NoiseCertificate.Details.verify|verify} messages.
                 * @param message Details message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.CertChain.NoiseCertificate.IDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Details message, length delimited. Does not implicitly {@link proto.CertChain.NoiseCertificate.Details.verify|verify} messages.
                 * @param message Details message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.CertChain.NoiseCertificate.IDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Details message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Details
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Decodes a Details message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Details
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Verifies a Details message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Details message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Details
                 */
                public static fromObject(object: { [k: string]: any }): proto.CertChain.NoiseCertificate.Details;

                /**
                 * Creates a plain object from a Details message. Also converts values to other types if specified.
                 * @param message Details
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.CertChain.NoiseCertificate.Details, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Details to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for Details
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }
    }

    /** Properties of a ChatLockSettings. */
    interface IChatLockSettings {

        /** ChatLockSettings hideLockedChats */
        hideLockedChats?: (boolean|null);

        /** ChatLockSettings secretCode */
        secretCode?: (proto.IUserPassword|null);
    }

    /** Represents a ChatLockSettings. */
    class ChatLockSettings implements IChatLockSettings {

        /**
         * Constructs a new ChatLockSettings.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IChatLockSettings);

        /** ChatLockSettings hideLockedChats. */
        public hideLockedChats?: (boolean|null);

        /** ChatLockSettings secretCode. */
        public secretCode?: (proto.IUserPassword|null);

        /**
         * Creates a new ChatLockSettings instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ChatLockSettings instance
         */
        public static create(properties?: proto.IChatLockSettings): proto.ChatLockSettings;

        /**
         * Encodes the specified ChatLockSettings message. Does not implicitly {@link proto.ChatLockSettings.verify|verify} messages.
         * @param message ChatLockSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IChatLockSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ChatLockSettings message, length delimited. Does not implicitly {@link proto.ChatLockSettings.verify|verify} messages.
         * @param message ChatLockSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IChatLockSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ChatLockSettings message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ChatLockSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ChatLockSettings;

        /**
         * Decodes a ChatLockSettings message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ChatLockSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ChatLockSettings;

        /**
         * Verifies a ChatLockSettings message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ChatLockSettings message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ChatLockSettings
         */
        public static fromObject(object: { [k: string]: any }): proto.ChatLockSettings;

        /**
         * Creates a plain object from a ChatLockSettings message. Also converts values to other types if specified.
         * @param message ChatLockSettings
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ChatLockSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ChatLockSettings to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ChatLockSettings
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a ChatRowOpaqueData. */
    interface IChatRowOpaqueData {

        /** ChatRowOpaqueData draftMessage */
        draftMessage?: (proto.ChatRowOpaqueData.IDraftMessage|null);
    }

    /** Represents a ChatRowOpaqueData. */
    class ChatRowOpaqueData implements IChatRowOpaqueData {

        /**
         * Constructs a new ChatRowOpaqueData.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IChatRowOpaqueData);

        /** ChatRowOpaqueData draftMessage. */
        public draftMessage?: (proto.ChatRowOpaqueData.IDraftMessage|null);

        /**
         * Creates a new ChatRowOpaqueData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ChatRowOpaqueData instance
         */
        public static create(properties?: proto.IChatRowOpaqueData): proto.ChatRowOpaqueData;

        /**
         * Encodes the specified ChatRowOpaqueData message. Does not implicitly {@link proto.ChatRowOpaqueData.verify|verify} messages.
         * @param message ChatRowOpaqueData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IChatRowOpaqueData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ChatRowOpaqueData message, length delimited. Does not implicitly {@link proto.ChatRowOpaqueData.verify|verify} messages.
         * @param message ChatRowOpaqueData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IChatRowOpaqueData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ChatRowOpaqueData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ChatRowOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ChatRowOpaqueData;

        /**
         * Decodes a ChatRowOpaqueData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ChatRowOpaqueData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ChatRowOpaqueData;

        /**
         * Verifies a ChatRowOpaqueData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ChatRowOpaqueData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ChatRowOpaqueData
         */
        public static fromObject(object: { [k: string]: any }): proto.ChatRowOpaqueData;

        /**
         * Creates a plain object from a ChatRowOpaqueData message. Also converts values to other types if specified.
         * @param message ChatRowOpaqueData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ChatRowOpaqueData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ChatRowOpaqueData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ChatRowOpaqueData
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace ChatRowOpaqueData {

        /** Properties of a DraftMessage. */
        interface IDraftMessage {

            /** DraftMessage text */
            text?: (string|null);

            /** DraftMessage omittedUrl */
            omittedUrl?: (string|null);

            /** DraftMessage ctwaContextLinkData */
            ctwaContextLinkData?: (proto.ChatRowOpaqueData.DraftMessage.ICtwaContextLinkData|null);

            /** DraftMessage ctwaContext */
            ctwaContext?: (proto.ChatRowOpaqueData.DraftMessage.ICtwaContextData|null);

            /** DraftMessage timestamp */
            timestamp?: (number|Long|null);
        }

        /** Represents a DraftMessage. */
        class DraftMessage implements IDraftMessage {

            /**
             * Constructs a new DraftMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ChatRowOpaqueData.IDraftMessage);

            /** DraftMessage text. */
            public text?: (string|null);

            /** DraftMessage omittedUrl. */
            public omittedUrl?: (string|null);

            /** DraftMessage ctwaContextLinkData. */
            public ctwaContextLinkData?: (proto.ChatRowOpaqueData.DraftMessage.ICtwaContextLinkData|null);

            /** DraftMessage ctwaContext. */
            public ctwaContext?: (proto.ChatRowOpaqueData.DraftMessage.ICtwaContextData|null);

            /** DraftMessage timestamp. */
            public timestamp?: (number|Long|null);

            /**
             * Creates a new DraftMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DraftMessage instance
             */
            public static create(properties?: proto.ChatRowOpaqueData.IDraftMessage): proto.ChatRowOpaqueData.DraftMessage;

            /**
             * Encodes the specified DraftMessage message. Does not implicitly {@link proto.ChatRowOpaqueData.DraftMessage.verify|verify} messages.
             * @param message DraftMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ChatRowOpaqueData.IDraftMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DraftMessage message, length delimited. Does not implicitly {@link proto.ChatRowOpaqueData.DraftMessage.verify|verify} messages.
             * @param message DraftMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ChatRowOpaqueData.IDraftMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DraftMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DraftMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ChatRowOpaqueData.DraftMessage;

            /**
             * Decodes a DraftMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DraftMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ChatRowOpaqueData.DraftMessage;

            /**
             * Verifies a DraftMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DraftMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DraftMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.ChatRowOpaqueData.DraftMessage;

            /**
             * Creates a plain object from a DraftMessage message. Also converts values to other types if specified.
             * @param message DraftMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ChatRowOpaqueData.DraftMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DraftMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for DraftMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace DraftMessage {

            /** Properties of a CtwaContextData. */
            interface ICtwaContextData {

                /** CtwaContextData conversionSource */
                conversionSource?: (string|null);

                /** CtwaContextData conversionData */
                conversionData?: (Uint8Array|null);

                /** CtwaContextData sourceUrl */
                sourceUrl?: (string|null);

                /** CtwaContextData sourceId */
                sourceId?: (string|null);

                /** CtwaContextData sourceType */
                sourceType?: (string|null);

                /** CtwaContextData title */
                title?: (string|null);

                /** CtwaContextData description */
                description?: (string|null);

                /** CtwaContextData thumbnail */
                thumbnail?: (string|null);

                /** CtwaContextData thumbnailUrl */
                thumbnailUrl?: (string|null);

                /** CtwaContextData mediaType */
                mediaType?: (proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.ContextInfoExternalAdReplyInfoMediaType|null);

                /** CtwaContextData mediaUrl */
                mediaUrl?: (string|null);

                /** CtwaContextData isSuspiciousLink */
                isSuspiciousLink?: (boolean|null);
            }

            /** Represents a CtwaContextData. */
            class CtwaContextData implements ICtwaContextData {

                /**
                 * Constructs a new CtwaContextData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextData);

                /** CtwaContextData conversionSource. */
                public conversionSource?: (string|null);

                /** CtwaContextData conversionData. */
                public conversionData?: (Uint8Array|null);

                /** CtwaContextData sourceUrl. */
                public sourceUrl?: (string|null);

                /** CtwaContextData sourceId. */
                public sourceId?: (string|null);

                /** CtwaContextData sourceType. */
                public sourceType?: (string|null);

                /** CtwaContextData title. */
                public title?: (string|null);

                /** CtwaContextData description. */
                public description?: (string|null);

                /** CtwaContextData thumbnail. */
                public thumbnail?: (string|null);

                /** CtwaContextData thumbnailUrl. */
                public thumbnailUrl?: (string|null);

                /** CtwaContextData mediaType. */
                public mediaType?: (proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.ContextInfoExternalAdReplyInfoMediaType|null);

                /** CtwaContextData mediaUrl. */
                public mediaUrl?: (string|null);

                /** CtwaContextData isSuspiciousLink. */
                public isSuspiciousLink?: (boolean|null);

                /**
                 * Creates a new CtwaContextData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns CtwaContextData instance
                 */
                public static create(properties?: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextData): proto.ChatRowOpaqueData.DraftMessage.CtwaContextData;

                /**
                 * Encodes the specified CtwaContextData message. Does not implicitly {@link proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.verify|verify} messages.
                 * @param message CtwaContextData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified CtwaContextData message, length delimited. Does not implicitly {@link proto.ChatRowOpaqueData.DraftMessage.CtwaContextData.verify|verify} messages.
                 * @param message CtwaContextData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a CtwaContextData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns CtwaContextData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ChatRowOpaqueData.DraftMessage.CtwaContextData;

                /**
                 * Decodes a CtwaContextData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns CtwaContextData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ChatRowOpaqueData.DraftMessage.CtwaContextData;

                /**
                 * Verifies a CtwaContextData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a CtwaContextData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns CtwaContextData
                 */
                public static fromObject(object: { [k: string]: any }): proto.ChatRowOpaqueData.DraftMessage.CtwaContextData;

                /**
                 * Creates a plain object from a CtwaContextData message. Also converts values to other types if specified.
                 * @param message CtwaContextData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.ChatRowOpaqueData.DraftMessage.CtwaContextData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this CtwaContextData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for CtwaContextData
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            namespace CtwaContextData {

                /** ContextInfoExternalAdReplyInfoMediaType enum. */
                enum ContextInfoExternalAdReplyInfoMediaType {
                    NONE = 0,
                    IMAGE = 1,
                    VIDEO = 2
                }
            }

            /** Properties of a CtwaContextLinkData. */
            interface ICtwaContextLinkData {

                /** CtwaContextLinkData context */
                context?: (string|null);

                /** CtwaContextLinkData sourceUrl */
                sourceUrl?: (string|null);

                /** CtwaContextLinkData icebreaker */
                icebreaker?: (string|null);

                /** CtwaContextLinkData phone */
                phone?: (string|null);
            }

            /** Represents a CtwaContextLinkData. */
            class CtwaContextLinkData implements ICtwaContextLinkData {

                /**
                 * Constructs a new CtwaContextLinkData.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextLinkData);

                /** CtwaContextLinkData context. */
                public context?: (string|null);

                /** CtwaContextLinkData sourceUrl. */
                public sourceUrl?: (string|null);

                /** CtwaContextLinkData icebreaker. */
                public icebreaker?: (string|null);

                /** CtwaContextLinkData phone. */
                public phone?: (string|null);

                /**
                 * Creates a new CtwaContextLinkData instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns CtwaContextLinkData instance
                 */
                public static create(properties?: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextLinkData): proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData;

                /**
                 * Encodes the specified CtwaContextLinkData message. Does not implicitly {@link proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.verify|verify} messages.
                 * @param message CtwaContextLinkData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextLinkData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified CtwaContextLinkData message, length delimited. Does not implicitly {@link proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData.verify|verify} messages.
                 * @param message CtwaContextLinkData message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.ChatRowOpaqueData.DraftMessage.ICtwaContextLinkData, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a CtwaContextLinkData message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns CtwaContextLinkData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData;

                /**
                 * Decodes a CtwaContextLinkData message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns CtwaContextLinkData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData;

                /**
                 * Verifies a CtwaContextLinkData message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a CtwaContextLinkData message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns CtwaContextLinkData
                 */
                public static fromObject(object: { [k: string]: any }): proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData;

                /**
                 * Creates a plain object from a CtwaContextLinkData message. Also converts values to other types if specified.
                 * @param message CtwaContextLinkData
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.ChatRowOpaqueData.DraftMessage.CtwaContextLinkData, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this CtwaContextLinkData to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for CtwaContextLinkData
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }
    }

    /** Properties of a Citation. */
    interface ICitation {

        /** Citation title */
        title: string;

        /** Citation subtitle */
        subtitle: string;

        /** Citation cmsId */
        cmsId: string;

        /** Citation imageUrl */
        imageUrl: string;
    }

    /** Represents a Citation. */
    class Citation implements ICitation {

        /**
         * Constructs a new Citation.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ICitation);

        /** Citation title. */
        public title: string;

        /** Citation subtitle. */
        public subtitle: string;

        /** Citation cmsId. */
        public cmsId: string;

        /** Citation imageUrl. */
        public imageUrl: string;

        /**
         * Creates a new Citation instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Citation instance
         */
        public static create(properties?: proto.ICitation): proto.Citation;

        /**
         * Encodes the specified Citation message. Does not implicitly {@link proto.Citation.verify|verify} messages.
         * @param message Citation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ICitation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Citation message, length delimited. Does not implicitly {@link proto.Citation.verify|verify} messages.
         * @param message Citation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ICitation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Citation message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Citation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Citation;

        /**
         * Decodes a Citation message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Citation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Citation;

        /**
         * Verifies a Citation message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Citation message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Citation
         */
        public static fromObject(object: { [k: string]: any }): proto.Citation;

        /**
         * Creates a plain object from a Citation message. Also converts values to other types if specified.
         * @param message Citation
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Citation, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Citation to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for Citation
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a ClientPairingProps. */
    interface IClientPairingProps {

        /** ClientPairingProps isChatDbLidMigrated */
        isChatDbLidMigrated?: (boolean|null);

        /** ClientPairingProps isSyncdPureLidSession */
        isSyncdPureLidSession?: (boolean|null);
    }

    /** Represents a ClientPairingProps. */
    class ClientPairingProps implements IClientPairingProps {

        /**
         * Constructs a new ClientPairingProps.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IClientPairingProps);

        /** ClientPairingProps isChatDbLidMigrated. */
        public isChatDbLidMigrated?: (boolean|null);

        /** ClientPairingProps isSyncdPureLidSession. */
        public isSyncdPureLidSession?: (boolean|null);

        /**
         * Creates a new ClientPairingProps instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ClientPairingProps instance
         */
        public static create(properties?: proto.IClientPairingProps): proto.ClientPairingProps;

        /**
         * Encodes the specified ClientPairingProps message. Does not implicitly {@link proto.ClientPairingProps.verify|verify} messages.
         * @param message ClientPairingProps message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IClientPairingProps, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ClientPairingProps message, length delimited. Does not implicitly {@link proto.ClientPairingProps.verify|verify} messages.
         * @param message ClientPairingProps message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IClientPairingProps, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ClientPairingProps message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ClientPairingProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPairingProps;

        /**
         * Decodes a ClientPairingProps message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ClientPairingProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPairingProps;

        /**
         * Verifies a ClientPairingProps message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ClientPairingProps message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ClientPairingProps
         */
        public static fromObject(object: { [k: string]: any }): proto.ClientPairingProps;

        /**
         * Creates a plain object from a ClientPairingProps message. Also converts values to other types if specified.
         * @param message ClientPairingProps
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ClientPairingProps, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ClientPairingProps to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ClientPairingProps
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a ClientPayload. */
    interface IClientPayload {

        /** ClientPayload username */
        username?: (number|Long|null);

        /** ClientPayload passive */
        passive?: (boolean|null);

        /** ClientPayload userAgent */
        userAgent?: (proto.ClientPayload.IUserAgent|null);

        /** ClientPayload webInfo */
        webInfo?: (proto.ClientPayload.IWebInfo|null);

        /** ClientPayload pushName */
        pushName?: (string|null);

        /** ClientPayload sessionId */
        sessionId?: (number|null);

        /** ClientPayload shortConnect */
        shortConnect?: (boolean|null);

        /** ClientPayload connectType */
        connectType?: (proto.ClientPayload.ConnectType|null);

        /** ClientPayload connectReason */
        connectReason?: (proto.ClientPayload.ConnectReason|null);

        /** ClientPayload shards */
        shards?: (number[]|null);

        /** ClientPayload dnsSource */
        dnsSource?: (proto.ClientPayload.IDNSSource|null);

        /** ClientPayload connectAttemptCount */
        connectAttemptCount?: (number|null);

        /** ClientPayload device */
        device?: (number|null);

        /** ClientPayload devicePairingData */
        devicePairingData?: (proto.ClientPayload.IDevicePairingRegistrationData|null);

        /** ClientPayload product */
        product?: (proto.ClientPayload.Product|null);

        /** ClientPayload fbCat */
        fbCat?: (Uint8Array|null);

        /** ClientPayload fbUserAgent */
        fbUserAgent?: (Uint8Array|null);

        /** ClientPayload oc */
        oc?: (boolean|null);

        /** ClientPayload lc */
        lc?: (number|null);

        /** ClientPayload iosAppExtension */
        iosAppExtension?: (proto.ClientPayload.IOSAppExtension|null);

        /** ClientPayload fbAppId */
        fbAppId?: (number|Long|null);

        /** ClientPayload fbDeviceId */
        fbDeviceId?: (Uint8Array|null);

        /** ClientPayload pull */
        pull?: (boolean|null);

        /** ClientPayload paddingBytes */
        paddingBytes?: (Uint8Array|null);

        /** ClientPayload yearClass */
        yearClass?: (number|null);

        /** ClientPayload memClass */
        memClass?: (number|null);

        /** ClientPayload interopData */
        interopData?: (proto.ClientPayload.IInteropData|null);

        /** ClientPayload trafficAnonymization */
        trafficAnonymization?: (proto.ClientPayload.TrafficAnonymization|null);

        /** ClientPayload lidDbMigrated */
        lidDbMigrated?: (boolean|null);

        /** ClientPayload accountType */
        accountType?: (proto.ClientPayload.AccountType|null);
    }

    /** Represents a ClientPayload. */
    class ClientPayload implements IClientPayload {

        /**
         * Constructs a new ClientPayload.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IClientPayload);

        /** ClientPayload username. */
        public username?: (number|Long|null);

        /** ClientPayload passive. */
        public passive?: (boolean|null);

        /** ClientPayload userAgent. */
        public userAgent?: (proto.ClientPayload.IUserAgent|null);

        /** ClientPayload webInfo. */
        public webInfo?: (proto.ClientPayload.IWebInfo|null);

        /** ClientPayload pushName. */
        public pushName?: (string|null);

        /** ClientPayload sessionId. */
        public sessionId?: (number|null);

        /** ClientPayload shortConnect. */
        public shortConnect?: (boolean|null);

        /** ClientPayload connectType. */
        public connectType?: (proto.ClientPayload.ConnectType|null);

        /** ClientPayload connectReason. */
        public connectReason?: (proto.ClientPayload.ConnectReason|null);

        /** ClientPayload shards. */
        public shards: number[];

        /** ClientPayload dnsSource. */
        public dnsSource?: (proto.ClientPayload.IDNSSource|null);

        /** ClientPayload connectAttemptCount. */
        public connectAttemptCount?: (number|null);

        /** ClientPayload device. */
        public device?: (number|null);

        /** ClientPayload devicePairingData. */
        public devicePairingData?: (proto.ClientPayload.IDevicePairingRegistrationData|null);

        /** ClientPayload product. */
        public product?: (proto.ClientPayload.Product|null);

        /** ClientPayload fbCat. */
        public fbCat?: (Uint8Array|null);

        /** ClientPayload fbUserAgent. */
        public fbUserAgent?: (Uint8Array|null);

        /** ClientPayload oc. */
        public oc?: (boolean|null);

        /** ClientPayload lc. */
        public lc?: (number|null);

        /** ClientPayload iosAppExtension. */
        public iosAppExtension?: (proto.ClientPayload.IOSAppExtension|null);

        /** ClientPayload fbAppId. */
        public fbAppId?: (number|Long|null);

        /** ClientPayload fbDeviceId. */
        public fbDeviceId?: (Uint8Array|null);

        /** ClientPayload pull. */
        public pull?: (boolean|null);

        /** ClientPayload paddingBytes. */
        public paddingBytes?: (Uint8Array|null);

        /** ClientPayload yearClass. */
        public yearClass?: (number|null);

        /** ClientPayload memClass. */
        public memClass?: (number|null);

        /** ClientPayload interopData. */
        public interopData?: (proto.ClientPayload.IInteropData|null);

        /** ClientPayload trafficAnonymization. */
        public trafficAnonymization?: (proto.ClientPayload.TrafficAnonymization|null);

        /** ClientPayload lidDbMigrated. */
        public lidDbMigrated?: (boolean|null);

        /** ClientPayload accountType. */
        public accountType?: (proto.ClientPayload.AccountType|null);

        /**
         * Creates a new ClientPayload instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ClientPayload instance
         */
        public static create(properties?: proto.IClientPayload): proto.ClientPayload;

        /**
         * Encodes the specified ClientPayload message. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @param message ClientPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IClientPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ClientPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @param message ClientPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IClientPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ClientPayload message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload;

        /**
         * Decodes a ClientPayload message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload;

        /**
         * Verifies a ClientPayload message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ClientPayload message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ClientPayload
         */
        public static fromObject(object: { [k: string]: any }): proto.ClientPayload;

        /**
         * Creates a plain object from a ClientPayload message. Also converts values to other types if specified.
         * @param message ClientPayload
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ClientPayload, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ClientPayload to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ClientPayload
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace ClientPayload {

        /** AccountType enum. */
        enum AccountType {
            DEFAULT = 0,
            GUEST = 1
        }

        /** ConnectReason enum. */
        enum ConnectReason {
            PUSH = 0,
            USER_ACTIVATED = 1,
            SCHEDULED = 2,
            ERROR_RECONNECT = 3,
            NETWORK_SWITCH = 4,
            PING_RECONNECT = 5,
            UNKNOWN = 6
        }

        /** ConnectType enum. */
        enum ConnectType {
            CELLULAR_UNKNOWN = 0,
            WIFI_UNKNOWN = 1,
            CELLULAR_EDGE = 100,
            CELLULAR_IDEN = 101,
            CELLULAR_UMTS = 102,
            CELLULAR_EVDO = 103,
            CELLULAR_GPRS = 104,
            CELLULAR_HSDPA = 105,
            CELLULAR_HSUPA = 106,
            CELLULAR_HSPA = 107,
            CELLULAR_CDMA = 108,
            CELLULAR_1XRTT = 109,
            CELLULAR_EHRPD = 110,
            CELLULAR_LTE = 111,
            CELLULAR_HSPAP = 112
        }

        /** Properties of a DNSSource. */
        interface IDNSSource {

            /** DNSSource dnsMethod */
            dnsMethod?: (proto.ClientPayload.DNSSource.DNSResolutionMethod|null);

            /** DNSSource appCached */
            appCached?: (boolean|null);
        }

        /** Represents a DNSSource. */
        class DNSSource implements IDNSSource {

            /**
             * Constructs a new DNSSource.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IDNSSource);

            /** DNSSource dnsMethod. */
            public dnsMethod?: (proto.ClientPayload.DNSSource.DNSResolutionMethod|null);

            /** DNSSource appCached. */
            public appCached?: (boolean|null);

            /**
             * Creates a new DNSSource instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DNSSource instance
             */
            public static create(properties?: proto.ClientPayload.IDNSSource): proto.ClientPayload.DNSSource;

            /**
             * Encodes the specified DNSSource message. Does not implicitly {@link proto.ClientPayload.DNSSource.verify|verify} messages.
             * @param message DNSSource message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IDNSSource, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DNSSource message, length delimited. Does not implicitly {@link proto.ClientPayload.DNSSource.verify|verify} messages.
             * @param message DNSSource message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IDNSSource, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DNSSource message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DNSSource
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.DNSSource;

            /**
             * Decodes a DNSSource message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DNSSource
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.DNSSource;

            /**
             * Verifies a DNSSource message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DNSSource message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DNSSource
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.DNSSource;

            /**
             * Creates a plain object from a DNSSource message. Also converts values to other types if specified.
             * @param message DNSSource
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.DNSSource, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DNSSource to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for DNSSource
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace DNSSource {

            /** DNSResolutionMethod enum. */
            enum DNSResolutionMethod {
                SYSTEM = 0,
                GOOGLE = 1,
                HARDCODED = 2,
                OVERRIDE = 3,
                FALLBACK = 4,
                MNS = 5
            }
        }

        /** Properties of a DevicePairingRegistrationData. */
        interface IDevicePairingRegistrationData {

            /** DevicePairingRegistrationData eRegid */
            eRegid?: (Uint8Array|null);

            /** DevicePairingRegistrationData eKeytype */
            eKeytype?: (Uint8Array|null);

            /** DevicePairingRegistrationData eIdent */
            eIdent?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeyId */
            eSkeyId?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeyVal */
            eSkeyVal?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeySig */
            eSkeySig?: (Uint8Array|null);

            /** DevicePairingRegistrationData buildHash */
            buildHash?: (Uint8Array|null);

            /** DevicePairingRegistrationData deviceProps */
            deviceProps?: (Uint8Array|null);
        }

        /** Represents a DevicePairingRegistrationData. */
        class DevicePairingRegistrationData implements IDevicePairingRegistrationData {

            /**
             * Constructs a new DevicePairingRegistrationData.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IDevicePairingRegistrationData);

            /** DevicePairingRegistrationData eRegid. */
            public eRegid?: (Uint8Array|null);

            /** DevicePairingRegistrationData eKeytype. */
            public eKeytype?: (Uint8Array|null);

            /** DevicePairingRegistrationData eIdent. */
            public eIdent?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeyId. */
            public eSkeyId?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeyVal. */
            public eSkeyVal?: (Uint8Array|null);

            /** DevicePairingRegistrationData eSkeySig. */
            public eSkeySig?: (Uint8Array|null);

            /** DevicePairingRegistrationData buildHash. */
            public buildHash?: (Uint8Array|null);

            /** DevicePairingRegistrationData deviceProps. */
            public deviceProps?: (Uint8Array|null);

            /**
             * Creates a new DevicePairingRegistrationData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DevicePairingRegistrationData instance
             */
            public static create(properties?: proto.ClientPayload.IDevicePairingRegistrationData): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Encodes the specified DevicePairingRegistrationData message. Does not implicitly {@link proto.ClientPayload.DevicePairingRegistrationData.verify|verify} messages.
             * @param message DevicePairingRegistrationData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IDevicePairingRegistrationData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DevicePairingRegistrationData message, length delimited. Does not implicitly {@link proto.ClientPayload.DevicePairingRegistrationData.verify|verify} messages.
             * @param message DevicePairingRegistrationData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IDevicePairingRegistrationData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DevicePairingRegistrationData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DevicePairingRegistrationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Decodes a DevicePairingRegistrationData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DevicePairingRegistrationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Verifies a DevicePairingRegistrationData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DevicePairingRegistrationData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DevicePairingRegistrationData
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.DevicePairingRegistrationData;

            /**
             * Creates a plain object from a DevicePairingRegistrationData message. Also converts values to other types if specified.
             * @param message DevicePairingRegistrationData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.DevicePairingRegistrationData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DevicePairingRegistrationData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for DevicePairingRegistrationData
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** IOSAppExtension enum. */
        enum IOSAppExtension {
            SHARE_EXTENSION = 0,
            SERVICE_EXTENSION = 1,
            INTENTS_EXTENSION = 2
        }

        /** Properties of an InteropData. */
        interface IInteropData {

            /** InteropData accountId */
            accountId?: (number|Long|null);

            /** InteropData token */
            token?: (Uint8Array|null);

            /** InteropData enableReadReceipts */
            enableReadReceipts?: (boolean|null);
        }

        /** Represents an InteropData. */
        class InteropData implements IInteropData {

            /**
             * Constructs a new InteropData.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IInteropData);

            /** InteropData accountId. */
            public accountId?: (number|Long|null);

            /** InteropData token. */
            public token?: (Uint8Array|null);

            /** InteropData enableReadReceipts. */
            public enableReadReceipts?: (boolean|null);

            /**
             * Creates a new InteropData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns InteropData instance
             */
            public static create(properties?: proto.ClientPayload.IInteropData): proto.ClientPayload.InteropData;

            /**
             * Encodes the specified InteropData message. Does not implicitly {@link proto.ClientPayload.InteropData.verify|verify} messages.
             * @param message InteropData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IInteropData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified InteropData message, length delimited. Does not implicitly {@link proto.ClientPayload.InteropData.verify|verify} messages.
             * @param message InteropData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IInteropData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an InteropData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns InteropData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.InteropData;

            /**
             * Decodes an InteropData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns InteropData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.InteropData;

            /**
             * Verifies an InteropData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an InteropData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns InteropData
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.InteropData;

            /**
             * Creates a plain object from an InteropData message. Also converts values to other types if specified.
             * @param message InteropData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.InteropData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this InteropData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for InteropData
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Product enum. */
        enum Product {
            WHATSAPP = 0,
            MESSENGER = 1,
            INTEROP = 2,
            INTEROP_MSGR = 3,
            WHATSAPP_LID = 4
        }

        /** TrafficAnonymization enum. */
        enum TrafficAnonymization {
            OFF = 0,
            STANDARD = 1
        }

        /** Properties of a UserAgent. */
        interface IUserAgent {

            /** UserAgent platform */
            platform?: (proto.ClientPayload.UserAgent.Platform|null);

            /** UserAgent appVersion */
            appVersion?: (proto.ClientPayload.UserAgent.IAppVersion|null);

            /** UserAgent mcc */
            mcc?: (string|null);

            /** UserAgent mnc */
            mnc?: (string|null);

            /** UserAgent osVersion */
            osVersion?: (string|null);

            /** UserAgent manufacturer */
            manufacturer?: (string|null);

            /** UserAgent device */
            device?: (string|null);

            /** UserAgent osBuildNumber */
            osBuildNumber?: (string|null);

            /** UserAgent phoneId */
            phoneId?: (string|null);

            /** UserAgent releaseChannel */
            releaseChannel?: (proto.ClientPayload.UserAgent.ReleaseChannel|null);

            /** UserAgent localeLanguageIso6391 */
            localeLanguageIso6391?: (string|null);

            /** UserAgent localeCountryIso31661Alpha2 */
            localeCountryIso31661Alpha2?: (string|null);

            /** UserAgent deviceBoard */
            deviceBoard?: (string|null);

            /** UserAgent deviceExpId */
            deviceExpId?: (string|null);

            /** UserAgent deviceType */
            deviceType?: (proto.ClientPayload.UserAgent.DeviceType|null);

            /** UserAgent deviceModelType */
            deviceModelType?: (string|null);
        }

        /** Represents a UserAgent. */
        class UserAgent implements IUserAgent {

            /**
             * Constructs a new UserAgent.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IUserAgent);

            /** UserAgent platform. */
            public platform?: (proto.ClientPayload.UserAgent.Platform|null);

            /** UserAgent appVersion. */
            public appVersion?: (proto.ClientPayload.UserAgent.IAppVersion|null);

            /** UserAgent mcc. */
            public mcc?: (string|null);

            /** UserAgent mnc. */
            public mnc?: (string|null);

            /** UserAgent osVersion. */
            public osVersion?: (string|null);

            /** UserAgent manufacturer. */
            public manufacturer?: (string|null);

            /** UserAgent device. */
            public device?: (string|null);

            /** UserAgent osBuildNumber. */
            public osBuildNumber?: (string|null);

            /** UserAgent phoneId. */
            public phoneId?: (string|null);

            /** UserAgent releaseChannel. */
            public releaseChannel?: (proto.ClientPayload.UserAgent.ReleaseChannel|null);

            /** UserAgent localeLanguageIso6391. */
            public localeLanguageIso6391?: (string|null);

            /** UserAgent localeCountryIso31661Alpha2. */
            public localeCountryIso31661Alpha2?: (string|null);

            /** UserAgent deviceBoard. */
            public deviceBoard?: (string|null);

            /** UserAgent deviceExpId. */
            public deviceExpId?: (string|null);

            /** UserAgent deviceType. */
            public deviceType?: (proto.ClientPayload.UserAgent.DeviceType|null);

            /** UserAgent deviceModelType. */
            public deviceModelType?: (string|null);

            /**
             * Creates a new UserAgent instance using the specified properties.
             * @param [properties] Properties to set
             * @returns UserAgent instance
             */
            public static create(properties?: proto.ClientPayload.IUserAgent): proto.ClientPayload.UserAgent;

            /**
             * Encodes the specified UserAgent message. Does not implicitly {@link proto.ClientPayload.UserAgent.verify|verify} messages.
             * @param message UserAgent message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IUserAgent, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified UserAgent message, length delimited. Does not implicitly {@link proto.ClientPayload.UserAgent.verify|verify} messages.
             * @param message UserAgent message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IUserAgent, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a UserAgent message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns UserAgent
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.UserAgent;

            /**
             * Decodes a UserAgent message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns UserAgent
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.UserAgent;

            /**
             * Verifies a UserAgent message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a UserAgent message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns UserAgent
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.UserAgent;

            /**
             * Creates a plain object from a UserAgent message. Also converts values to other types if specified.
             * @param message UserAgent
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.UserAgent, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this UserAgent to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for UserAgent
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace UserAgent {

            /** Properties of an AppVersion. */
            interface IAppVersion {

                /** AppVersion primary */
                primary?: (number|null);

                /** AppVersion secondary */
                secondary?: (number|null);

                /** AppVersion tertiary */
                tertiary?: (number|null);

                /** AppVersion quaternary */
                quaternary?: (number|null);

                /** AppVersion quinary */
                quinary?: (number|null);
            }

            /** Represents an AppVersion. */
            class AppVersion implements IAppVersion {

                /**
                 * Constructs a new AppVersion.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.ClientPayload.UserAgent.IAppVersion);

                /** AppVersion primary. */
                public primary?: (number|null);

                /** AppVersion secondary. */
                public secondary?: (number|null);

                /** AppVersion tertiary. */
                public tertiary?: (number|null);

                /** AppVersion quaternary. */
                public quaternary?: (number|null);

                /** AppVersion quinary. */
                public quinary?: (number|null);

                /**
                 * Creates a new AppVersion instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns AppVersion instance
                 */
                public static create(properties?: proto.ClientPayload.UserAgent.IAppVersion): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Encodes the specified AppVersion message. Does not implicitly {@link proto.ClientPayload.UserAgent.AppVersion.verify|verify} messages.
                 * @param message AppVersion message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.ClientPayload.UserAgent.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.ClientPayload.UserAgent.AppVersion.verify|verify} messages.
                 * @param message AppVersion message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.ClientPayload.UserAgent.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes an AppVersion message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns AppVersion
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Decodes an AppVersion message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns AppVersion
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Verifies an AppVersion message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns AppVersion
                 */
                public static fromObject(object: { [k: string]: any }): proto.ClientPayload.UserAgent.AppVersion;

                /**
                 * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
                 * @param message AppVersion
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.ClientPayload.UserAgent.AppVersion, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this AppVersion to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for AppVersion
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            /** DeviceType enum. */
            enum DeviceType {
                PHONE = 0,
                TABLET = 1,
                DESKTOP = 2,
                WEARABLE = 3,
                VR = 4
            }

            /** Platform enum. */
            enum Platform {
                ANDROID = 0,
                IOS = 1,
                WINDOWS_PHONE = 2,
                BLACKBERRY = 3,
                BLACKBERRYX = 4,
                S40 = 5,
                S60 = 6,
                PYTHON_CLIENT = 7,
                TIZEN = 8,
                ENTERPRISE = 9,
                SMB_ANDROID = 10,
                KAIOS = 11,
                SMB_IOS = 12,
                WINDOWS = 13,
                WEB = 14,
                PORTAL = 15,
                GREEN_ANDROID = 16,
                GREEN_IPHONE = 17,
                BLUE_ANDROID = 18,
                BLUE_IPHONE = 19,
                FBLITE_ANDROID = 20,
                MLITE_ANDROID = 21,
                IGLITE_ANDROID = 22,
                PAGE = 23,
                MACOS = 24,
                OCULUS_MSG = 25,
                OCULUS_CALL = 26,
                MILAN = 27,
                CAPI = 28,
                WEAROS = 29,
                ARDEVICE = 30,
                VRDEVICE = 31,
                BLUE_WEB = 32,
                IPAD = 33,
                TEST = 34,
                SMART_GLASSES = 35
            }

            /** ReleaseChannel enum. */
            enum ReleaseChannel {
                RELEASE = 0,
                BETA = 1,
                ALPHA = 2,
                DEBUG = 3
            }
        }

        /** Properties of a WebInfo. */
        interface IWebInfo {

            /** WebInfo refToken */
            refToken?: (string|null);

            /** WebInfo version */
            version?: (string|null);

            /** WebInfo webdPayload */
            webdPayload?: (proto.ClientPayload.WebInfo.IWebdPayload|null);

            /** WebInfo webSubPlatform */
            webSubPlatform?: (proto.ClientPayload.WebInfo.WebSubPlatform|null);
        }

        /** Represents a WebInfo. */
        class WebInfo implements IWebInfo {

            /**
             * Constructs a new WebInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ClientPayload.IWebInfo);

            /** WebInfo refToken. */
            public refToken?: (string|null);

            /** WebInfo version. */
            public version?: (string|null);

            /** WebInfo webdPayload. */
            public webdPayload?: (proto.ClientPayload.WebInfo.IWebdPayload|null);

            /** WebInfo webSubPlatform. */
            public webSubPlatform?: (proto.ClientPayload.WebInfo.WebSubPlatform|null);

            /**
             * Creates a new WebInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns WebInfo instance
             */
            public static create(properties?: proto.ClientPayload.IWebInfo): proto.ClientPayload.WebInfo;

            /**
             * Encodes the specified WebInfo message. Does not implicitly {@link proto.ClientPayload.WebInfo.verify|verify} messages.
             * @param message WebInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ClientPayload.IWebInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified WebInfo message, length delimited. Does not implicitly {@link proto.ClientPayload.WebInfo.verify|verify} messages.
             * @param message WebInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ClientPayload.IWebInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a WebInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns WebInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.WebInfo;

            /**
             * Decodes a WebInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns WebInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.WebInfo;

            /**
             * Verifies a WebInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a WebInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns WebInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ClientPayload.WebInfo;

            /**
             * Creates a plain object from a WebInfo message. Also converts values to other types if specified.
             * @param message WebInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ClientPayload.WebInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this WebInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for WebInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace WebInfo {

            /** WebSubPlatform enum. */
            enum WebSubPlatform {
                WEB_BROWSER = 0,
                APP_STORE = 1,
                WIN_STORE = 2,
                DARWIN = 3,
                WIN32 = 4,
                WIN_HYBRID = 5
            }

            /** Properties of a WebdPayload. */
            interface IWebdPayload {

                /** WebdPayload usesParticipantInKey */
                usesParticipantInKey?: (boolean|null);

                /** WebdPayload supportsStarredMessages */
                supportsStarredMessages?: (boolean|null);

                /** WebdPayload supportsDocumentMessages */
                supportsDocumentMessages?: (boolean|null);

                /** WebdPayload supportsUrlMessages */
                supportsUrlMessages?: (boolean|null);

                /** WebdPayload supportsMediaRetry */
                supportsMediaRetry?: (boolean|null);

                /** WebdPayload supportsE2EImage */
                supportsE2EImage?: (boolean|null);

                /** WebdPayload supportsE2EVideo */
                supportsE2EVideo?: (boolean|null);

                /** WebdPayload supportsE2EAudio */
                supportsE2EAudio?: (boolean|null);

                /** WebdPayload supportsE2EDocument */
                supportsE2EDocument?: (boolean|null);

                /** WebdPayload documentTypes */
                documentTypes?: (string|null);

                /** WebdPayload features */
                features?: (Uint8Array|null);
            }

            /** Represents a WebdPayload. */
            class WebdPayload implements IWebdPayload {

                /**
                 * Constructs a new WebdPayload.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.ClientPayload.WebInfo.IWebdPayload);

                /** WebdPayload usesParticipantInKey. */
                public usesParticipantInKey?: (boolean|null);

                /** WebdPayload supportsStarredMessages. */
                public supportsStarredMessages?: (boolean|null);

                /** WebdPayload supportsDocumentMessages. */
                public supportsDocumentMessages?: (boolean|null);

                /** WebdPayload supportsUrlMessages. */
                public supportsUrlMessages?: (boolean|null);

                /** WebdPayload supportsMediaRetry. */
                public supportsMediaRetry?: (boolean|null);

                /** WebdPayload supportsE2EImage. */
                public supportsE2EImage?: (boolean|null);

                /** WebdPayload supportsE2EVideo. */
                public supportsE2EVideo?: (boolean|null);

                /** WebdPayload supportsE2EAudio. */
                public supportsE2EAudio?: (boolean|null);

                /** WebdPayload supportsE2EDocument. */
                public supportsE2EDocument?: (boolean|null);

                /** WebdPayload documentTypes. */
                public documentTypes?: (string|null);

                /** WebdPayload features. */
                public features?: (Uint8Array|null);

                /**
                 * Creates a new WebdPayload instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns WebdPayload instance
                 */
                public static create(properties?: proto.ClientPayload.WebInfo.IWebdPayload): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Encodes the specified WebdPayload message. Does not implicitly {@link proto.ClientPayload.WebInfo.WebdPayload.verify|verify} messages.
                 * @param message WebdPayload message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.ClientPayload.WebInfo.IWebdPayload, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified WebdPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.WebInfo.WebdPayload.verify|verify} messages.
                 * @param message WebdPayload message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.ClientPayload.WebInfo.IWebdPayload, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a WebdPayload message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns WebdPayload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Decodes a WebdPayload message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns WebdPayload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Verifies a WebdPayload message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a WebdPayload message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns WebdPayload
                 */
                public static fromObject(object: { [k: string]: any }): proto.ClientPayload.WebInfo.WebdPayload;

                /**
                 * Creates a plain object from a WebdPayload message. Also converts values to other types if specified.
                 * @param message WebdPayload
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.ClientPayload.WebInfo.WebdPayload, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this WebdPayload to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for WebdPayload
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }
    }

    /** Properties of a CommentMetadata. */
    interface ICommentMetadata {

        /** CommentMetadata commentParentKey */
        commentParentKey?: (proto.IMessageKey|null);

        /** CommentMetadata replyCount */
        replyCount?: (number|null);
    }

    /** Represents a CommentMetadata. */
    class CommentMetadata implements ICommentMetadata {

        /**
         * Constructs a new CommentMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ICommentMetadata);

        /** CommentMetadata commentParentKey. */
        public commentParentKey?: (proto.IMessageKey|null);

        /** CommentMetadata replyCount. */
        public replyCount?: (number|null);

        /**
         * Creates a new CommentMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CommentMetadata instance
         */
        public static create(properties?: proto.ICommentMetadata): proto.CommentMetadata;

        /**
         * Encodes the specified CommentMetadata message. Does not implicitly {@link proto.CommentMetadata.verify|verify} messages.
         * @param message CommentMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ICommentMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CommentMetadata message, length delimited. Does not implicitly {@link proto.CommentMetadata.verify|verify} messages.
         * @param message CommentMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ICommentMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CommentMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CommentMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CommentMetadata;

        /**
         * Decodes a CommentMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CommentMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CommentMetadata;

        /**
         * Verifies a CommentMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CommentMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CommentMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.CommentMetadata;

        /**
         * Creates a plain object from a CommentMetadata message. Also converts values to other types if specified.
         * @param message CommentMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.CommentMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CommentMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for CommentMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a CompanionCommitment. */
    interface ICompanionCommitment {

        /** CompanionCommitment hash */
        hash?: (Uint8Array|null);
    }

    /** Represents a CompanionCommitment. */
    class CompanionCommitment implements ICompanionCommitment {

        /**
         * Constructs a new CompanionCommitment.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ICompanionCommitment);

        /** CompanionCommitment hash. */
        public hash?: (Uint8Array|null);

        /**
         * Creates a new CompanionCommitment instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CompanionCommitment instance
         */
        public static create(properties?: proto.ICompanionCommitment): proto.CompanionCommitment;

        /**
         * Encodes the specified CompanionCommitment message. Does not implicitly {@link proto.CompanionCommitment.verify|verify} messages.
         * @param message CompanionCommitment message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ICompanionCommitment, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CompanionCommitment message, length delimited. Does not implicitly {@link proto.CompanionCommitment.verify|verify} messages.
         * @param message CompanionCommitment message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ICompanionCommitment, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CompanionCommitment message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CompanionCommitment
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CompanionCommitment;

        /**
         * Decodes a CompanionCommitment message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CompanionCommitment
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CompanionCommitment;

        /**
         * Verifies a CompanionCommitment message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CompanionCommitment message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CompanionCommitment
         */
        public static fromObject(object: { [k: string]: any }): proto.CompanionCommitment;

        /**
         * Creates a plain object from a CompanionCommitment message. Also converts values to other types if specified.
         * @param message CompanionCommitment
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.CompanionCommitment, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CompanionCommitment to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for CompanionCommitment
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a CompanionEphemeralIdentity. */
    interface ICompanionEphemeralIdentity {

        /** CompanionEphemeralIdentity publicKey */
        publicKey?: (Uint8Array|null);

        /** CompanionEphemeralIdentity deviceType */
        deviceType?: (proto.DeviceProps.PlatformType|null);

        /** CompanionEphemeralIdentity ref */
        ref?: (string|null);
    }

    /** Represents a CompanionEphemeralIdentity. */
    class CompanionEphemeralIdentity implements ICompanionEphemeralIdentity {

        /**
         * Constructs a new CompanionEphemeralIdentity.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ICompanionEphemeralIdentity);

        /** CompanionEphemeralIdentity publicKey. */
        public publicKey?: (Uint8Array|null);

        /** CompanionEphemeralIdentity deviceType. */
        public deviceType?: (proto.DeviceProps.PlatformType|null);

        /** CompanionEphemeralIdentity ref. */
        public ref?: (string|null);

        /**
         * Creates a new CompanionEphemeralIdentity instance using the specified properties.
         * @param [properties] Properties to set
         * @returns CompanionEphemeralIdentity instance
         */
        public static create(properties?: proto.ICompanionEphemeralIdentity): proto.CompanionEphemeralIdentity;

        /**
         * Encodes the specified CompanionEphemeralIdentity message. Does not implicitly {@link proto.CompanionEphemeralIdentity.verify|verify} messages.
         * @param message CompanionEphemeralIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ICompanionEphemeralIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified CompanionEphemeralIdentity message, length delimited. Does not implicitly {@link proto.CompanionEphemeralIdentity.verify|verify} messages.
         * @param message CompanionEphemeralIdentity message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ICompanionEphemeralIdentity, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a CompanionEphemeralIdentity message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns CompanionEphemeralIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.CompanionEphemeralIdentity;

        /**
         * Decodes a CompanionEphemeralIdentity message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns CompanionEphemeralIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.CompanionEphemeralIdentity;

        /**
         * Verifies a CompanionEphemeralIdentity message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a CompanionEphemeralIdentity message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns CompanionEphemeralIdentity
         */
        public static fromObject(object: { [k: string]: any }): proto.CompanionEphemeralIdentity;

        /**
         * Creates a plain object from a CompanionEphemeralIdentity message. Also converts values to other types if specified.
         * @param message CompanionEphemeralIdentity
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.CompanionEphemeralIdentity, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this CompanionEphemeralIdentity to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for CompanionEphemeralIdentity
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a Config. */
    interface IConfig {

        /** Config field */
        field?: ({ [k: string]: proto.IField }|null);

        /** Config version */
        version?: (number|null);
    }

    /** Represents a Config. */
    class Config implements IConfig {

        /**
         * Constructs a new Config.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IConfig);

        /** Config field. */
        public field: { [k: string]: proto.IField };

        /** Config version. */
        public version?: (number|null);

        /**
         * Creates a new Config instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Config instance
         */
        public static create(properties?: proto.IConfig): proto.Config;

        /**
         * Encodes the specified Config message. Does not implicitly {@link proto.Config.verify|verify} messages.
         * @param message Config message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IConfig, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Config message, length delimited. Does not implicitly {@link proto.Config.verify|verify} messages.
         * @param message Config message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IConfig, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Config message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Config
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Config;

        /**
         * Decodes a Config message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Config
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Config;

        /**
         * Verifies a Config message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Config message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Config
         */
        public static fromObject(object: { [k: string]: any }): proto.Config;

        /**
         * Creates a plain object from a Config message. Also converts values to other types if specified.
         * @param message Config
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Config, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Config to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for Config
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a ContextInfo. */
    interface IContextInfo {

        /** ContextInfo stanzaId */
        stanzaId?: (string|null);

        /** ContextInfo participant */
        participant?: (string|null);

        /** ContextInfo quotedMessage */
        quotedMessage?: (proto.IMessage|null);

        /** ContextInfo remoteJid */
        remoteJid?: (string|null);

        /** ContextInfo mentionedJid */
        mentionedJid?: (string[]|null);

        /** ContextInfo conversionSource */
        conversionSource?: (string|null);

        /** ContextInfo conversionData */
        conversionData?: (Uint8Array|null);

        /** ContextInfo conversionDelaySeconds */
        conversionDelaySeconds?: (number|null);

        /** ContextInfo forwardingScore */
        forwardingScore?: (number|null);

        /** ContextInfo isForwarded */
        isForwarded?: (boolean|null);

        /** ContextInfo quotedAd */
        quotedAd?: (proto.ContextInfo.IAdReplyInfo|null);

        /** ContextInfo placeholderKey */
        placeholderKey?: (proto.IMessageKey|null);

        /** ContextInfo expiration */
        expiration?: (number|null);

        /** ContextInfo ephemeralSettingTimestamp */
        ephemeralSettingTimestamp?: (number|Long|null);

        /** ContextInfo ephemeralSharedSecret */
        ephemeralSharedSecret?: (Uint8Array|null);

        /** ContextInfo externalAdReply */
        externalAdReply?: (proto.ContextInfo.IExternalAdReplyInfo|null);

        /** ContextInfo entryPointConversionSource */
        entryPointConversionSource?: (string|null);

        /** ContextInfo entryPointConversionApp */
        entryPointConversionApp?: (string|null);

        /** ContextInfo entryPointConversionDelaySeconds */
        entryPointConversionDelaySeconds?: (number|null);

        /** ContextInfo disappearingMode */
        disappearingMode?: (proto.IDisappearingMode|null);

        /** ContextInfo actionLink */
        actionLink?: (proto.IActionLink|null);

        /** ContextInfo groupSubject */
        groupSubject?: (string|null);

        /** ContextInfo parentGroupJid */
        parentGroupJid?: (string|null);

        /** ContextInfo trustBannerType */
        trustBannerType?: (string|null);

        /** ContextInfo trustBannerAction */
        trustBannerAction?: (number|null);

        /** ContextInfo isSampled */
        isSampled?: (boolean|null);

        /** ContextInfo groupMentions */
        groupMentions?: (proto.IGroupMention[]|null);

        /** ContextInfo utm */
        utm?: (proto.ContextInfo.IUTMInfo|null);

        /** ContextInfo forwardedNewsletterMessageInfo */
        forwardedNewsletterMessageInfo?: (proto.ContextInfo.IForwardedNewsletterMessageInfo|null);

        /** ContextInfo businessMessageForwardInfo */
        businessMessageForwardInfo?: (proto.ContextInfo.IBusinessMessageForwardInfo|null);

        /** ContextInfo smbClientCampaignId */
        smbClientCampaignId?: (string|null);

        /** ContextInfo smbServerCampaignId */
        smbServerCampaignId?: (string|null);

        /** ContextInfo dataSharingContext */
        dataSharingContext?: (proto.ContextInfo.IDataSharingContext|null);

        /** ContextInfo alwaysShowAdAttribution */
        alwaysShowAdAttribution?: (boolean|null);

        /** ContextInfo featureEligibilities */
        featureEligibilities?: (proto.ContextInfo.IFeatureEligibilities|null);

        /** ContextInfo entryPointConversionExternalSource */
        entryPointConversionExternalSource?: (string|null);

        /** ContextInfo entryPointConversionExternalMedium */
        entryPointConversionExternalMedium?: (string|null);

        /** ContextInfo ctwaSignals */
        ctwaSignals?: (string|null);

        /** ContextInfo ctwaPayload */
        ctwaPayload?: (Uint8Array|null);

        /** ContextInfo forwardedAiBotMessageInfo */
        forwardedAiBotMessageInfo?: (proto.ContextInfo.IForwardedAIBotMessageInfo|null);

        /** ContextInfo statusAttributionType */
        statusAttributionType?: (proto.ContextInfo.StatusAttributionType|null);

        /** ContextInfo urlTrackingMap */
        urlTrackingMap?: (proto.IUrlTrackingMap|null);

        /** ContextInfo pairedMediaType */
        pairedMediaType?: (proto.ContextInfo.PairedMediaType|null);

        /** ContextInfo rankingVersion */
        rankingVersion?: (number|null);

        /** ContextInfo memberLabel */
        memberLabel?: (proto.IMemberLabel|null);

        /** ContextInfo isQuestion */
        isQuestion?: (boolean|null);

        /** ContextInfo statusSourceType */
        statusSourceType?: (proto.ContextInfo.StatusSourceType|null);
    }

    /** Represents a ContextInfo. */
    class ContextInfo implements IContextInfo {

        /**
         * Constructs a new ContextInfo.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IContextInfo);

        /** ContextInfo stanzaId. */
        public stanzaId?: (string|null);

        /** ContextInfo participant. */
        public participant?: (string|null);

        /** ContextInfo quotedMessage. */
        public quotedMessage?: (proto.IMessage|null);

        /** ContextInfo remoteJid. */
        public remoteJid?: (string|null);

        /** ContextInfo mentionedJid. */
        public mentionedJid: string[];

        /** ContextInfo conversionSource. */
        public conversionSource?: (string|null);

        /** ContextInfo conversionData. */
        public conversionData?: (Uint8Array|null);

        /** ContextInfo conversionDelaySeconds. */
        public conversionDelaySeconds?: (number|null);

        /** ContextInfo forwardingScore. */
        public forwardingScore?: (number|null);

        /** ContextInfo isForwarded. */
        public isForwarded?: (boolean|null);

        /** ContextInfo quotedAd. */
        public quotedAd?: (proto.ContextInfo.IAdReplyInfo|null);

        /** ContextInfo placeholderKey. */
        public placeholderKey?: (proto.IMessageKey|null);

        /** ContextInfo expiration. */
        public expiration?: (number|null);

        /** ContextInfo ephemeralSettingTimestamp. */
        public ephemeralSettingTimestamp?: (number|Long|null);

        /** ContextInfo ephemeralSharedSecret. */
        public ephemeralSharedSecret?: (Uint8Array|null);

        /** ContextInfo externalAdReply. */
        public externalAdReply?: (proto.ContextInfo.IExternalAdReplyInfo|null);

        /** ContextInfo entryPointConversionSource. */
        public entryPointConversionSource?: (string|null);

        /** ContextInfo entryPointConversionApp. */
        public entryPointConversionApp?: (string|null);

        /** ContextInfo entryPointConversionDelaySeconds. */
        public entryPointConversionDelaySeconds?: (number|null);

        /** ContextInfo disappearingMode. */
        public disappearingMode?: (proto.IDisappearingMode|null);

        /** ContextInfo actionLink. */
        public actionLink?: (proto.IActionLink|null);

        /** ContextInfo groupSubject. */
        public groupSubject?: (string|null);

        /** ContextInfo parentGroupJid. */
        public parentGroupJid?: (string|null);

        /** ContextInfo trustBannerType. */
        public trustBannerType?: (string|null);

        /** ContextInfo trustBannerAction. */
        public trustBannerAction?: (number|null);

        /** ContextInfo isSampled. */
        public isSampled?: (boolean|null);

        /** ContextInfo groupMentions. */
        public groupMentions: proto.IGroupMention[];

        /** ContextInfo utm. */
        public utm?: (proto.ContextInfo.IUTMInfo|null);

        /** ContextInfo forwardedNewsletterMessageInfo. */
        public forwardedNewsletterMessageInfo?: (proto.ContextInfo.IForwardedNewsletterMessageInfo|null);

        /** ContextInfo businessMessageForwardInfo. */
        public businessMessageForwardInfo?: (proto.ContextInfo.IBusinessMessageForwardInfo|null);

        /** ContextInfo smbClientCampaignId. */
        public smbClientCampaignId?: (string|null);

        /** ContextInfo smbServerCampaignId. */
        public smbServerCampaignId?: (string|null);

        /** ContextInfo dataSharingContext. */
        public dataSharingContext?: (proto.ContextInfo.IDataSharingContext|null);

        /** ContextInfo alwaysShowAdAttribution. */
        public alwaysShowAdAttribution?: (boolean|null);

        /** ContextInfo featureEligibilities. */
        public featureEligibilities?: (proto.ContextInfo.IFeatureEligibilities|null);

        /** ContextInfo entryPointConversionExternalSource. */
        public entryPointConversionExternalSource?: (string|null);

        /** ContextInfo entryPointConversionExternalMedium. */
        public entryPointConversionExternalMedium?: (string|null);

        /** ContextInfo ctwaSignals. */
        public ctwaSignals?: (string|null);

        /** ContextInfo ctwaPayload. */
        public ctwaPayload?: (Uint8Array|null);

        /** ContextInfo forwardedAiBotMessageInfo. */
        public forwardedAiBotMessageInfo?: (proto.ContextInfo.IForwardedAIBotMessageInfo|null);

        /** ContextInfo statusAttributionType. */
        public statusAttributionType?: (proto.ContextInfo.StatusAttributionType|null);

        /** ContextInfo urlTrackingMap. */
        public urlTrackingMap?: (proto.IUrlTrackingMap|null);

        /** ContextInfo pairedMediaType. */
        public pairedMediaType?: (proto.ContextInfo.PairedMediaType|null);

        /** ContextInfo rankingVersion. */
        public rankingVersion?: (number|null);

        /** ContextInfo memberLabel. */
        public memberLabel?: (proto.IMemberLabel|null);

        /** ContextInfo isQuestion. */
        public isQuestion?: (boolean|null);

        /** ContextInfo statusSourceType. */
        public statusSourceType?: (proto.ContextInfo.StatusSourceType|null);

        /**
         * Creates a new ContextInfo instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ContextInfo instance
         */
        public static create(properties?: proto.IContextInfo): proto.ContextInfo;

        /**
         * Encodes the specified ContextInfo message. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @param message ContextInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IContextInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ContextInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @param message ContextInfo message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IContextInfo, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a ContextInfo message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo;

        /**
         * Decodes a ContextInfo message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo;

        /**
         * Verifies a ContextInfo message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a ContextInfo message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ContextInfo
         */
        public static fromObject(object: { [k: string]: any }): proto.ContextInfo;

        /**
         * Creates a plain object from a ContextInfo message. Also converts values to other types if specified.
         * @param message ContextInfo
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ContextInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ContextInfo to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ContextInfo
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace ContextInfo {

        /** Properties of an AdReplyInfo. */
        interface IAdReplyInfo {

            /** AdReplyInfo advertiserName */
            advertiserName?: (string|null);

            /** AdReplyInfo mediaType */
            mediaType?: (proto.ContextInfo.AdReplyInfo.MediaType|null);

            /** AdReplyInfo jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** AdReplyInfo caption */
            caption?: (string|null);
        }

        /** Represents an AdReplyInfo. */
        class AdReplyInfo implements IAdReplyInfo {

            /**
             * Constructs a new AdReplyInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IAdReplyInfo);

            /** AdReplyInfo advertiserName. */
            public advertiserName?: (string|null);

            /** AdReplyInfo mediaType. */
            public mediaType?: (proto.ContextInfo.AdReplyInfo.MediaType|null);

            /** AdReplyInfo jpegThumbnail. */
            public jpegThumbnail?: (Uint8Array|null);

            /** AdReplyInfo caption. */
            public caption?: (string|null);

            /**
             * Creates a new AdReplyInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AdReplyInfo instance
             */
            public static create(properties?: proto.ContextInfo.IAdReplyInfo): proto.ContextInfo.AdReplyInfo;

            /**
             * Encodes the specified AdReplyInfo message. Does not implicitly {@link proto.ContextInfo.AdReplyInfo.verify|verify} messages.
             * @param message AdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AdReplyInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.AdReplyInfo.verify|verify} messages.
             * @param message AdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AdReplyInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.AdReplyInfo;

            /**
             * Decodes an AdReplyInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.AdReplyInfo;

            /**
             * Verifies an AdReplyInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AdReplyInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AdReplyInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.AdReplyInfo;

            /**
             * Creates a plain object from an AdReplyInfo message. Also converts values to other types if specified.
             * @param message AdReplyInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.AdReplyInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AdReplyInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AdReplyInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace AdReplyInfo {

            /** MediaType enum. */
            enum MediaType {
                NONE = 0,
                IMAGE = 1,
                VIDEO = 2
            }
        }

        /** Properties of a BusinessMessageForwardInfo. */
        interface IBusinessMessageForwardInfo {

            /** BusinessMessageForwardInfo businessOwnerJid */
            businessOwnerJid?: (string|null);
        }

        /** Represents a BusinessMessageForwardInfo. */
        class BusinessMessageForwardInfo implements IBusinessMessageForwardInfo {

            /**
             * Constructs a new BusinessMessageForwardInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IBusinessMessageForwardInfo);

            /** BusinessMessageForwardInfo businessOwnerJid. */
            public businessOwnerJid?: (string|null);

            /**
             * Creates a new BusinessMessageForwardInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BusinessMessageForwardInfo instance
             */
            public static create(properties?: proto.ContextInfo.IBusinessMessageForwardInfo): proto.ContextInfo.BusinessMessageForwardInfo;

            /**
             * Encodes the specified BusinessMessageForwardInfo message. Does not implicitly {@link proto.ContextInfo.BusinessMessageForwardInfo.verify|verify} messages.
             * @param message BusinessMessageForwardInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IBusinessMessageForwardInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BusinessMessageForwardInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.BusinessMessageForwardInfo.verify|verify} messages.
             * @param message BusinessMessageForwardInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IBusinessMessageForwardInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BusinessMessageForwardInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BusinessMessageForwardInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.BusinessMessageForwardInfo;

            /**
             * Decodes a BusinessMessageForwardInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BusinessMessageForwardInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.BusinessMessageForwardInfo;

            /**
             * Verifies a BusinessMessageForwardInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BusinessMessageForwardInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BusinessMessageForwardInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.BusinessMessageForwardInfo;

            /**
             * Creates a plain object from a BusinessMessageForwardInfo message. Also converts values to other types if specified.
             * @param message BusinessMessageForwardInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.BusinessMessageForwardInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BusinessMessageForwardInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for BusinessMessageForwardInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a DataSharingContext. */
        interface IDataSharingContext {

            /** DataSharingContext showMmDisclosure */
            showMmDisclosure?: (boolean|null);

            /** DataSharingContext encryptedSignalTokenConsented */
            encryptedSignalTokenConsented?: (string|null);

            /** DataSharingContext parameters */
            parameters?: (proto.ContextInfo.DataSharingContext.IParameters[]|null);
        }

        /** Represents a DataSharingContext. */
        class DataSharingContext implements IDataSharingContext {

            /**
             * Constructs a new DataSharingContext.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IDataSharingContext);

            /** DataSharingContext showMmDisclosure. */
            public showMmDisclosure?: (boolean|null);

            /** DataSharingContext encryptedSignalTokenConsented. */
            public encryptedSignalTokenConsented?: (string|null);

            /** DataSharingContext parameters. */
            public parameters: proto.ContextInfo.DataSharingContext.IParameters[];

            /**
             * Creates a new DataSharingContext instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DataSharingContext instance
             */
            public static create(properties?: proto.ContextInfo.IDataSharingContext): proto.ContextInfo.DataSharingContext;

            /**
             * Encodes the specified DataSharingContext message. Does not implicitly {@link proto.ContextInfo.DataSharingContext.verify|verify} messages.
             * @param message DataSharingContext message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IDataSharingContext, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DataSharingContext message, length delimited. Does not implicitly {@link proto.ContextInfo.DataSharingContext.verify|verify} messages.
             * @param message DataSharingContext message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IDataSharingContext, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DataSharingContext message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DataSharingContext
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.DataSharingContext;

            /**
             * Decodes a DataSharingContext message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DataSharingContext
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.DataSharingContext;

            /**
             * Verifies a DataSharingContext message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DataSharingContext message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DataSharingContext
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.DataSharingContext;

            /**
             * Creates a plain object from a DataSharingContext message. Also converts values to other types if specified.
             * @param message DataSharingContext
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.DataSharingContext, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DataSharingContext to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for DataSharingContext
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace DataSharingContext {

            /** Properties of a Parameters. */
            interface IParameters {

                /** Parameters key */
                key?: (string|null);

                /** Parameters stringData */
                stringData?: (string|null);

                /** Parameters intData */
                intData?: (number|Long|null);

                /** Parameters floatData */
                floatData?: (number|null);

                /** Parameters contents */
                contents?: (proto.ContextInfo.DataSharingContext.IParameters|null);
            }

            /** Represents a Parameters. */
            class Parameters implements IParameters {

                /**
                 * Constructs a new Parameters.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.ContextInfo.DataSharingContext.IParameters);

                /** Parameters key. */
                public key?: (string|null);

                /** Parameters stringData. */
                public stringData?: (string|null);

                /** Parameters intData. */
                public intData?: (number|Long|null);

                /** Parameters floatData. */
                public floatData?: (number|null);

                /** Parameters contents. */
                public contents?: (proto.ContextInfo.DataSharingContext.IParameters|null);

                /**
                 * Creates a new Parameters instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Parameters instance
                 */
                public static create(properties?: proto.ContextInfo.DataSharingContext.IParameters): proto.ContextInfo.DataSharingContext.Parameters;

                /**
                 * Encodes the specified Parameters message. Does not implicitly {@link proto.ContextInfo.DataSharingContext.Parameters.verify|verify} messages.
                 * @param message Parameters message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.ContextInfo.DataSharingContext.IParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Parameters message, length delimited. Does not implicitly {@link proto.ContextInfo.DataSharingContext.Parameters.verify|verify} messages.
                 * @param message Parameters message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.ContextInfo.DataSharingContext.IParameters, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Parameters message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Parameters
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.DataSharingContext.Parameters;

                /**
                 * Decodes a Parameters message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Parameters
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.DataSharingContext.Parameters;

                /**
                 * Verifies a Parameters message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Parameters message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Parameters
                 */
                public static fromObject(object: { [k: string]: any }): proto.ContextInfo.DataSharingContext.Parameters;

                /**
                 * Creates a plain object from a Parameters message. Also converts values to other types if specified.
                 * @param message Parameters
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.ContextInfo.DataSharingContext.Parameters, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Parameters to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for Parameters
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }

        /** Properties of an ExternalAdReplyInfo. */
        interface IExternalAdReplyInfo {

            /** ExternalAdReplyInfo title */
            title?: (string|null);

            /** ExternalAdReplyInfo body */
            body?: (string|null);

            /** ExternalAdReplyInfo mediaType */
            mediaType?: (proto.ContextInfo.ExternalAdReplyInfo.MediaType|null);

            /** ExternalAdReplyInfo thumbnailUrl */
            thumbnailUrl?: (string|null);

            /** ExternalAdReplyInfo mediaUrl */
            mediaUrl?: (string|null);

            /** ExternalAdReplyInfo thumbnail */
            thumbnail?: (Uint8Array|null);

            /** ExternalAdReplyInfo sourceType */
            sourceType?: (string|null);

            /** ExternalAdReplyInfo sourceId */
            sourceId?: (string|null);

            /** ExternalAdReplyInfo sourceUrl */
            sourceUrl?: (string|null);

            /** ExternalAdReplyInfo containsAutoReply */
            containsAutoReply?: (boolean|null);

            /** ExternalAdReplyInfo renderLargerThumbnail */
            renderLargerThumbnail?: (boolean|null);

            /** ExternalAdReplyInfo showAdAttribution */
            showAdAttribution?: (boolean|null);

            /** ExternalAdReplyInfo ctwaClid */
            ctwaClid?: (string|null);

            /** ExternalAdReplyInfo ref */
            ref?: (string|null);

            /** ExternalAdReplyInfo clickToWhatsappCall */
            clickToWhatsappCall?: (boolean|null);

            /** ExternalAdReplyInfo adContextPreviewDismissed */
            adContextPreviewDismissed?: (boolean|null);

            /** ExternalAdReplyInfo sourceApp */
            sourceApp?: (string|null);

            /** ExternalAdReplyInfo automatedGreetingMessageShown */
            automatedGreetingMessageShown?: (boolean|null);

            /** ExternalAdReplyInfo greetingMessageBody */
            greetingMessageBody?: (string|null);

            /** ExternalAdReplyInfo ctaPayload */
            ctaPayload?: (string|null);

            /** ExternalAdReplyInfo disableNudge */
            disableNudge?: (boolean|null);

            /** ExternalAdReplyInfo originalImageUrl */
            originalImageUrl?: (string|null);

            /** ExternalAdReplyInfo automatedGreetingMessageCtaType */
            automatedGreetingMessageCtaType?: (string|null);

            /** ExternalAdReplyInfo wtwaAdFormat */
            wtwaAdFormat?: (boolean|null);

            /** ExternalAdReplyInfo adType */
            adType?: (proto.ContextInfo.ExternalAdReplyInfo.AdType|null);
        }

        /** Represents an ExternalAdReplyInfo. */
        class ExternalAdReplyInfo implements IExternalAdReplyInfo {

            /**
             * Constructs a new ExternalAdReplyInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IExternalAdReplyInfo);

            /** ExternalAdReplyInfo title. */
            public title?: (string|null);

            /** ExternalAdReplyInfo body. */
            public body?: (string|null);

            /** ExternalAdReplyInfo mediaType. */
            public mediaType?: (proto.ContextInfo.ExternalAdReplyInfo.MediaType|null);

            /** ExternalAdReplyInfo thumbnailUrl. */
            public thumbnailUrl?: (string|null);

            /** ExternalAdReplyInfo mediaUrl. */
            public mediaUrl?: (string|null);

            /** ExternalAdReplyInfo thumbnail. */
            public thumbnail?: (Uint8Array|null);

            /** ExternalAdReplyInfo sourceType. */
            public sourceType?: (string|null);

            /** ExternalAdReplyInfo sourceId. */
            public sourceId?: (string|null);

            /** ExternalAdReplyInfo sourceUrl. */
            public sourceUrl?: (string|null);

            /** ExternalAdReplyInfo containsAutoReply. */
            public containsAutoReply?: (boolean|null);

            /** ExternalAdReplyInfo renderLargerThumbnail. */
            public renderLargerThumbnail?: (boolean|null);

            /** ExternalAdReplyInfo showAdAttribution. */
            public showAdAttribution?: (boolean|null);

            /** ExternalAdReplyInfo ctwaClid. */
            public ctwaClid?: (string|null);

            /** ExternalAdReplyInfo ref. */
            public ref?: (string|null);

            /** ExternalAdReplyInfo clickToWhatsappCall. */
            public clickToWhatsappCall?: (boolean|null);

            /** ExternalAdReplyInfo adContextPreviewDismissed. */
            public adContextPreviewDismissed?: (boolean|null);

            /** ExternalAdReplyInfo sourceApp. */
            public sourceApp?: (string|null);

            /** ExternalAdReplyInfo automatedGreetingMessageShown. */
            public automatedGreetingMessageShown?: (boolean|null);

            /** ExternalAdReplyInfo greetingMessageBody. */
            public greetingMessageBody?: (string|null);

            /** ExternalAdReplyInfo ctaPayload. */
            public ctaPayload?: (string|null);

            /** ExternalAdReplyInfo disableNudge. */
            public disableNudge?: (boolean|null);

            /** ExternalAdReplyInfo originalImageUrl. */
            public originalImageUrl?: (string|null);

            /** ExternalAdReplyInfo automatedGreetingMessageCtaType. */
            public automatedGreetingMessageCtaType?: (string|null);

            /** ExternalAdReplyInfo wtwaAdFormat. */
            public wtwaAdFormat?: (boolean|null);

            /** ExternalAdReplyInfo adType. */
            public adType?: (proto.ContextInfo.ExternalAdReplyInfo.AdType|null);

            /**
             * Creates a new ExternalAdReplyInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ExternalAdReplyInfo instance
             */
            public static create(properties?: proto.ContextInfo.IExternalAdReplyInfo): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Encodes the specified ExternalAdReplyInfo message. Does not implicitly {@link proto.ContextInfo.ExternalAdReplyInfo.verify|verify} messages.
             * @param message ExternalAdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IExternalAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ExternalAdReplyInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.ExternalAdReplyInfo.verify|verify} messages.
             * @param message ExternalAdReplyInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IExternalAdReplyInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an ExternalAdReplyInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ExternalAdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Decodes an ExternalAdReplyInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ExternalAdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Verifies an ExternalAdReplyInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an ExternalAdReplyInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ExternalAdReplyInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.ExternalAdReplyInfo;

            /**
             * Creates a plain object from an ExternalAdReplyInfo message. Also converts values to other types if specified.
             * @param message ExternalAdReplyInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.ExternalAdReplyInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ExternalAdReplyInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ExternalAdReplyInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace ExternalAdReplyInfo {

            /** AdType enum. */
            enum AdType {
                CTWA = 0,
                CAWC = 1
            }

            /** MediaType enum. */
            enum MediaType {
                NONE = 0,
                IMAGE = 1,
                VIDEO = 2
            }
        }

        /** Properties of a FeatureEligibilities. */
        interface IFeatureEligibilities {

            /** FeatureEligibilities cannotBeReactedTo */
            cannotBeReactedTo?: (boolean|null);

            /** FeatureEligibilities cannotBeRanked */
            cannotBeRanked?: (boolean|null);

            /** FeatureEligibilities canRequestFeedback */
            canRequestFeedback?: (boolean|null);

            /** FeatureEligibilities canBeReshared */
            canBeReshared?: (boolean|null);
        }

        /** Represents a FeatureEligibilities. */
        class FeatureEligibilities implements IFeatureEligibilities {

            /**
             * Constructs a new FeatureEligibilities.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IFeatureEligibilities);

            /** FeatureEligibilities cannotBeReactedTo. */
            public cannotBeReactedTo?: (boolean|null);

            /** FeatureEligibilities cannotBeRanked. */
            public cannotBeRanked?: (boolean|null);

            /** FeatureEligibilities canRequestFeedback. */
            public canRequestFeedback?: (boolean|null);

            /** FeatureEligibilities canBeReshared. */
            public canBeReshared?: (boolean|null);

            /**
             * Creates a new FeatureEligibilities instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FeatureEligibilities instance
             */
            public static create(properties?: proto.ContextInfo.IFeatureEligibilities): proto.ContextInfo.FeatureEligibilities;

            /**
             * Encodes the specified FeatureEligibilities message. Does not implicitly {@link proto.ContextInfo.FeatureEligibilities.verify|verify} messages.
             * @param message FeatureEligibilities message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IFeatureEligibilities, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FeatureEligibilities message, length delimited. Does not implicitly {@link proto.ContextInfo.FeatureEligibilities.verify|verify} messages.
             * @param message FeatureEligibilities message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IFeatureEligibilities, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FeatureEligibilities message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FeatureEligibilities
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.FeatureEligibilities;

            /**
             * Decodes a FeatureEligibilities message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FeatureEligibilities
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.FeatureEligibilities;

            /**
             * Verifies a FeatureEligibilities message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FeatureEligibilities message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FeatureEligibilities
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.FeatureEligibilities;

            /**
             * Creates a plain object from a FeatureEligibilities message. Also converts values to other types if specified.
             * @param message FeatureEligibilities
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.FeatureEligibilities, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FeatureEligibilities to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for FeatureEligibilities
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a ForwardedAIBotMessageInfo. */
        interface IForwardedAIBotMessageInfo {

            /** ForwardedAIBotMessageInfo botName */
            botName?: (string|null);

            /** ForwardedAIBotMessageInfo botJid */
            botJid?: (string|null);

            /** ForwardedAIBotMessageInfo creatorName */
            creatorName?: (string|null);
        }

        /** Represents a ForwardedAIBotMessageInfo. */
        class ForwardedAIBotMessageInfo implements IForwardedAIBotMessageInfo {

            /**
             * Constructs a new ForwardedAIBotMessageInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IForwardedAIBotMessageInfo);

            /** ForwardedAIBotMessageInfo botName. */
            public botName?: (string|null);

            /** ForwardedAIBotMessageInfo botJid. */
            public botJid?: (string|null);

            /** ForwardedAIBotMessageInfo creatorName. */
            public creatorName?: (string|null);

            /**
             * Creates a new ForwardedAIBotMessageInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ForwardedAIBotMessageInfo instance
             */
            public static create(properties?: proto.ContextInfo.IForwardedAIBotMessageInfo): proto.ContextInfo.ForwardedAIBotMessageInfo;

            /**
             * Encodes the specified ForwardedAIBotMessageInfo message. Does not implicitly {@link proto.ContextInfo.ForwardedAIBotMessageInfo.verify|verify} messages.
             * @param message ForwardedAIBotMessageInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IForwardedAIBotMessageInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ForwardedAIBotMessageInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.ForwardedAIBotMessageInfo.verify|verify} messages.
             * @param message ForwardedAIBotMessageInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IForwardedAIBotMessageInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ForwardedAIBotMessageInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ForwardedAIBotMessageInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.ForwardedAIBotMessageInfo;

            /**
             * Decodes a ForwardedAIBotMessageInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ForwardedAIBotMessageInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.ForwardedAIBotMessageInfo;

            /**
             * Verifies a ForwardedAIBotMessageInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ForwardedAIBotMessageInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ForwardedAIBotMessageInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.ForwardedAIBotMessageInfo;

            /**
             * Creates a plain object from a ForwardedAIBotMessageInfo message. Also converts values to other types if specified.
             * @param message ForwardedAIBotMessageInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.ForwardedAIBotMessageInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ForwardedAIBotMessageInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ForwardedAIBotMessageInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a ForwardedNewsletterMessageInfo. */
        interface IForwardedNewsletterMessageInfo {

            /** ForwardedNewsletterMessageInfo newsletterJid */
            newsletterJid?: (string|null);

            /** ForwardedNewsletterMessageInfo serverMessageId */
            serverMessageId?: (number|null);

            /** ForwardedNewsletterMessageInfo newsletterName */
            newsletterName?: (string|null);

            /** ForwardedNewsletterMessageInfo contentType */
            contentType?: (proto.ContextInfo.ForwardedNewsletterMessageInfo.ContentType|null);

            /** ForwardedNewsletterMessageInfo accessibilityText */
            accessibilityText?: (string|null);
        }

        /** Represents a ForwardedNewsletterMessageInfo. */
        class ForwardedNewsletterMessageInfo implements IForwardedNewsletterMessageInfo {

            /**
             * Constructs a new ForwardedNewsletterMessageInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IForwardedNewsletterMessageInfo);

            /** ForwardedNewsletterMessageInfo newsletterJid. */
            public newsletterJid?: (string|null);

            /** ForwardedNewsletterMessageInfo serverMessageId. */
            public serverMessageId?: (number|null);

            /** ForwardedNewsletterMessageInfo newsletterName. */
            public newsletterName?: (string|null);

            /** ForwardedNewsletterMessageInfo contentType. */
            public contentType?: (proto.ContextInfo.ForwardedNewsletterMessageInfo.ContentType|null);

            /** ForwardedNewsletterMessageInfo accessibilityText. */
            public accessibilityText?: (string|null);

            /**
             * Creates a new ForwardedNewsletterMessageInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ForwardedNewsletterMessageInfo instance
             */
            public static create(properties?: proto.ContextInfo.IForwardedNewsletterMessageInfo): proto.ContextInfo.ForwardedNewsletterMessageInfo;

            /**
             * Encodes the specified ForwardedNewsletterMessageInfo message. Does not implicitly {@link proto.ContextInfo.ForwardedNewsletterMessageInfo.verify|verify} messages.
             * @param message ForwardedNewsletterMessageInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IForwardedNewsletterMessageInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ForwardedNewsletterMessageInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.ForwardedNewsletterMessageInfo.verify|verify} messages.
             * @param message ForwardedNewsletterMessageInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IForwardedNewsletterMessageInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ForwardedNewsletterMessageInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ForwardedNewsletterMessageInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.ForwardedNewsletterMessageInfo;

            /**
             * Decodes a ForwardedNewsletterMessageInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ForwardedNewsletterMessageInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.ForwardedNewsletterMessageInfo;

            /**
             * Verifies a ForwardedNewsletterMessageInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ForwardedNewsletterMessageInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ForwardedNewsletterMessageInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.ForwardedNewsletterMessageInfo;

            /**
             * Creates a plain object from a ForwardedNewsletterMessageInfo message. Also converts values to other types if specified.
             * @param message ForwardedNewsletterMessageInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.ForwardedNewsletterMessageInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ForwardedNewsletterMessageInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ForwardedNewsletterMessageInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace ForwardedNewsletterMessageInfo {

            /** ContentType enum. */
            enum ContentType {
                UPDATE = 1,
                UPDATE_CARD = 2,
                LINK_CARD = 3
            }
        }

        /** PairedMediaType enum. */
        enum PairedMediaType {
            NOT_PAIRED_MEDIA = 0,
            SD_VIDEO_PARENT = 1,
            HD_VIDEO_CHILD = 2,
            SD_IMAGE_PARENT = 3,
            HD_IMAGE_CHILD = 4,
            MOTION_PHOTO_PARENT = 5,
            MOTION_PHOTO_CHILD = 6
        }

        /** StatusAttributionType enum. */
        enum StatusAttributionType {
            NONE = 0,
            RESHARED_FROM_MENTION = 1,
            RESHARED_FROM_POST = 2
        }

        /** StatusSourceType enum. */
        enum StatusSourceType {
            IMAGE = 0,
            VIDEO = 1,
            GIF = 2,
            AUDIO = 3,
            TEXT = 4,
            MUSIC_STANDALONE = 5
        }

        /** Properties of a UTMInfo. */
        interface IUTMInfo {

            /** UTMInfo utmSource */
            utmSource?: (string|null);

            /** UTMInfo utmCampaign */
            utmCampaign?: (string|null);
        }

        /** Represents a UTMInfo. */
        class UTMInfo implements IUTMInfo {

            /**
             * Constructs a new UTMInfo.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.ContextInfo.IUTMInfo);

            /** UTMInfo utmSource. */
            public utmSource?: (string|null);

            /** UTMInfo utmCampaign. */
            public utmCampaign?: (string|null);

            /**
             * Creates a new UTMInfo instance using the specified properties.
             * @param [properties] Properties to set
             * @returns UTMInfo instance
             */
            public static create(properties?: proto.ContextInfo.IUTMInfo): proto.ContextInfo.UTMInfo;

            /**
             * Encodes the specified UTMInfo message. Does not implicitly {@link proto.ContextInfo.UTMInfo.verify|verify} messages.
             * @param message UTMInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.ContextInfo.IUTMInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified UTMInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.UTMInfo.verify|verify} messages.
             * @param message UTMInfo message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.ContextInfo.IUTMInfo, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a UTMInfo message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns UTMInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ContextInfo.UTMInfo;

            /**
             * Decodes a UTMInfo message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns UTMInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ContextInfo.UTMInfo;

            /**
             * Verifies a UTMInfo message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a UTMInfo message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns UTMInfo
             */
            public static fromObject(object: { [k: string]: any }): proto.ContextInfo.UTMInfo;

            /**
             * Creates a plain object from a UTMInfo message. Also converts values to other types if specified.
             * @param message UTMInfo
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.ContextInfo.UTMInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this UTMInfo to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for UTMInfo
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }
    }

    /** Properties of a Conversation. */
    interface IConversation {

        /** Conversation id */
        id: string;

        /** Conversation messages */
        messages?: (proto.IHistorySyncMsg[]|null);

        /** Conversation newJid */
        newJid?: (string|null);

        /** Conversation oldJid */
        oldJid?: (string|null);

        /** Conversation lastMsgTimestamp */
        lastMsgTimestamp?: (number|Long|null);

        /** Conversation unreadCount */
        unreadCount?: (number|null);

        /** Conversation readOnly */
        readOnly?: (boolean|null);

        /** Conversation endOfHistoryTransfer */
        endOfHistoryTransfer?: (boolean|null);

        /** Conversation ephemeralExpiration */
        ephemeralExpiration?: (number|null);

        /** Conversation ephemeralSettingTimestamp */
        ephemeralSettingTimestamp?: (number|Long|null);

        /** Conversation endOfHistoryTransferType */
        endOfHistoryTransferType?: (proto.Conversation.EndOfHistoryTransferType|null);

        /** Conversation conversationTimestamp */
        conversationTimestamp?: (number|Long|null);

        /** Conversation name */
        name?: (string|null);

        /** Conversation pHash */
        pHash?: (string|null);

        /** Conversation notSpam */
        notSpam?: (boolean|null);

        /** Conversation archived */
        archived?: (boolean|null);

        /** Conversation disappearingMode */
        disappearingMode?: (proto.IDisappearingMode|null);

        /** Conversation unreadMentionCount */
        unreadMentionCount?: (number|null);

        /** Conversation markedAsUnread */
        markedAsUnread?: (boolean|null);

        /** Conversation participant */
        participant?: (proto.IGroupParticipant[]|null);

        /** Conversation tcToken */
        tcToken?: (Uint8Array|null);

        /** Conversation tcTokenTimestamp */
        tcTokenTimestamp?: (number|Long|null);

        /** Conversation contactPrimaryIdentityKey */
        contactPrimaryIdentityKey?: (Uint8Array|null);

        /** Conversation pinned */
        pinned?: (number|null);

        /** Conversation muteEndTime */
        muteEndTime?: (number|Long|null);

        /** Conversation wallpaper */
        wallpaper?: (proto.IWallpaperSettings|null);

        /** Conversation mediaVisibility */
        mediaVisibility?: (proto.MediaVisibility|null);

        /** Conversation tcTokenSenderTimestamp */
        tcTokenSenderTimestamp?: (number|Long|null);

        /** Conversation suspended */
        suspended?: (boolean|null);

        /** Conversation terminated */
        terminated?: (boolean|null);

        /** Conversation createdAt */
        createdAt?: (number|Long|null);

        /** Conversation createdBy */
        createdBy?: (string|null);

        /** Conversation description */
        description?: (string|null);

        /** Conversation support */
        support?: (boolean|null);

        /** Conversation isParentGroup */
        isParentGroup?: (boolean|null);

        /** Conversation parentGroupId */
        parentGroupId?: (string|null);

        /** Conversation isDefaultSubgroup */
        isDefaultSubgroup?: (boolean|null);

        /** Conversation displayName */
        displayName?: (string|null);

        /** Conversation pnJid */
        pnJid?: (string|null);

        /** Conversation shareOwnPn */
        shareOwnPn?: (boolean|null);

        /** Conversation pnhDuplicateLidThread */
        pnhDuplicateLidThread?: (boolean|null);

        /** Conversation lidJid */
        lidJid?: (string|null);

        /** Conversation username */
        username?: (string|null);

        /** Conversation lidOriginType */
        lidOriginType?: (string|null);

        /** Conversation commentsCount */
        commentsCount?: (number|null);

        /** Conversation locked */
        locked?: (boolean|null);

        /** Conversation systemMessageToInsert */
        systemMessageToInsert?: (proto.PrivacySystemMessage|null);

        /** Conversation capiCreatedGroup */
        capiCreatedGroup?: (boolean|null);

        /** Conversation accountLid */
        accountLid?: (string|null);

        /** Conversation limitSharing */
        limitSharing?: (boolean|null);

        /** Conversation limitSharingSettingTimestamp */
        limitSharingSettingTimestamp?: (number|Long|null);

        /** Conversation limitSharingTrigger */
        limitSharingTrigger?: (proto.LimitSharing.TriggerType|null);

        /** Conversation limitSharingInitiatedByMe */
        limitSharingInitiatedByMe?: (boolean|null);
    }

    /** Represents a Conversation. */
    class Conversation implements IConversation {

        /**
         * Constructs a new Conversation.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IConversation);

        /** Conversation id. */
        public id: string;

        /** Conversation messages. */
        public messages: proto.IHistorySyncMsg[];

        /** Conversation newJid. */
        public newJid?: (string|null);

        /** Conversation oldJid. */
        public oldJid?: (string|null);

        /** Conversation lastMsgTimestamp. */
        public lastMsgTimestamp?: (number|Long|null);

        /** Conversation unreadCount. */
        public unreadCount?: (number|null);

        /** Conversation readOnly. */
        public readOnly?: (boolean|null);

        /** Conversation endOfHistoryTransfer. */
        public endOfHistoryTransfer?: (boolean|null);

        /** Conversation ephemeralExpiration. */
        public ephemeralExpiration?: (number|null);

        /** Conversation ephemeralSettingTimestamp. */
        public ephemeralSettingTimestamp?: (number|Long|null);

        /** Conversation endOfHistoryTransferType. */
        public endOfHistoryTransferType?: (proto.Conversation.EndOfHistoryTransferType|null);

        /** Conversation conversationTimestamp. */
        public conversationTimestamp?: (number|Long|null);

        /** Conversation name. */
        public name?: (string|null);

        /** Conversation pHash. */
        public pHash?: (string|null);

        /** Conversation notSpam. */
        public notSpam?: (boolean|null);

        /** Conversation archived. */
        public archived?: (boolean|null);

        /** Conversation disappearingMode. */
        public disappearingMode?: (proto.IDisappearingMode|null);

        /** Conversation unreadMentionCount. */
        public unreadMentionCount?: (number|null);

        /** Conversation markedAsUnread. */
        public markedAsUnread?: (boolean|null);

        /** Conversation participant. */
        public participant: proto.IGroupParticipant[];

        /** Conversation tcToken. */
        public tcToken?: (Uint8Array|null);

        /** Conversation tcTokenTimestamp. */
        public tcTokenTimestamp?: (number|Long|null);

        /** Conversation contactPrimaryIdentityKey. */
        public contactPrimaryIdentityKey?: (Uint8Array|null);

        /** Conversation pinned. */
        public pinned?: (number|null);

        /** Conversation muteEndTime. */
        public muteEndTime?: (number|Long|null);

        /** Conversation wallpaper. */
        public wallpaper?: (proto.IWallpaperSettings|null);

        /** Conversation mediaVisibility. */
        public mediaVisibility?: (proto.MediaVisibility|null);

        /** Conversation tcTokenSenderTimestamp. */
        public tcTokenSenderTimestamp?: (number|Long|null);

        /** Conversation suspended. */
        public suspended?: (boolean|null);

        /** Conversation terminated. */
        public terminated?: (boolean|null);

        /** Conversation createdAt. */
        public createdAt?: (number|Long|null);

        /** Conversation createdBy. */
        public createdBy?: (string|null);

        /** Conversation description. */
        public description?: (string|null);

        /** Conversation support. */
        public support?: (boolean|null);

        /** Conversation isParentGroup. */
        public isParentGroup?: (boolean|null);

        /** Conversation parentGroupId. */
        public parentGroupId?: (string|null);

        /** Conversation isDefaultSubgroup. */
        public isDefaultSubgroup?: (boolean|null);

        /** Conversation displayName. */
        public displayName?: (string|null);

        /** Conversation pnJid. */
        public pnJid?: (string|null);

        /** Conversation shareOwnPn. */
        public shareOwnPn?: (boolean|null);

        /** Conversation pnhDuplicateLidThread. */
        public pnhDuplicateLidThread?: (boolean|null);

        /** Conversation lidJid. */
        public lidJid?: (string|null);

        /** Conversation username. */
        public username?: (string|null);

        /** Conversation lidOriginType. */
        public lidOriginType?: (string|null);

        /** Conversation commentsCount. */
        public commentsCount?: (number|null);

        /** Conversation locked. */
        public locked?: (boolean|null);

        /** Conversation systemMessageToInsert. */
        public systemMessageToInsert?: (proto.PrivacySystemMessage|null);

        /** Conversation capiCreatedGroup. */
        public capiCreatedGroup?: (boolean|null);

        /** Conversation accountLid. */
        public accountLid?: (string|null);

        /** Conversation limitSharing. */
        public limitSharing?: (boolean|null);

        /** Conversation limitSharingSettingTimestamp. */
        public limitSharingSettingTimestamp?: (number|Long|null);

        /** Conversation limitSharingTrigger. */
        public limitSharingTrigger?: (proto.LimitSharing.TriggerType|null);

        /** Conversation limitSharingInitiatedByMe. */
        public limitSharingInitiatedByMe?: (boolean|null);

        /**
         * Creates a new Conversation instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Conversation instance
         */
        public static create(properties?: proto.IConversation): proto.Conversation;

        /**
         * Encodes the specified Conversation message. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @param message Conversation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IConversation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Conversation message, length delimited. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @param message Conversation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IConversation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Conversation message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Conversation;

        /**
         * Decodes a Conversation message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Conversation;

        /**
         * Verifies a Conversation message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Conversation message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Conversation
         */
        public static fromObject(object: { [k: string]: any }): proto.Conversation;

        /**
         * Creates a plain object from a Conversation message. Also converts values to other types if specified.
         * @param message Conversation
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Conversation, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Conversation to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for Conversation
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace Conversation {

        /** EndOfHistoryTransferType enum. */
        enum EndOfHistoryTransferType {
            COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY = 0,
            COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY = 1,
            COMPLETE_ON_DEMAND_SYNC_BUT_MORE_MSG_REMAIN_ON_PRIMARY = 2
        }
    }

    /** Properties of a DeviceCapabilities. */
    interface IDeviceCapabilities {

        /** DeviceCapabilities chatLockSupportLevel */
        chatLockSupportLevel?: (proto.DeviceCapabilities.ChatLockSupportLevel|null);

        /** DeviceCapabilities lidMigration */
        lidMigration?: (proto.DeviceCapabilities.ILIDMigration|null);
    }

    /** Represents a DeviceCapabilities. */
    class DeviceCapabilities implements IDeviceCapabilities {

        /**
         * Constructs a new DeviceCapabilities.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDeviceCapabilities);

        /** DeviceCapabilities chatLockSupportLevel. */
        public chatLockSupportLevel?: (proto.DeviceCapabilities.ChatLockSupportLevel|null);

        /** DeviceCapabilities lidMigration. */
        public lidMigration?: (proto.DeviceCapabilities.ILIDMigration|null);

        /**
         * Creates a new DeviceCapabilities instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DeviceCapabilities instance
         */
        public static create(properties?: proto.IDeviceCapabilities): proto.DeviceCapabilities;

        /**
         * Encodes the specified DeviceCapabilities message. Does not implicitly {@link proto.DeviceCapabilities.verify|verify} messages.
         * @param message DeviceCapabilities message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDeviceCapabilities, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DeviceCapabilities message, length delimited. Does not implicitly {@link proto.DeviceCapabilities.verify|verify} messages.
         * @param message DeviceCapabilities message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDeviceCapabilities, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DeviceCapabilities message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DeviceCapabilities
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceCapabilities;

        /**
         * Decodes a DeviceCapabilities message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DeviceCapabilities
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceCapabilities;

        /**
         * Verifies a DeviceCapabilities message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DeviceCapabilities message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DeviceCapabilities
         */
        public static fromObject(object: { [k: string]: any }): proto.DeviceCapabilities;

        /**
         * Creates a plain object from a DeviceCapabilities message. Also converts values to other types if specified.
         * @param message DeviceCapabilities
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DeviceCapabilities, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DeviceCapabilities to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for DeviceCapabilities
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace DeviceCapabilities {

        /** ChatLockSupportLevel enum. */
        enum ChatLockSupportLevel {
            NONE = 0,
            MINIMAL = 1,
            FULL = 2
        }

        /** Properties of a LIDMigration. */
        interface ILIDMigration {

            /** LIDMigration chatDbMigrationTimestamp */
            chatDbMigrationTimestamp?: (number|Long|null);
        }

        /** Represents a LIDMigration. */
        class LIDMigration implements ILIDMigration {

            /**
             * Constructs a new LIDMigration.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.DeviceCapabilities.ILIDMigration);

            /** LIDMigration chatDbMigrationTimestamp. */
            public chatDbMigrationTimestamp?: (number|Long|null);

            /**
             * Creates a new LIDMigration instance using the specified properties.
             * @param [properties] Properties to set
             * @returns LIDMigration instance
             */
            public static create(properties?: proto.DeviceCapabilities.ILIDMigration): proto.DeviceCapabilities.LIDMigration;

            /**
             * Encodes the specified LIDMigration message. Does not implicitly {@link proto.DeviceCapabilities.LIDMigration.verify|verify} messages.
             * @param message LIDMigration message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.DeviceCapabilities.ILIDMigration, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified LIDMigration message, length delimited. Does not implicitly {@link proto.DeviceCapabilities.LIDMigration.verify|verify} messages.
             * @param message LIDMigration message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.DeviceCapabilities.ILIDMigration, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a LIDMigration message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns LIDMigration
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceCapabilities.LIDMigration;

            /**
             * Decodes a LIDMigration message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns LIDMigration
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceCapabilities.LIDMigration;

            /**
             * Verifies a LIDMigration message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a LIDMigration message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns LIDMigration
             */
            public static fromObject(object: { [k: string]: any }): proto.DeviceCapabilities.LIDMigration;

            /**
             * Creates a plain object from a LIDMigration message. Also converts values to other types if specified.
             * @param message LIDMigration
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.DeviceCapabilities.LIDMigration, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this LIDMigration to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for LIDMigration
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }
    }

    /** Properties of a DeviceConsistencyCodeMessage. */
    interface IDeviceConsistencyCodeMessage {

        /** DeviceConsistencyCodeMessage generation */
        generation?: (number|null);

        /** DeviceConsistencyCodeMessage signature */
        signature?: (Uint8Array|null);
    }

    /** Represents a DeviceConsistencyCodeMessage. */
    class DeviceConsistencyCodeMessage implements IDeviceConsistencyCodeMessage {

        /**
         * Constructs a new DeviceConsistencyCodeMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDeviceConsistencyCodeMessage);

        /** DeviceConsistencyCodeMessage generation. */
        public generation?: (number|null);

        /** DeviceConsistencyCodeMessage signature. */
        public signature?: (Uint8Array|null);

        /**
         * Creates a new DeviceConsistencyCodeMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DeviceConsistencyCodeMessage instance
         */
        public static create(properties?: proto.IDeviceConsistencyCodeMessage): proto.DeviceConsistencyCodeMessage;

        /**
         * Encodes the specified DeviceConsistencyCodeMessage message. Does not implicitly {@link proto.DeviceConsistencyCodeMessage.verify|verify} messages.
         * @param message DeviceConsistencyCodeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDeviceConsistencyCodeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DeviceConsistencyCodeMessage message, length delimited. Does not implicitly {@link proto.DeviceConsistencyCodeMessage.verify|verify} messages.
         * @param message DeviceConsistencyCodeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDeviceConsistencyCodeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DeviceConsistencyCodeMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DeviceConsistencyCodeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceConsistencyCodeMessage;

        /**
         * Decodes a DeviceConsistencyCodeMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DeviceConsistencyCodeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceConsistencyCodeMessage;

        /**
         * Verifies a DeviceConsistencyCodeMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DeviceConsistencyCodeMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DeviceConsistencyCodeMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.DeviceConsistencyCodeMessage;

        /**
         * Creates a plain object from a DeviceConsistencyCodeMessage message. Also converts values to other types if specified.
         * @param message DeviceConsistencyCodeMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DeviceConsistencyCodeMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DeviceConsistencyCodeMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for DeviceConsistencyCodeMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a DeviceListMetadata. */
    interface IDeviceListMetadata {

        /** DeviceListMetadata senderKeyHash */
        senderKeyHash?: (Uint8Array|null);

        /** DeviceListMetadata senderTimestamp */
        senderTimestamp?: (number|Long|null);

        /** DeviceListMetadata senderKeyIndexes */
        senderKeyIndexes?: (number[]|null);

        /** DeviceListMetadata senderAccountType */
        senderAccountType?: (proto.ADVEncryptionType|null);

        /** DeviceListMetadata receiverAccountType */
        receiverAccountType?: (proto.ADVEncryptionType|null);

        /** DeviceListMetadata recipientKeyHash */
        recipientKeyHash?: (Uint8Array|null);

        /** DeviceListMetadata recipientTimestamp */
        recipientTimestamp?: (number|Long|null);

        /** DeviceListMetadata recipientKeyIndexes */
        recipientKeyIndexes?: (number[]|null);
    }

    /** Represents a DeviceListMetadata. */
    class DeviceListMetadata implements IDeviceListMetadata {

        /**
         * Constructs a new DeviceListMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDeviceListMetadata);

        /** DeviceListMetadata senderKeyHash. */
        public senderKeyHash?: (Uint8Array|null);

        /** DeviceListMetadata senderTimestamp. */
        public senderTimestamp?: (number|Long|null);

        /** DeviceListMetadata senderKeyIndexes. */
        public senderKeyIndexes: number[];

        /** DeviceListMetadata senderAccountType. */
        public senderAccountType?: (proto.ADVEncryptionType|null);

        /** DeviceListMetadata receiverAccountType. */
        public receiverAccountType?: (proto.ADVEncryptionType|null);

        /** DeviceListMetadata recipientKeyHash. */
        public recipientKeyHash?: (Uint8Array|null);

        /** DeviceListMetadata recipientTimestamp. */
        public recipientTimestamp?: (number|Long|null);

        /** DeviceListMetadata recipientKeyIndexes. */
        public recipientKeyIndexes: number[];

        /**
         * Creates a new DeviceListMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DeviceListMetadata instance
         */
        public static create(properties?: proto.IDeviceListMetadata): proto.DeviceListMetadata;

        /**
         * Encodes the specified DeviceListMetadata message. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @param message DeviceListMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDeviceListMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DeviceListMetadata message, length delimited. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @param message DeviceListMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDeviceListMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceListMetadata;

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceListMetadata;

        /**
         * Verifies a DeviceListMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DeviceListMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DeviceListMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.DeviceListMetadata;

        /**
         * Creates a plain object from a DeviceListMetadata message. Also converts values to other types if specified.
         * @param message DeviceListMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DeviceListMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DeviceListMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for DeviceListMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a DeviceProps. */
    interface IDeviceProps {

        /** DeviceProps os */
        os?: (string|null);

        /** DeviceProps version */
        version?: (proto.DeviceProps.IAppVersion|null);

        /** DeviceProps platformType */
        platformType?: (proto.DeviceProps.PlatformType|null);

        /** DeviceProps requireFullSync */
        requireFullSync?: (boolean|null);

        /** DeviceProps historySyncConfig */
        historySyncConfig?: (proto.DeviceProps.IHistorySyncConfig|null);
    }

    /** Represents a DeviceProps. */
    class DeviceProps implements IDeviceProps {

        /**
         * Constructs a new DeviceProps.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDeviceProps);

        /** DeviceProps os. */
        public os?: (string|null);

        /** DeviceProps version. */
        public version?: (proto.DeviceProps.IAppVersion|null);

        /** DeviceProps platformType. */
        public platformType?: (proto.DeviceProps.PlatformType|null);

        /** DeviceProps requireFullSync. */
        public requireFullSync?: (boolean|null);

        /** DeviceProps historySyncConfig. */
        public historySyncConfig?: (proto.DeviceProps.IHistorySyncConfig|null);

        /**
         * Creates a new DeviceProps instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DeviceProps instance
         */
        public static create(properties?: proto.IDeviceProps): proto.DeviceProps;

        /**
         * Encodes the specified DeviceProps message. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @param message DeviceProps message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDeviceProps, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DeviceProps message, length delimited. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @param message DeviceProps message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDeviceProps, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DeviceProps message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceProps;

        /**
         * Decodes a DeviceProps message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceProps;

        /**
         * Verifies a DeviceProps message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DeviceProps message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DeviceProps
         */
        public static fromObject(object: { [k: string]: any }): proto.DeviceProps;

        /**
         * Creates a plain object from a DeviceProps message. Also converts values to other types if specified.
         * @param message DeviceProps
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DeviceProps, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DeviceProps to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for DeviceProps
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace DeviceProps {

        /** Properties of an AppVersion. */
        interface IAppVersion {

            /** AppVersion primary */
            primary?: (number|null);

            /** AppVersion secondary */
            secondary?: (number|null);

            /** AppVersion tertiary */
            tertiary?: (number|null);

            /** AppVersion quaternary */
            quaternary?: (number|null);

            /** AppVersion quinary */
            quinary?: (number|null);
        }

        /** Represents an AppVersion. */
        class AppVersion implements IAppVersion {

            /**
             * Constructs a new AppVersion.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.DeviceProps.IAppVersion);

            /** AppVersion primary. */
            public primary?: (number|null);

            /** AppVersion secondary. */
            public secondary?: (number|null);

            /** AppVersion tertiary. */
            public tertiary?: (number|null);

            /** AppVersion quaternary. */
            public quaternary?: (number|null);

            /** AppVersion quinary. */
            public quinary?: (number|null);

            /**
             * Creates a new AppVersion instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppVersion instance
             */
            public static create(properties?: proto.DeviceProps.IAppVersion): proto.DeviceProps.AppVersion;

            /**
             * Encodes the specified AppVersion message. Does not implicitly {@link proto.DeviceProps.AppVersion.verify|verify} messages.
             * @param message AppVersion message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.DeviceProps.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.DeviceProps.AppVersion.verify|verify} messages.
             * @param message AppVersion message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.DeviceProps.IAppVersion, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppVersion message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppVersion
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceProps.AppVersion;

            /**
             * Decodes an AppVersion message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppVersion
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceProps.AppVersion;

            /**
             * Verifies an AppVersion message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppVersion
             */
            public static fromObject(object: { [k: string]: any }): proto.DeviceProps.AppVersion;

            /**
             * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
             * @param message AppVersion
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.DeviceProps.AppVersion, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppVersion to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppVersion
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a HistorySyncConfig. */
        interface IHistorySyncConfig {

            /** HistorySyncConfig fullSyncDaysLimit */
            fullSyncDaysLimit?: (number|null);

            /** HistorySyncConfig fullSyncSizeMbLimit */
            fullSyncSizeMbLimit?: (number|null);

            /** HistorySyncConfig storageQuotaMb */
            storageQuotaMb?: (number|null);

            /** HistorySyncConfig inlineInitialPayloadInE2EeMsg */
            inlineInitialPayloadInE2EeMsg?: (boolean|null);

            /** HistorySyncConfig recentSyncDaysLimit */
            recentSyncDaysLimit?: (number|null);

            /** HistorySyncConfig supportCallLogHistory */
            supportCallLogHistory?: (boolean|null);

            /** HistorySyncConfig supportBotUserAgentChatHistory */
            supportBotUserAgentChatHistory?: (boolean|null);

            /** HistorySyncConfig supportCagReactionsAndPolls */
            supportCagReactionsAndPolls?: (boolean|null);

            /** HistorySyncConfig supportBizHostedMsg */
            supportBizHostedMsg?: (boolean|null);

            /** HistorySyncConfig supportRecentSyncChunkMessageCountTuning */
            supportRecentSyncChunkMessageCountTuning?: (boolean|null);

            /** HistorySyncConfig supportHostedGroupMsg */
            supportHostedGroupMsg?: (boolean|null);

            /** HistorySyncConfig supportFbidBotChatHistory */
            supportFbidBotChatHistory?: (boolean|null);

            /** HistorySyncConfig supportAddOnHistorySyncMigration */
            supportAddOnHistorySyncMigration?: (boolean|null);

            /** HistorySyncConfig supportMessageAssociation */
            supportMessageAssociation?: (boolean|null);
        }

        /** Represents a HistorySyncConfig. */
        class HistorySyncConfig implements IHistorySyncConfig {

            /**
             * Constructs a new HistorySyncConfig.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.DeviceProps.IHistorySyncConfig);

            /** HistorySyncConfig fullSyncDaysLimit. */
            public fullSyncDaysLimit?: (number|null);

            /** HistorySyncConfig fullSyncSizeMbLimit. */
            public fullSyncSizeMbLimit?: (number|null);

            /** HistorySyncConfig storageQuotaMb. */
            public storageQuotaMb?: (number|null);

            /** HistorySyncConfig inlineInitialPayloadInE2EeMsg. */
            public inlineInitialPayloadInE2EeMsg?: (boolean|null);

            /** HistorySyncConfig recentSyncDaysLimit. */
            public recentSyncDaysLimit?: (number|null);

            /** HistorySyncConfig supportCallLogHistory. */
            public supportCallLogHistory?: (boolean|null);

            /** HistorySyncConfig supportBotUserAgentChatHistory. */
            public supportBotUserAgentChatHistory?: (boolean|null);

            /** HistorySyncConfig supportCagReactionsAndPolls. */
            public supportCagReactionsAndPolls?: (boolean|null);

            /** HistorySyncConfig supportBizHostedMsg. */
            public supportBizHostedMsg?: (boolean|null);

            /** HistorySyncConfig supportRecentSyncChunkMessageCountTuning. */
            public supportRecentSyncChunkMessageCountTuning?: (boolean|null);

            /** HistorySyncConfig supportHostedGroupMsg. */
            public supportHostedGroupMsg?: (boolean|null);

            /** HistorySyncConfig supportFbidBotChatHistory. */
            public supportFbidBotChatHistory?: (boolean|null);

            /** HistorySyncConfig supportAddOnHistorySyncMigration. */
            public supportAddOnHistorySyncMigration?: (boolean|null);

            /** HistorySyncConfig supportMessageAssociation. */
            public supportMessageAssociation?: (boolean|null);

            /**
             * Creates a new HistorySyncConfig instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HistorySyncConfig instance
             */
            public static create(properties?: proto.DeviceProps.IHistorySyncConfig): proto.DeviceProps.HistorySyncConfig;

            /**
             * Encodes the specified HistorySyncConfig message. Does not implicitly {@link proto.DeviceProps.HistorySyncConfig.verify|verify} messages.
             * @param message HistorySyncConfig message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.DeviceProps.IHistorySyncConfig, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HistorySyncConfig message, length delimited. Does not implicitly {@link proto.DeviceProps.HistorySyncConfig.verify|verify} messages.
             * @param message HistorySyncConfig message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.DeviceProps.IHistorySyncConfig, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HistorySyncConfig message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HistorySyncConfig
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DeviceProps.HistorySyncConfig;

            /**
             * Decodes a HistorySyncConfig message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HistorySyncConfig
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DeviceProps.HistorySyncConfig;

            /**
             * Verifies a HistorySyncConfig message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HistorySyncConfig message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HistorySyncConfig
             */
            public static fromObject(object: { [k: string]: any }): proto.DeviceProps.HistorySyncConfig;

            /**
             * Creates a plain object from a HistorySyncConfig message. Also converts values to other types if specified.
             * @param message HistorySyncConfig
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.DeviceProps.HistorySyncConfig, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HistorySyncConfig to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for HistorySyncConfig
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** PlatformType enum. */
        enum PlatformType {
            UNKNOWN = 0,
            CHROME = 1,
            FIREFOX = 2,
            IE = 3,
            OPERA = 4,
            SAFARI = 5,
            EDGE = 6,
            DESKTOP = 7,
            IPAD = 8,
            ANDROID_TABLET = 9,
            OHANA = 10,
            ALOHA = 11,
            CATALINA = 12,
            TCL_TV = 13,
            IOS_PHONE = 14,
            IOS_CATALYST = 15,
            ANDROID_PHONE = 16,
            ANDROID_AMBIGUOUS = 17,
            WEAR_OS = 18,
            AR_WRIST = 19,
            AR_DEVICE = 20,
            UWP = 21,
            VR = 22,
            CLOUD_API = 23,
            SMARTGLASSES = 24
        }
    }

    /** Properties of a DisappearingMode. */
    interface IDisappearingMode {

        /** DisappearingMode initiator */
        initiator?: (proto.DisappearingMode.Initiator|null);

        /** DisappearingMode trigger */
        trigger?: (proto.DisappearingMode.Trigger|null);

        /** DisappearingMode initiatorDeviceJid */
        initiatorDeviceJid?: (string|null);

        /** DisappearingMode initiatedByMe */
        initiatedByMe?: (boolean|null);
    }

    /** Represents a DisappearingMode. */
    class DisappearingMode implements IDisappearingMode {

        /**
         * Constructs a new DisappearingMode.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IDisappearingMode);

        /** DisappearingMode initiator. */
        public initiator?: (proto.DisappearingMode.Initiator|null);

        /** DisappearingMode trigger. */
        public trigger?: (proto.DisappearingMode.Trigger|null);

        /** DisappearingMode initiatorDeviceJid. */
        public initiatorDeviceJid?: (string|null);

        /** DisappearingMode initiatedByMe. */
        public initiatedByMe?: (boolean|null);

        /**
         * Creates a new DisappearingMode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns DisappearingMode instance
         */
        public static create(properties?: proto.IDisappearingMode): proto.DisappearingMode;

        /**
         * Encodes the specified DisappearingMode message. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @param message DisappearingMode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IDisappearingMode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified DisappearingMode message, length delimited. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @param message DisappearingMode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IDisappearingMode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.DisappearingMode;

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.DisappearingMode;

        /**
         * Verifies a DisappearingMode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a DisappearingMode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns DisappearingMode
         */
        public static fromObject(object: { [k: string]: any }): proto.DisappearingMode;

        /**
         * Creates a plain object from a DisappearingMode message. Also converts values to other types if specified.
         * @param message DisappearingMode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.DisappearingMode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this DisappearingMode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for DisappearingMode
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace DisappearingMode {

        /** Initiator enum. */
        enum Initiator {
            CHANGED_IN_CHAT = 0,
            INITIATED_BY_ME = 1,
            INITIATED_BY_OTHER = 2,
            BIZ_UPGRADE_FB_HOSTING = 3
        }

        /** Trigger enum. */
        enum Trigger {
            UNKNOWN = 0,
            CHAT_SETTING = 1,
            ACCOUNT_SETTING = 2,
            BULK_CHANGE = 3,
            BIZ_SUPPORTS_FB_HOSTING = 4,
            UNKNOWN_GROUPS = 5
        }
    }

    /** Properties of an EmbeddedContent. */
    interface IEmbeddedContent {

        /** EmbeddedContent embeddedMessage */
        embeddedMessage?: (proto.IEmbeddedMessage|null);

        /** EmbeddedContent embeddedMusic */
        embeddedMusic?: (proto.IEmbeddedMusic|null);
    }

    /** Represents an EmbeddedContent. */
    class EmbeddedContent implements IEmbeddedContent {

        /**
         * Constructs a new EmbeddedContent.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEmbeddedContent);

        /** EmbeddedContent embeddedMessage. */
        public embeddedMessage?: (proto.IEmbeddedMessage|null);

        /** EmbeddedContent embeddedMusic. */
        public embeddedMusic?: (proto.IEmbeddedMusic|null);

        /** EmbeddedContent content. */
        public content?: ("embeddedMessage"|"embeddedMusic");

        /**
         * Creates a new EmbeddedContent instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EmbeddedContent instance
         */
        public static create(properties?: proto.IEmbeddedContent): proto.EmbeddedContent;

        /**
         * Encodes the specified EmbeddedContent message. Does not implicitly {@link proto.EmbeddedContent.verify|verify} messages.
         * @param message EmbeddedContent message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEmbeddedContent, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EmbeddedContent message, length delimited. Does not implicitly {@link proto.EmbeddedContent.verify|verify} messages.
         * @param message EmbeddedContent message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEmbeddedContent, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EmbeddedContent message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EmbeddedContent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EmbeddedContent;

        /**
         * Decodes an EmbeddedContent message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EmbeddedContent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EmbeddedContent;

        /**
         * Verifies an EmbeddedContent message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EmbeddedContent message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EmbeddedContent
         */
        public static fromObject(object: { [k: string]: any }): proto.EmbeddedContent;

        /**
         * Creates a plain object from an EmbeddedContent message. Also converts values to other types if specified.
         * @param message EmbeddedContent
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EmbeddedContent, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EmbeddedContent to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for EmbeddedContent
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an EmbeddedMessage. */
    interface IEmbeddedMessage {

        /** EmbeddedMessage stanzaId */
        stanzaId?: (string|null);

        /** EmbeddedMessage message */
        message?: (proto.IMessage|null);
    }

    /** Represents an EmbeddedMessage. */
    class EmbeddedMessage implements IEmbeddedMessage {

        /**
         * Constructs a new EmbeddedMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEmbeddedMessage);

        /** EmbeddedMessage stanzaId. */
        public stanzaId?: (string|null);

        /** EmbeddedMessage message. */
        public message?: (proto.IMessage|null);

        /**
         * Creates a new EmbeddedMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EmbeddedMessage instance
         */
        public static create(properties?: proto.IEmbeddedMessage): proto.EmbeddedMessage;

        /**
         * Encodes the specified EmbeddedMessage message. Does not implicitly {@link proto.EmbeddedMessage.verify|verify} messages.
         * @param message EmbeddedMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEmbeddedMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EmbeddedMessage message, length delimited. Does not implicitly {@link proto.EmbeddedMessage.verify|verify} messages.
         * @param message EmbeddedMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEmbeddedMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EmbeddedMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EmbeddedMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EmbeddedMessage;

        /**
         * Decodes an EmbeddedMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EmbeddedMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EmbeddedMessage;

        /**
         * Verifies an EmbeddedMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EmbeddedMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EmbeddedMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.EmbeddedMessage;

        /**
         * Creates a plain object from an EmbeddedMessage message. Also converts values to other types if specified.
         * @param message EmbeddedMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EmbeddedMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EmbeddedMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for EmbeddedMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an EmbeddedMusic. */
    interface IEmbeddedMusic {

        /** EmbeddedMusic musicContentMediaId */
        musicContentMediaId?: (string|null);

        /** EmbeddedMusic songId */
        songId?: (string|null);

        /** EmbeddedMusic author */
        author?: (string|null);

        /** EmbeddedMusic title */
        title?: (string|null);

        /** EmbeddedMusic artworkDirectPath */
        artworkDirectPath?: (string|null);

        /** EmbeddedMusic artworkSha256 */
        artworkSha256?: (Uint8Array|null);

        /** EmbeddedMusic artworkEncSha256 */
        artworkEncSha256?: (Uint8Array|null);

        /** EmbeddedMusic artworkMediaKey */
        artworkMediaKey?: (Uint8Array|null);

        /** EmbeddedMusic artistAttribution */
        artistAttribution?: (string|null);

        /** EmbeddedMusic countryBlocklist */
        countryBlocklist?: (Uint8Array|null);

        /** EmbeddedMusic isExplicit */
        isExplicit?: (boolean|null);
    }

    /** Represents an EmbeddedMusic. */
    class EmbeddedMusic implements IEmbeddedMusic {

        /**
         * Constructs a new EmbeddedMusic.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEmbeddedMusic);

        /** EmbeddedMusic musicContentMediaId. */
        public musicContentMediaId?: (string|null);

        /** EmbeddedMusic songId. */
        public songId?: (string|null);

        /** EmbeddedMusic author. */
        public author?: (string|null);

        /** EmbeddedMusic title. */
        public title?: (string|null);

        /** EmbeddedMusic artworkDirectPath. */
        public artworkDirectPath?: (string|null);

        /** EmbeddedMusic artworkSha256. */
        public artworkSha256?: (Uint8Array|null);

        /** EmbeddedMusic artworkEncSha256. */
        public artworkEncSha256?: (Uint8Array|null);

        /** EmbeddedMusic artworkMediaKey. */
        public artworkMediaKey?: (Uint8Array|null);

        /** EmbeddedMusic artistAttribution. */
        public artistAttribution?: (string|null);

        /** EmbeddedMusic countryBlocklist. */
        public countryBlocklist?: (Uint8Array|null);

        /** EmbeddedMusic isExplicit. */
        public isExplicit?: (boolean|null);

        /**
         * Creates a new EmbeddedMusic instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EmbeddedMusic instance
         */
        public static create(properties?: proto.IEmbeddedMusic): proto.EmbeddedMusic;

        /**
         * Encodes the specified EmbeddedMusic message. Does not implicitly {@link proto.EmbeddedMusic.verify|verify} messages.
         * @param message EmbeddedMusic message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEmbeddedMusic, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EmbeddedMusic message, length delimited. Does not implicitly {@link proto.EmbeddedMusic.verify|verify} messages.
         * @param message EmbeddedMusic message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEmbeddedMusic, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EmbeddedMusic message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EmbeddedMusic
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EmbeddedMusic;

        /**
         * Decodes an EmbeddedMusic message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EmbeddedMusic
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EmbeddedMusic;

        /**
         * Verifies an EmbeddedMusic message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EmbeddedMusic message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EmbeddedMusic
         */
        public static fromObject(object: { [k: string]: any }): proto.EmbeddedMusic;

        /**
         * Creates a plain object from an EmbeddedMusic message. Also converts values to other types if specified.
         * @param message EmbeddedMusic
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EmbeddedMusic, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EmbeddedMusic to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for EmbeddedMusic
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an EncryptedPairingRequest. */
    interface IEncryptedPairingRequest {

        /** EncryptedPairingRequest encryptedPayload */
        encryptedPayload?: (Uint8Array|null);

        /** EncryptedPairingRequest iv */
        iv?: (Uint8Array|null);
    }

    /** Represents an EncryptedPairingRequest. */
    class EncryptedPairingRequest implements IEncryptedPairingRequest {

        /**
         * Constructs a new EncryptedPairingRequest.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEncryptedPairingRequest);

        /** EncryptedPairingRequest encryptedPayload. */
        public encryptedPayload?: (Uint8Array|null);

        /** EncryptedPairingRequest iv. */
        public iv?: (Uint8Array|null);

        /**
         * Creates a new EncryptedPairingRequest instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EncryptedPairingRequest instance
         */
        public static create(properties?: proto.IEncryptedPairingRequest): proto.EncryptedPairingRequest;

        /**
         * Encodes the specified EncryptedPairingRequest message. Does not implicitly {@link proto.EncryptedPairingRequest.verify|verify} messages.
         * @param message EncryptedPairingRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEncryptedPairingRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EncryptedPairingRequest message, length delimited. Does not implicitly {@link proto.EncryptedPairingRequest.verify|verify} messages.
         * @param message EncryptedPairingRequest message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEncryptedPairingRequest, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EncryptedPairingRequest message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EncryptedPairingRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EncryptedPairingRequest;

        /**
         * Decodes an EncryptedPairingRequest message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EncryptedPairingRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EncryptedPairingRequest;

        /**
         * Verifies an EncryptedPairingRequest message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EncryptedPairingRequest message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EncryptedPairingRequest
         */
        public static fromObject(object: { [k: string]: any }): proto.EncryptedPairingRequest;

        /**
         * Creates a plain object from an EncryptedPairingRequest message. Also converts values to other types if specified.
         * @param message EncryptedPairingRequest
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EncryptedPairingRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EncryptedPairingRequest to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for EncryptedPairingRequest
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an EphemeralSetting. */
    interface IEphemeralSetting {

        /** EphemeralSetting duration */
        duration?: (number|null);

        /** EphemeralSetting timestamp */
        timestamp?: (number|Long|null);
    }

    /** Represents an EphemeralSetting. */
    class EphemeralSetting implements IEphemeralSetting {

        /**
         * Constructs a new EphemeralSetting.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEphemeralSetting);

        /** EphemeralSetting duration. */
        public duration?: (number|null);

        /** EphemeralSetting timestamp. */
        public timestamp?: (number|Long|null);

        /**
         * Creates a new EphemeralSetting instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EphemeralSetting instance
         */
        public static create(properties?: proto.IEphemeralSetting): proto.EphemeralSetting;

        /**
         * Encodes the specified EphemeralSetting message. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @param message EphemeralSetting message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEphemeralSetting, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EphemeralSetting message, length delimited. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @param message EphemeralSetting message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEphemeralSetting, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EphemeralSetting;

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EphemeralSetting;

        /**
         * Verifies an EphemeralSetting message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EphemeralSetting message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EphemeralSetting
         */
        public static fromObject(object: { [k: string]: any }): proto.EphemeralSetting;

        /**
         * Creates a plain object from an EphemeralSetting message. Also converts values to other types if specified.
         * @param message EphemeralSetting
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EphemeralSetting, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EphemeralSetting to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for EphemeralSetting
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an EventAdditionalMetadata. */
    interface IEventAdditionalMetadata {

        /** EventAdditionalMetadata isStale */
        isStale?: (boolean|null);
    }

    /** Represents an EventAdditionalMetadata. */
    class EventAdditionalMetadata implements IEventAdditionalMetadata {

        /**
         * Constructs a new EventAdditionalMetadata.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEventAdditionalMetadata);

        /** EventAdditionalMetadata isStale. */
        public isStale?: (boolean|null);

        /**
         * Creates a new EventAdditionalMetadata instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EventAdditionalMetadata instance
         */
        public static create(properties?: proto.IEventAdditionalMetadata): proto.EventAdditionalMetadata;

        /**
         * Encodes the specified EventAdditionalMetadata message. Does not implicitly {@link proto.EventAdditionalMetadata.verify|verify} messages.
         * @param message EventAdditionalMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEventAdditionalMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EventAdditionalMetadata message, length delimited. Does not implicitly {@link proto.EventAdditionalMetadata.verify|verify} messages.
         * @param message EventAdditionalMetadata message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEventAdditionalMetadata, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EventAdditionalMetadata message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EventAdditionalMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EventAdditionalMetadata;

        /**
         * Decodes an EventAdditionalMetadata message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EventAdditionalMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EventAdditionalMetadata;

        /**
         * Verifies an EventAdditionalMetadata message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EventAdditionalMetadata message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EventAdditionalMetadata
         */
        public static fromObject(object: { [k: string]: any }): proto.EventAdditionalMetadata;

        /**
         * Creates a plain object from an EventAdditionalMetadata message. Also converts values to other types if specified.
         * @param message EventAdditionalMetadata
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EventAdditionalMetadata, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EventAdditionalMetadata to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for EventAdditionalMetadata
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an EventResponse. */
    interface IEventResponse {

        /** EventResponse eventResponseMessageKey */
        eventResponseMessageKey?: (proto.IMessageKey|null);

        /** EventResponse timestampMs */
        timestampMs?: (number|Long|null);

        /** EventResponse eventResponseMessage */
        eventResponseMessage?: (proto.Message.IEventResponseMessage|null);

        /** EventResponse unread */
        unread?: (boolean|null);
    }

    /** Represents an EventResponse. */
    class EventResponse implements IEventResponse {

        /**
         * Constructs a new EventResponse.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IEventResponse);

        /** EventResponse eventResponseMessageKey. */
        public eventResponseMessageKey?: (proto.IMessageKey|null);

        /** EventResponse timestampMs. */
        public timestampMs?: (number|Long|null);

        /** EventResponse eventResponseMessage. */
        public eventResponseMessage?: (proto.Message.IEventResponseMessage|null);

        /** EventResponse unread. */
        public unread?: (boolean|null);

        /**
         * Creates a new EventResponse instance using the specified properties.
         * @param [properties] Properties to set
         * @returns EventResponse instance
         */
        public static create(properties?: proto.IEventResponse): proto.EventResponse;

        /**
         * Encodes the specified EventResponse message. Does not implicitly {@link proto.EventResponse.verify|verify} messages.
         * @param message EventResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IEventResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified EventResponse message, length delimited. Does not implicitly {@link proto.EventResponse.verify|verify} messages.
         * @param message EventResponse message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IEventResponse, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an EventResponse message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns EventResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.EventResponse;

        /**
         * Decodes an EventResponse message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns EventResponse
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.EventResponse;

        /**
         * Verifies an EventResponse message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an EventResponse message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns EventResponse
         */
        public static fromObject(object: { [k: string]: any }): proto.EventResponse;

        /**
         * Creates a plain object from an EventResponse message. Also converts values to other types if specified.
         * @param message EventResponse
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.EventResponse, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this EventResponse to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for EventResponse
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an ExitCode. */
    interface IExitCode {

        /** ExitCode code */
        code?: (number|Long|null);

        /** ExitCode text */
        text?: (string|null);
    }

    /** Represents an ExitCode. */
    class ExitCode implements IExitCode {

        /**
         * Constructs a new ExitCode.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IExitCode);

        /** ExitCode code. */
        public code?: (number|Long|null);

        /** ExitCode text. */
        public text?: (string|null);

        /**
         * Creates a new ExitCode instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ExitCode instance
         */
        public static create(properties?: proto.IExitCode): proto.ExitCode;

        /**
         * Encodes the specified ExitCode message. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @param message ExitCode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IExitCode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ExitCode message, length delimited. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @param message ExitCode message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IExitCode, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an ExitCode message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ExitCode;

        /**
         * Decodes an ExitCode message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ExitCode;

        /**
         * Verifies an ExitCode message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an ExitCode message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ExitCode
         */
        public static fromObject(object: { [k: string]: any }): proto.ExitCode;

        /**
         * Creates a plain object from an ExitCode message. Also converts values to other types if specified.
         * @param message ExitCode
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ExitCode, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ExitCode to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ExitCode
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an ExternalBlobReference. */
    interface IExternalBlobReference {

        /** ExternalBlobReference mediaKey */
        mediaKey?: (Uint8Array|null);

        /** ExternalBlobReference directPath */
        directPath?: (string|null);

        /** ExternalBlobReference handle */
        handle?: (string|null);

        /** ExternalBlobReference fileSizeBytes */
        fileSizeBytes?: (number|Long|null);

        /** ExternalBlobReference fileSha256 */
        fileSha256?: (Uint8Array|null);

        /** ExternalBlobReference fileEncSha256 */
        fileEncSha256?: (Uint8Array|null);
    }

    /** Represents an ExternalBlobReference. */
    class ExternalBlobReference implements IExternalBlobReference {

        /**
         * Constructs a new ExternalBlobReference.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IExternalBlobReference);

        /** ExternalBlobReference mediaKey. */
        public mediaKey?: (Uint8Array|null);

        /** ExternalBlobReference directPath. */
        public directPath?: (string|null);

        /** ExternalBlobReference handle. */
        public handle?: (string|null);

        /** ExternalBlobReference fileSizeBytes. */
        public fileSizeBytes?: (number|Long|null);

        /** ExternalBlobReference fileSha256. */
        public fileSha256?: (Uint8Array|null);

        /** ExternalBlobReference fileEncSha256. */
        public fileEncSha256?: (Uint8Array|null);

        /**
         * Creates a new ExternalBlobReference instance using the specified properties.
         * @param [properties] Properties to set
         * @returns ExternalBlobReference instance
         */
        public static create(properties?: proto.IExternalBlobReference): proto.ExternalBlobReference;

        /**
         * Encodes the specified ExternalBlobReference message. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @param message ExternalBlobReference message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IExternalBlobReference, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified ExternalBlobReference message, length delimited. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @param message ExternalBlobReference message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IExternalBlobReference, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.ExternalBlobReference;

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.ExternalBlobReference;

        /**
         * Verifies an ExternalBlobReference message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an ExternalBlobReference message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns ExternalBlobReference
         */
        public static fromObject(object: { [k: string]: any }): proto.ExternalBlobReference;

        /**
         * Creates a plain object from an ExternalBlobReference message. Also converts values to other types if specified.
         * @param message ExternalBlobReference
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.ExternalBlobReference, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this ExternalBlobReference to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for ExternalBlobReference
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a Field. */
    interface IField {

        /** Field minVersion */
        minVersion?: (number|null);

        /** Field maxVersion */
        maxVersion?: (number|null);

        /** Field notReportableMinVersion */
        notReportableMinVersion?: (number|null);

        /** Field isMessage */
        isMessage?: (boolean|null);

        /** Field subfield */
        subfield?: ({ [k: string]: proto.IField }|null);
    }

    /** Represents a Field. */
    class Field implements IField {

        /**
         * Constructs a new Field.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IField);

        /** Field minVersion. */
        public minVersion?: (number|null);

        /** Field maxVersion. */
        public maxVersion?: (number|null);

        /** Field notReportableMinVersion. */
        public notReportableMinVersion?: (number|null);

        /** Field isMessage. */
        public isMessage?: (boolean|null);

        /** Field subfield. */
        public subfield: { [k: string]: proto.IField };

        /**
         * Creates a new Field instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Field instance
         */
        public static create(properties?: proto.IField): proto.Field;

        /**
         * Encodes the specified Field message. Does not implicitly {@link proto.Field.verify|verify} messages.
         * @param message Field message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IField, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Field message, length delimited. Does not implicitly {@link proto.Field.verify|verify} messages.
         * @param message Field message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IField, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Field message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Field
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Field;

        /**
         * Decodes a Field message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Field
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Field;

        /**
         * Verifies a Field message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Field message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Field
         */
        public static fromObject(object: { [k: string]: any }): proto.Field;

        /**
         * Creates a plain object from a Field message. Also converts values to other types if specified.
         * @param message Field
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Field, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Field to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for Field
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a GlobalSettings. */
    interface IGlobalSettings {

        /** GlobalSettings lightThemeWallpaper */
        lightThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings mediaVisibility */
        mediaVisibility?: (proto.MediaVisibility|null);

        /** GlobalSettings darkThemeWallpaper */
        darkThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings autoDownloadWiFi */
        autoDownloadWiFi?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadCellular */
        autoDownloadCellular?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadRoaming */
        autoDownloadRoaming?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings showIndividualNotificationsPreview */
        showIndividualNotificationsPreview?: (boolean|null);

        /** GlobalSettings showGroupNotificationsPreview */
        showGroupNotificationsPreview?: (boolean|null);

        /** GlobalSettings disappearingModeDuration */
        disappearingModeDuration?: (number|null);

        /** GlobalSettings disappearingModeTimestamp */
        disappearingModeTimestamp?: (number|Long|null);

        /** GlobalSettings avatarUserSettings */
        avatarUserSettings?: (proto.IAvatarUserSettings|null);

        /** GlobalSettings fontSize */
        fontSize?: (number|null);

        /** GlobalSettings securityNotifications */
        securityNotifications?: (boolean|null);

        /** GlobalSettings autoUnarchiveChats */
        autoUnarchiveChats?: (boolean|null);

        /** GlobalSettings videoQualityMode */
        videoQualityMode?: (number|null);

        /** GlobalSettings photoQualityMode */
        photoQualityMode?: (number|null);

        /** GlobalSettings individualNotificationSettings */
        individualNotificationSettings?: (proto.INotificationSettings|null);

        /** GlobalSettings groupNotificationSettings */
        groupNotificationSettings?: (proto.INotificationSettings|null);

        /** GlobalSettings chatLockSettings */
        chatLockSettings?: (proto.IChatLockSettings|null);

        /** GlobalSettings chatDbLidMigrationTimestamp */
        chatDbLidMigrationTimestamp?: (number|Long|null);
    }

    /** Represents a GlobalSettings. */
    class GlobalSettings implements IGlobalSettings {

        /**
         * Constructs a new GlobalSettings.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IGlobalSettings);

        /** GlobalSettings lightThemeWallpaper. */
        public lightThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings mediaVisibility. */
        public mediaVisibility?: (proto.MediaVisibility|null);

        /** GlobalSettings darkThemeWallpaper. */
        public darkThemeWallpaper?: (proto.IWallpaperSettings|null);

        /** GlobalSettings autoDownloadWiFi. */
        public autoDownloadWiFi?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadCellular. */
        public autoDownloadCellular?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings autoDownloadRoaming. */
        public autoDownloadRoaming?: (proto.IAutoDownloadSettings|null);

        /** GlobalSettings showIndividualNotificationsPreview. */
        public showIndividualNotificationsPreview?: (boolean|null);

        /** GlobalSettings showGroupNotificationsPreview. */
        public showGroupNotificationsPreview?: (boolean|null);

        /** GlobalSettings disappearingModeDuration. */
        public disappearingModeDuration?: (number|null);

        /** GlobalSettings disappearingModeTimestamp. */
        public disappearingModeTimestamp?: (number|Long|null);

        /** GlobalSettings avatarUserSettings. */
        public avatarUserSettings?: (proto.IAvatarUserSettings|null);

        /** GlobalSettings fontSize. */
        public fontSize?: (number|null);

        /** GlobalSettings securityNotifications. */
        public securityNotifications?: (boolean|null);

        /** GlobalSettings autoUnarchiveChats. */
        public autoUnarchiveChats?: (boolean|null);

        /** GlobalSettings videoQualityMode. */
        public videoQualityMode?: (number|null);

        /** GlobalSettings photoQualityMode. */
        public photoQualityMode?: (number|null);

        /** GlobalSettings individualNotificationSettings. */
        public individualNotificationSettings?: (proto.INotificationSettings|null);

        /** GlobalSettings groupNotificationSettings. */
        public groupNotificationSettings?: (proto.INotificationSettings|null);

        /** GlobalSettings chatLockSettings. */
        public chatLockSettings?: (proto.IChatLockSettings|null);

        /** GlobalSettings chatDbLidMigrationTimestamp. */
        public chatDbLidMigrationTimestamp?: (number|Long|null);

        /**
         * Creates a new GlobalSettings instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GlobalSettings instance
         */
        public static create(properties?: proto.IGlobalSettings): proto.GlobalSettings;

        /**
         * Encodes the specified GlobalSettings message. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @param message GlobalSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IGlobalSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GlobalSettings message, length delimited. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @param message GlobalSettings message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IGlobalSettings, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.GlobalSettings;

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.GlobalSettings;

        /**
         * Verifies a GlobalSettings message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GlobalSettings message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GlobalSettings
         */
        public static fromObject(object: { [k: string]: any }): proto.GlobalSettings;

        /**
         * Creates a plain object from a GlobalSettings message. Also converts values to other types if specified.
         * @param message GlobalSettings
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.GlobalSettings, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GlobalSettings to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for GlobalSettings
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a GroupMention. */
    interface IGroupMention {

        /** GroupMention groupJid */
        groupJid?: (string|null);

        /** GroupMention groupSubject */
        groupSubject?: (string|null);
    }

    /** Represents a GroupMention. */
    class GroupMention implements IGroupMention {

        /**
         * Constructs a new GroupMention.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IGroupMention);

        /** GroupMention groupJid. */
        public groupJid?: (string|null);

        /** GroupMention groupSubject. */
        public groupSubject?: (string|null);

        /**
         * Creates a new GroupMention instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GroupMention instance
         */
        public static create(properties?: proto.IGroupMention): proto.GroupMention;

        /**
         * Encodes the specified GroupMention message. Does not implicitly {@link proto.GroupMention.verify|verify} messages.
         * @param message GroupMention message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IGroupMention, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GroupMention message, length delimited. Does not implicitly {@link proto.GroupMention.verify|verify} messages.
         * @param message GroupMention message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IGroupMention, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GroupMention message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GroupMention
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.GroupMention;

        /**
         * Decodes a GroupMention message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GroupMention
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.GroupMention;

        /**
         * Verifies a GroupMention message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GroupMention message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GroupMention
         */
        public static fromObject(object: { [k: string]: any }): proto.GroupMention;

        /**
         * Creates a plain object from a GroupMention message. Also converts values to other types if specified.
         * @param message GroupMention
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.GroupMention, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GroupMention to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for GroupMention
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a GroupParticipant. */
    interface IGroupParticipant {

        /** GroupParticipant userJid */
        userJid: string;

        /** GroupParticipant rank */
        rank?: (proto.GroupParticipant.Rank|null);
    }

    /** Represents a GroupParticipant. */
    class GroupParticipant implements IGroupParticipant {

        /**
         * Constructs a new GroupParticipant.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IGroupParticipant);

        /** GroupParticipant userJid. */
        public userJid: string;

        /** GroupParticipant rank. */
        public rank?: (proto.GroupParticipant.Rank|null);

        /**
         * Creates a new GroupParticipant instance using the specified properties.
         * @param [properties] Properties to set
         * @returns GroupParticipant instance
         */
        public static create(properties?: proto.IGroupParticipant): proto.GroupParticipant;

        /**
         * Encodes the specified GroupParticipant message. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @param message GroupParticipant message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IGroupParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified GroupParticipant message, length delimited. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @param message GroupParticipant message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IGroupParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.GroupParticipant;

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.GroupParticipant;

        /**
         * Verifies a GroupParticipant message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a GroupParticipant message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns GroupParticipant
         */
        public static fromObject(object: { [k: string]: any }): proto.GroupParticipant;

        /**
         * Creates a plain object from a GroupParticipant message. Also converts values to other types if specified.
         * @param message GroupParticipant
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.GroupParticipant, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this GroupParticipant to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for GroupParticipant
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace GroupParticipant {

        /** Rank enum. */
        enum Rank {
            REGULAR = 0,
            ADMIN = 1,
            SUPERADMIN = 2
        }
    }

    /** Properties of a HandshakeMessage. */
    interface IHandshakeMessage {

        /** HandshakeMessage clientHello */
        clientHello?: (proto.HandshakeMessage.IClientHello|null);

        /** HandshakeMessage serverHello */
        serverHello?: (proto.HandshakeMessage.IServerHello|null);

        /** HandshakeMessage clientFinish */
        clientFinish?: (proto.HandshakeMessage.IClientFinish|null);
    }

    /** Represents a HandshakeMessage. */
    class HandshakeMessage implements IHandshakeMessage {

        /**
         * Constructs a new HandshakeMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHandshakeMessage);

        /** HandshakeMessage clientHello. */
        public clientHello?: (proto.HandshakeMessage.IClientHello|null);

        /** HandshakeMessage serverHello. */
        public serverHello?: (proto.HandshakeMessage.IServerHello|null);

        /** HandshakeMessage clientFinish. */
        public clientFinish?: (proto.HandshakeMessage.IClientFinish|null);

        /**
         * Creates a new HandshakeMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HandshakeMessage instance
         */
        public static create(properties?: proto.IHandshakeMessage): proto.HandshakeMessage;

        /**
         * Encodes the specified HandshakeMessage message. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @param message HandshakeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHandshakeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HandshakeMessage message, length delimited. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @param message HandshakeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHandshakeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage;

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage;

        /**
         * Verifies a HandshakeMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HandshakeMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HandshakeMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage;

        /**
         * Creates a plain object from a HandshakeMessage message. Also converts values to other types if specified.
         * @param message HandshakeMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HandshakeMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HandshakeMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for HandshakeMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace HandshakeMessage {

        /** Properties of a ClientFinish. */
        interface IClientFinish {

            /** ClientFinish static */
            "static"?: (Uint8Array|null);

            /** ClientFinish payload */
            payload?: (Uint8Array|null);
        }

        /** Represents a ClientFinish. */
        class ClientFinish implements IClientFinish {

            /**
             * Constructs a new ClientFinish.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HandshakeMessage.IClientFinish);

            /** ClientFinish static. */
            public static?: (Uint8Array|null);

            /** ClientFinish payload. */
            public payload?: (Uint8Array|null);

            /**
             * Creates a new ClientFinish instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ClientFinish instance
             */
            public static create(properties?: proto.HandshakeMessage.IClientFinish): proto.HandshakeMessage.ClientFinish;

            /**
             * Encodes the specified ClientFinish message. Does not implicitly {@link proto.HandshakeMessage.ClientFinish.verify|verify} messages.
             * @param message ClientFinish message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HandshakeMessage.IClientFinish, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ClientFinish message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ClientFinish.verify|verify} messages.
             * @param message ClientFinish message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HandshakeMessage.IClientFinish, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ClientFinish message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ClientFinish
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage.ClientFinish;

            /**
             * Decodes a ClientFinish message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ClientFinish
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage.ClientFinish;

            /**
             * Verifies a ClientFinish message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ClientFinish message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ClientFinish
             */
            public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage.ClientFinish;

            /**
             * Creates a plain object from a ClientFinish message. Also converts values to other types if specified.
             * @param message ClientFinish
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HandshakeMessage.ClientFinish, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ClientFinish to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ClientFinish
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a ClientHello. */
        interface IClientHello {

            /** ClientHello ephemeral */
            ephemeral?: (Uint8Array|null);

            /** ClientHello static */
            "static"?: (Uint8Array|null);

            /** ClientHello payload */
            payload?: (Uint8Array|null);
        }

        /** Represents a ClientHello. */
        class ClientHello implements IClientHello {

            /**
             * Constructs a new ClientHello.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HandshakeMessage.IClientHello);

            /** ClientHello ephemeral. */
            public ephemeral?: (Uint8Array|null);

            /** ClientHello static. */
            public static?: (Uint8Array|null);

            /** ClientHello payload. */
            public payload?: (Uint8Array|null);

            /**
             * Creates a new ClientHello instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ClientHello instance
             */
            public static create(properties?: proto.HandshakeMessage.IClientHello): proto.HandshakeMessage.ClientHello;

            /**
             * Encodes the specified ClientHello message. Does not implicitly {@link proto.HandshakeMessage.ClientHello.verify|verify} messages.
             * @param message ClientHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HandshakeMessage.IClientHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ClientHello message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ClientHello.verify|verify} messages.
             * @param message ClientHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HandshakeMessage.IClientHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ClientHello message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ClientHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage.ClientHello;

            /**
             * Decodes a ClientHello message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ClientHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage.ClientHello;

            /**
             * Verifies a ClientHello message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ClientHello message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ClientHello
             */
            public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage.ClientHello;

            /**
             * Creates a plain object from a ClientHello message. Also converts values to other types if specified.
             * @param message ClientHello
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HandshakeMessage.ClientHello, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ClientHello to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ClientHello
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a ServerHello. */
        interface IServerHello {

            /** ServerHello ephemeral */
            ephemeral?: (Uint8Array|null);

            /** ServerHello static */
            "static"?: (Uint8Array|null);

            /** ServerHello payload */
            payload?: (Uint8Array|null);
        }

        /** Represents a ServerHello. */
        class ServerHello implements IServerHello {

            /**
             * Constructs a new ServerHello.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HandshakeMessage.IServerHello);

            /** ServerHello ephemeral. */
            public ephemeral?: (Uint8Array|null);

            /** ServerHello static. */
            public static?: (Uint8Array|null);

            /** ServerHello payload. */
            public payload?: (Uint8Array|null);

            /**
             * Creates a new ServerHello instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ServerHello instance
             */
            public static create(properties?: proto.HandshakeMessage.IServerHello): proto.HandshakeMessage.ServerHello;

            /**
             * Encodes the specified ServerHello message. Does not implicitly {@link proto.HandshakeMessage.ServerHello.verify|verify} messages.
             * @param message ServerHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HandshakeMessage.IServerHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ServerHello message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ServerHello.verify|verify} messages.
             * @param message ServerHello message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HandshakeMessage.IServerHello, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ServerHello message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ServerHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HandshakeMessage.ServerHello;

            /**
             * Decodes a ServerHello message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ServerHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HandshakeMessage.ServerHello;

            /**
             * Verifies a ServerHello message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ServerHello message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ServerHello
             */
            public static fromObject(object: { [k: string]: any }): proto.HandshakeMessage.ServerHello;

            /**
             * Creates a plain object from a ServerHello message. Also converts values to other types if specified.
             * @param message ServerHello
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HandshakeMessage.ServerHello, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ServerHello to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ServerHello
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }
    }

    /** Properties of a HistorySync. */
    interface IHistorySync {

        /** HistorySync syncType */
        syncType: proto.HistorySync.HistorySyncType;

        /** HistorySync conversations */
        conversations?: (proto.IConversation[]|null);

        /** HistorySync statusV3Messages */
        statusV3Messages?: (proto.IWebMessageInfo[]|null);

        /** HistorySync chunkOrder */
        chunkOrder?: (number|null);

        /** HistorySync progress */
        progress?: (number|null);

        /** HistorySync pushnames */
        pushnames?: (proto.IPushname[]|null);

        /** HistorySync globalSettings */
        globalSettings?: (proto.IGlobalSettings|null);

        /** HistorySync threadIdUserSecret */
        threadIdUserSecret?: (Uint8Array|null);

        /** HistorySync threadDsTimeframeOffset */
        threadDsTimeframeOffset?: (number|null);

        /** HistorySync recentStickers */
        recentStickers?: (proto.IStickerMetadata[]|null);

        /** HistorySync pastParticipants */
        pastParticipants?: (proto.IPastParticipants[]|null);

        /** HistorySync callLogRecords */
        callLogRecords?: (proto.ICallLogRecord[]|null);

        /** HistorySync aiWaitListState */
        aiWaitListState?: (proto.HistorySync.BotAIWaitListState|null);

        /** HistorySync phoneNumberToLidMappings */
        phoneNumberToLidMappings?: (proto.IPhoneNumberToLIDMapping[]|null);

        /** HistorySync companionMetaNonce */
        companionMetaNonce?: (string|null);

        /** HistorySync shareableChatIdentifierEncryptionKey */
        shareableChatIdentifierEncryptionKey?: (Uint8Array|null);

        /** HistorySync accounts */
        accounts?: (proto.IAccount[]|null);
    }

    /** Represents a HistorySync. */
    class HistorySync implements IHistorySync {

        /**
         * Constructs a new HistorySync.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHistorySync);

        /** HistorySync syncType. */
        public syncType: proto.HistorySync.HistorySyncType;

        /** HistorySync conversations. */
        public conversations: proto.IConversation[];

        /** HistorySync statusV3Messages. */
        public statusV3Messages: proto.IWebMessageInfo[];

        /** HistorySync chunkOrder. */
        public chunkOrder?: (number|null);

        /** HistorySync progress. */
        public progress?: (number|null);

        /** HistorySync pushnames. */
        public pushnames: proto.IPushname[];

        /** HistorySync globalSettings. */
        public globalSettings?: (proto.IGlobalSettings|null);

        /** HistorySync threadIdUserSecret. */
        public threadIdUserSecret?: (Uint8Array|null);

        /** HistorySync threadDsTimeframeOffset. */
        public threadDsTimeframeOffset?: (number|null);

        /** HistorySync recentStickers. */
        public recentStickers: proto.IStickerMetadata[];

        /** HistorySync pastParticipants. */
        public pastParticipants: proto.IPastParticipants[];

        /** HistorySync callLogRecords. */
        public callLogRecords: proto.ICallLogRecord[];

        /** HistorySync aiWaitListState. */
        public aiWaitListState?: (proto.HistorySync.BotAIWaitListState|null);

        /** HistorySync phoneNumberToLidMappings. */
        public phoneNumberToLidMappings: proto.IPhoneNumberToLIDMapping[];

        /** HistorySync companionMetaNonce. */
        public companionMetaNonce?: (string|null);

        /** HistorySync shareableChatIdentifierEncryptionKey. */
        public shareableChatIdentifierEncryptionKey?: (Uint8Array|null);

        /** HistorySync accounts. */
        public accounts: proto.IAccount[];

        /**
         * Creates a new HistorySync instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HistorySync instance
         */
        public static create(properties?: proto.IHistorySync): proto.HistorySync;

        /**
         * Encodes the specified HistorySync message. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @param message HistorySync message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHistorySync, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HistorySync message, length delimited. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @param message HistorySync message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHistorySync, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HistorySync message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HistorySync;

        /**
         * Decodes a HistorySync message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HistorySync;

        /**
         * Verifies a HistorySync message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HistorySync message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HistorySync
         */
        public static fromObject(object: { [k: string]: any }): proto.HistorySync;

        /**
         * Creates a plain object from a HistorySync message. Also converts values to other types if specified.
         * @param message HistorySync
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HistorySync, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HistorySync to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for HistorySync
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace HistorySync {

        /** BotAIWaitListState enum. */
        enum BotAIWaitListState {
            IN_WAITLIST = 0,
            AI_AVAILABLE = 1
        }

        /** HistorySyncType enum. */
        enum HistorySyncType {
            INITIAL_BOOTSTRAP = 0,
            INITIAL_STATUS_V3 = 1,
            FULL = 2,
            RECENT = 3,
            PUSH_NAME = 4,
            NON_BLOCKING_DATA = 5,
            ON_DEMAND = 6
        }
    }

    /** Properties of a HistorySyncMsg. */
    interface IHistorySyncMsg {

        /** HistorySyncMsg message */
        message?: (proto.IWebMessageInfo|null);

        /** HistorySyncMsg msgOrderId */
        msgOrderId?: (number|Long|null);
    }

    /** Represents a HistorySyncMsg. */
    class HistorySyncMsg implements IHistorySyncMsg {

        /**
         * Constructs a new HistorySyncMsg.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHistorySyncMsg);

        /** HistorySyncMsg message. */
        public message?: (proto.IWebMessageInfo|null);

        /** HistorySyncMsg msgOrderId. */
        public msgOrderId?: (number|Long|null);

        /**
         * Creates a new HistorySyncMsg instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HistorySyncMsg instance
         */
        public static create(properties?: proto.IHistorySyncMsg): proto.HistorySyncMsg;

        /**
         * Encodes the specified HistorySyncMsg message. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @param message HistorySyncMsg message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHistorySyncMsg, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HistorySyncMsg message, length delimited. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @param message HistorySyncMsg message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHistorySyncMsg, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HistorySyncMsg;

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HistorySyncMsg;

        /**
         * Verifies a HistorySyncMsg message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HistorySyncMsg message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HistorySyncMsg
         */
        public static fromObject(object: { [k: string]: any }): proto.HistorySyncMsg;

        /**
         * Creates a plain object from a HistorySyncMsg message. Also converts values to other types if specified.
         * @param message HistorySyncMsg
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HistorySyncMsg, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HistorySyncMsg to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for HistorySyncMsg
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a HydratedTemplateButton. */
    interface IHydratedTemplateButton {

        /** HydratedTemplateButton index */
        index?: (number|null);

        /** HydratedTemplateButton quickReplyButton */
        quickReplyButton?: (proto.HydratedTemplateButton.IHydratedQuickReplyButton|null);

        /** HydratedTemplateButton urlButton */
        urlButton?: (proto.HydratedTemplateButton.IHydratedURLButton|null);

        /** HydratedTemplateButton callButton */
        callButton?: (proto.HydratedTemplateButton.IHydratedCallButton|null);
    }

    /** Represents a HydratedTemplateButton. */
    class HydratedTemplateButton implements IHydratedTemplateButton {

        /**
         * Constructs a new HydratedTemplateButton.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IHydratedTemplateButton);

        /** HydratedTemplateButton index. */
        public index?: (number|null);

        /** HydratedTemplateButton quickReplyButton. */
        public quickReplyButton?: (proto.HydratedTemplateButton.IHydratedQuickReplyButton|null);

        /** HydratedTemplateButton urlButton. */
        public urlButton?: (proto.HydratedTemplateButton.IHydratedURLButton|null);

        /** HydratedTemplateButton callButton. */
        public callButton?: (proto.HydratedTemplateButton.IHydratedCallButton|null);

        /** HydratedTemplateButton hydratedButton. */
        public hydratedButton?: ("quickReplyButton"|"urlButton"|"callButton");

        /**
         * Creates a new HydratedTemplateButton instance using the specified properties.
         * @param [properties] Properties to set
         * @returns HydratedTemplateButton instance
         */
        public static create(properties?: proto.IHydratedTemplateButton): proto.HydratedTemplateButton;

        /**
         * Encodes the specified HydratedTemplateButton message. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @param message HydratedTemplateButton message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IHydratedTemplateButton, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified HydratedTemplateButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @param message HydratedTemplateButton message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IHydratedTemplateButton, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton;

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton;

        /**
         * Verifies a HydratedTemplateButton message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a HydratedTemplateButton message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns HydratedTemplateButton
         */
        public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton;

        /**
         * Creates a plain object from a HydratedTemplateButton message. Also converts values to other types if specified.
         * @param message HydratedTemplateButton
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.HydratedTemplateButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this HydratedTemplateButton to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for HydratedTemplateButton
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace HydratedTemplateButton {

        /** Properties of a HydratedCallButton. */
        interface IHydratedCallButton {

            /** HydratedCallButton displayText */
            displayText?: (string|null);

            /** HydratedCallButton phoneNumber */
            phoneNumber?: (string|null);
        }

        /** Represents a HydratedCallButton. */
        class HydratedCallButton implements IHydratedCallButton {

            /**
             * Constructs a new HydratedCallButton.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HydratedTemplateButton.IHydratedCallButton);

            /** HydratedCallButton displayText. */
            public displayText?: (string|null);

            /** HydratedCallButton phoneNumber. */
            public phoneNumber?: (string|null);

            /**
             * Creates a new HydratedCallButton instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HydratedCallButton instance
             */
            public static create(properties?: proto.HydratedTemplateButton.IHydratedCallButton): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Encodes the specified HydratedCallButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedCallButton.verify|verify} messages.
             * @param message HydratedCallButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HydratedTemplateButton.IHydratedCallButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HydratedCallButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedCallButton.verify|verify} messages.
             * @param message HydratedCallButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HydratedTemplateButton.IHydratedCallButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HydratedCallButton message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HydratedCallButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Decodes a HydratedCallButton message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HydratedCallButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Verifies a HydratedCallButton message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HydratedCallButton message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HydratedCallButton
             */
            public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton.HydratedCallButton;

            /**
             * Creates a plain object from a HydratedCallButton message. Also converts values to other types if specified.
             * @param message HydratedCallButton
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HydratedTemplateButton.HydratedCallButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HydratedCallButton to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for HydratedCallButton
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a HydratedQuickReplyButton. */
        interface IHydratedQuickReplyButton {

            /** HydratedQuickReplyButton displayText */
            displayText?: (string|null);

            /** HydratedQuickReplyButton id */
            id?: (string|null);
        }

        /** Represents a HydratedQuickReplyButton. */
        class HydratedQuickReplyButton implements IHydratedQuickReplyButton {

            /**
             * Constructs a new HydratedQuickReplyButton.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HydratedTemplateButton.IHydratedQuickReplyButton);

            /** HydratedQuickReplyButton displayText. */
            public displayText?: (string|null);

            /** HydratedQuickReplyButton id. */
            public id?: (string|null);

            /**
             * Creates a new HydratedQuickReplyButton instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HydratedQuickReplyButton instance
             */
            public static create(properties?: proto.HydratedTemplateButton.IHydratedQuickReplyButton): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Encodes the specified HydratedQuickReplyButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedQuickReplyButton.verify|verify} messages.
             * @param message HydratedQuickReplyButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HydratedTemplateButton.IHydratedQuickReplyButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HydratedQuickReplyButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedQuickReplyButton.verify|verify} messages.
             * @param message HydratedQuickReplyButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HydratedTemplateButton.IHydratedQuickReplyButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HydratedQuickReplyButton message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HydratedQuickReplyButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Decodes a HydratedQuickReplyButton message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HydratedQuickReplyButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Verifies a HydratedQuickReplyButton message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HydratedQuickReplyButton message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HydratedQuickReplyButton
             */
            public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton.HydratedQuickReplyButton;

            /**
             * Creates a plain object from a HydratedQuickReplyButton message. Also converts values to other types if specified.
             * @param message HydratedQuickReplyButton
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HydratedTemplateButton.HydratedQuickReplyButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HydratedQuickReplyButton to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for HydratedQuickReplyButton
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a HydratedURLButton. */
        interface IHydratedURLButton {

            /** HydratedURLButton displayText */
            displayText?: (string|null);

            /** HydratedURLButton url */
            url?: (string|null);

            /** HydratedURLButton consentedUsersUrl */
            consentedUsersUrl?: (string|null);

            /** HydratedURLButton webviewPresentation */
            webviewPresentation?: (proto.HydratedTemplateButton.HydratedURLButton.WebviewPresentationType|null);
        }

        /** Represents a HydratedURLButton. */
        class HydratedURLButton implements IHydratedURLButton {

            /**
             * Constructs a new HydratedURLButton.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.HydratedTemplateButton.IHydratedURLButton);

            /** HydratedURLButton displayText. */
            public displayText?: (string|null);

            /** HydratedURLButton url. */
            public url?: (string|null);

            /** HydratedURLButton consentedUsersUrl. */
            public consentedUsersUrl?: (string|null);

            /** HydratedURLButton webviewPresentation. */
            public webviewPresentation?: (proto.HydratedTemplateButton.HydratedURLButton.WebviewPresentationType|null);

            /**
             * Creates a new HydratedURLButton instance using the specified properties.
             * @param [properties] Properties to set
             * @returns HydratedURLButton instance
             */
            public static create(properties?: proto.HydratedTemplateButton.IHydratedURLButton): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Encodes the specified HydratedURLButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedURLButton.verify|verify} messages.
             * @param message HydratedURLButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.HydratedTemplateButton.IHydratedURLButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified HydratedURLButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedURLButton.verify|verify} messages.
             * @param message HydratedURLButton message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.HydratedTemplateButton.IHydratedURLButton, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a HydratedURLButton message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns HydratedURLButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Decodes a HydratedURLButton message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns HydratedURLButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Verifies a HydratedURLButton message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a HydratedURLButton message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns HydratedURLButton
             */
            public static fromObject(object: { [k: string]: any }): proto.HydratedTemplateButton.HydratedURLButton;

            /**
             * Creates a plain object from a HydratedURLButton message. Also converts values to other types if specified.
             * @param message HydratedURLButton
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.HydratedTemplateButton.HydratedURLButton, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this HydratedURLButton to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for HydratedURLButton
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace HydratedURLButton {

            /** WebviewPresentationType enum. */
            enum WebviewPresentationType {
                FULL = 1,
                TALL = 2,
                COMPACT = 3
            }
        }
    }

    /** Properties of an IdentityKeyPairStructure. */
    interface IIdentityKeyPairStructure {

        /** IdentityKeyPairStructure publicKey */
        publicKey?: (Uint8Array|null);

        /** IdentityKeyPairStructure privateKey */
        privateKey?: (Uint8Array|null);
    }

    /** Represents an IdentityKeyPairStructure. */
    class IdentityKeyPairStructure implements IIdentityKeyPairStructure {

        /**
         * Constructs a new IdentityKeyPairStructure.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IIdentityKeyPairStructure);

        /** IdentityKeyPairStructure publicKey. */
        public publicKey?: (Uint8Array|null);

        /** IdentityKeyPairStructure privateKey. */
        public privateKey?: (Uint8Array|null);

        /**
         * Creates a new IdentityKeyPairStructure instance using the specified properties.
         * @param [properties] Properties to set
         * @returns IdentityKeyPairStructure instance
         */
        public static create(properties?: proto.IIdentityKeyPairStructure): proto.IdentityKeyPairStructure;

        /**
         * Encodes the specified IdentityKeyPairStructure message. Does not implicitly {@link proto.IdentityKeyPairStructure.verify|verify} messages.
         * @param message IdentityKeyPairStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IIdentityKeyPairStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified IdentityKeyPairStructure message, length delimited. Does not implicitly {@link proto.IdentityKeyPairStructure.verify|verify} messages.
         * @param message IdentityKeyPairStructure message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IIdentityKeyPairStructure, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an IdentityKeyPairStructure message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns IdentityKeyPairStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.IdentityKeyPairStructure;

        /**
         * Decodes an IdentityKeyPairStructure message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns IdentityKeyPairStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.IdentityKeyPairStructure;

        /**
         * Verifies an IdentityKeyPairStructure message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an IdentityKeyPairStructure message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns IdentityKeyPairStructure
         */
        public static fromObject(object: { [k: string]: any }): proto.IdentityKeyPairStructure;

        /**
         * Creates a plain object from an IdentityKeyPairStructure message. Also converts values to other types if specified.
         * @param message IdentityKeyPairStructure
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.IdentityKeyPairStructure, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this IdentityKeyPairStructure to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for IdentityKeyPairStructure
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of an InteractiveAnnotation. */
    interface IInteractiveAnnotation {

        /** InteractiveAnnotation polygonVertices */
        polygonVertices?: (proto.IPoint[]|null);

        /** InteractiveAnnotation shouldSkipConfirmation */
        shouldSkipConfirmation?: (boolean|null);

        /** InteractiveAnnotation embeddedContent */
        embeddedContent?: (proto.IEmbeddedContent|null);

        /** InteractiveAnnotation statusLinkType */
        statusLinkType?: (proto.InteractiveAnnotation.StatusLinkType|null);

        /** InteractiveAnnotation location */
        location?: (proto.ILocation|null);

        /** InteractiveAnnotation newsletter */
        newsletter?: (proto.ContextInfo.IForwardedNewsletterMessageInfo|null);

        /** InteractiveAnnotation embeddedAction */
        embeddedAction?: (boolean|null);

        /** InteractiveAnnotation tapAction */
        tapAction?: (proto.ITapLinkAction|null);
    }

    /** Represents an InteractiveAnnotation. */
    class InteractiveAnnotation implements IInteractiveAnnotation {

        /**
         * Constructs a new InteractiveAnnotation.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IInteractiveAnnotation);

        /** InteractiveAnnotation polygonVertices. */
        public polygonVertices: proto.IPoint[];

        /** InteractiveAnnotation shouldSkipConfirmation. */
        public shouldSkipConfirmation?: (boolean|null);

        /** InteractiveAnnotation embeddedContent. */
        public embeddedContent?: (proto.IEmbeddedContent|null);

        /** InteractiveAnnotation statusLinkType. */
        public statusLinkType?: (proto.InteractiveAnnotation.StatusLinkType|null);

        /** InteractiveAnnotation location. */
        public location?: (proto.ILocation|null);

        /** InteractiveAnnotation newsletter. */
        public newsletter?: (proto.ContextInfo.IForwardedNewsletterMessageInfo|null);

        /** InteractiveAnnotation embeddedAction. */
        public embeddedAction?: (boolean|null);

        /** InteractiveAnnotation tapAction. */
        public tapAction?: (proto.ITapLinkAction|null);

        /** InteractiveAnnotation action. */
        public action?: ("location"|"newsletter"|"embeddedAction"|"tapAction");

        /**
         * Creates a new InteractiveAnnotation instance using the specified properties.
         * @param [properties] Properties to set
         * @returns InteractiveAnnotation instance
         */
        public static create(properties?: proto.IInteractiveAnnotation): proto.InteractiveAnnotation;

        /**
         * Encodes the specified InteractiveAnnotation message. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @param message InteractiveAnnotation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IInteractiveAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified InteractiveAnnotation message, length delimited. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @param message InteractiveAnnotation message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IInteractiveAnnotation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.InteractiveAnnotation;

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.InteractiveAnnotation;

        /**
         * Verifies an InteractiveAnnotation message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates an InteractiveAnnotation message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns InteractiveAnnotation
         */
        public static fromObject(object: { [k: string]: any }): proto.InteractiveAnnotation;

        /**
         * Creates a plain object from an InteractiveAnnotation message. Also converts values to other types if specified.
         * @param message InteractiveAnnotation
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.InteractiveAnnotation, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this InteractiveAnnotation to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for InteractiveAnnotation
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace InteractiveAnnotation {

        /** StatusLinkType enum. */
        enum StatusLinkType {
            RASTERIZED_LINK_PREVIEW = 1,
            RASTERIZED_LINK_TRUNCATED = 2,
            RASTERIZED_LINK_FULL_URL = 3
        }
    }

    /** Properties of a KeepInChat. */
    interface IKeepInChat {

        /** KeepInChat keepType */
        keepType?: (proto.KeepType|null);

        /** KeepInChat serverTimestamp */
        serverTimestamp?: (number|Long|null);

        /** KeepInChat key */
        key?: (proto.IMessageKey|null);

        /** KeepInChat deviceJid */
        deviceJid?: (string|null);

        /** KeepInChat clientTimestampMs */
        clientTimestampMs?: (number|Long|null);

        /** KeepInChat serverTimestampMs */
        serverTimestampMs?: (number|Long|null);
    }

    /** Represents a KeepInChat. */
    class KeepInChat implements IKeepInChat {

        /**
         * Constructs a new KeepInChat.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IKeepInChat);

        /** KeepInChat keepType. */
        public keepType?: (proto.KeepType|null);

        /** KeepInChat serverTimestamp. */
        public serverTimestamp?: (number|Long|null);

        /** KeepInChat key. */
        public key?: (proto.IMessageKey|null);

        /** KeepInChat deviceJid. */
        public deviceJid?: (string|null);

        /** KeepInChat clientTimestampMs. */
        public clientTimestampMs?: (number|Long|null);

        /** KeepInChat serverTimestampMs. */
        public serverTimestampMs?: (number|Long|null);

        /**
         * Creates a new KeepInChat instance using the specified properties.
         * @param [properties] Properties to set
         * @returns KeepInChat instance
         */
        public static create(properties?: proto.IKeepInChat): proto.KeepInChat;

        /**
         * Encodes the specified KeepInChat message. Does not implicitly {@link proto.KeepInChat.verify|verify} messages.
         * @param message KeepInChat message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IKeepInChat, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified KeepInChat message, length delimited. Does not implicitly {@link proto.KeepInChat.verify|verify} messages.
         * @param message KeepInChat message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IKeepInChat, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a KeepInChat message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns KeepInChat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.KeepInChat;

        /**
         * Decodes a KeepInChat message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns KeepInChat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.KeepInChat;

        /**
         * Verifies a KeepInChat message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a KeepInChat message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns KeepInChat
         */
        public static fromObject(object: { [k: string]: any }): proto.KeepInChat;

        /**
         * Creates a plain object from a KeepInChat message. Also converts values to other types if specified.
         * @param message KeepInChat
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.KeepInChat, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this KeepInChat to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for KeepInChat
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** KeepType enum. */
    enum KeepType {
        UNKNOWN = 0,
        KEEP_FOR_ALL = 1,
        UNDO_KEEP_FOR_ALL = 2
    }

    /** Properties of a KeyExchangeMessage. */
    interface IKeyExchangeMessage {

        /** KeyExchangeMessage id */
        id?: (number|null);

        /** KeyExchangeMessage baseKey */
        baseKey?: (Uint8Array|null);

        /** KeyExchangeMessage ratchetKey */
        ratchetKey?: (Uint8Array|null);

        /** KeyExchangeMessage identityKey */
        identityKey?: (Uint8Array|null);

        /** KeyExchangeMessage baseKeySignature */
        baseKeySignature?: (Uint8Array|null);
    }

    /** Represents a KeyExchangeMessage. */
    class KeyExchangeMessage implements IKeyExchangeMessage {

        /**
         * Constructs a new KeyExchangeMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IKeyExchangeMessage);

        /** KeyExchangeMessage id. */
        public id?: (number|null);

        /** KeyExchangeMessage baseKey. */
        public baseKey?: (Uint8Array|null);

        /** KeyExchangeMessage ratchetKey. */
        public ratchetKey?: (Uint8Array|null);

        /** KeyExchangeMessage identityKey. */
        public identityKey?: (Uint8Array|null);

        /** KeyExchangeMessage baseKeySignature. */
        public baseKeySignature?: (Uint8Array|null);

        /**
         * Creates a new KeyExchangeMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns KeyExchangeMessage instance
         */
        public static create(properties?: proto.IKeyExchangeMessage): proto.KeyExchangeMessage;

        /**
         * Encodes the specified KeyExchangeMessage message. Does not implicitly {@link proto.KeyExchangeMessage.verify|verify} messages.
         * @param message KeyExchangeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IKeyExchangeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified KeyExchangeMessage message, length delimited. Does not implicitly {@link proto.KeyExchangeMessage.verify|verify} messages.
         * @param message KeyExchangeMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IKeyExchangeMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a KeyExchangeMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns KeyExchangeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.KeyExchangeMessage;

        /**
         * Decodes a KeyExchangeMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns KeyExchangeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.KeyExchangeMessage;

        /**
         * Verifies a KeyExchangeMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a KeyExchangeMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns KeyExchangeMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.KeyExchangeMessage;

        /**
         * Creates a plain object from a KeyExchangeMessage message. Also converts values to other types if specified.
         * @param message KeyExchangeMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.KeyExchangeMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this KeyExchangeMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for KeyExchangeMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a KeyId. */
    interface IKeyId {

        /** KeyId id */
        id?: (Uint8Array|null);
    }

    /** Represents a KeyId. */
    class KeyId implements IKeyId {

        /**
         * Constructs a new KeyId.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IKeyId);

        /** KeyId id. */
        public id?: (Uint8Array|null);

        /**
         * Creates a new KeyId instance using the specified properties.
         * @param [properties] Properties to set
         * @returns KeyId instance
         */
        public static create(properties?: proto.IKeyId): proto.KeyId;

        /**
         * Encodes the specified KeyId message. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @param message KeyId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified KeyId message, length delimited. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @param message KeyId message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a KeyId message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.KeyId;

        /**
         * Decodes a KeyId message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.KeyId;

        /**
         * Verifies a KeyId message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a KeyId message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns KeyId
         */
        public static fromObject(object: { [k: string]: any }): proto.KeyId;

        /**
         * Creates a plain object from a KeyId message. Also converts values to other types if specified.
         * @param message KeyId
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.KeyId, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this KeyId to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for KeyId
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a LIDMigrationMapping. */
    interface ILIDMigrationMapping {

        /** LIDMigrationMapping pn */
        pn: (number|Long);

        /** LIDMigrationMapping assignedLid */
        assignedLid: (number|Long);

        /** LIDMigrationMapping latestLid */
        latestLid?: (number|Long|null);
    }

    /** Represents a LIDMigrationMapping. */
    class LIDMigrationMapping implements ILIDMigrationMapping {

        /**
         * Constructs a new LIDMigrationMapping.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILIDMigrationMapping);

        /** LIDMigrationMapping pn. */
        public pn: (number|Long);

        /** LIDMigrationMapping assignedLid. */
        public assignedLid: (number|Long);

        /** LIDMigrationMapping latestLid. */
        public latestLid?: (number|Long|null);

        /**
         * Creates a new LIDMigrationMapping instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LIDMigrationMapping instance
         */
        public static create(properties?: proto.ILIDMigrationMapping): proto.LIDMigrationMapping;

        /**
         * Encodes the specified LIDMigrationMapping message. Does not implicitly {@link proto.LIDMigrationMapping.verify|verify} messages.
         * @param message LIDMigrationMapping message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILIDMigrationMapping, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LIDMigrationMapping message, length delimited. Does not implicitly {@link proto.LIDMigrationMapping.verify|verify} messages.
         * @param message LIDMigrationMapping message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILIDMigrationMapping, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LIDMigrationMapping message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LIDMigrationMapping
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.LIDMigrationMapping;

        /**
         * Decodes a LIDMigrationMapping message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LIDMigrationMapping
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.LIDMigrationMapping;

        /**
         * Verifies a LIDMigrationMapping message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LIDMigrationMapping message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LIDMigrationMapping
         */
        public static fromObject(object: { [k: string]: any }): proto.LIDMigrationMapping;

        /**
         * Creates a plain object from a LIDMigrationMapping message. Also converts values to other types if specified.
         * @param message LIDMigrationMapping
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.LIDMigrationMapping, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LIDMigrationMapping to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for LIDMigrationMapping
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a LIDMigrationMappingSyncMessage. */
    interface ILIDMigrationMappingSyncMessage {

        /** LIDMigrationMappingSyncMessage encodedMappingPayload */
        encodedMappingPayload?: (Uint8Array|null);
    }

    /** Represents a LIDMigrationMappingSyncMessage. */
    class LIDMigrationMappingSyncMessage implements ILIDMigrationMappingSyncMessage {

        /**
         * Constructs a new LIDMigrationMappingSyncMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILIDMigrationMappingSyncMessage);

        /** LIDMigrationMappingSyncMessage encodedMappingPayload. */
        public encodedMappingPayload?: (Uint8Array|null);

        /**
         * Creates a new LIDMigrationMappingSyncMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LIDMigrationMappingSyncMessage instance
         */
        public static create(properties?: proto.ILIDMigrationMappingSyncMessage): proto.LIDMigrationMappingSyncMessage;

        /**
         * Encodes the specified LIDMigrationMappingSyncMessage message. Does not implicitly {@link proto.LIDMigrationMappingSyncMessage.verify|verify} messages.
         * @param message LIDMigrationMappingSyncMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILIDMigrationMappingSyncMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LIDMigrationMappingSyncMessage message, length delimited. Does not implicitly {@link proto.LIDMigrationMappingSyncMessage.verify|verify} messages.
         * @param message LIDMigrationMappingSyncMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILIDMigrationMappingSyncMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LIDMigrationMappingSyncMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LIDMigrationMappingSyncMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.LIDMigrationMappingSyncMessage;

        /**
         * Decodes a LIDMigrationMappingSyncMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LIDMigrationMappingSyncMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.LIDMigrationMappingSyncMessage;

        /**
         * Verifies a LIDMigrationMappingSyncMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LIDMigrationMappingSyncMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LIDMigrationMappingSyncMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.LIDMigrationMappingSyncMessage;

        /**
         * Creates a plain object from a LIDMigrationMappingSyncMessage message. Also converts values to other types if specified.
         * @param message LIDMigrationMappingSyncMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.LIDMigrationMappingSyncMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LIDMigrationMappingSyncMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for LIDMigrationMappingSyncMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a LIDMigrationMappingSyncPayload. */
    interface ILIDMigrationMappingSyncPayload {

        /** LIDMigrationMappingSyncPayload pnToLidMappings */
        pnToLidMappings?: (proto.ILIDMigrationMapping[]|null);

        /** LIDMigrationMappingSyncPayload chatDbMigrationTimestamp */
        chatDbMigrationTimestamp?: (number|Long|null);
    }

    /** Represents a LIDMigrationMappingSyncPayload. */
    class LIDMigrationMappingSyncPayload implements ILIDMigrationMappingSyncPayload {

        /**
         * Constructs a new LIDMigrationMappingSyncPayload.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILIDMigrationMappingSyncPayload);

        /** LIDMigrationMappingSyncPayload pnToLidMappings. */
        public pnToLidMappings: proto.ILIDMigrationMapping[];

        /** LIDMigrationMappingSyncPayload chatDbMigrationTimestamp. */
        public chatDbMigrationTimestamp?: (number|Long|null);

        /**
         * Creates a new LIDMigrationMappingSyncPayload instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LIDMigrationMappingSyncPayload instance
         */
        public static create(properties?: proto.ILIDMigrationMappingSyncPayload): proto.LIDMigrationMappingSyncPayload;

        /**
         * Encodes the specified LIDMigrationMappingSyncPayload message. Does not implicitly {@link proto.LIDMigrationMappingSyncPayload.verify|verify} messages.
         * @param message LIDMigrationMappingSyncPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILIDMigrationMappingSyncPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LIDMigrationMappingSyncPayload message, length delimited. Does not implicitly {@link proto.LIDMigrationMappingSyncPayload.verify|verify} messages.
         * @param message LIDMigrationMappingSyncPayload message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILIDMigrationMappingSyncPayload, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LIDMigrationMappingSyncPayload message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LIDMigrationMappingSyncPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.LIDMigrationMappingSyncPayload;

        /**
         * Decodes a LIDMigrationMappingSyncPayload message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LIDMigrationMappingSyncPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.LIDMigrationMappingSyncPayload;

        /**
         * Verifies a LIDMigrationMappingSyncPayload message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LIDMigrationMappingSyncPayload message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LIDMigrationMappingSyncPayload
         */
        public static fromObject(object: { [k: string]: any }): proto.LIDMigrationMappingSyncPayload;

        /**
         * Creates a plain object from a LIDMigrationMappingSyncPayload message. Also converts values to other types if specified.
         * @param message LIDMigrationMappingSyncPayload
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.LIDMigrationMappingSyncPayload, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LIDMigrationMappingSyncPayload to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for LIDMigrationMappingSyncPayload
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a LegacyMessage. */
    interface ILegacyMessage {

        /** LegacyMessage eventResponseMessage */
        eventResponseMessage?: (proto.Message.IEventResponseMessage|null);

        /** LegacyMessage pollVote */
        pollVote?: (proto.Message.IPollVoteMessage|null);
    }

    /** Represents a LegacyMessage. */
    class LegacyMessage implements ILegacyMessage {

        /**
         * Constructs a new LegacyMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILegacyMessage);

        /** LegacyMessage eventResponseMessage. */
        public eventResponseMessage?: (proto.Message.IEventResponseMessage|null);

        /** LegacyMessage pollVote. */
        public pollVote?: (proto.Message.IPollVoteMessage|null);

        /**
         * Creates a new LegacyMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LegacyMessage instance
         */
        public static create(properties?: proto.ILegacyMessage): proto.LegacyMessage;

        /**
         * Encodes the specified LegacyMessage message. Does not implicitly {@link proto.LegacyMessage.verify|verify} messages.
         * @param message LegacyMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILegacyMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LegacyMessage message, length delimited. Does not implicitly {@link proto.LegacyMessage.verify|verify} messages.
         * @param message LegacyMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILegacyMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LegacyMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LegacyMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.LegacyMessage;

        /**
         * Decodes a LegacyMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LegacyMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.LegacyMessage;

        /**
         * Verifies a LegacyMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LegacyMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LegacyMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.LegacyMessage;

        /**
         * Creates a plain object from a LegacyMessage message. Also converts values to other types if specified.
         * @param message LegacyMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.LegacyMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LegacyMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for LegacyMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a LimitSharing. */
    interface ILimitSharing {

        /** LimitSharing sharingLimited */
        sharingLimited?: (boolean|null);

        /** LimitSharing trigger */
        trigger?: (proto.LimitSharing.TriggerType|null);

        /** LimitSharing limitSharingSettingTimestamp */
        limitSharingSettingTimestamp?: (number|Long|null);

        /** LimitSharing initiatedByMe */
        initiatedByMe?: (boolean|null);
    }

    /** Represents a LimitSharing. */
    class LimitSharing implements ILimitSharing {

        /**
         * Constructs a new LimitSharing.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILimitSharing);

        /** LimitSharing sharingLimited. */
        public sharingLimited?: (boolean|null);

        /** LimitSharing trigger. */
        public trigger?: (proto.LimitSharing.TriggerType|null);

        /** LimitSharing limitSharingSettingTimestamp. */
        public limitSharingSettingTimestamp?: (number|Long|null);

        /** LimitSharing initiatedByMe. */
        public initiatedByMe?: (boolean|null);

        /**
         * Creates a new LimitSharing instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LimitSharing instance
         */
        public static create(properties?: proto.ILimitSharing): proto.LimitSharing;

        /**
         * Encodes the specified LimitSharing message. Does not implicitly {@link proto.LimitSharing.verify|verify} messages.
         * @param message LimitSharing message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILimitSharing, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LimitSharing message, length delimited. Does not implicitly {@link proto.LimitSharing.verify|verify} messages.
         * @param message LimitSharing message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILimitSharing, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LimitSharing message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LimitSharing
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.LimitSharing;

        /**
         * Decodes a LimitSharing message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LimitSharing
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.LimitSharing;

        /**
         * Verifies a LimitSharing message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LimitSharing message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LimitSharing
         */
        public static fromObject(object: { [k: string]: any }): proto.LimitSharing;

        /**
         * Creates a plain object from a LimitSharing message. Also converts values to other types if specified.
         * @param message LimitSharing
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.LimitSharing, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LimitSharing to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for LimitSharing
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace LimitSharing {

        /** TriggerType enum. */
        enum TriggerType {
            UNKNOWN = 0,
            CHAT_SETTING = 1,
            BIZ_SUPPORTS_FB_HOSTING = 2,
            UNKNOWN_GROUP = 3
        }
    }

    /** Properties of a LocalizedName. */
    interface ILocalizedName {

        /** LocalizedName lg */
        lg?: (string|null);

        /** LocalizedName lc */
        lc?: (string|null);

        /** LocalizedName verifiedName */
        verifiedName?: (string|null);
    }

    /** Represents a LocalizedName. */
    class LocalizedName implements ILocalizedName {

        /**
         * Constructs a new LocalizedName.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILocalizedName);

        /** LocalizedName lg. */
        public lg?: (string|null);

        /** LocalizedName lc. */
        public lc?: (string|null);

        /** LocalizedName verifiedName. */
        public verifiedName?: (string|null);

        /**
         * Creates a new LocalizedName instance using the specified properties.
         * @param [properties] Properties to set
         * @returns LocalizedName instance
         */
        public static create(properties?: proto.ILocalizedName): proto.LocalizedName;

        /**
         * Encodes the specified LocalizedName message. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @param message LocalizedName message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILocalizedName, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified LocalizedName message, length delimited. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @param message LocalizedName message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILocalizedName, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a LocalizedName message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.LocalizedName;

        /**
         * Decodes a LocalizedName message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.LocalizedName;

        /**
         * Verifies a LocalizedName message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a LocalizedName message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns LocalizedName
         */
        public static fromObject(object: { [k: string]: any }): proto.LocalizedName;

        /**
         * Creates a plain object from a LocalizedName message. Also converts values to other types if specified.
         * @param message LocalizedName
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.LocalizedName, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this LocalizedName to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for LocalizedName
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a Location. */
    interface ILocation {

        /** Location degreesLatitude */
        degreesLatitude?: (number|null);

        /** Location degreesLongitude */
        degreesLongitude?: (number|null);

        /** Location name */
        name?: (string|null);
    }

    /** Represents a Location. */
    class Location implements ILocation {

        /**
         * Constructs a new Location.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.ILocation);

        /** Location degreesLatitude. */
        public degreesLatitude?: (number|null);

        /** Location degreesLongitude. */
        public degreesLongitude?: (number|null);

        /** Location name. */
        public name?: (string|null);

        /**
         * Creates a new Location instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Location instance
         */
        public static create(properties?: proto.ILocation): proto.Location;

        /**
         * Encodes the specified Location message. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @param message Location message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.ILocation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Location message, length delimited. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @param message Location message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.ILocation, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Location message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Location;

        /**
         * Decodes a Location message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Location;

        /**
         * Verifies a Location message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Location message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Location
         */
        public static fromObject(object: { [k: string]: any }): proto.Location;

        /**
         * Creates a plain object from a Location message. Also converts values to other types if specified.
         * @param message Location
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Location, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Location to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for Location
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a MediaData. */
    interface IMediaData {

        /** MediaData localPath */
        localPath?: (string|null);
    }

    /** Represents a MediaData. */
    class MediaData implements IMediaData {

        /**
         * Constructs a new MediaData.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMediaData);

        /** MediaData localPath. */
        public localPath?: (string|null);

        /**
         * Creates a new MediaData instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MediaData instance
         */
        public static create(properties?: proto.IMediaData): proto.MediaData;

        /**
         * Encodes the specified MediaData message. Does not implicitly {@link proto.MediaData.verify|verify} messages.
         * @param message MediaData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMediaData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MediaData message, length delimited. Does not implicitly {@link proto.MediaData.verify|verify} messages.
         * @param message MediaData message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMediaData, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MediaData message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MediaData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MediaData;

        /**
         * Decodes a MediaData message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MediaData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MediaData;

        /**
         * Verifies a MediaData message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MediaData message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MediaData
         */
        public static fromObject(object: { [k: string]: any }): proto.MediaData;

        /**
         * Creates a plain object from a MediaData message. Also converts values to other types if specified.
         * @param message MediaData
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MediaData, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MediaData to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for MediaData
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a MediaNotifyMessage. */
    interface IMediaNotifyMessage {

        /** MediaNotifyMessage expressPathUrl */
        expressPathUrl?: (string|null);

        /** MediaNotifyMessage fileEncSha256 */
        fileEncSha256?: (Uint8Array|null);

        /** MediaNotifyMessage fileLength */
        fileLength?: (number|Long|null);
    }

    /** Represents a MediaNotifyMessage. */
    class MediaNotifyMessage implements IMediaNotifyMessage {

        /**
         * Constructs a new MediaNotifyMessage.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMediaNotifyMessage);

        /** MediaNotifyMessage expressPathUrl. */
        public expressPathUrl?: (string|null);

        /** MediaNotifyMessage fileEncSha256. */
        public fileEncSha256?: (Uint8Array|null);

        /** MediaNotifyMessage fileLength. */
        public fileLength?: (number|Long|null);

        /**
         * Creates a new MediaNotifyMessage instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MediaNotifyMessage instance
         */
        public static create(properties?: proto.IMediaNotifyMessage): proto.MediaNotifyMessage;

        /**
         * Encodes the specified MediaNotifyMessage message. Does not implicitly {@link proto.MediaNotifyMessage.verify|verify} messages.
         * @param message MediaNotifyMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMediaNotifyMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MediaNotifyMessage message, length delimited. Does not implicitly {@link proto.MediaNotifyMessage.verify|verify} messages.
         * @param message MediaNotifyMessage message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMediaNotifyMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MediaNotifyMessage message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MediaNotifyMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MediaNotifyMessage;

        /**
         * Decodes a MediaNotifyMessage message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MediaNotifyMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MediaNotifyMessage;

        /**
         * Verifies a MediaNotifyMessage message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MediaNotifyMessage message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MediaNotifyMessage
         */
        public static fromObject(object: { [k: string]: any }): proto.MediaNotifyMessage;

        /**
         * Creates a plain object from a MediaNotifyMessage message. Also converts values to other types if specified.
         * @param message MediaNotifyMessage
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MediaNotifyMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MediaNotifyMessage to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for MediaNotifyMessage
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a MediaRetryNotification. */
    interface IMediaRetryNotification {

        /** MediaRetryNotification stanzaId */
        stanzaId?: (string|null);

        /** MediaRetryNotification directPath */
        directPath?: (string|null);

        /** MediaRetryNotification result */
        result?: (proto.MediaRetryNotification.ResultType|null);

        /** MediaRetryNotification messageSecret */
        messageSecret?: (Uint8Array|null);
    }

    /** Represents a MediaRetryNotification. */
    class MediaRetryNotification implements IMediaRetryNotification {

        /**
         * Constructs a new MediaRetryNotification.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMediaRetryNotification);

        /** MediaRetryNotification stanzaId. */
        public stanzaId?: (string|null);

        /** MediaRetryNotification directPath. */
        public directPath?: (string|null);

        /** MediaRetryNotification result. */
        public result?: (proto.MediaRetryNotification.ResultType|null);

        /** MediaRetryNotification messageSecret. */
        public messageSecret?: (Uint8Array|null);

        /**
         * Creates a new MediaRetryNotification instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MediaRetryNotification instance
         */
        public static create(properties?: proto.IMediaRetryNotification): proto.MediaRetryNotification;

        /**
         * Encodes the specified MediaRetryNotification message. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @param message MediaRetryNotification message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMediaRetryNotification, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MediaRetryNotification message, length delimited. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @param message MediaRetryNotification message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMediaRetryNotification, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MediaRetryNotification;

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MediaRetryNotification;

        /**
         * Verifies a MediaRetryNotification message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MediaRetryNotification message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MediaRetryNotification
         */
        public static fromObject(object: { [k: string]: any }): proto.MediaRetryNotification;

        /**
         * Creates a plain object from a MediaRetryNotification message. Also converts values to other types if specified.
         * @param message MediaRetryNotification
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MediaRetryNotification, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MediaRetryNotification to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for MediaRetryNotification
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace MediaRetryNotification {

        /** ResultType enum. */
        enum ResultType {
            GENERAL_ERROR = 0,
            SUCCESS = 1,
            NOT_FOUND = 2,
            DECRYPTION_ERROR = 3
        }
    }

    /** MediaVisibility enum. */
    enum MediaVisibility {
        DEFAULT = 0,
        OFF = 1,
        ON = 2
    }

    /** Properties of a MemberLabel. */
    interface IMemberLabel {

        /** MemberLabel label */
        label?: (string|null);

        /** MemberLabel labelTimestamp */
        labelTimestamp?: (number|Long|null);
    }

    /** Represents a MemberLabel. */
    class MemberLabel implements IMemberLabel {

        /**
         * Constructs a new MemberLabel.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMemberLabel);

        /** MemberLabel label. */
        public label?: (string|null);

        /** MemberLabel labelTimestamp. */
        public labelTimestamp?: (number|Long|null);

        /**
         * Creates a new MemberLabel instance using the specified properties.
         * @param [properties] Properties to set
         * @returns MemberLabel instance
         */
        public static create(properties?: proto.IMemberLabel): proto.MemberLabel;

        /**
         * Encodes the specified MemberLabel message. Does not implicitly {@link proto.MemberLabel.verify|verify} messages.
         * @param message MemberLabel message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMemberLabel, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified MemberLabel message, length delimited. Does not implicitly {@link proto.MemberLabel.verify|verify} messages.
         * @param message MemberLabel message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMemberLabel, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a MemberLabel message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns MemberLabel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.MemberLabel;

        /**
         * Decodes a MemberLabel message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns MemberLabel
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.MemberLabel;

        /**
         * Verifies a MemberLabel message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a MemberLabel message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns MemberLabel
         */
        public static fromObject(object: { [k: string]: any }): proto.MemberLabel;

        /**
         * Creates a plain object from a MemberLabel message. Also converts values to other types if specified.
         * @param message MemberLabel
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.MemberLabel, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this MemberLabel to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for MemberLabel
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    /** Properties of a Message. */
    interface IMessage {

        /** Message conversation */
        conversation?: (string|null);

        /** Message senderKeyDistributionMessage */
        senderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message imageMessage */
        imageMessage?: (proto.Message.IImageMessage|null);

        /** Message contactMessage */
        contactMessage?: (proto.Message.IContactMessage|null);

        /** Message locationMessage */
        locationMessage?: (proto.Message.ILocationMessage|null);

        /** Message extendedTextMessage */
        extendedTextMessage?: (proto.Message.IExtendedTextMessage|null);

        /** Message documentMessage */
        documentMessage?: (proto.Message.IDocumentMessage|null);

        /** Message audioMessage */
        audioMessage?: (proto.Message.IAudioMessage|null);

        /** Message videoMessage */
        videoMessage?: (proto.Message.IVideoMessage|null);

        /** Message call */
        call?: (proto.Message.ICall|null);

        /** Message chat */
        chat?: (proto.Message.IChat|null);

        /** Message protocolMessage */
        protocolMessage?: (proto.Message.IProtocolMessage|null);

        /** Message contactsArrayMessage */
        contactsArrayMessage?: (proto.Message.IContactsArrayMessage|null);

        /** Message highlyStructuredMessage */
        highlyStructuredMessage?: (proto.Message.IHighlyStructuredMessage|null);

        /** Message fastRatchetKeySenderKeyDistributionMessage */
        fastRatchetKeySenderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message sendPaymentMessage */
        sendPaymentMessage?: (proto.Message.ISendPaymentMessage|null);

        /** Message liveLocationMessage */
        liveLocationMessage?: (proto.Message.ILiveLocationMessage|null);

        /** Message requestPaymentMessage */
        requestPaymentMessage?: (proto.Message.IRequestPaymentMessage|null);

        /** Message declinePaymentRequestMessage */
        declinePaymentRequestMessage?: (proto.Message.IDeclinePaymentRequestMessage|null);

        /** Message cancelPaymentRequestMessage */
        cancelPaymentRequestMessage?: (proto.Message.ICancelPaymentRequestMessage|null);

        /** Message templateMessage */
        templateMessage?: (proto.Message.ITemplateMessage|null);

        /** Message stickerMessage */
        stickerMessage?: (proto.Message.IStickerMessage|null);

        /** Message groupInviteMessage */
        groupInviteMessage?: (proto.Message.IGroupInviteMessage|null);

        /** Message templateButtonReplyMessage */
        templateButtonReplyMessage?: (proto.Message.ITemplateButtonReplyMessage|null);

        /** Message productMessage */
        productMessage?: (proto.Message.IProductMessage|null);

        /** Message deviceSentMessage */
        deviceSentMessage?: (proto.Message.IDeviceSentMessage|null);

        /** Message messageContextInfo */
        messageContextInfo?: (proto.IMessageContextInfo|null);

        /** Message listMessage */
        listMessage?: (proto.Message.IListMessage|null);

        /** Message viewOnceMessage */
        viewOnceMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message orderMessage */
        orderMessage?: (proto.Message.IOrderMessage|null);

        /** Message listResponseMessage */
        listResponseMessage?: (proto.Message.IListResponseMessage|null);

        /** Message ephemeralMessage */
        ephemeralMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message invoiceMessage */
        invoiceMessage?: (proto.Message.IInvoiceMessage|null);

        /** Message buttonsMessage */
        buttonsMessage?: (proto.Message.IButtonsMessage|null);

        /** Message buttonsResponseMessage */
        buttonsResponseMessage?: (proto.Message.IButtonsResponseMessage|null);

        /** Message paymentInviteMessage */
        paymentInviteMessage?: (proto.Message.IPaymentInviteMessage|null);

        /** Message interactiveMessage */
        interactiveMessage?: (proto.Message.IInteractiveMessage|null);

        /** Message reactionMessage */
        reactionMessage?: (proto.Message.IReactionMessage|null);

        /** Message stickerSyncRmrMessage */
        stickerSyncRmrMessage?: (proto.Message.IStickerSyncRMRMessage|null);

        /** Message interactiveResponseMessage */
        interactiveResponseMessage?: (proto.Message.IInteractiveResponseMessage|null);

        /** Message pollCreationMessage */
        pollCreationMessage?: (proto.Message.IPollCreationMessage|null);

        /** Message pollUpdateMessage */
        pollUpdateMessage?: (proto.Message.IPollUpdateMessage|null);

        /** Message keepInChatMessage */
        keepInChatMessage?: (proto.Message.IKeepInChatMessage|null);

        /** Message documentWithCaptionMessage */
        documentWithCaptionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message requestPhoneNumberMessage */
        requestPhoneNumberMessage?: (proto.Message.IRequestPhoneNumberMessage|null);

        /** Message viewOnceMessageV2 */
        viewOnceMessageV2?: (proto.Message.IFutureProofMessage|null);

        /** Message encReactionMessage */
        encReactionMessage?: (proto.Message.IEncReactionMessage|null);

        /** Message editedMessage */
        editedMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message viewOnceMessageV2Extension */
        viewOnceMessageV2Extension?: (proto.Message.IFutureProofMessage|null);

        /** Message pollCreationMessageV2 */
        pollCreationMessageV2?: (proto.Message.IPollCreationMessage|null);

        /** Message scheduledCallCreationMessage */
        scheduledCallCreationMessage?: (proto.Message.IScheduledCallCreationMessage|null);

        /** Message groupMentionedMessage */
        groupMentionedMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message pinInChatMessage */
        pinInChatMessage?: (proto.Message.IPinInChatMessage|null);

        /** Message pollCreationMessageV3 */
        pollCreationMessageV3?: (proto.Message.IPollCreationMessage|null);

        /** Message scheduledCallEditMessage */
        scheduledCallEditMessage?: (proto.Message.IScheduledCallEditMessage|null);

        /** Message ptvMessage */
        ptvMessage?: (proto.Message.IVideoMessage|null);

        /** Message botInvokeMessage */
        botInvokeMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message callLogMesssage */
        callLogMesssage?: (proto.Message.ICallLogMessage|null);

        /** Message messageHistoryBundle */
        messageHistoryBundle?: (proto.Message.IMessageHistoryBundle|null);

        /** Message encCommentMessage */
        encCommentMessage?: (proto.Message.IEncCommentMessage|null);

        /** Message bcallMessage */
        bcallMessage?: (proto.Message.IBCallMessage|null);

        /** Message lottieStickerMessage */
        lottieStickerMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message eventMessage */
        eventMessage?: (proto.Message.IEventMessage|null);

        /** Message encEventResponseMessage */
        encEventResponseMessage?: (proto.Message.IEncEventResponseMessage|null);

        /** Message commentMessage */
        commentMessage?: (proto.Message.ICommentMessage|null);

        /** Message newsletterAdminInviteMessage */
        newsletterAdminInviteMessage?: (proto.Message.INewsletterAdminInviteMessage|null);

        /** Message placeholderMessage */
        placeholderMessage?: (proto.Message.IPlaceholderMessage|null);

        /** Message secretEncryptedMessage */
        secretEncryptedMessage?: (proto.Message.ISecretEncryptedMessage|null);

        /** Message albumMessage */
        albumMessage?: (proto.Message.IAlbumMessage|null);

        /** Message eventCoverImage */
        eventCoverImage?: (proto.Message.IFutureProofMessage|null);

        /** Message stickerPackMessage */
        stickerPackMessage?: (proto.Message.IStickerPackMessage|null);

        /** Message statusMentionMessage */
        statusMentionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message pollResultSnapshotMessage */
        pollResultSnapshotMessage?: (proto.Message.IPollResultSnapshotMessage|null);

        /** Message pollCreationOptionImageMessage */
        pollCreationOptionImageMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message associatedChildMessage */
        associatedChildMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message groupStatusMentionMessage */
        groupStatusMentionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message pollCreationMessageV4 */
        pollCreationMessageV4?: (proto.Message.IFutureProofMessage|null);

        /** Message pollCreationMessageV5 */
        pollCreationMessageV5?: (proto.Message.IFutureProofMessage|null);

        /** Message statusAddYours */
        statusAddYours?: (proto.Message.IFutureProofMessage|null);

        /** Message groupStatusMessage */
        groupStatusMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message richResponseMessage */
        richResponseMessage?: (proto.IAIRichResponseMessage|null);

        /** Message statusNotificationMessage */
        statusNotificationMessage?: (proto.Message.IStatusNotificationMessage|null);

        /** Message limitSharingMessage */
        limitSharingMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message botTaskMessage */
        botTaskMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message questionMessage */
        questionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message messageHistoryNotice */
        messageHistoryNotice?: (proto.Message.IMessageHistoryNotice|null);
    }

    /** Represents a Message. */
    class Message implements IMessage {

        /**
         * Constructs a new Message.
         * @param [properties] Properties to set
         */
        constructor(properties?: proto.IMessage);

        /** Message conversation. */
        public conversation?: (string|null);

        /** Message senderKeyDistributionMessage. */
        public senderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message imageMessage. */
        public imageMessage?: (proto.Message.IImageMessage|null);

        /** Message contactMessage. */
        public contactMessage?: (proto.Message.IContactMessage|null);

        /** Message locationMessage. */
        public locationMessage?: (proto.Message.ILocationMessage|null);

        /** Message extendedTextMessage. */
        public extendedTextMessage?: (proto.Message.IExtendedTextMessage|null);

        /** Message documentMessage. */
        public documentMessage?: (proto.Message.IDocumentMessage|null);

        /** Message audioMessage. */
        public audioMessage?: (proto.Message.IAudioMessage|null);

        /** Message videoMessage. */
        public videoMessage?: (proto.Message.IVideoMessage|null);

        /** Message call. */
        public call?: (proto.Message.ICall|null);

        /** Message chat. */
        public chat?: (proto.Message.IChat|null);

        /** Message protocolMessage. */
        public protocolMessage?: (proto.Message.IProtocolMessage|null);

        /** Message contactsArrayMessage. */
        public contactsArrayMessage?: (proto.Message.IContactsArrayMessage|null);

        /** Message highlyStructuredMessage. */
        public highlyStructuredMessage?: (proto.Message.IHighlyStructuredMessage|null);

        /** Message fastRatchetKeySenderKeyDistributionMessage. */
        public fastRatchetKeySenderKeyDistributionMessage?: (proto.Message.ISenderKeyDistributionMessage|null);

        /** Message sendPaymentMessage. */
        public sendPaymentMessage?: (proto.Message.ISendPaymentMessage|null);

        /** Message liveLocationMessage. */
        public liveLocationMessage?: (proto.Message.ILiveLocationMessage|null);

        /** Message requestPaymentMessage. */
        public requestPaymentMessage?: (proto.Message.IRequestPaymentMessage|null);

        /** Message declinePaymentRequestMessage. */
        public declinePaymentRequestMessage?: (proto.Message.IDeclinePaymentRequestMessage|null);

        /** Message cancelPaymentRequestMessage. */
        public cancelPaymentRequestMessage?: (proto.Message.ICancelPaymentRequestMessage|null);

        /** Message templateMessage. */
        public templateMessage?: (proto.Message.ITemplateMessage|null);

        /** Message stickerMessage. */
        public stickerMessage?: (proto.Message.IStickerMessage|null);

        /** Message groupInviteMessage. */
        public groupInviteMessage?: (proto.Message.IGroupInviteMessage|null);

        /** Message templateButtonReplyMessage. */
        public templateButtonReplyMessage?: (proto.Message.ITemplateButtonReplyMessage|null);

        /** Message productMessage. */
        public productMessage?: (proto.Message.IProductMessage|null);

        /** Message deviceSentMessage. */
        public deviceSentMessage?: (proto.Message.IDeviceSentMessage|null);

        /** Message messageContextInfo. */
        public messageContextInfo?: (proto.IMessageContextInfo|null);

        /** Message listMessage. */
        public listMessage?: (proto.Message.IListMessage|null);

        /** Message viewOnceMessage. */
        public viewOnceMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message orderMessage. */
        public orderMessage?: (proto.Message.IOrderMessage|null);

        /** Message listResponseMessage. */
        public listResponseMessage?: (proto.Message.IListResponseMessage|null);

        /** Message ephemeralMessage. */
        public ephemeralMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message invoiceMessage. */
        public invoiceMessage?: (proto.Message.IInvoiceMessage|null);

        /** Message buttonsMessage. */
        public buttonsMessage?: (proto.Message.IButtonsMessage|null);

        /** Message buttonsResponseMessage. */
        public buttonsResponseMessage?: (proto.Message.IButtonsResponseMessage|null);

        /** Message paymentInviteMessage. */
        public paymentInviteMessage?: (proto.Message.IPaymentInviteMessage|null);

        /** Message interactiveMessage. */
        public interactiveMessage?: (proto.Message.IInteractiveMessage|null);

        /** Message reactionMessage. */
        public reactionMessage?: (proto.Message.IReactionMessage|null);

        /** Message stickerSyncRmrMessage. */
        public stickerSyncRmrMessage?: (proto.Message.IStickerSyncRMRMessage|null);

        /** Message interactiveResponseMessage. */
        public interactiveResponseMessage?: (proto.Message.IInteractiveResponseMessage|null);

        /** Message pollCreationMessage. */
        public pollCreationMessage?: (proto.Message.IPollCreationMessage|null);

        /** Message pollUpdateMessage. */
        public pollUpdateMessage?: (proto.Message.IPollUpdateMessage|null);

        /** Message keepInChatMessage. */
        public keepInChatMessage?: (proto.Message.IKeepInChatMessage|null);

        /** Message documentWithCaptionMessage. */
        public documentWithCaptionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message requestPhoneNumberMessage. */
        public requestPhoneNumberMessage?: (proto.Message.IRequestPhoneNumberMessage|null);

        /** Message viewOnceMessageV2. */
        public viewOnceMessageV2?: (proto.Message.IFutureProofMessage|null);

        /** Message encReactionMessage. */
        public encReactionMessage?: (proto.Message.IEncReactionMessage|null);

        /** Message editedMessage. */
        public editedMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message viewOnceMessageV2Extension. */
        public viewOnceMessageV2Extension?: (proto.Message.IFutureProofMessage|null);

        /** Message pollCreationMessageV2. */
        public pollCreationMessageV2?: (proto.Message.IPollCreationMessage|null);

        /** Message scheduledCallCreationMessage. */
        public scheduledCallCreationMessage?: (proto.Message.IScheduledCallCreationMessage|null);

        /** Message groupMentionedMessage. */
        public groupMentionedMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message pinInChatMessage. */
        public pinInChatMessage?: (proto.Message.IPinInChatMessage|null);

        /** Message pollCreationMessageV3. */
        public pollCreationMessageV3?: (proto.Message.IPollCreationMessage|null);

        /** Message scheduledCallEditMessage. */
        public scheduledCallEditMessage?: (proto.Message.IScheduledCallEditMessage|null);

        /** Message ptvMessage. */
        public ptvMessage?: (proto.Message.IVideoMessage|null);

        /** Message botInvokeMessage. */
        public botInvokeMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message callLogMesssage. */
        public callLogMesssage?: (proto.Message.ICallLogMessage|null);

        /** Message messageHistoryBundle. */
        public messageHistoryBundle?: (proto.Message.IMessageHistoryBundle|null);

        /** Message encCommentMessage. */
        public encCommentMessage?: (proto.Message.IEncCommentMessage|null);

        /** Message bcallMessage. */
        public bcallMessage?: (proto.Message.IBCallMessage|null);

        /** Message lottieStickerMessage. */
        public lottieStickerMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message eventMessage. */
        public eventMessage?: (proto.Message.IEventMessage|null);

        /** Message encEventResponseMessage. */
        public encEventResponseMessage?: (proto.Message.IEncEventResponseMessage|null);

        /** Message commentMessage. */
        public commentMessage?: (proto.Message.ICommentMessage|null);

        /** Message newsletterAdminInviteMessage. */
        public newsletterAdminInviteMessage?: (proto.Message.INewsletterAdminInviteMessage|null);

        /** Message placeholderMessage. */
        public placeholderMessage?: (proto.Message.IPlaceholderMessage|null);

        /** Message secretEncryptedMessage. */
        public secretEncryptedMessage?: (proto.Message.ISecretEncryptedMessage|null);

        /** Message albumMessage. */
        public albumMessage?: (proto.Message.IAlbumMessage|null);

        /** Message eventCoverImage. */
        public eventCoverImage?: (proto.Message.IFutureProofMessage|null);

        /** Message stickerPackMessage. */
        public stickerPackMessage?: (proto.Message.IStickerPackMessage|null);

        /** Message statusMentionMessage. */
        public statusMentionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message pollResultSnapshotMessage. */
        public pollResultSnapshotMessage?: (proto.Message.IPollResultSnapshotMessage|null);

        /** Message pollCreationOptionImageMessage. */
        public pollCreationOptionImageMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message associatedChildMessage. */
        public associatedChildMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message groupStatusMentionMessage. */
        public groupStatusMentionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message pollCreationMessageV4. */
        public pollCreationMessageV4?: (proto.Message.IFutureProofMessage|null);

        /** Message pollCreationMessageV5. */
        public pollCreationMessageV5?: (proto.Message.IFutureProofMessage|null);

        /** Message statusAddYours. */
        public statusAddYours?: (proto.Message.IFutureProofMessage|null);

        /** Message groupStatusMessage. */
        public groupStatusMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message richResponseMessage. */
        public richResponseMessage?: (proto.IAIRichResponseMessage|null);

        /** Message statusNotificationMessage. */
        public statusNotificationMessage?: (proto.Message.IStatusNotificationMessage|null);

        /** Message limitSharingMessage. */
        public limitSharingMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message botTaskMessage. */
        public botTaskMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message questionMessage. */
        public questionMessage?: (proto.Message.IFutureProofMessage|null);

        /** Message messageHistoryNotice. */
        public messageHistoryNotice?: (proto.Message.IMessageHistoryNotice|null);

        /**
         * Creates a new Message instance using the specified properties.
         * @param [properties] Properties to set
         * @returns Message instance
         */
        public static create(properties?: proto.IMessage): proto.Message;

        /**
         * Encodes the specified Message message. Does not implicitly {@link proto.Message.verify|verify} messages.
         * @param message Message message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encode(message: proto.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Encodes the specified Message message, length delimited. Does not implicitly {@link proto.Message.verify|verify} messages.
         * @param message Message message or plain object to encode
         * @param [writer] Writer to encode to
         * @returns Writer
         */
        public static encodeDelimited(message: proto.IMessage, writer?: $protobuf.Writer): $protobuf.Writer;

        /**
         * Decodes a Message message from the specified reader or buffer.
         * @param reader Reader or buffer to decode from
         * @param [length] Message length if known beforehand
         * @returns Message
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message;

        /**
         * Decodes a Message message from the specified reader or buffer, length delimited.
         * @param reader Reader or buffer to decode from
         * @returns Message
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message;

        /**
         * Verifies a Message message.
         * @param message Plain object to verify
         * @returns `null` if valid, otherwise the reason why it is not
         */
        public static verify(message: { [k: string]: any }): (string|null);

        /**
         * Creates a Message message from a plain object. Also converts values to their respective internal types.
         * @param object Plain object
         * @returns Message
         */
        public static fromObject(object: { [k: string]: any }): proto.Message;

        /**
         * Creates a plain object from a Message message. Also converts values to other types if specified.
         * @param message Message
         * @param [options] Conversion options
         * @returns Plain object
         */
        public static toObject(message: proto.Message, options?: $protobuf.IConversionOptions): { [k: string]: any };

        /**
         * Converts this Message to JSON.
         * @returns JSON object
         */
        public toJSON(): { [k: string]: any };

        /**
         * Gets the default type url for Message
         * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
         * @returns The default type url
         */
        public static getTypeUrl(typeUrlPrefix?: string): string;
    }

    namespace Message {

        /** Properties of an AlbumMessage. */
        interface IAlbumMessage {

            /** AlbumMessage expectedImageCount */
            expectedImageCount?: (number|null);

            /** AlbumMessage expectedVideoCount */
            expectedVideoCount?: (number|null);

            /** AlbumMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents an AlbumMessage. */
        class AlbumMessage implements IAlbumMessage {

            /**
             * Constructs a new AlbumMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAlbumMessage);

            /** AlbumMessage expectedImageCount. */
            public expectedImageCount?: (number|null);

            /** AlbumMessage expectedVideoCount. */
            public expectedVideoCount?: (number|null);

            /** AlbumMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new AlbumMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AlbumMessage instance
             */
            public static create(properties?: proto.Message.IAlbumMessage): proto.Message.AlbumMessage;

            /**
             * Encodes the specified AlbumMessage message. Does not implicitly {@link proto.Message.AlbumMessage.verify|verify} messages.
             * @param message AlbumMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAlbumMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AlbumMessage message, length delimited. Does not implicitly {@link proto.Message.AlbumMessage.verify|verify} messages.
             * @param message AlbumMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAlbumMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AlbumMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AlbumMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AlbumMessage;

            /**
             * Decodes an AlbumMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AlbumMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AlbumMessage;

            /**
             * Verifies an AlbumMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AlbumMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AlbumMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AlbumMessage;

            /**
             * Creates a plain object from an AlbumMessage message. Also converts values to other types if specified.
             * @param message AlbumMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AlbumMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AlbumMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AlbumMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AppStateFatalExceptionNotification. */
        interface IAppStateFatalExceptionNotification {

            /** AppStateFatalExceptionNotification collectionNames */
            collectionNames?: (string[]|null);

            /** AppStateFatalExceptionNotification timestamp */
            timestamp?: (number|Long|null);
        }

        /** Represents an AppStateFatalExceptionNotification. */
        class AppStateFatalExceptionNotification implements IAppStateFatalExceptionNotification {

            /**
             * Constructs a new AppStateFatalExceptionNotification.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateFatalExceptionNotification);

            /** AppStateFatalExceptionNotification collectionNames. */
            public collectionNames: string[];

            /** AppStateFatalExceptionNotification timestamp. */
            public timestamp?: (number|Long|null);

            /**
             * Creates a new AppStateFatalExceptionNotification instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateFatalExceptionNotification instance
             */
            public static create(properties?: proto.Message.IAppStateFatalExceptionNotification): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Encodes the specified AppStateFatalExceptionNotification message. Does not implicitly {@link proto.Message.AppStateFatalExceptionNotification.verify|verify} messages.
             * @param message AppStateFatalExceptionNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateFatalExceptionNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateFatalExceptionNotification message, length delimited. Does not implicitly {@link proto.Message.AppStateFatalExceptionNotification.verify|verify} messages.
             * @param message AppStateFatalExceptionNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateFatalExceptionNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateFatalExceptionNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateFatalExceptionNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Verifies an AppStateFatalExceptionNotification message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateFatalExceptionNotification message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateFatalExceptionNotification
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateFatalExceptionNotification;

            /**
             * Creates a plain object from an AppStateFatalExceptionNotification message. Also converts values to other types if specified.
             * @param message AppStateFatalExceptionNotification
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateFatalExceptionNotification, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateFatalExceptionNotification to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppStateFatalExceptionNotification
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AppStateSyncKey. */
        interface IAppStateSyncKey {

            /** AppStateSyncKey keyId */
            keyId?: (proto.Message.IAppStateSyncKeyId|null);

            /** AppStateSyncKey keyData */
            keyData?: (proto.Message.IAppStateSyncKeyData|null);
        }

        /** Represents an AppStateSyncKey. */
        class AppStateSyncKey implements IAppStateSyncKey {

            /**
             * Constructs a new AppStateSyncKey.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKey);

            /** AppStateSyncKey keyId. */
            public keyId?: (proto.Message.IAppStateSyncKeyId|null);

            /** AppStateSyncKey keyData. */
            public keyData?: (proto.Message.IAppStateSyncKeyData|null);

            /**
             * Creates a new AppStateSyncKey instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKey instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKey): proto.Message.AppStateSyncKey;

            /**
             * Encodes the specified AppStateSyncKey message. Does not implicitly {@link proto.Message.AppStateSyncKey.verify|verify} messages.
             * @param message AppStateSyncKey message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKey, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKey message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKey.verify|verify} messages.
             * @param message AppStateSyncKey message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKey, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKey message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKey
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKey;

            /**
             * Decodes an AppStateSyncKey message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKey
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKey;

            /**
             * Verifies an AppStateSyncKey message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKey message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKey
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKey;

            /**
             * Creates a plain object from an AppStateSyncKey message. Also converts values to other types if specified.
             * @param message AppStateSyncKey
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKey, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKey to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppStateSyncKey
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AppStateSyncKeyData. */
        interface IAppStateSyncKeyData {

            /** AppStateSyncKeyData keyData */
            keyData?: (Uint8Array|null);

            /** AppStateSyncKeyData fingerprint */
            fingerprint?: (proto.Message.IAppStateSyncKeyFingerprint|null);

            /** AppStateSyncKeyData timestamp */
            timestamp?: (number|Long|null);
        }

        /** Represents an AppStateSyncKeyData. */
        class AppStateSyncKeyData implements IAppStateSyncKeyData {

            /**
             * Constructs a new AppStateSyncKeyData.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyData);

            /** AppStateSyncKeyData keyData. */
            public keyData?: (Uint8Array|null);

            /** AppStateSyncKeyData fingerprint. */
            public fingerprint?: (proto.Message.IAppStateSyncKeyFingerprint|null);

            /** AppStateSyncKeyData timestamp. */
            public timestamp?: (number|Long|null);

            /**
             * Creates a new AppStateSyncKeyData instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyData instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyData): proto.Message.AppStateSyncKeyData;

            /**
             * Encodes the specified AppStateSyncKeyData message. Does not implicitly {@link proto.Message.AppStateSyncKeyData.verify|verify} messages.
             * @param message AppStateSyncKeyData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyData message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyData.verify|verify} messages.
             * @param message AppStateSyncKeyData message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyData, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyData message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyData;

            /**
             * Decodes an AppStateSyncKeyData message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyData;

            /**
             * Verifies an AppStateSyncKeyData message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyData message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyData
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyData;

            /**
             * Creates a plain object from an AppStateSyncKeyData message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyData
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyData, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyData to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppStateSyncKeyData
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AppStateSyncKeyFingerprint. */
        interface IAppStateSyncKeyFingerprint {

            /** AppStateSyncKeyFingerprint rawId */
            rawId?: (number|null);

            /** AppStateSyncKeyFingerprint currentIndex */
            currentIndex?: (number|null);

            /** AppStateSyncKeyFingerprint deviceIndexes */
            deviceIndexes?: (number[]|null);
        }

        /** Represents an AppStateSyncKeyFingerprint. */
        class AppStateSyncKeyFingerprint implements IAppStateSyncKeyFingerprint {

            /**
             * Constructs a new AppStateSyncKeyFingerprint.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyFingerprint);

            /** AppStateSyncKeyFingerprint rawId. */
            public rawId?: (number|null);

            /** AppStateSyncKeyFingerprint currentIndex. */
            public currentIndex?: (number|null);

            /** AppStateSyncKeyFingerprint deviceIndexes. */
            public deviceIndexes: number[];

            /**
             * Creates a new AppStateSyncKeyFingerprint instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyFingerprint instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyFingerprint): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Encodes the specified AppStateSyncKeyFingerprint message. Does not implicitly {@link proto.Message.AppStateSyncKeyFingerprint.verify|verify} messages.
             * @param message AppStateSyncKeyFingerprint message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyFingerprint, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyFingerprint message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyFingerprint.verify|verify} messages.
             * @param message AppStateSyncKeyFingerprint message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyFingerprint, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyFingerprint
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyFingerprint
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Verifies an AppStateSyncKeyFingerprint message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyFingerprint message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyFingerprint
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyFingerprint;

            /**
             * Creates a plain object from an AppStateSyncKeyFingerprint message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyFingerprint
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyFingerprint, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyFingerprint to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppStateSyncKeyFingerprint
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AppStateSyncKeyId. */
        interface IAppStateSyncKeyId {

            /** AppStateSyncKeyId keyId */
            keyId?: (Uint8Array|null);
        }

        /** Represents an AppStateSyncKeyId. */
        class AppStateSyncKeyId implements IAppStateSyncKeyId {

            /**
             * Constructs a new AppStateSyncKeyId.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyId);

            /** AppStateSyncKeyId keyId. */
            public keyId?: (Uint8Array|null);

            /**
             * Creates a new AppStateSyncKeyId instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyId instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyId): proto.Message.AppStateSyncKeyId;

            /**
             * Encodes the specified AppStateSyncKeyId message. Does not implicitly {@link proto.Message.AppStateSyncKeyId.verify|verify} messages.
             * @param message AppStateSyncKeyId message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyId message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyId.verify|verify} messages.
             * @param message AppStateSyncKeyId message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyId, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyId message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyId
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyId;

            /**
             * Decodes an AppStateSyncKeyId message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyId
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyId;

            /**
             * Verifies an AppStateSyncKeyId message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyId message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyId
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyId;

            /**
             * Creates a plain object from an AppStateSyncKeyId message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyId
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyId, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyId to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppStateSyncKeyId
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AppStateSyncKeyRequest. */
        interface IAppStateSyncKeyRequest {

            /** AppStateSyncKeyRequest keyIds */
            keyIds?: (proto.Message.IAppStateSyncKeyId[]|null);
        }

        /** Represents an AppStateSyncKeyRequest. */
        class AppStateSyncKeyRequest implements IAppStateSyncKeyRequest {

            /**
             * Constructs a new AppStateSyncKeyRequest.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyRequest);

            /** AppStateSyncKeyRequest keyIds. */
            public keyIds: proto.Message.IAppStateSyncKeyId[];

            /**
             * Creates a new AppStateSyncKeyRequest instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyRequest instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyRequest): proto.Message.AppStateSyncKeyRequest;

            /**
             * Encodes the specified AppStateSyncKeyRequest message. Does not implicitly {@link proto.Message.AppStateSyncKeyRequest.verify|verify} messages.
             * @param message AppStateSyncKeyRequest message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyRequest, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyRequest message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyRequest.verify|verify} messages.
             * @param message AppStateSyncKeyRequest message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyRequest, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyRequest
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyRequest;

            /**
             * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyRequest
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyRequest;

            /**
             * Verifies an AppStateSyncKeyRequest message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyRequest message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyRequest
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyRequest;

            /**
             * Creates a plain object from an AppStateSyncKeyRequest message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyRequest
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyRequest, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyRequest to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppStateSyncKeyRequest
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AppStateSyncKeyShare. */
        interface IAppStateSyncKeyShare {

            /** AppStateSyncKeyShare keys */
            keys?: (proto.Message.IAppStateSyncKey[]|null);
        }

        /** Represents an AppStateSyncKeyShare. */
        class AppStateSyncKeyShare implements IAppStateSyncKeyShare {

            /**
             * Constructs a new AppStateSyncKeyShare.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAppStateSyncKeyShare);

            /** AppStateSyncKeyShare keys. */
            public keys: proto.Message.IAppStateSyncKey[];

            /**
             * Creates a new AppStateSyncKeyShare instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AppStateSyncKeyShare instance
             */
            public static create(properties?: proto.Message.IAppStateSyncKeyShare): proto.Message.AppStateSyncKeyShare;

            /**
             * Encodes the specified AppStateSyncKeyShare message. Does not implicitly {@link proto.Message.AppStateSyncKeyShare.verify|verify} messages.
             * @param message AppStateSyncKeyShare message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAppStateSyncKeyShare, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AppStateSyncKeyShare message, length delimited. Does not implicitly {@link proto.Message.AppStateSyncKeyShare.verify|verify} messages.
             * @param message AppStateSyncKeyShare message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAppStateSyncKeyShare, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AppStateSyncKeyShare message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AppStateSyncKeyShare
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AppStateSyncKeyShare;

            /**
             * Decodes an AppStateSyncKeyShare message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AppStateSyncKeyShare
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AppStateSyncKeyShare;

            /**
             * Verifies an AppStateSyncKeyShare message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AppStateSyncKeyShare message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AppStateSyncKeyShare
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AppStateSyncKeyShare;

            /**
             * Creates a plain object from an AppStateSyncKeyShare message. Also converts values to other types if specified.
             * @param message AppStateSyncKeyShare
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AppStateSyncKeyShare, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AppStateSyncKeyShare to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AppStateSyncKeyShare
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an AudioMessage. */
        interface IAudioMessage {

            /** AudioMessage url */
            url?: (string|null);

            /** AudioMessage mimetype */
            mimetype?: (string|null);

            /** AudioMessage fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** AudioMessage fileLength */
            fileLength?: (number|Long|null);

            /** AudioMessage seconds */
            seconds?: (number|null);

            /** AudioMessage ptt */
            ptt?: (boolean|null);

            /** AudioMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** AudioMessage fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** AudioMessage directPath */
            directPath?: (string|null);

            /** AudioMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** AudioMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** AudioMessage streamingSidecar */
            streamingSidecar?: (Uint8Array|null);

            /** AudioMessage waveform */
            waveform?: (Uint8Array|null);

            /** AudioMessage backgroundArgb */
            backgroundArgb?: (number|null);

            /** AudioMessage viewOnce */
            viewOnce?: (boolean|null);

            /** AudioMessage accessibilityLabel */
            accessibilityLabel?: (string|null);
        }

        /** Represents an AudioMessage. */
        class AudioMessage implements IAudioMessage {

            /**
             * Constructs a new AudioMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IAudioMessage);

            /** AudioMessage url. */
            public url?: (string|null);

            /** AudioMessage mimetype. */
            public mimetype?: (string|null);

            /** AudioMessage fileSha256. */
            public fileSha256?: (Uint8Array|null);

            /** AudioMessage fileLength. */
            public fileLength?: (number|Long|null);

            /** AudioMessage seconds. */
            public seconds?: (number|null);

            /** AudioMessage ptt. */
            public ptt?: (boolean|null);

            /** AudioMessage mediaKey. */
            public mediaKey?: (Uint8Array|null);

            /** AudioMessage fileEncSha256. */
            public fileEncSha256?: (Uint8Array|null);

            /** AudioMessage directPath. */
            public directPath?: (string|null);

            /** AudioMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp?: (number|Long|null);

            /** AudioMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** AudioMessage streamingSidecar. */
            public streamingSidecar?: (Uint8Array|null);

            /** AudioMessage waveform. */
            public waveform?: (Uint8Array|null);

            /** AudioMessage backgroundArgb. */
            public backgroundArgb?: (number|null);

            /** AudioMessage viewOnce. */
            public viewOnce?: (boolean|null);

            /** AudioMessage accessibilityLabel. */
            public accessibilityLabel?: (string|null);

            /**
             * Creates a new AudioMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns AudioMessage instance
             */
            public static create(properties?: proto.Message.IAudioMessage): proto.Message.AudioMessage;

            /**
             * Encodes the specified AudioMessage message. Does not implicitly {@link proto.Message.AudioMessage.verify|verify} messages.
             * @param message AudioMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IAudioMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified AudioMessage message, length delimited. Does not implicitly {@link proto.Message.AudioMessage.verify|verify} messages.
             * @param message AudioMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IAudioMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an AudioMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns AudioMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.AudioMessage;

            /**
             * Decodes an AudioMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns AudioMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.AudioMessage;

            /**
             * Verifies an AudioMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an AudioMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns AudioMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.AudioMessage;

            /**
             * Creates a plain object from an AudioMessage message. Also converts values to other types if specified.
             * @param message AudioMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.AudioMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this AudioMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for AudioMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a BCallMessage. */
        interface IBCallMessage {

            /** BCallMessage sessionId */
            sessionId?: (string|null);

            /** BCallMessage mediaType */
            mediaType?: (proto.Message.BCallMessage.MediaType|null);

            /** BCallMessage masterKey */
            masterKey?: (Uint8Array|null);

            /** BCallMessage caption */
            caption?: (string|null);
        }

        /** Represents a BCallMessage. */
        class BCallMessage implements IBCallMessage {

            /**
             * Constructs a new BCallMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IBCallMessage);

            /** BCallMessage sessionId. */
            public sessionId?: (string|null);

            /** BCallMessage mediaType. */
            public mediaType?: (proto.Message.BCallMessage.MediaType|null);

            /** BCallMessage masterKey. */
            public masterKey?: (Uint8Array|null);

            /** BCallMessage caption. */
            public caption?: (string|null);

            /**
             * Creates a new BCallMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BCallMessage instance
             */
            public static create(properties?: proto.Message.IBCallMessage): proto.Message.BCallMessage;

            /**
             * Encodes the specified BCallMessage message. Does not implicitly {@link proto.Message.BCallMessage.verify|verify} messages.
             * @param message BCallMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IBCallMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BCallMessage message, length delimited. Does not implicitly {@link proto.Message.BCallMessage.verify|verify} messages.
             * @param message BCallMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IBCallMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BCallMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BCallMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.BCallMessage;

            /**
             * Decodes a BCallMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BCallMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.BCallMessage;

            /**
             * Verifies a BCallMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BCallMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BCallMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.BCallMessage;

            /**
             * Creates a plain object from a BCallMessage message. Also converts values to other types if specified.
             * @param message BCallMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.BCallMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BCallMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for BCallMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace BCallMessage {

            /** MediaType enum. */
            enum MediaType {
                UNKNOWN = 0,
                AUDIO = 1,
                VIDEO = 2
            }
        }

        /** Properties of a BotFeedbackMessage. */
        interface IBotFeedbackMessage {

            /** BotFeedbackMessage messageKey */
            messageKey?: (proto.IMessageKey|null);

            /** BotFeedbackMessage kind */
            kind?: (proto.Message.BotFeedbackMessage.BotFeedbackKind|null);

            /** BotFeedbackMessage text */
            text?: (string|null);

            /** BotFeedbackMessage kindNegative */
            kindNegative?: (number|Long|null);

            /** BotFeedbackMessage kindPositive */
            kindPositive?: (number|Long|null);

            /** BotFeedbackMessage kindReport */
            kindReport?: (proto.Message.BotFeedbackMessage.ReportKind|null);
        }

        /** Represents a BotFeedbackMessage. */
        class BotFeedbackMessage implements IBotFeedbackMessage {

            /**
             * Constructs a new BotFeedbackMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IBotFeedbackMessage);

            /** BotFeedbackMessage messageKey. */
            public messageKey?: (proto.IMessageKey|null);

            /** BotFeedbackMessage kind. */
            public kind?: (proto.Message.BotFeedbackMessage.BotFeedbackKind|null);

            /** BotFeedbackMessage text. */
            public text?: (string|null);

            /** BotFeedbackMessage kindNegative. */
            public kindNegative?: (number|Long|null);

            /** BotFeedbackMessage kindPositive. */
            public kindPositive?: (number|Long|null);

            /** BotFeedbackMessage kindReport. */
            public kindReport?: (proto.Message.BotFeedbackMessage.ReportKind|null);

            /**
             * Creates a new BotFeedbackMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BotFeedbackMessage instance
             */
            public static create(properties?: proto.Message.IBotFeedbackMessage): proto.Message.BotFeedbackMessage;

            /**
             * Encodes the specified BotFeedbackMessage message. Does not implicitly {@link proto.Message.BotFeedbackMessage.verify|verify} messages.
             * @param message BotFeedbackMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IBotFeedbackMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BotFeedbackMessage message, length delimited. Does not implicitly {@link proto.Message.BotFeedbackMessage.verify|verify} messages.
             * @param message BotFeedbackMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IBotFeedbackMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BotFeedbackMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BotFeedbackMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.BotFeedbackMessage;

            /**
             * Decodes a BotFeedbackMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BotFeedbackMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.BotFeedbackMessage;

            /**
             * Verifies a BotFeedbackMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BotFeedbackMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BotFeedbackMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.BotFeedbackMessage;

            /**
             * Creates a plain object from a BotFeedbackMessage message. Also converts values to other types if specified.
             * @param message BotFeedbackMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.BotFeedbackMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BotFeedbackMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for BotFeedbackMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace BotFeedbackMessage {

            /** BotFeedbackKind enum. */
            enum BotFeedbackKind {
                BOT_FEEDBACK_POSITIVE = 0,
                BOT_FEEDBACK_NEGATIVE_GENERIC = 1,
                BOT_FEEDBACK_NEGATIVE_HELPFUL = 2,
                BOT_FEEDBACK_NEGATIVE_INTERESTING = 3,
                BOT_FEEDBACK_NEGATIVE_ACCURATE = 4,
                BOT_FEEDBACK_NEGATIVE_SAFE = 5,
                BOT_FEEDBACK_NEGATIVE_OTHER = 6,
                BOT_FEEDBACK_NEGATIVE_REFUSED = 7,
                BOT_FEEDBACK_NEGATIVE_NOT_VISUALLY_APPEALING = 8,
                BOT_FEEDBACK_NEGATIVE_NOT_RELEVANT_TO_TEXT = 9,
                BOT_FEEDBACK_NEGATIVE_PERSONALIZED = 10,
                BOT_FEEDBACK_NEGATIVE_CLARITY = 11,
                BOT_FEEDBACK_NEGATIVE_DOESNT_LOOK_LIKE_THE_PERSON = 12
            }

            /** BotFeedbackKindMultipleNegative enum. */
            enum BotFeedbackKindMultipleNegative {
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_GENERIC = 1,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_HELPFUL = 2,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_INTERESTING = 4,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_ACCURATE = 8,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_SAFE = 16,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_OTHER = 32,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_REFUSED = 64,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_NOT_VISUALLY_APPEALING = 128,
                BOT_FEEDBACK_MULTIPLE_NEGATIVE_NOT_RELEVANT_TO_TEXT = 256
            }

            /** BotFeedbackKindMultiplePositive enum. */
            enum BotFeedbackKindMultiplePositive {
                BOT_FEEDBACK_MULTIPLE_POSITIVE_GENERIC = 1
            }

            /** ReportKind enum. */
            enum ReportKind {
                GENERIC = 0
            }
        }

        /** Properties of a ButtonsMessage. */
        interface IButtonsMessage {

            /** ButtonsMessage contentText */
            contentText?: (string|null);

            /** ButtonsMessage footerText */
            footerText?: (string|null);

            /** ButtonsMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ButtonsMessage buttons */
            buttons?: (proto.Message.ButtonsMessage.IButton[]|null);

            /** ButtonsMessage headerType */
            headerType?: (proto.Message.ButtonsMessage.HeaderType|null);

            /** ButtonsMessage text */
            text?: (string|null);

            /** ButtonsMessage documentMessage */
            documentMessage?: (proto.Message.IDocumentMessage|null);

            /** ButtonsMessage imageMessage */
            imageMessage?: (proto.Message.IImageMessage|null);

            /** ButtonsMessage videoMessage */
            videoMessage?: (proto.Message.IVideoMessage|null);

            /** ButtonsMessage locationMessage */
            locationMessage?: (proto.Message.ILocationMessage|null);
        }

        /** Represents a ButtonsMessage. */
        class ButtonsMessage implements IButtonsMessage {

            /**
             * Constructs a new ButtonsMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IButtonsMessage);

            /** ButtonsMessage contentText. */
            public contentText?: (string|null);

            /** ButtonsMessage footerText. */
            public footerText?: (string|null);

            /** ButtonsMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** ButtonsMessage buttons. */
            public buttons: proto.Message.ButtonsMessage.IButton[];

            /** ButtonsMessage headerType. */
            public headerType?: (proto.Message.ButtonsMessage.HeaderType|null);

            /** ButtonsMessage text. */
            public text?: (string|null);

            /** ButtonsMessage documentMessage. */
            public documentMessage?: (proto.Message.IDocumentMessage|null);

            /** ButtonsMessage imageMessage. */
            public imageMessage?: (proto.Message.IImageMessage|null);

            /** ButtonsMessage videoMessage. */
            public videoMessage?: (proto.Message.IVideoMessage|null);

            /** ButtonsMessage locationMessage. */
            public locationMessage?: (proto.Message.ILocationMessage|null);

            /** ButtonsMessage header. */
            public header?: ("text"|"documentMessage"|"imageMessage"|"videoMessage"|"locationMessage");

            /**
             * Creates a new ButtonsMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ButtonsMessage instance
             */
            public static create(properties?: proto.Message.IButtonsMessage): proto.Message.ButtonsMessage;

            /**
             * Encodes the specified ButtonsMessage message. Does not implicitly {@link proto.Message.ButtonsMessage.verify|verify} messages.
             * @param message ButtonsMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IButtonsMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ButtonsMessage message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.verify|verify} messages.
             * @param message ButtonsMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IButtonsMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ButtonsMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ButtonsMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage;

            /**
             * Decodes a ButtonsMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ButtonsMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage;

            /**
             * Verifies a ButtonsMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ButtonsMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ButtonsMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage;

            /**
             * Creates a plain object from a ButtonsMessage message. Also converts values to other types if specified.
             * @param message ButtonsMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ButtonsMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ButtonsMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ButtonsMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace ButtonsMessage {

            /** Properties of a Button. */
            interface IButton {

                /** Button buttonId */
                buttonId?: (string|null);

                /** Button buttonText */
                buttonText?: (proto.Message.ButtonsMessage.Button.IButtonText|null);

                /** Button type */
                type?: (proto.Message.ButtonsMessage.Button.Type|null);

                /** Button nativeFlowInfo */
                nativeFlowInfo?: (proto.Message.ButtonsMessage.Button.INativeFlowInfo|null);
            }

            /** Represents a Button. */
            class Button implements IButton {

                /**
                 * Constructs a new Button.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.ButtonsMessage.IButton);

                /** Button buttonId. */
                public buttonId?: (string|null);

                /** Button buttonText. */
                public buttonText?: (proto.Message.ButtonsMessage.Button.IButtonText|null);

                /** Button type. */
                public type?: (proto.Message.ButtonsMessage.Button.Type|null);

                /** Button nativeFlowInfo. */
                public nativeFlowInfo?: (proto.Message.ButtonsMessage.Button.INativeFlowInfo|null);

                /**
                 * Creates a new Button instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns Button instance
                 */
                public static create(properties?: proto.Message.ButtonsMessage.IButton): proto.Message.ButtonsMessage.Button;

                /**
                 * Encodes the specified Button message. Does not implicitly {@link proto.Message.ButtonsMessage.Button.verify|verify} messages.
                 * @param message Button message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.ButtonsMessage.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified Button message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.Button.verify|verify} messages.
                 * @param message Button message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.ButtonsMessage.IButton, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a Button message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns Button
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage.Button;

                /**
                 * Decodes a Button message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns Button
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage.Button;

                /**
                 * Verifies a Button message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a Button message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns Button
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage.Button;

                /**
                 * Creates a plain object from a Button message. Also converts values to other types if specified.
                 * @param message Button
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.ButtonsMessage.Button, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this Button to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for Button
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            namespace Button {

                /** Properties of a ButtonText. */
                interface IButtonText {

                    /** ButtonText displayText */
                    displayText?: (string|null);
                }

                /** Represents a ButtonText. */
                class ButtonText implements IButtonText {

                    /**
                     * Constructs a new ButtonText.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.ButtonsMessage.Button.IButtonText);

                    /** ButtonText displayText. */
                    public displayText?: (string|null);

                    /**
                     * Creates a new ButtonText instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns ButtonText instance
                     */
                    public static create(properties?: proto.Message.ButtonsMessage.Button.IButtonText): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Encodes the specified ButtonText message. Does not implicitly {@link proto.Message.ButtonsMessage.Button.ButtonText.verify|verify} messages.
                     * @param message ButtonText message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.ButtonsMessage.Button.IButtonText, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified ButtonText message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.Button.ButtonText.verify|verify} messages.
                     * @param message ButtonText message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.ButtonsMessage.Button.IButtonText, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a ButtonText message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns ButtonText
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Decodes a ButtonText message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns ButtonText
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Verifies a ButtonText message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a ButtonText message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns ButtonText
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage.Button.ButtonText;

                    /**
                     * Creates a plain object from a ButtonText message. Also converts values to other types if specified.
                     * @param message ButtonText
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.ButtonsMessage.Button.ButtonText, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this ButtonText to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for ButtonText
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Properties of a NativeFlowInfo. */
                interface INativeFlowInfo {

                    /** NativeFlowInfo name */
                    name?: (string|null);

                    /** NativeFlowInfo paramsJson */
                    paramsJson?: (string|null);
                }

                /** Represents a NativeFlowInfo. */
                class NativeFlowInfo implements INativeFlowInfo {

                    /**
                     * Constructs a new NativeFlowInfo.
                     * @param [properties] Properties to set
                     */
                    constructor(properties?: proto.Message.ButtonsMessage.Button.INativeFlowInfo);

                    /** NativeFlowInfo name. */
                    public name?: (string|null);

                    /** NativeFlowInfo paramsJson. */
                    public paramsJson?: (string|null);

                    /**
                     * Creates a new NativeFlowInfo instance using the specified properties.
                     * @param [properties] Properties to set
                     * @returns NativeFlowInfo instance
                     */
                    public static create(properties?: proto.Message.ButtonsMessage.Button.INativeFlowInfo): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Encodes the specified NativeFlowInfo message. Does not implicitly {@link proto.Message.ButtonsMessage.Button.NativeFlowInfo.verify|verify} messages.
                     * @param message NativeFlowInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encode(message: proto.Message.ButtonsMessage.Button.INativeFlowInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Encodes the specified NativeFlowInfo message, length delimited. Does not implicitly {@link proto.Message.ButtonsMessage.Button.NativeFlowInfo.verify|verify} messages.
                     * @param message NativeFlowInfo message or plain object to encode
                     * @param [writer] Writer to encode to
                     * @returns Writer
                     */
                    public static encodeDelimited(message: proto.Message.ButtonsMessage.Button.INativeFlowInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                    /**
                     * Decodes a NativeFlowInfo message from the specified reader or buffer.
                     * @param reader Reader or buffer to decode from
                     * @param [length] Message length if known beforehand
                     * @returns NativeFlowInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Decodes a NativeFlowInfo message from the specified reader or buffer, length delimited.
                     * @param reader Reader or buffer to decode from
                     * @returns NativeFlowInfo
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Verifies a NativeFlowInfo message.
                     * @param message Plain object to verify
                     * @returns `null` if valid, otherwise the reason why it is not
                     */
                    public static verify(message: { [k: string]: any }): (string|null);

                    /**
                     * Creates a NativeFlowInfo message from a plain object. Also converts values to their respective internal types.
                     * @param object Plain object
                     * @returns NativeFlowInfo
                     */
                    public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsMessage.Button.NativeFlowInfo;

                    /**
                     * Creates a plain object from a NativeFlowInfo message. Also converts values to other types if specified.
                     * @param message NativeFlowInfo
                     * @param [options] Conversion options
                     * @returns Plain object
                     */
                    public static toObject(message: proto.Message.ButtonsMessage.Button.NativeFlowInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                    /**
                     * Converts this NativeFlowInfo to JSON.
                     * @returns JSON object
                     */
                    public toJSON(): { [k: string]: any };

                    /**
                     * Gets the default type url for NativeFlowInfo
                     * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns The default type url
                     */
                    public static getTypeUrl(typeUrlPrefix?: string): string;
                }

                /** Type enum. */
                enum Type {
                    UNKNOWN = 0,
                    RESPONSE = 1,
                    NATIVE_FLOW = 2
                }
            }

            /** HeaderType enum. */
            enum HeaderType {
                UNKNOWN = 0,
                EMPTY = 1,
                TEXT = 2,
                DOCUMENT = 3,
                IMAGE = 4,
                VIDEO = 5,
                LOCATION = 6
            }
        }

        /** Properties of a ButtonsResponseMessage. */
        interface IButtonsResponseMessage {

            /** ButtonsResponseMessage selectedButtonId */
            selectedButtonId?: (string|null);

            /** ButtonsResponseMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ButtonsResponseMessage type */
            type?: (proto.Message.ButtonsResponseMessage.Type|null);

            /** ButtonsResponseMessage selectedDisplayText */
            selectedDisplayText?: (string|null);
        }

        /** Represents a ButtonsResponseMessage. */
        class ButtonsResponseMessage implements IButtonsResponseMessage {

            /**
             * Constructs a new ButtonsResponseMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IButtonsResponseMessage);

            /** ButtonsResponseMessage selectedButtonId. */
            public selectedButtonId?: (string|null);

            /** ButtonsResponseMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** ButtonsResponseMessage type. */
            public type?: (proto.Message.ButtonsResponseMessage.Type|null);

            /** ButtonsResponseMessage selectedDisplayText. */
            public selectedDisplayText?: (string|null);

            /** ButtonsResponseMessage response. */
            public response?: "selectedDisplayText";

            /**
             * Creates a new ButtonsResponseMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ButtonsResponseMessage instance
             */
            public static create(properties?: proto.Message.IButtonsResponseMessage): proto.Message.ButtonsResponseMessage;

            /**
             * Encodes the specified ButtonsResponseMessage message. Does not implicitly {@link proto.Message.ButtonsResponseMessage.verify|verify} messages.
             * @param message ButtonsResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IButtonsResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ButtonsResponseMessage message, length delimited. Does not implicitly {@link proto.Message.ButtonsResponseMessage.verify|verify} messages.
             * @param message ButtonsResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IButtonsResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ButtonsResponseMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ButtonsResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ButtonsResponseMessage;

            /**
             * Decodes a ButtonsResponseMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ButtonsResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ButtonsResponseMessage;

            /**
             * Verifies a ButtonsResponseMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ButtonsResponseMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ButtonsResponseMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ButtonsResponseMessage;

            /**
             * Creates a plain object from a ButtonsResponseMessage message. Also converts values to other types if specified.
             * @param message ButtonsResponseMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ButtonsResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ButtonsResponseMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ButtonsResponseMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace ButtonsResponseMessage {

            /** Type enum. */
            enum Type {
                UNKNOWN = 0,
                DISPLAY_TEXT = 1
            }
        }

        /** Properties of a Call. */
        interface ICall {

            /** Call callKey */
            callKey?: (Uint8Array|null);

            /** Call conversionSource */
            conversionSource?: (string|null);

            /** Call conversionData */
            conversionData?: (Uint8Array|null);

            /** Call conversionDelaySeconds */
            conversionDelaySeconds?: (number|null);

            /** Call ctwaSignals */
            ctwaSignals?: (string|null);

            /** Call ctwaPayload */
            ctwaPayload?: (Uint8Array|null);

            /** Call contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a Call. */
        class Call implements ICall {

            /**
             * Constructs a new Call.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ICall);

            /** Call callKey. */
            public callKey?: (Uint8Array|null);

            /** Call conversionSource. */
            public conversionSource?: (string|null);

            /** Call conversionData. */
            public conversionData?: (Uint8Array|null);

            /** Call conversionDelaySeconds. */
            public conversionDelaySeconds?: (number|null);

            /** Call ctwaSignals. */
            public ctwaSignals?: (string|null);

            /** Call ctwaPayload. */
            public ctwaPayload?: (Uint8Array|null);

            /** Call contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new Call instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Call instance
             */
            public static create(properties?: proto.Message.ICall): proto.Message.Call;

            /**
             * Encodes the specified Call message. Does not implicitly {@link proto.Message.Call.verify|verify} messages.
             * @param message Call message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ICall, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Call message, length delimited. Does not implicitly {@link proto.Message.Call.verify|verify} messages.
             * @param message Call message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ICall, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a Call message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Call
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.Call;

            /**
             * Decodes a Call message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Call
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.Call;

            /**
             * Verifies a Call message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a Call message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Call
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.Call;

            /**
             * Creates a plain object from a Call message. Also converts values to other types if specified.
             * @param message Call
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.Call, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Call to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for Call
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a CallLogMessage. */
        interface ICallLogMessage {

            /** CallLogMessage isVideo */
            isVideo?: (boolean|null);

            /** CallLogMessage callOutcome */
            callOutcome?: (proto.Message.CallLogMessage.CallOutcome|null);

            /** CallLogMessage durationSecs */
            durationSecs?: (number|Long|null);

            /** CallLogMessage callType */
            callType?: (proto.Message.CallLogMessage.CallType|null);

            /** CallLogMessage participants */
            participants?: (proto.Message.CallLogMessage.ICallParticipant[]|null);
        }

        /** Represents a CallLogMessage. */
        class CallLogMessage implements ICallLogMessage {

            /**
             * Constructs a new CallLogMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ICallLogMessage);

            /** CallLogMessage isVideo. */
            public isVideo?: (boolean|null);

            /** CallLogMessage callOutcome. */
            public callOutcome?: (proto.Message.CallLogMessage.CallOutcome|null);

            /** CallLogMessage durationSecs. */
            public durationSecs?: (number|Long|null);

            /** CallLogMessage callType. */
            public callType?: (proto.Message.CallLogMessage.CallType|null);

            /** CallLogMessage participants. */
            public participants: proto.Message.CallLogMessage.ICallParticipant[];

            /**
             * Creates a new CallLogMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns CallLogMessage instance
             */
            public static create(properties?: proto.Message.ICallLogMessage): proto.Message.CallLogMessage;

            /**
             * Encodes the specified CallLogMessage message. Does not implicitly {@link proto.Message.CallLogMessage.verify|verify} messages.
             * @param message CallLogMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ICallLogMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified CallLogMessage message, length delimited. Does not implicitly {@link proto.Message.CallLogMessage.verify|verify} messages.
             * @param message CallLogMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ICallLogMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a CallLogMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns CallLogMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.CallLogMessage;

            /**
             * Decodes a CallLogMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns CallLogMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.CallLogMessage;

            /**
             * Verifies a CallLogMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a CallLogMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns CallLogMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.CallLogMessage;

            /**
             * Creates a plain object from a CallLogMessage message. Also converts values to other types if specified.
             * @param message CallLogMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.CallLogMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this CallLogMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for CallLogMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace CallLogMessage {

            /** CallOutcome enum. */
            enum CallOutcome {
                CONNECTED = 0,
                MISSED = 1,
                FAILED = 2,
                REJECTED = 3,
                ACCEPTED_ELSEWHERE = 4,
                ONGOING = 5,
                SILENCED_BY_DND = 6,
                SILENCED_UNKNOWN_CALLER = 7
            }

            /** Properties of a CallParticipant. */
            interface ICallParticipant {

                /** CallParticipant jid */
                jid?: (string|null);

                /** CallParticipant callOutcome */
                callOutcome?: (proto.Message.CallLogMessage.CallOutcome|null);
            }

            /** Represents a CallParticipant. */
            class CallParticipant implements ICallParticipant {

                /**
                 * Constructs a new CallParticipant.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.CallLogMessage.ICallParticipant);

                /** CallParticipant jid. */
                public jid?: (string|null);

                /** CallParticipant callOutcome. */
                public callOutcome?: (proto.Message.CallLogMessage.CallOutcome|null);

                /**
                 * Creates a new CallParticipant instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns CallParticipant instance
                 */
                public static create(properties?: proto.Message.CallLogMessage.ICallParticipant): proto.Message.CallLogMessage.CallParticipant;

                /**
                 * Encodes the specified CallParticipant message. Does not implicitly {@link proto.Message.CallLogMessage.CallParticipant.verify|verify} messages.
                 * @param message CallParticipant message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.CallLogMessage.ICallParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified CallParticipant message, length delimited. Does not implicitly {@link proto.Message.CallLogMessage.CallParticipant.verify|verify} messages.
                 * @param message CallParticipant message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.CallLogMessage.ICallParticipant, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a CallParticipant message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns CallParticipant
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.CallLogMessage.CallParticipant;

                /**
                 * Decodes a CallParticipant message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns CallParticipant
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.CallLogMessage.CallParticipant;

                /**
                 * Verifies a CallParticipant message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a CallParticipant message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns CallParticipant
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.CallLogMessage.CallParticipant;

                /**
                 * Creates a plain object from a CallParticipant message. Also converts values to other types if specified.
                 * @param message CallParticipant
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.CallLogMessage.CallParticipant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this CallParticipant to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for CallParticipant
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }

            /** CallType enum. */
            enum CallType {
                REGULAR = 0,
                SCHEDULED_CALL = 1,
                VOICE_CHAT = 2
            }
        }

        /** Properties of a CancelPaymentRequestMessage. */
        interface ICancelPaymentRequestMessage {

            /** CancelPaymentRequestMessage key */
            key?: (proto.IMessageKey|null);
        }

        /** Represents a CancelPaymentRequestMessage. */
        class CancelPaymentRequestMessage implements ICancelPaymentRequestMessage {

            /**
             * Constructs a new CancelPaymentRequestMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ICancelPaymentRequestMessage);

            /** CancelPaymentRequestMessage key. */
            public key?: (proto.IMessageKey|null);

            /**
             * Creates a new CancelPaymentRequestMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns CancelPaymentRequestMessage instance
             */
            public static create(properties?: proto.Message.ICancelPaymentRequestMessage): proto.Message.CancelPaymentRequestMessage;

            /**
             * Encodes the specified CancelPaymentRequestMessage message. Does not implicitly {@link proto.Message.CancelPaymentRequestMessage.verify|verify} messages.
             * @param message CancelPaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ICancelPaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified CancelPaymentRequestMessage message, length delimited. Does not implicitly {@link proto.Message.CancelPaymentRequestMessage.verify|verify} messages.
             * @param message CancelPaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ICancelPaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns CancelPaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.CancelPaymentRequestMessage;

            /**
             * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns CancelPaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.CancelPaymentRequestMessage;

            /**
             * Verifies a CancelPaymentRequestMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a CancelPaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns CancelPaymentRequestMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.CancelPaymentRequestMessage;

            /**
             * Creates a plain object from a CancelPaymentRequestMessage message. Also converts values to other types if specified.
             * @param message CancelPaymentRequestMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.CancelPaymentRequestMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this CancelPaymentRequestMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for CancelPaymentRequestMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a Chat. */
        interface IChat {

            /** Chat displayName */
            displayName?: (string|null);

            /** Chat id */
            id?: (string|null);
        }

        /** Represents a Chat. */
        class Chat implements IChat {

            /**
             * Constructs a new Chat.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IChat);

            /** Chat displayName. */
            public displayName?: (string|null);

            /** Chat id. */
            public id?: (string|null);

            /**
             * Creates a new Chat instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Chat instance
             */
            public static create(properties?: proto.Message.IChat): proto.Message.Chat;

            /**
             * Encodes the specified Chat message. Does not implicitly {@link proto.Message.Chat.verify|verify} messages.
             * @param message Chat message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IChat, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Chat message, length delimited. Does not implicitly {@link proto.Message.Chat.verify|verify} messages.
             * @param message Chat message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IChat, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a Chat message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Chat
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.Chat;

            /**
             * Decodes a Chat message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Chat
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.Chat;

            /**
             * Verifies a Chat message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a Chat message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Chat
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.Chat;

            /**
             * Creates a plain object from a Chat message. Also converts values to other types if specified.
             * @param message Chat
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.Chat, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Chat to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for Chat
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a CloudAPIThreadControlNotification. */
        interface ICloudAPIThreadControlNotification {

            /** CloudAPIThreadControlNotification status */
            status?: (proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControl|null);

            /** CloudAPIThreadControlNotification senderNotificationTimestampMs */
            senderNotificationTimestampMs?: (number|Long|null);

            /** CloudAPIThreadControlNotification consumerLid */
            consumerLid?: (string|null);

            /** CloudAPIThreadControlNotification consumerPhoneNumber */
            consumerPhoneNumber?: (string|null);

            /** CloudAPIThreadControlNotification notificationContent */
            notificationContent?: (proto.Message.CloudAPIThreadControlNotification.ICloudAPIThreadControlNotificationContent|null);
        }

        /** Represents a CloudAPIThreadControlNotification. */
        class CloudAPIThreadControlNotification implements ICloudAPIThreadControlNotification {

            /**
             * Constructs a new CloudAPIThreadControlNotification.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ICloudAPIThreadControlNotification);

            /** CloudAPIThreadControlNotification status. */
            public status?: (proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControl|null);

            /** CloudAPIThreadControlNotification senderNotificationTimestampMs. */
            public senderNotificationTimestampMs?: (number|Long|null);

            /** CloudAPIThreadControlNotification consumerLid. */
            public consumerLid?: (string|null);

            /** CloudAPIThreadControlNotification consumerPhoneNumber. */
            public consumerPhoneNumber?: (string|null);

            /** CloudAPIThreadControlNotification notificationContent. */
            public notificationContent?: (proto.Message.CloudAPIThreadControlNotification.ICloudAPIThreadControlNotificationContent|null);

            /**
             * Creates a new CloudAPIThreadControlNotification instance using the specified properties.
             * @param [properties] Properties to set
             * @returns CloudAPIThreadControlNotification instance
             */
            public static create(properties?: proto.Message.ICloudAPIThreadControlNotification): proto.Message.CloudAPIThreadControlNotification;

            /**
             * Encodes the specified CloudAPIThreadControlNotification message. Does not implicitly {@link proto.Message.CloudAPIThreadControlNotification.verify|verify} messages.
             * @param message CloudAPIThreadControlNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ICloudAPIThreadControlNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified CloudAPIThreadControlNotification message, length delimited. Does not implicitly {@link proto.Message.CloudAPIThreadControlNotification.verify|verify} messages.
             * @param message CloudAPIThreadControlNotification message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ICloudAPIThreadControlNotification, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a CloudAPIThreadControlNotification message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns CloudAPIThreadControlNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.CloudAPIThreadControlNotification;

            /**
             * Decodes a CloudAPIThreadControlNotification message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns CloudAPIThreadControlNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.CloudAPIThreadControlNotification;

            /**
             * Verifies a CloudAPIThreadControlNotification message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a CloudAPIThreadControlNotification message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns CloudAPIThreadControlNotification
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.CloudAPIThreadControlNotification;

            /**
             * Creates a plain object from a CloudAPIThreadControlNotification message. Also converts values to other types if specified.
             * @param message CloudAPIThreadControlNotification
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.CloudAPIThreadControlNotification, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this CloudAPIThreadControlNotification to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for CloudAPIThreadControlNotification
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace CloudAPIThreadControlNotification {

            /** CloudAPIThreadControl enum. */
            enum CloudAPIThreadControl {
                UNKNOWN = 0,
                CONTROL_PASSED = 1,
                CONTROL_TAKEN = 2
            }

            /** Properties of a CloudAPIThreadControlNotificationContent. */
            interface ICloudAPIThreadControlNotificationContent {

                /** CloudAPIThreadControlNotificationContent handoffNotificationText */
                handoffNotificationText?: (string|null);

                /** CloudAPIThreadControlNotificationContent extraJson */
                extraJson?: (string|null);
            }

            /** Represents a CloudAPIThreadControlNotificationContent. */
            class CloudAPIThreadControlNotificationContent implements ICloudAPIThreadControlNotificationContent {

                /**
                 * Constructs a new CloudAPIThreadControlNotificationContent.
                 * @param [properties] Properties to set
                 */
                constructor(properties?: proto.Message.CloudAPIThreadControlNotification.ICloudAPIThreadControlNotificationContent);

                /** CloudAPIThreadControlNotificationContent handoffNotificationText. */
                public handoffNotificationText?: (string|null);

                /** CloudAPIThreadControlNotificationContent extraJson. */
                public extraJson?: (string|null);

                /**
                 * Creates a new CloudAPIThreadControlNotificationContent instance using the specified properties.
                 * @param [properties] Properties to set
                 * @returns CloudAPIThreadControlNotificationContent instance
                 */
                public static create(properties?: proto.Message.CloudAPIThreadControlNotification.ICloudAPIThreadControlNotificationContent): proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent;

                /**
                 * Encodes the specified CloudAPIThreadControlNotificationContent message. Does not implicitly {@link proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent.verify|verify} messages.
                 * @param message CloudAPIThreadControlNotificationContent message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encode(message: proto.Message.CloudAPIThreadControlNotification.ICloudAPIThreadControlNotificationContent, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Encodes the specified CloudAPIThreadControlNotificationContent message, length delimited. Does not implicitly {@link proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent.verify|verify} messages.
                 * @param message CloudAPIThreadControlNotificationContent message or plain object to encode
                 * @param [writer] Writer to encode to
                 * @returns Writer
                 */
                public static encodeDelimited(message: proto.Message.CloudAPIThreadControlNotification.ICloudAPIThreadControlNotificationContent, writer?: $protobuf.Writer): $protobuf.Writer;

                /**
                 * Decodes a CloudAPIThreadControlNotificationContent message from the specified reader or buffer.
                 * @param reader Reader or buffer to decode from
                 * @param [length] Message length if known beforehand
                 * @returns CloudAPIThreadControlNotificationContent
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent;

                /**
                 * Decodes a CloudAPIThreadControlNotificationContent message from the specified reader or buffer, length delimited.
                 * @param reader Reader or buffer to decode from
                 * @returns CloudAPIThreadControlNotificationContent
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent;

                /**
                 * Verifies a CloudAPIThreadControlNotificationContent message.
                 * @param message Plain object to verify
                 * @returns `null` if valid, otherwise the reason why it is not
                 */
                public static verify(message: { [k: string]: any }): (string|null);

                /**
                 * Creates a CloudAPIThreadControlNotificationContent message from a plain object. Also converts values to their respective internal types.
                 * @param object Plain object
                 * @returns CloudAPIThreadControlNotificationContent
                 */
                public static fromObject(object: { [k: string]: any }): proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent;

                /**
                 * Creates a plain object from a CloudAPIThreadControlNotificationContent message. Also converts values to other types if specified.
                 * @param message CloudAPIThreadControlNotificationContent
                 * @param [options] Conversion options
                 * @returns Plain object
                 */
                public static toObject(message: proto.Message.CloudAPIThreadControlNotification.CloudAPIThreadControlNotificationContent, options?: $protobuf.IConversionOptions): { [k: string]: any };

                /**
                 * Converts this CloudAPIThreadControlNotificationContent to JSON.
                 * @returns JSON object
                 */
                public toJSON(): { [k: string]: any };

                /**
                 * Gets the default type url for CloudAPIThreadControlNotificationContent
                 * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                 * @returns The default type url
                 */
                public static getTypeUrl(typeUrlPrefix?: string): string;
            }
        }

        /** Properties of a CommentMessage. */
        interface ICommentMessage {

            /** CommentMessage message */
            message?: (proto.IMessage|null);

            /** CommentMessage targetMessageKey */
            targetMessageKey?: (proto.IMessageKey|null);
        }

        /** Represents a CommentMessage. */
        class CommentMessage implements ICommentMessage {

            /**
             * Constructs a new CommentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.ICommentMessage);

            /** CommentMessage message. */
            public message?: (proto.IMessage|null);

            /** CommentMessage targetMessageKey. */
            public targetMessageKey?: (proto.IMessageKey|null);

            /**
             * Creates a new CommentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns CommentMessage instance
             */
            public static create(properties?: proto.Message.ICommentMessage): proto.Message.CommentMessage;

            /**
             * Encodes the specified CommentMessage message. Does not implicitly {@link proto.Message.CommentMessage.verify|verify} messages.
             * @param message CommentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.ICommentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified CommentMessage message, length delimited. Does not implicitly {@link proto.Message.CommentMessage.verify|verify} messages.
             * @param message CommentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.ICommentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a CommentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns CommentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.CommentMessage;

            /**
             * Decodes a CommentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns CommentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.CommentMessage;

            /**
             * Verifies a CommentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a CommentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns CommentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.CommentMessage;

            /**
             * Creates a plain object from a CommentMessage message. Also converts values to other types if specified.
             * @param message CommentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.CommentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this CommentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for CommentMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a ContactMessage. */
        interface IContactMessage {

            /** ContactMessage displayName */
            displayName?: (string|null);

            /** ContactMessage vcard */
            vcard?: (string|null);

            /** ContactMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a ContactMessage. */
        class ContactMessage implements IContactMessage {

            /**
             * Constructs a new ContactMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IContactMessage);

            /** ContactMessage displayName. */
            public displayName?: (string|null);

            /** ContactMessage vcard. */
            public vcard?: (string|null);

            /** ContactMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new ContactMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ContactMessage instance
             */
            public static create(properties?: proto.Message.IContactMessage): proto.Message.ContactMessage;

            /**
             * Encodes the specified ContactMessage message. Does not implicitly {@link proto.Message.ContactMessage.verify|verify} messages.
             * @param message ContactMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IContactMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ContactMessage message, length delimited. Does not implicitly {@link proto.Message.ContactMessage.verify|verify} messages.
             * @param message ContactMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IContactMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ContactMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ContactMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ContactMessage;

            /**
             * Decodes a ContactMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ContactMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ContactMessage;

            /**
             * Verifies a ContactMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ContactMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ContactMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ContactMessage;

            /**
             * Creates a plain object from a ContactMessage message. Also converts values to other types if specified.
             * @param message ContactMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ContactMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ContactMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ContactMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a ContactsArrayMessage. */
        interface IContactsArrayMessage {

            /** ContactsArrayMessage displayName */
            displayName?: (string|null);

            /** ContactsArrayMessage contacts */
            contacts?: (proto.Message.IContactMessage[]|null);

            /** ContactsArrayMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);
        }

        /** Represents a ContactsArrayMessage. */
        class ContactsArrayMessage implements IContactsArrayMessage {

            /**
             * Constructs a new ContactsArrayMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IContactsArrayMessage);

            /** ContactsArrayMessage displayName. */
            public displayName?: (string|null);

            /** ContactsArrayMessage contacts. */
            public contacts: proto.Message.IContactMessage[];

            /** ContactsArrayMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /**
             * Creates a new ContactsArrayMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns ContactsArrayMessage instance
             */
            public static create(properties?: proto.Message.IContactsArrayMessage): proto.Message.ContactsArrayMessage;

            /**
             * Encodes the specified ContactsArrayMessage message. Does not implicitly {@link proto.Message.ContactsArrayMessage.verify|verify} messages.
             * @param message ContactsArrayMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IContactsArrayMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified ContactsArrayMessage message, length delimited. Does not implicitly {@link proto.Message.ContactsArrayMessage.verify|verify} messages.
             * @param message ContactsArrayMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IContactsArrayMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a ContactsArrayMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns ContactsArrayMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.ContactsArrayMessage;

            /**
             * Decodes a ContactsArrayMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns ContactsArrayMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.ContactsArrayMessage;

            /**
             * Verifies a ContactsArrayMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a ContactsArrayMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns ContactsArrayMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.ContactsArrayMessage;

            /**
             * Creates a plain object from a ContactsArrayMessage message. Also converts values to other types if specified.
             * @param message ContactsArrayMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.ContactsArrayMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this ContactsArrayMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for ContactsArrayMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a DeclinePaymentRequestMessage. */
        interface IDeclinePaymentRequestMessage {

            /** DeclinePaymentRequestMessage key */
            key?: (proto.IMessageKey|null);
        }

        /** Represents a DeclinePaymentRequestMessage. */
        class DeclinePaymentRequestMessage implements IDeclinePaymentRequestMessage {

            /**
             * Constructs a new DeclinePaymentRequestMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IDeclinePaymentRequestMessage);

            /** DeclinePaymentRequestMessage key. */
            public key?: (proto.IMessageKey|null);

            /**
             * Creates a new DeclinePaymentRequestMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DeclinePaymentRequestMessage instance
             */
            public static create(properties?: proto.Message.IDeclinePaymentRequestMessage): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Encodes the specified DeclinePaymentRequestMessage message. Does not implicitly {@link proto.Message.DeclinePaymentRequestMessage.verify|verify} messages.
             * @param message DeclinePaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IDeclinePaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DeclinePaymentRequestMessage message, length delimited. Does not implicitly {@link proto.Message.DeclinePaymentRequestMessage.verify|verify} messages.
             * @param message DeclinePaymentRequestMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IDeclinePaymentRequestMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DeclinePaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DeclinePaymentRequestMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Verifies a DeclinePaymentRequestMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DeclinePaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DeclinePaymentRequestMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.DeclinePaymentRequestMessage;

            /**
             * Creates a plain object from a DeclinePaymentRequestMessage message. Also converts values to other types if specified.
             * @param message DeclinePaymentRequestMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.DeclinePaymentRequestMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DeclinePaymentRequestMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for DeclinePaymentRequestMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a DeviceSentMessage. */
        interface IDeviceSentMessage {

            /** DeviceSentMessage destinationJid */
            destinationJid?: (string|null);

            /** DeviceSentMessage message */
            message?: (proto.IMessage|null);

            /** DeviceSentMessage phash */
            phash?: (string|null);
        }

        /** Represents a DeviceSentMessage. */
        class DeviceSentMessage implements IDeviceSentMessage {

            /**
             * Constructs a new DeviceSentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IDeviceSentMessage);

            /** DeviceSentMessage destinationJid. */
            public destinationJid?: (string|null);

            /** DeviceSentMessage message. */
            public message?: (proto.IMessage|null);

            /** DeviceSentMessage phash. */
            public phash?: (string|null);

            /**
             * Creates a new DeviceSentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DeviceSentMessage instance
             */
            public static create(properties?: proto.Message.IDeviceSentMessage): proto.Message.DeviceSentMessage;

            /**
             * Encodes the specified DeviceSentMessage message. Does not implicitly {@link proto.Message.DeviceSentMessage.verify|verify} messages.
             * @param message DeviceSentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IDeviceSentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DeviceSentMessage message, length delimited. Does not implicitly {@link proto.Message.DeviceSentMessage.verify|verify} messages.
             * @param message DeviceSentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IDeviceSentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DeviceSentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DeviceSentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.DeviceSentMessage;

            /**
             * Decodes a DeviceSentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DeviceSentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.DeviceSentMessage;

            /**
             * Verifies a DeviceSentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DeviceSentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DeviceSentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.DeviceSentMessage;

            /**
             * Creates a plain object from a DeviceSentMessage message. Also converts values to other types if specified.
             * @param message DeviceSentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.DeviceSentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DeviceSentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for DeviceSentMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of a DocumentMessage. */
        interface IDocumentMessage {

            /** DocumentMessage url */
            url?: (string|null);

            /** DocumentMessage mimetype */
            mimetype?: (string|null);

            /** DocumentMessage title */
            title?: (string|null);

            /** DocumentMessage fileSha256 */
            fileSha256?: (Uint8Array|null);

            /** DocumentMessage fileLength */
            fileLength?: (number|Long|null);

            /** DocumentMessage pageCount */
            pageCount?: (number|null);

            /** DocumentMessage mediaKey */
            mediaKey?: (Uint8Array|null);

            /** DocumentMessage fileName */
            fileName?: (string|null);

            /** DocumentMessage fileEncSha256 */
            fileEncSha256?: (Uint8Array|null);

            /** DocumentMessage directPath */
            directPath?: (string|null);

            /** DocumentMessage mediaKeyTimestamp */
            mediaKeyTimestamp?: (number|Long|null);

            /** DocumentMessage contactVcard */
            contactVcard?: (boolean|null);

            /** DocumentMessage thumbnailDirectPath */
            thumbnailDirectPath?: (string|null);

            /** DocumentMessage thumbnailSha256 */
            thumbnailSha256?: (Uint8Array|null);

            /** DocumentMessage thumbnailEncSha256 */
            thumbnailEncSha256?: (Uint8Array|null);

            /** DocumentMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** DocumentMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** DocumentMessage thumbnailHeight */
            thumbnailHeight?: (number|null);

            /** DocumentMessage thumbnailWidth */
            thumbnailWidth?: (number|null);

            /** DocumentMessage caption */
            caption?: (string|null);

            /** DocumentMessage accessibilityLabel */
            accessibilityLabel?: (string|null);
        }

        /** Represents a DocumentMessage. */
        class DocumentMessage implements IDocumentMessage {

            /**
             * Constructs a new DocumentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IDocumentMessage);

            /** DocumentMessage url. */
            public url?: (string|null);

            /** DocumentMessage mimetype. */
            public mimetype?: (string|null);

            /** DocumentMessage title. */
            public title?: (string|null);

            /** DocumentMessage fileSha256. */
            public fileSha256?: (Uint8Array|null);

            /** DocumentMessage fileLength. */
            public fileLength?: (number|Long|null);

            /** DocumentMessage pageCount. */
            public pageCount?: (number|null);

            /** DocumentMessage mediaKey. */
            public mediaKey?: (Uint8Array|null);

            /** DocumentMessage fileName. */
            public fileName?: (string|null);

            /** DocumentMessage fileEncSha256. */
            public fileEncSha256?: (Uint8Array|null);

            /** DocumentMessage directPath. */
            public directPath?: (string|null);

            /** DocumentMessage mediaKeyTimestamp. */
            public mediaKeyTimestamp?: (number|Long|null);

            /** DocumentMessage contactVcard. */
            public contactVcard?: (boolean|null);

            /** DocumentMessage thumbnailDirectPath. */
            public thumbnailDirectPath?: (string|null);

            /** DocumentMessage thumbnailSha256. */
            public thumbnailSha256?: (Uint8Array|null);

            /** DocumentMessage thumbnailEncSha256. */
            public thumbnailEncSha256?: (Uint8Array|null);

            /** DocumentMessage jpegThumbnail. */
            public jpegThumbnail?: (Uint8Array|null);

            /** DocumentMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** DocumentMessage thumbnailHeight. */
            public thumbnailHeight?: (number|null);

            /** DocumentMessage thumbnailWidth. */
            public thumbnailWidth?: (number|null);

            /** DocumentMessage caption. */
            public caption?: (string|null);

            /** DocumentMessage accessibilityLabel. */
            public accessibilityLabel?: (string|null);

            /**
             * Creates a new DocumentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DocumentMessage instance
             */
            public static create(properties?: proto.Message.IDocumentMessage): proto.Message.DocumentMessage;

            /**
             * Encodes the specified DocumentMessage message. Does not implicitly {@link proto.Message.DocumentMessage.verify|verify} messages.
             * @param message DocumentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IDocumentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DocumentMessage message, length delimited. Does not implicitly {@link proto.Message.DocumentMessage.verify|verify} messages.
             * @param message DocumentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IDocumentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DocumentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DocumentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.DocumentMessage;

            /**
             * Decodes a DocumentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DocumentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.DocumentMessage;

            /**
             * Verifies a DocumentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DocumentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DocumentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.DocumentMessage;

            /**
             * Creates a plain object from a DocumentMessage message. Also converts values to other types if specified.
             * @param message DocumentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.DocumentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DocumentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for DocumentMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an EncCommentMessage. */
        interface IEncCommentMessage {

            /** EncCommentMessage targetMessageKey */
            targetMessageKey?: (proto.IMessageKey|null);

            /** EncCommentMessage encPayload */
            encPayload?: (Uint8Array|null);

            /** EncCommentMessage encIv */
            encIv?: (Uint8Array|null);
        }

        /** Represents an EncCommentMessage. */
        class EncCommentMessage implements IEncCommentMessage {

            /**
             * Constructs a new EncCommentMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IEncCommentMessage);

            /** EncCommentMessage targetMessageKey. */
            public targetMessageKey?: (proto.IMessageKey|null);

            /** EncCommentMessage encPayload. */
            public encPayload?: (Uint8Array|null);

            /** EncCommentMessage encIv. */
            public encIv?: (Uint8Array|null);

            /**
             * Creates a new EncCommentMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EncCommentMessage instance
             */
            public static create(properties?: proto.Message.IEncCommentMessage): proto.Message.EncCommentMessage;

            /**
             * Encodes the specified EncCommentMessage message. Does not implicitly {@link proto.Message.EncCommentMessage.verify|verify} messages.
             * @param message EncCommentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IEncCommentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EncCommentMessage message, length delimited. Does not implicitly {@link proto.Message.EncCommentMessage.verify|verify} messages.
             * @param message EncCommentMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IEncCommentMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EncCommentMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EncCommentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.EncCommentMessage;

            /**
             * Decodes an EncCommentMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EncCommentMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.EncCommentMessage;

            /**
             * Verifies an EncCommentMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EncCommentMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EncCommentMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.EncCommentMessage;

            /**
             * Creates a plain object from an EncCommentMessage message. Also converts values to other types if specified.
             * @param message EncCommentMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.EncCommentMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EncCommentMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for EncCommentMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an EncEventResponseMessage. */
        interface IEncEventResponseMessage {

            /** EncEventResponseMessage eventCreationMessageKey */
            eventCreationMessageKey?: (proto.IMessageKey|null);

            /** EncEventResponseMessage encPayload */
            encPayload?: (Uint8Array|null);

            /** EncEventResponseMessage encIv */
            encIv?: (Uint8Array|null);
        }

        /** Represents an EncEventResponseMessage. */
        class EncEventResponseMessage implements IEncEventResponseMessage {

            /**
             * Constructs a new EncEventResponseMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IEncEventResponseMessage);

            /** EncEventResponseMessage eventCreationMessageKey. */
            public eventCreationMessageKey?: (proto.IMessageKey|null);

            /** EncEventResponseMessage encPayload. */
            public encPayload?: (Uint8Array|null);

            /** EncEventResponseMessage encIv. */
            public encIv?: (Uint8Array|null);

            /**
             * Creates a new EncEventResponseMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EncEventResponseMessage instance
             */
            public static create(properties?: proto.Message.IEncEventResponseMessage): proto.Message.EncEventResponseMessage;

            /**
             * Encodes the specified EncEventResponseMessage message. Does not implicitly {@link proto.Message.EncEventResponseMessage.verify|verify} messages.
             * @param message EncEventResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IEncEventResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EncEventResponseMessage message, length delimited. Does not implicitly {@link proto.Message.EncEventResponseMessage.verify|verify} messages.
             * @param message EncEventResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IEncEventResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EncEventResponseMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EncEventResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.EncEventResponseMessage;

            /**
             * Decodes an EncEventResponseMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EncEventResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.EncEventResponseMessage;

            /**
             * Verifies an EncEventResponseMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EncEventResponseMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EncEventResponseMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.EncEventResponseMessage;

            /**
             * Creates a plain object from an EncEventResponseMessage message. Also converts values to other types if specified.
             * @param message EncEventResponseMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.EncEventResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EncEventResponseMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for EncEventResponseMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an EncReactionMessage. */
        interface IEncReactionMessage {

            /** EncReactionMessage targetMessageKey */
            targetMessageKey?: (proto.IMessageKey|null);

            /** EncReactionMessage encPayload */
            encPayload?: (Uint8Array|null);

            /** EncReactionMessage encIv */
            encIv?: (Uint8Array|null);
        }

        /** Represents an EncReactionMessage. */
        class EncReactionMessage implements IEncReactionMessage {

            /**
             * Constructs a new EncReactionMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IEncReactionMessage);

            /** EncReactionMessage targetMessageKey. */
            public targetMessageKey?: (proto.IMessageKey|null);

            /** EncReactionMessage encPayload. */
            public encPayload?: (Uint8Array|null);

            /** EncReactionMessage encIv. */
            public encIv?: (Uint8Array|null);

            /**
             * Creates a new EncReactionMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EncReactionMessage instance
             */
            public static create(properties?: proto.Message.IEncReactionMessage): proto.Message.EncReactionMessage;

            /**
             * Encodes the specified EncReactionMessage message. Does not implicitly {@link proto.Message.EncReactionMessage.verify|verify} messages.
             * @param message EncReactionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IEncReactionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EncReactionMessage message, length delimited. Does not implicitly {@link proto.Message.EncReactionMessage.verify|verify} messages.
             * @param message EncReactionMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IEncReactionMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EncReactionMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EncReactionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.EncReactionMessage;

            /**
             * Decodes an EncReactionMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EncReactionMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.EncReactionMessage;

            /**
             * Verifies an EncReactionMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EncReactionMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EncReactionMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.EncReactionMessage;

            /**
             * Creates a plain object from an EncReactionMessage message. Also converts values to other types if specified.
             * @param message EncReactionMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.EncReactionMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EncReactionMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for EncReactionMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an EventMessage. */
        interface IEventMessage {

            /** EventMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** EventMessage isCanceled */
            isCanceled?: (boolean|null);

            /** EventMessage name */
            name?: (string|null);

            /** EventMessage description */
            description?: (string|null);

            /** EventMessage location */
            location?: (proto.Message.ILocationMessage|null);

            /** EventMessage joinLink */
            joinLink?: (string|null);

            /** EventMessage startTime */
            startTime?: (number|Long|null);

            /** EventMessage endTime */
            endTime?: (number|Long|null);

            /** EventMessage extraGuestsAllowed */
            extraGuestsAllowed?: (boolean|null);

            /** EventMessage isScheduleCall */
            isScheduleCall?: (boolean|null);
        }

        /** Represents an EventMessage. */
        class EventMessage implements IEventMessage {

            /**
             * Constructs a new EventMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IEventMessage);

            /** EventMessage contextInfo. */
            public contextInfo?: (proto.IContextInfo|null);

            /** EventMessage isCanceled. */
            public isCanceled?: (boolean|null);

            /** EventMessage name. */
            public name?: (string|null);

            /** EventMessage description. */
            public description?: (string|null);

            /** EventMessage location. */
            public location?: (proto.Message.ILocationMessage|null);

            /** EventMessage joinLink. */
            public joinLink?: (string|null);

            /** EventMessage startTime. */
            public startTime?: (number|Long|null);

            /** EventMessage endTime. */
            public endTime?: (number|Long|null);

            /** EventMessage extraGuestsAllowed. */
            public extraGuestsAllowed?: (boolean|null);

            /** EventMessage isScheduleCall. */
            public isScheduleCall?: (boolean|null);

            /**
             * Creates a new EventMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EventMessage instance
             */
            public static create(properties?: proto.Message.IEventMessage): proto.Message.EventMessage;

            /**
             * Encodes the specified EventMessage message. Does not implicitly {@link proto.Message.EventMessage.verify|verify} messages.
             * @param message EventMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IEventMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EventMessage message, length delimited. Does not implicitly {@link proto.Message.EventMessage.verify|verify} messages.
             * @param message EventMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IEventMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EventMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EventMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.EventMessage;

            /**
             * Decodes an EventMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EventMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.EventMessage;

            /**
             * Verifies an EventMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EventMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EventMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.EventMessage;

            /**
             * Creates a plain object from an EventMessage message. Also converts values to other types if specified.
             * @param message EventMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.EventMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EventMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for EventMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        /** Properties of an EventResponseMessage. */
        interface IEventResponseMessage {

            /** EventResponseMessage response */
            response?: (proto.Message.EventResponseMessage.EventResponseType|null);

            /** EventResponseMessage timestampMs */
            timestampMs?: (number|Long|null);

            /** EventResponseMessage extraGuestCount */
            extraGuestCount?: (number|null);
        }

        /** Represents an EventResponseMessage. */
        class EventResponseMessage implements IEventResponseMessage {

            /**
             * Constructs a new EventResponseMessage.
             * @param [properties] Properties to set
             */
            constructor(properties?: proto.Message.IEventResponseMessage);

            /** EventResponseMessage response. */
            public response?: (proto.Message.EventResponseMessage.EventResponseType|null);

            /** EventResponseMessage timestampMs. */
            public timestampMs?: (number|Long|null);

            /** EventResponseMessage extraGuestCount. */
            public extraGuestCount?: (number|null);

            /**
             * Creates a new EventResponseMessage instance using the specified properties.
             * @param [properties] Properties to set
             * @returns EventResponseMessage instance
             */
            public static create(properties?: proto.Message.IEventResponseMessage): proto.Message.EventResponseMessage;

            /**
             * Encodes the specified EventResponseMessage message. Does not implicitly {@link proto.Message.EventResponseMessage.verify|verify} messages.
             * @param message EventResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: proto.Message.IEventResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified EventResponseMessage message, length delimited. Does not implicitly {@link proto.Message.EventResponseMessage.verify|verify} messages.
             * @param message EventResponseMessage message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: proto.Message.IEventResponseMessage, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an EventResponseMessage message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns EventResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): proto.Message.EventResponseMessage;

            /**
             * Decodes an EventResponseMessage message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns EventResponseMessage
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): proto.Message.EventResponseMessage;

            /**
             * Verifies an EventResponseMessage message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an EventResponseMessage message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns EventResponseMessage
             */
            public static fromObject(object: { [k: string]: any }): proto.Message.EventResponseMessage;

            /**
             * Creates a plain object from an EventResponseMessage message. Also converts values to other types if specified.
             * @param message EventResponseMessage
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: proto.Message.EventResponseMessage, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this EventResponseMessage to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };

            /**
             * Gets the default type url for EventResponseMessage
             * @param [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
             * @returns The default type url
             */
            public static getTypeUrl(typeUrlPrefix?: string): string;
        }

        namespace EventResponseMessage {

            /** EventResponseType enum. */
            enum EventResponseType {
                UNKNOWN = 0,
                GOING = 1,
                NOT_GOING = 2,
                MAYBE = 3
            }
        }

        /** Properties of an ExtendedTextMessage. */
        interface IExtendedTextMessage {

            /** ExtendedTextMessage text */
            text?: (string|null);

            /** ExtendedTextMessage matchedText */
            matchedText?: (string|null);

            /** ExtendedTextMessage description */
            description?: (string|null);

            /** ExtendedTextMessage title */
            title?: (string|null);

            /** ExtendedTextMessage textArgb */
            textArgb?: (number|null);

            /** ExtendedTextMessage backgroundArgb */
            backgroundArgb?: (number|null);

            /** ExtendedTextMessage font */
            font?: (proto.Message.ExtendedTextMessage.FontType|null);

            /** ExtendedTextMessage previewType */
            previewType?: (proto.Message.ExtendedTextMessage.PreviewType|null);

            /** ExtendedTextMessage jpegThumbnail */
            jpegThumbnail?: (Uint8Array|null);

            /** ExtendedTextMessage contextInfo */
            contextInfo?: (proto.IContextInfo|null);

            /** ExtendedTextMessage doNotPlayInline */
            doNotPlayInline?: (boolean|null);

            /** ExtendedTextMessage thumbnailDirectPath */
            thumbnailDirectPath?: (string|null);

            /** ExtendedTextMessage thumbnailSha256 */
            thumbnailSha256?: (Uint8Array|null);

            /** ExtendedTextMessage thumbnailEncSha256 */
            thumbnailEncSha256?: (Uint8Array|null);

            /** ExtendedTextMessage mediaKey */
