function assertNonEmptyString(e){if("string"!=typeof e||!e)throw Error("expected a non-empty string, got: "+e)}function assertNumber(e){if("number"!=typeof e)throw Error("expected a number, got: "+e)}let DB_VERSION_CURRENT=1,DB_VERSION_INITIAL=1,STORE_EMOJI="emoji",STORE_KEYVALUE="keyvalue",STORE_FAVORITES="favorites",FIELD_TOKENS="tokens",INDEX_TOKENS="tokens",FIELD_UNICODE="unicode",INDEX_COUNT="count",FIELD_GROUP="group",FIELD_ORDER="order",INDEX_GROUP_AND_ORDER="group-order",KEY_ETAG="eTag",KEY_URL="url",KEY_PREFERRED_SKINTONE="skinTone",MODE_READONLY="readonly",MODE_READWRITE="readwrite",INDEX_SKIN_UNICODE="skinUnicodes",FIELD_SKIN_UNICODE="skinUnicodes",DEFAULT_DATA_SOURCE="/themes/vuexy/js/emoji/data.json",DEFAULT_LOCALE="en";function uniqBy(e,t){let n=new Set,o=[];for(let r of e){let a=t(r);n.has(a)||(n.add(a),o.push(r))}return o}function uniqEmoji(e){return uniqBy(e,e=>e.unicode)}function initialMigration(e){function t(t,n,o){let r=n?e.createObjectStore(t,{keyPath:n}):e.createObjectStore(t);if(o)for(let[a,[i,s]]of Object.entries(o))r.createIndex(a,i,{multiEntry:s});return r}t(STORE_KEYVALUE),t(STORE_EMOJI,"unicode",{[INDEX_TOKENS]:["tokens",!0],[INDEX_GROUP_AND_ORDER]:[["group","order"]],[INDEX_SKIN_UNICODE]:["skinUnicodes",!0]}),t(STORE_FAVORITES,void 0,{[INDEX_COUNT]:[""]})}let openIndexedDBRequests={},databaseCache={},onCloseListeners={};function handleOpenOrDeleteReq(e,t,n){n.onerror=()=>t(n.error),n.onblocked=()=>t(Error("IDB blocked")),n.onsuccess=()=>e(n.result)}async function createDatabase(e){let t=await new Promise((t,n)=>{let o=indexedDB.open(e,1);openIndexedDBRequests[e]=o,o.onupgradeneeded=e=>{e.oldVersion<1&&initialMigration(o.result)},handleOpenOrDeleteReq(t,n,o)});return t.onclose=()=>closeDatabase(e),t}function openDatabase(e){return databaseCache[e]||(databaseCache[e]=createDatabase(e)),databaseCache[e]}function dbPromise(e,t,n,o){return new Promise((r,a)=>{let i=e.transaction(t,n,{durability:"relaxed"}),s="string"==typeof t?i.objectStore(t):t.map(e=>i.objectStore(e)),l;o(s,i,e=>{l=e}),i.oncomplete=()=>r(l),i.onerror=()=>a(i.error)})}function closeDatabase(e){let t=openIndexedDBRequests[e],n=t&&t.result;if(n){n.close();let o=onCloseListeners[e];if(o)for(let r of o)r()}delete openIndexedDBRequests[e],delete databaseCache[e],delete onCloseListeners[e]}function deleteDatabase(e){return new Promise((t,n)=>{closeDatabase(e);let o=indexedDB.deleteDatabase(e);handleOpenOrDeleteReq(t,n,o)})}function addOnCloseListener(e,t){let n=onCloseListeners[e];n||(n=onCloseListeners[e]=[]),n.push(t)}let irregularEmoticons=new Set([":D","XD",":'D","O:)",":X",":P",";P","XP",":L",":Z",":j","8D","XO","8)",":B",":O",":S",":'o","Dx","X(","D:",":C",">0)",":3","</3","<3","\\M/",":E","8#"]);function extractTokens(e){return e.split(/[\s_]+/).map(e=>!e.match(/\w/)||irregularEmoticons.has(e)?e.toLowerCase():e.replace(/[)(:,]/g,"").replace(/’/g,"'").toLowerCase()).filter(Boolean)}let MIN_SEARCH_TEXT_LENGTH=2;function normalizeTokens(e){return e.filter(Boolean).map(e=>e.toLowerCase()).filter(e=>e.length>=2)}function transformEmojiData(e){let t=e.map(({annotation:e,emoticon:t,group:n,order:o,shortcodes:r,skins:a,tags:i,emoji:s,version:l})=>{let u=[...new Set(normalizeTokens([...(r||[]).map(extractTokens).flat(),...(i||[]).map(extractTokens).flat(),...extractTokens(e),t]))].sort(),c={annotation:e,group:n,order:o,tags:i,tokens:u,unicode:s,version:l};if(t&&(c.emoticon=t),r&&(c.shortcodes=r),a)for(let{tone:E,emoji:d,version:m}of(c.skinTones=[],c.skinUnicodes=[],c.skinVersions=[],a))c.skinTones.push(E),c.skinUnicodes.push(d),c.skinVersions.push(m);return c});return t}function callStore(e,t,n,o){e[t](n).onsuccess=e=>o&&o(e.target.result)}function getIDB(e,t,n){callStore(e,"get",t,n)}function getAllIDB(e,t,n){callStore(e,"getAll",t,n)}function commit(e){e.commit&&e.commit()}function minBy(e,t){let n=e[0];for(let o=1;o<e.length;o++){let r=e[o];t(n)>t(r)&&(n=r)}return n}function findCommonMembers(e,t){let n=minBy(e,e=>e.length),o=[];for(let r of n)e.some(e=>-1===e.findIndex(e=>t(e)===t(r)))||o.push(r);return o}async function isEmpty(e){return!await get(e,STORE_KEYVALUE,"url")}async function hasData(e,t,n){let[o,r]=await Promise.all([KEY_ETAG,"url"].map(t=>get(e,STORE_KEYVALUE,t)));return o===n&&r===t}async function doFullDatabaseScanForSingleResult(e,t){return dbPromise(e,STORE_EMOJI,MODE_READONLY,(e,n,o)=>{let r,a=()=>{e.getAll(r&&IDBKeyRange.lowerBound(r,!0),50).onsuccess=e=>{let n=e.target.result;for(let i of n)if(r=i.unicode,t(i))return o(i);if(n.length<50)return o();a()}};a()})}async function loadData(e,t,n,o){{let r=transformEmojiData(t);await dbPromise(e,[STORE_EMOJI,STORE_KEYVALUE],MODE_READWRITE,([e,t],a)=>{let i,s,l=0;function u(){2==++l&&function l(){if(i!==o||s!==n){for(let u of(e.clear(),r))e.put(u);t.put(o,KEY_ETAG),t.put(n,"url"),commit(a)}}()}getIDB(t,KEY_ETAG,e=>{i=e,u()}),getIDB(t,"url",e=>{s=e,u()})})}}async function getEmojiByGroup(e,t){return dbPromise(e,STORE_EMOJI,MODE_READONLY,(e,n,o)=>{let r=IDBKeyRange.bound([t,0],[t+1,0],!1,!0);getAllIDB(e.index(INDEX_GROUP_AND_ORDER),r,o)})}async function getEmojiBySearchQuery(e,t){let n=normalizeTokens(extractTokens(t));return n.length?dbPromise(e,STORE_EMOJI,MODE_READONLY,(e,t,o)=>{let r=[],a=()=>{r.length===n.length&&i()},i=()=>{let e=findCommonMembers(r,e=>e.unicode);o(e.sort((e,t)=>e.order<t.order?-1:1))};for(let s=0;s<n.length;s++){let l=n[s],u=s===n.length-1?IDBKeyRange.bound(l,l+"￿",!1,!0):IDBKeyRange.only(l);getAllIDB(e.index(INDEX_TOKENS),u,e=>{r.push(e),a()})}}):[]}async function getEmojiByShortcode(e,t){let n=await getEmojiBySearchQuery(e,t);if(!n.length){let o=e=>(e.shortcodes||[]).includes(t.toLowerCase());return await doFullDatabaseScanForSingleResult(e,o)||null}return n.filter(e=>{let n=(e.shortcodes||[]).map(e=>e.toLowerCase());return n.includes(t.toLowerCase())})[0]||null}async function getEmojiByUnicode(e,t){return dbPromise(e,STORE_EMOJI,MODE_READONLY,(e,n,o)=>getIDB(e,t,n=>{if(n)return o(n);getIDB(e.index(INDEX_SKIN_UNICODE),t,e=>o(e||null))}))}function get(e,t,n){return dbPromise(e,t,MODE_READONLY,(e,t,o)=>getIDB(e,n,o))}function set(e,t,n,o){return dbPromise(e,t,MODE_READWRITE,(e,t)=>{e.put(o,n),commit(t)})}function incrementFavoriteEmojiCount(e,t){return dbPromise(e,STORE_FAVORITES,MODE_READWRITE,(e,n)=>getIDB(e,t,o=>{e.put((o||0)+1,t),commit(n)}))}function getTopFavoriteEmoji(e,t,n){return 0===n?[]:dbPromise(e,[STORE_FAVORITES,STORE_EMOJI],MODE_READONLY,([e,o],r,a)=>{let i=[];e.index(INDEX_COUNT).openCursor(void 0,"prev").onsuccess=e=>{let r=e.target.result;if(!r)return a(i);function s(e){if(i.push(e),i.length===n)return a(i);r.continue()}let l=r.primaryKey,u=t.byName(l);if(u)return s(u);getIDB(o,l,e=>{if(e)return s(e);r.continue()})}})}let CODA_MARKER="";function trie(e,t){let n=new Map;for(let o of e){let r=t(o);for(let a of r){let i=n;for(let s=0;s<a.length;s++){let l=a.charAt(s),u=i.get(l);u||(u=new Map,i.set(l,u)),i=u}let c=i.get("");c||(c=[],i.set("",c)),c.push(o)}}let E=(e,t)=>{let o=n;for(let r=0;r<e.length;r++){let a=e.charAt(r),i=o.get(a);if(!i)return[];o=i}if(t){let s=o.get("");return s||[]}let l=[],u=[o];for(;u.length;){let c=u.shift(),E=[...c.entries()].sort((e,t)=>e[0]<t[0]?-1:1);for(let[d,m]of E)""===d?l.push(...m):u.push(m)}return l};return E}let requiredKeys$1=["name","url"];function assertCustomEmojis(e){let t=e&&Array.isArray(e),n=t&&e.length&&(!e[0]||requiredKeys$1.some(t=>!(t in e[0])));if(!t||n)throw Error("Custom emojis are in the wrong format")}function customEmojiIndex(e){assertCustomEmojis(e);let t=(e,t)=>e.name.toLowerCase()<t.name.toLowerCase()?-1:1,n=e.sort(t),o=e=>{let t=new Set;if(e.shortcodes)for(let n of e.shortcodes)for(let o of extractTokens(n))t.add(o);return t},r=trie(e,o),a=e=>r(e,!0),i=e=>r(e,!1),s=e=>{let n=extractTokens(e),o=n.map((e,t)=>(t<n.length-1?a:i)(e));return findCommonMembers(o,e=>e.name).sort(t)},l=new Map,u=new Map;for(let c of e)for(let E of(u.set(c.name.toLowerCase(),c),c.shortcodes||[]))l.set(E.toLowerCase(),c);let d=e=>l.get(e.toLowerCase()),m=e=>u.get(e.toLowerCase());return{all:n,search:s,byShortcode:d,byName:m}}let isFirefoxContentScript="undefined"!=typeof wrappedJSObject;function cleanEmoji(e){if(!e)return e;if(isFirefoxContentScript&&(e=structuredClone(e)),delete e.tokens,e.skinTones){let t=e.skinTones.length;e.skins=Array(t);for(let n=0;n<t;n++)e.skins[n]={tone:e.skinTones[n],unicode:e.skinUnicodes[n],version:e.skinVersions[n]};delete e.skinTones,delete e.skinUnicodes,delete e.skinVersions}return e}function warnETag(e){e||console.warn("emoji-picker-element is more efficient if the dataSource server exposes an ETag header.")}let requiredKeys=["annotation","emoji","group","order","version"];function assertEmojiData(e){if(!e||!Array.isArray(e)||!e[0]||"object"!=typeof e[0]||requiredKeys.some(t=>!(t in e[0])))throw Error("Emoji data is in the wrong format")}function assertStatus(e,t){if(2!==Math.floor(e.status/100))throw Error("Failed to fetch: "+t+":  "+e.status)}async function getETag(e){let t=await fetch(e,{method:"HEAD"});assertStatus(t,e);let n=t.headers.get("etag");return warnETag(n),n}async function getETagAndData(e){let t=await fetch(e);assertStatus(t,e);let n=t.headers.get("etag");warnETag(n);let o=await t.json();return assertEmojiData(o),[n,o]}function arrayBufferToBinaryString(e){for(var t="",n=new Uint8Array(e),o=n.byteLength,r=-1;++r<o;)t+=String.fromCharCode(n[r]);return t}function binaryStringToArrayBuffer(e){for(var t=e.length,n=new ArrayBuffer(t),o=new Uint8Array(n),r=-1;++r<t;)o[r]=e.charCodeAt(r);return n}async function jsonChecksum(e){let t=JSON.stringify(e),n=binaryStringToArrayBuffer(t),o=await crypto.subtle.digest("SHA-1",n),r=arrayBufferToBinaryString(o),a=btoa(r);return a}async function doCheckForUpdates(e,t){let n,o=await getETag(t);if(!o){let r=await getETagAndData(t);o=r[0],n=r[1],o||(o=await jsonChecksum(n))}if(await hasData(e,t,o));else{if(!n){let a=await getETagAndData(t);n=a[1]}await loadData(e,n,t,o)}}async function loadDataForFirstTime(e,t){let[n,o]=await getETagAndData(t);n||(n=await jsonChecksum(o)),await loadData(e,o,t,n)}async function checkForUpdates(e,t){try{await doCheckForUpdates(e,t)}catch(n){if("InvalidStateError"!==n.name)throw n}}class Database{constructor({dataSource:e="/themes/vuexy/js/emoji/data.json",locale:t="en",customEmoji:n=[]}={}){this.dataSource=e,this.locale=t,this._dbName=`emoji-picker-element-${this.locale}`,this._db=void 0,this._lazyUpdate=void 0,this._custom=customEmojiIndex(n),this._clear=this._clear.bind(this),this._ready=this._init()}async _init(){let e=this._db=await openDatabase(this._dbName);addOnCloseListener(this._dbName,this._clear);let t=this.dataSource,n=await isEmpty(e);n?await loadDataForFirstTime(e,t):this._lazyUpdate=checkForUpdates(e,t)}async ready(){let e=async()=>(this._ready||(this._ready=this._init()),this._ready);await e(),this._db||await e()}async getEmojiByGroup(e){return assertNumber(e),await this.ready(),uniqEmoji(await getEmojiByGroup(this._db,e)).map(cleanEmoji)}async getEmojiBySearchQuery(e){assertNonEmptyString(e),await this.ready();let t=this._custom.search(e),n=uniqEmoji(await getEmojiBySearchQuery(this._db,e)).map(cleanEmoji);return[...t,...n]}async getEmojiByShortcode(e){assertNonEmptyString(e),await this.ready();let t=this._custom.byShortcode(e);return t||cleanEmoji(await getEmojiByShortcode(this._db,e))}async getEmojiByUnicodeOrName(e){assertNonEmptyString(e),await this.ready();let t=this._custom.byName(e);return t||cleanEmoji(await getEmojiByUnicode(this._db,e))}async getPreferredSkinTone(){return await this.ready(),await get(this._db,STORE_KEYVALUE,KEY_PREFERRED_SKINTONE)||0}async setPreferredSkinTone(e){return assertNumber(e),await this.ready(),set(this._db,STORE_KEYVALUE,KEY_PREFERRED_SKINTONE,e)}async incrementFavoriteEmojiCount(e){return assertNonEmptyString(e),await this.ready(),incrementFavoriteEmojiCount(this._db,e)}async getTopFavoriteEmoji(e){return assertNumber(e),await this.ready(),(await getTopFavoriteEmoji(this._db,this._custom,e)).map(cleanEmoji)}set customEmoji(e){this._custom=customEmojiIndex(e)}get customEmoji(){return this._custom.all}async _shutdown(){await this.ready();try{await this._lazyUpdate}catch(e){}}_clear(){this._db=this._ready=this._lazyUpdate=void 0}async close(){await this._shutdown(),await closeDatabase(this._dbName)}async delete(){await this._shutdown(),await deleteDatabase(this._dbName)}}export{Database as default};